/*
 * Copyright (c) 2007, 2022 -2022 Apple Inc.  All rights reserved.
 * Copyright (c) 2016 Apple Inc. All rights reserved.
 * 
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 * 1. Redistributions of source code must retain the above copyright
 *    notice, this list of conditions and the following disclaimer.
 * 2. Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in the
 *    documentation and/or other materials provided with the distribution.
 * 
 * THIS SOFTWARE IS PROVIDED BY APPLE INC. AND ITS CONTRIBUTORS ``AS IS''
 * AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO,
 * THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR
 * PURPOSE ARE DISCLAIMED. IN NO EVENT SHALL APPLE INC. OR ITS CONTRIBUTORS
 * BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR
 * CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF
 * SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS
 * INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN
 * CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE)
 * ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF
 * THE POSSIBILITY OF SUCH DAMAGE.
 * 
 */

// DO NOT EDIT THIS FILE. It is automatically generated from JavaScript files for
// builtins by the script: Source/JavaScriptCore/Scripts/generate-js-builtins.py

#pragma once

#include <JavaScriptCore/BuiltinUtils.h>
#include <JavaScriptCore/Identifier.h>
#include <JavaScriptCore/JSFunction.h>
#include <JavaScriptCore/UnlinkedFunctionExecutable.h>

namespace JSC {
class FunctionExecutable;
}

namespace WebCore {

/* CommandLineAPIModuleSource */
extern const char* const s_commandLineAPIModuleSourceInjectModuleCode;
extern const int s_commandLineAPIModuleSourceInjectModuleCodeLength;
extern const JSC::ConstructAbility s_commandLineAPIModuleSourceInjectModuleCodeConstructAbility;
extern const JSC::ConstructorKind s_commandLineAPIModuleSourceInjectModuleCodeConstructorKind;
extern const JSC::ImplementationVisibility s_commandLineAPIModuleSourceInjectModuleCodeImplementationVisibility;
extern const JSC::InlineAttribute s_commandLineAPIModuleSourceInjectModuleCodeInlineAttribute;

#define WEBCORE_FOREACH_COMMANDLINEAPIMODULESOURCE_BUILTIN_DATA(macro) \
    macro(injectModule, commandLineAPIModuleSourceInjectModule, 1) \

#define WEBCORE_BUILTIN_COMMANDLINEAPIMODULESOURCE_INJECTMODULE 1

#define WEBCORE_FOREACH_COMMANDLINEAPIMODULESOURCE_BUILTIN_CODE(macro) \
    macro(commandLineAPIModuleSourceInjectModuleCode, injectModule, ASCIILiteral(), s_commandLineAPIModuleSourceInjectModuleCodeLength) \

#define WEBCORE_FOREACH_COMMANDLINEAPIMODULESOURCE_BUILTIN_FUNCTION_NAME(macro) \
    macro(injectModule) \

#define DECLARE_BUILTIN_GENERATOR(codeName, functionName, overriddenName, argumentCount) \
    JSC::FunctionExecutable* codeName##Generator(JSC::VM&);

WEBCORE_FOREACH_COMMANDLINEAPIMODULESOURCE_BUILTIN_CODE(DECLARE_BUILTIN_GENERATOR)
#undef DECLARE_BUILTIN_GENERATOR

class CommandLineAPIModuleSourceBuiltinsWrapper : private JSC::WeakHandleOwner {
public:
    explicit CommandLineAPIModuleSourceBuiltinsWrapper(JSC::VM& vm)
        : m_vm(vm)
        WEBCORE_FOREACH_COMMANDLINEAPIMODULESOURCE_BUILTIN_FUNCTION_NAME(INITIALIZE_BUILTIN_NAMES)
#define INITIALIZE_BUILTIN_SOURCE_MEMBERS(name, functionName, overriddenName, length) , m_##name##Source(JSC::makeSource(StringImpl::createWithoutCopying({ s_##name, static_cast<size_t>(length) }), { }, JSC::SourceTaintedOrigin::Untainted))
        WEBCORE_FOREACH_COMMANDLINEAPIMODULESOURCE_BUILTIN_CODE(INITIALIZE_BUILTIN_SOURCE_MEMBERS)
#undef INITIALIZE_BUILTIN_SOURCE_MEMBERS
    {
    }

#define EXPOSE_BUILTIN_EXECUTABLES(name, functionName, overriddenName, length) \
    JSC::UnlinkedFunctionExecutable* name##Executable(); \
    const JSC::SourceCode& name##Source() const { return m_##name##Source; }
    WEBCORE_FOREACH_COMMANDLINEAPIMODULESOURCE_BUILTIN_CODE(EXPOSE_BUILTIN_EXECUTABLES)
#undef EXPOSE_BUILTIN_EXECUTABLES

    WEBCORE_FOREACH_COMMANDLINEAPIMODULESOURCE_BUILTIN_FUNCTION_NAME(DECLARE_BUILTIN_IDENTIFIER_ACCESSOR)

    void exportNames();

private:
    JSC::VM& m_vm;

    WEBCORE_FOREACH_COMMANDLINEAPIMODULESOURCE_BUILTIN_FUNCTION_NAME(DECLARE_BUILTIN_NAMES)

#define DECLARE_BUILTIN_SOURCE_MEMBERS(name, functionName, overriddenName, length) \
    JSC::SourceCode m_##name##Source;\
    JSC::Weak<JSC::UnlinkedFunctionExecutable> m_##name##Executable;
    WEBCORE_FOREACH_COMMANDLINEAPIMODULESOURCE_BUILTIN_CODE(DECLARE_BUILTIN_SOURCE_MEMBERS)
#undef DECLARE_BUILTIN_SOURCE_MEMBERS

};

#define DEFINE_BUILTIN_EXECUTABLES(name, functionName, overriddenName, length) \
inline JSC::UnlinkedFunctionExecutable* CommandLineAPIModuleSourceBuiltinsWrapper::name##Executable() \
{\
    if (!m_##name##Executable) {\
        JSC::Identifier executableName = functionName##PublicName();\
        if (overriddenName)\
            executableName = JSC::Identifier::fromString(m_vm, overriddenName);\
        m_##name##Executable = JSC::Weak<JSC::UnlinkedFunctionExecutable>(JSC::createBuiltinExecutable(m_vm, m_##name##Source, executableName, s_##name##ImplementationVisibility, s_##name##ConstructorKind, s_##name##ConstructAbility, s_##name##InlineAttribute), this, &m_##name##Executable);\
    }\
    return m_##name##Executable.get();\
}
WEBCORE_FOREACH_COMMANDLINEAPIMODULESOURCE_BUILTIN_CODE(DEFINE_BUILTIN_EXECUTABLES)
#undef DEFINE_BUILTIN_EXECUTABLES

inline void CommandLineAPIModuleSourceBuiltinsWrapper::exportNames()
{
#define EXPORT_FUNCTION_NAME(name) m_vm.propertyNames->appendExternalName(name##PublicName(), name##PrivateName());
    WEBCORE_FOREACH_COMMANDLINEAPIMODULESOURCE_BUILTIN_FUNCTION_NAME(EXPORT_FUNCTION_NAME)
#undef EXPORT_FUNCTION_NAME
}

class CommandLineAPIModuleSourceBuiltinFunctions {
public:
    explicit CommandLineAPIModuleSourceBuiltinFunctions(JSC::VM& vm) : m_vm(vm) { }

    void init(JSC::JSGlobalObject&);
    template<typename Visitor> void visit(Visitor&);

public:
    JSC::VM& m_vm;

#define DECLARE_BUILTIN_SOURCE_MEMBERS(functionName) \
    JSC::WriteBarrier<JSC::JSFunction> m_##functionName##Function;
    WEBCORE_FOREACH_COMMANDLINEAPIMODULESOURCE_BUILTIN_FUNCTION_NAME(DECLARE_BUILTIN_SOURCE_MEMBERS)
#undef DECLARE_BUILTIN_SOURCE_MEMBERS
};

inline void CommandLineAPIModuleSourceBuiltinFunctions::init(JSC::JSGlobalObject& globalObject)
{
#define EXPORT_FUNCTION(codeName, functionName, overriddenName, length)\
    m_##functionName##Function.set(m_vm, &globalObject, JSC::JSFunction::create(m_vm, codeName##Generator(m_vm), &globalObject));
    WEBCORE_FOREACH_COMMANDLINEAPIMODULESOURCE_BUILTIN_CODE(EXPORT_FUNCTION)
#undef EXPORT_FUNCTION
}

template<typename Visitor>
inline void CommandLineAPIModuleSourceBuiltinFunctions::visit(Visitor& visitor)
{
#define VISIT_FUNCTION(name) visitor.append(m_##name##Function);
    WEBCORE_FOREACH_COMMANDLINEAPIMODULESOURCE_BUILTIN_FUNCTION_NAME(VISIT_FUNCTION)
#undef VISIT_FUNCTION
}

template void CommandLineAPIModuleSourceBuiltinFunctions::visit(JSC::AbstractSlotVisitor&);
template void CommandLineAPIModuleSourceBuiltinFunctions::visit(JSC::SlotVisitor&);



} // namespace WebCore
