/*
 * Copyright (C) 2014-2024 Apple Inc. All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 * 1. Redistributions of source code must retain the above copyright
 *    notice, this list of conditions and the following disclaimer.
 * 2. Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in the
 *    documentation and/or other materials provided with the distribution.
 *
 * THIS SOFTWARE IS PROVIDED BY APPLE INC. AND ITS CONTRIBUTORS ``AS IS''
 * AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO,
 * THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR
 * PURPOSE ARE DISCLAIMED. IN NO EVENT SHALL APPLE INC. OR ITS CONTRIBUTORS
 * BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR
 * CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF
 * SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS
 * INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN
 * CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE)
 * ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF
 * THE POSSIBILITY OF SUCH DAMAGE.
 */

// This file is automatically generated from CSSPseudoSelectors.json by the process-css-pseudo-selectors.py script, do not edit by hand.

#pragma once

#include "CSSSelector.h"
#include "CSSSelectorParserContext.h"
#include "DeprecatedGlobalSettings.h"
#include <wtf/text/StringView.h>

namespace WebCore {

inline bool CSSSelector::isPseudoClassEnabled(PseudoClass type, const CSSSelectorParserContext& context)
{
    switch (type) {
#if ENABLE(ATTACHMENT_ELEMENT)
    case PseudoClass::AppleHasAttachment:
        return DeprecatedGlobalSettings::attachmentElementEnabled();
#endif
    case PseudoClass::InternalHTMLDocument:
        return (context.mode == UASheetMode);
    case PseudoClass::FocusVisible:
        return context.focusVisibleEnabled;
    case PseudoClass::Has:
        return context.hasPseudoClassEnabled;
    case PseudoClass::PopoverOpen:
        return context.popoverAttributeEnabled;
    case PseudoClass::State:
        return context.customStateSetEnabled;
    default:
        return true;
    }
}

inline bool CSSSelector::isPseudoElementEnabled(PseudoElement type, StringView name, const CSSSelectorParserContext& context)
{
    switch (type) {
    case PseudoElement::GrammarError:
        return context.grammarAndSpellingPseudoElementsEnabled;
    case PseudoElement::Highlight:
        return context.highlightAPIEnabled;
    case PseudoElement::SpellingError:
        return context.grammarAndSpellingPseudoElementsEnabled;
    case PseudoElement::ViewTransition:
        return context.viewTransitionsEnabled;
    case PseudoElement::ViewTransitionGroup:
        return context.viewTransitionsEnabled;
    case PseudoElement::ViewTransitionImagePair:
        return context.viewTransitionsEnabled;
    case PseudoElement::ViewTransitionNew:
        return context.viewTransitionsEnabled;
    case PseudoElement::ViewTransitionOld:
        return context.viewTransitionsEnabled;
    case PseudoElement::UserAgentPart:
#if ENABLE(SERVICE_CONTROLS)
        if (!context.imageControlsEnabled && equalLettersIgnoringASCIICase(name, "-apple-attachment-controls-container"_s))
            return false;
#endif
        if (!(context.mode == UASheetMode) && equalLettersIgnoringASCIICase(name, "-internal-loading-auto-fill-button"_s))
            return false;
        if (!context.thumbAndTrackPseudoElementsEnabled && equalLettersIgnoringASCIICase(name, "thumb"_s))
            return false;
        if (!context.thumbAndTrackPseudoElementsEnabled && equalLettersIgnoringASCIICase(name, "track"_s))
            return false;
        return true;
    case PseudoElement::UserAgentPartLegacyAlias:
        return true;
    default:
        return true;
    }
}

inline const ASCIILiteral CSSSelector::selectorTextForPseudoClass(PseudoClass type)
{
    switch (type) {
#if ENABLE(ATTACHMENT_ELEMENT)
    case PseudoClass::AppleHasAttachment:
        return ":-apple-has-attachment"_s;
#endif
    case PseudoClass::InternalHTMLDocument:
        return ":-internal-html-document"_s;
#if ENABLE(FULLSCREEN_API)
    case PseudoClass::WebKitAnimatingFullScreenTransition:
        return ":-webkit-animating-full-screen-transition"_s;
#endif
    case PseudoClass::WebKitAny:
        return ":-webkit-any"_s;
    case PseudoClass::WebKitAutofillAndObscured:
        return ":-webkit-autofill-and-obscured"_s;
    case PseudoClass::WebKitAutofillStrongPassword:
        return ":-webkit-autofill-strong-password"_s;
    case PseudoClass::WebKitAutofillStrongPasswordViewable:
        return ":-webkit-autofill-strong-password-viewable"_s;
    case PseudoClass::WebKitDrag:
        return ":-webkit-drag"_s;
    case PseudoClass::WebKitFullPageMedia:
        return ":-webkit-full-page-media"_s;
#if ENABLE(FULLSCREEN_API)
    case PseudoClass::WebKitFullScreenAncestor:
        return ":-webkit-full-screen-ancestor"_s;
#endif
#if ENABLE(FULLSCREEN_API)
    case PseudoClass::WebKitFullScreenDocument:
        return ":-webkit-full-screen-document"_s;
#endif
#if ENABLE(FULLSCREEN_API)
    case PseudoClass::WebKitFullScreenControlsHidden:
        return ":-webkit-full-screen-controls-hidden"_s;
#endif
    case PseudoClass::Active:
        return ":active"_s;
    case PseudoClass::AnyLink:
        return ":any-link"_s;
    case PseudoClass::Autofill:
        return ":autofill"_s;
#if ENABLE(VIDEO)
    case PseudoClass::Buffering:
        return ":buffering"_s;
#endif
    case PseudoClass::Checked:
        return ":checked"_s;
    case PseudoClass::CornerPresent:
        return ":corner-present"_s;
    case PseudoClass::Decrement:
        return ":decrement"_s;
    case PseudoClass::Default:
        return ":default"_s;
    case PseudoClass::Defined:
        return ":defined"_s;
    case PseudoClass::Dir:
        return ":dir"_s;
    case PseudoClass::Disabled:
        return ":disabled"_s;
    case PseudoClass::DoubleButton:
        return ":double-button"_s;
    case PseudoClass::Empty:
        return ":empty"_s;
    case PseudoClass::Enabled:
        return ":enabled"_s;
    case PseudoClass::End:
        return ":end"_s;
    case PseudoClass::FirstChild:
        return ":first-child"_s;
    case PseudoClass::FirstOfType:
        return ":first-of-type"_s;
    case PseudoClass::Focus:
        return ":focus"_s;
    case PseudoClass::FocusVisible:
        return ":focus-visible"_s;
    case PseudoClass::FocusWithin:
        return ":focus-within"_s;
#if ENABLE(FULLSCREEN_API)
    case PseudoClass::Fullscreen:
        return ":fullscreen"_s;
#endif
#if ENABLE(VIDEO)
    case PseudoClass::Future:
        return ":future"_s;
#endif
    case PseudoClass::Has:
        return ":has"_s;
    case PseudoClass::Horizontal:
        return ":horizontal"_s;
    case PseudoClass::Host:
        return ":host"_s;
    case PseudoClass::Hover:
        return ":hover"_s;
    case PseudoClass::InRange:
        return ":in-range"_s;
    case PseudoClass::Increment:
        return ":increment"_s;
    case PseudoClass::Indeterminate:
        return ":indeterminate"_s;
    case PseudoClass::Invalid:
        return ":invalid"_s;
    case PseudoClass::Is:
        return ":is"_s;
    case PseudoClass::Lang:
        return ":lang"_s;
    case PseudoClass::LastChild:
        return ":last-child"_s;
    case PseudoClass::LastOfType:
        return ":last-of-type"_s;
    case PseudoClass::Link:
        return ":link"_s;
    case PseudoClass::Modal:
        return ":modal"_s;
#if ENABLE(VIDEO)
    case PseudoClass::Muted:
        return ":muted"_s;
#endif
    case PseudoClass::NoButton:
        return ":no-button"_s;
    case PseudoClass::Not:
        return ":not"_s;
    case PseudoClass::NthChild:
        return ":nth-child"_s;
    case PseudoClass::NthLastChild:
        return ":nth-last-child"_s;
    case PseudoClass::NthLastOfType:
        return ":nth-last-of-type"_s;
    case PseudoClass::NthOfType:
        return ":nth-of-type"_s;
    case PseudoClass::OnlyChild:
        return ":only-child"_s;
    case PseudoClass::OnlyOfType:
        return ":only-of-type"_s;
    case PseudoClass::Optional:
        return ":optional"_s;
    case PseudoClass::OutOfRange:
        return ":out-of-range"_s;
#if ENABLE(VIDEO)
    case PseudoClass::Past:
        return ":past"_s;
#endif
#if ENABLE(VIDEO)
    case PseudoClass::Paused:
        return ":paused"_s;
#endif
#if ENABLE(PICTURE_IN_PICTURE_API)
    case PseudoClass::PictureInPicture:
        return ":picture-in-picture"_s;
#endif
    case PseudoClass::PlaceholderShown:
        return ":placeholder-shown"_s;
#if ENABLE(VIDEO)
    case PseudoClass::Playing:
        return ":playing"_s;
#endif
    case PseudoClass::PopoverOpen:
        return ":popover-open"_s;
    case PseudoClass::ReadOnly:
        return ":read-only"_s;
    case PseudoClass::ReadWrite:
        return ":read-write"_s;
    case PseudoClass::Required:
        return ":required"_s;
    case PseudoClass::Root:
        return ":root"_s;
    case PseudoClass::Scope:
        return ":scope"_s;
#if ENABLE(VIDEO)
    case PseudoClass::Seeking:
        return ":seeking"_s;
#endif
#if ENABLE(VIDEO)
    case PseudoClass::Stalled:
        return ":stalled"_s;
#endif
    case PseudoClass::State:
        return ":state"_s;
    case PseudoClass::SingleButton:
        return ":single-button"_s;
    case PseudoClass::Start:
        return ":start"_s;
    case PseudoClass::Target:
        return ":target"_s;
    case PseudoClass::UserInvalid:
        return ":user-invalid"_s;
    case PseudoClass::UserValid:
        return ":user-valid"_s;
    case PseudoClass::Valid:
        return ":valid"_s;
    case PseudoClass::Vertical:
        return ":vertical"_s;
    case PseudoClass::Visited:
        return ":visited"_s;
#if ENABLE(VIDEO)
    case PseudoClass::VolumeLocked:
        return ":volume-locked"_s;
#endif
    case PseudoClass::Where:
        return ":where"_s;
    case PseudoClass::WindowInactive:
        return ":window-inactive"_s;
    default:
        ASSERT_NOT_REACHED();
        return ""_s;
    }
}

inline const ASCIILiteral CSSSelector::nameForUserAgentPartLegacyAlias(StringView alias)
{
    if (equalLettersIgnoringASCIICase(alias, "-webkit-file-upload-button"_s))
        return "file-selector-button"_s;
    if (equalLettersIgnoringASCIICase(alias, "-webkit-input-placeholder"_s))
        return "placeholder"_s;
    ASSERT_NOT_REACHED();
    return ""_s;
}

inline bool CSSSelector::pseudoClassRequiresArgument(PseudoClass type)
{
    switch (type) {
    case PseudoClass::WebKitAny:
    case PseudoClass::Dir:
    case PseudoClass::Has:
    case PseudoClass::Is:
    case PseudoClass::Lang:
    case PseudoClass::Not:
    case PseudoClass::NthChild:
    case PseudoClass::NthLastChild:
    case PseudoClass::NthLastOfType:
    case PseudoClass::NthOfType:
    case PseudoClass::State:
    case PseudoClass::Where:
        return true;
    default:
        return false;
    }
}

inline bool CSSSelector::pseudoElementRequiresArgument(PseudoElement type)
{
    switch (type) {
    case PseudoElement::Highlight:
    case PseudoElement::Part:
    case PseudoElement::Slotted:
    case PseudoElement::ViewTransitionGroup:
    case PseudoElement::ViewTransitionImagePair:
    case PseudoElement::ViewTransitionNew:
    case PseudoElement::ViewTransitionOld:
        return true;
    default:
        return false;
    }
}

inline bool CSSSelector::pseudoClassMayHaveArgument(PseudoClass type)
{
    switch (type) {
    case PseudoClass::WebKitAny:
    case PseudoClass::Dir:
    case PseudoClass::Has:
    case PseudoClass::Host:
    case PseudoClass::Is:
    case PseudoClass::Lang:
    case PseudoClass::Not:
    case PseudoClass::NthChild:
    case PseudoClass::NthLastChild:
    case PseudoClass::NthLastOfType:
    case PseudoClass::NthOfType:
    case PseudoClass::State:
    case PseudoClass::Where:
        return true;
    default:
        return false;
    }
}

inline bool CSSSelector::pseudoElementMayHaveArgument(PseudoElement type)
{
    switch (type) {
#if ENABLE(VIDEO)
    case PseudoElement::Cue:
#endif
    case PseudoElement::Highlight:
    case PseudoElement::Part:
    case PseudoElement::Slotted:
    case PseudoElement::ViewTransitionGroup:
    case PseudoElement::ViewTransitionImagePair:
    case PseudoElement::ViewTransitionNew:
    case PseudoElement::ViewTransitionOld:
        return true;
    default:
        return false;
    }
}

} // namespace WebCore
