/*
 * Copyright (C) 2023 Apple Inc. All rights reserved.
 * 
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 * 
 * 1.  Redistributions of source code must retain the above copyright
 *     notice, this list of conditions and the following disclaimer.
 * 2.  Redistributions in binary form must reproduce the above copyright
 *     notice, this list of conditions and the following disclaimer in the
 *     documentation and/or other materials provided with the distribution.
 * 
 * THIS SOFTWARE IS PROVIDED BY APPLE AND ITS CONTRIBUTORS "AS IS" AND ANY
 * EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED
 * WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE
 * DISCLAIMED. IN NO EVENT SHALL APPLE OR ITS CONTRIBUTORS BE LIABLE FOR ANY
 * DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES
 * (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES;
 * LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND
 * ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT
 * (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF
 * THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.

 * Autogenerated, do not modify.
*/

#pragma once

#define FOR_EACH_BYTECODE_ID(macro) \
    macro(op_tail_call_varargs, 7) \
    macro(op_call_varargs, 7) \
    macro(op_iterator_next, 7) \
    macro(op_construct_varargs, 7) \
    macro(op_iterator_open, 6) \
    macro(op_set_private_brand, 3) \
    macro(op_check_private_brand, 3) \
    macro(op_put_by_id, 5) \
    macro(op_construct, 5) \
    macro(op_bitand, 4) \
    macro(op_bitor, 4) \
    macro(op_bitxor, 4) \
    macro(op_lshift, 4) \
    macro(op_rshift, 4) \
    macro(op_to_object, 4) \
    macro(op_to_number, 3) \
    macro(op_to_numeric, 3) \
    macro(op_tail_call, 5) \
    macro(op_call_direct_eval, 8) \
    macro(op_tail_call_forward_arguments, 7) \
    macro(op_create_generator, 3) \
    macro(op_create_async_generator, 3) \
    macro(op_get_by_val, 4) \
    macro(op_get_private_name, 4) \
    macro(op_create_promise, 4) \
    macro(op_bitnot, 3) \
    macro(op_catch, 3) \
    macro(op_new_array_with_size, 3) \
    macro(op_new_array_buffer, 4) \
    macro(op_get_by_id, 4) \
    macro(op_get_by_id_with_this, 5) \
    macro(op_profile_type, 6) \
    macro(op_profile_control_flow, 2) \
    macro(op_get_by_val_with_this, 5) \
    macro(op_enumerator_get_by_val, 7) \
    macro(op_get_by_id_direct, 4) \
    macro(op_get_prototype_of, 3) \
    macro(op_get_internal_field, 4) \
    macro(op_try_get_by_id, 4) \
    macro(op_new_array_with_species, 4) \
    macro(op_call, 5) \
    macro(op_get_argument, 3) \
    macro(op_put_private_name, 5) \
    macro(op_resolve_scope, 6) \
    macro(op_get_from_scope, 7) \
    macro(op_put_to_scope, 7) \
    macro(op_get_from_arguments, 4) \
    macro(op_create_this, 4) \
    macro(op_new_object, 3) \
    macro(op_to_this, 3) \
    macro(op_new_array, 5) \
    macro(op_put_by_val, 5) \
    macro(op_put_by_val_direct, 5) \
    macro(op_in_by_val, 4) \
    macro(op_enumerator_next, 6) \
    macro(op_enumerator_in_by_val, 7) \
    macro(op_enumerator_has_own_property, 7) \
    macro(op_jneq_ptr, 4) \
    macro(op_in_by_id, 3) \
    macro(op_has_private_name, 3) \
    macro(op_has_private_brand, 3) \
    macro(op_put_by_id_with_this, 5) \
    macro(op_del_by_id, 4) \
    macro(op_put_by_val_with_this, 5) \
    macro(op_del_by_val, 4) \
    macro(op_put_getter_by_id, 4) \
    macro(op_put_setter_by_id, 4) \
    macro(op_put_getter_setter_by_id, 5) \
    macro(op_put_getter_by_val, 4) \
    macro(op_put_setter_by_val, 4) \
    macro(op_define_data_property, 4) \
    macro(op_define_accessor_property, 5) \
    macro(op_jmp, 1) \
    macro(op_jtrue, 2) \
    macro(op_jfalse, 2) \
    macro(op_jeq_null, 2) \
    macro(op_jneq_null, 2) \
    macro(op_jundefined_or_null, 2) \
    macro(op_jnundefined_or_null, 2) \
    macro(op_jeq_ptr, 3) \
    macro(op_jeq, 3) \
    macro(op_jstricteq, 3) \
    macro(op_jneq, 3) \
    macro(op_jnstricteq, 3) \
    macro(op_jless, 3) \
    macro(op_jlesseq, 3) \
    macro(op_jgreater, 3) \
    macro(op_jgreatereq, 3) \
    macro(op_jnless, 3) \
    macro(op_jnlesseq, 3) \
    macro(op_jngreater, 3) \
    macro(op_jngreatereq, 3) \
    macro(op_jbelow, 3) \
    macro(op_jbeloweq, 3) \
    macro(op_loop_hint, 0) \
    macro(op_switch_imm, 3) \
    macro(op_switch_char, 3) \
    macro(op_switch_string, 3) \
    macro(op_new_func, 3) \
    macro(op_new_func_exp, 3) \
    macro(op_new_generator_func, 3) \
    macro(op_new_generator_func_exp, 3) \
    macro(op_new_async_func, 3) \
    macro(op_new_async_func_exp, 3) \
    macro(op_new_async_generator_func, 3) \
    macro(op_new_async_generator_func_exp, 3) \
    macro(op_set_function_name, 2) \
    macro(op_ret, 1) \
    macro(op_strcat, 3) \
    macro(op_to_primitive, 2) \
    macro(op_to_property_key, 2) \
    macro(op_put_to_arguments, 3) \
    macro(op_push_with_scope, 3) \
    macro(op_create_lexical_environment, 4) \
    macro(op_create_generator_frame_environment, 4) \
    macro(op_get_parent_scope, 2) \
    macro(op_throw, 1) \
    macro(op_throw_static_error, 2) \
    macro(op_debug, 2) \
    macro(op_end, 1) \
    macro(op_get_property_enumerator, 2) \
    macro(op_unreachable, 0) \
    macro(op_create_rest, 3) \
    macro(op_get_rest_length, 2) \
    macro(op_yield, 2) \
    macro(op_check_traps, 0) \
    macro(op_log_shadow_chicken_prologue, 1) \
    macro(op_log_shadow_chicken_tail, 2) \
    macro(op_resolve_scope_for_hoisting_func_decl_in_eval, 3) \
    macro(op_put_internal_field, 3) \
    macro(op_nop, 0) \
    macro(op_super_sampler_begin, 0) \
    macro(op_wide16, 0) \
    macro(op_super_sampler_end, 0) \
    macro(op_wide32, 0) \
    macro(op_enter, 0) \
    macro(op_get_scope, 1) \
    macro(op_create_direct_arguments, 1) \
    macro(op_create_scoped_arguments, 2) \
    macro(op_create_cloned_arguments, 1) \
    macro(op_new_promise, 2) \
    macro(op_new_generator, 1) \
    macro(op_argument_count, 1) \
    macro(op_check_tdz, 1) \
    macro(op_new_array_with_spread, 4) \
    macro(op_spread, 2) \
    macro(op_new_regexp, 2) \
    macro(op_mov, 2) \
    macro(op_eq, 3) \
    macro(op_neq, 3) \
    macro(op_stricteq, 3) \
    macro(op_nstricteq, 3) \
    macro(op_less, 3) \
    macro(op_lesseq, 3) \
    macro(op_greater, 3) \
    macro(op_greatereq, 3) \
    macro(op_below, 3) \
    macro(op_beloweq, 3) \
    macro(op_mod, 3) \
    macro(op_pow, 3) \
    macro(op_urshift, 3) \
    macro(op_add, 5) \
    macro(op_mul, 5) \
    macro(op_div, 5) \
    macro(op_sub, 5) \
    macro(op_eq_null, 2) \
    macro(op_neq_null, 2) \
    macro(op_to_string, 2) \
    macro(op_unsigned, 2) \
    macro(op_is_empty, 2) \
    macro(op_typeof_is_undefined, 2) \
    macro(op_typeof_is_object, 2) \
    macro(op_typeof_is_function, 2) \
    macro(op_is_undefined_or_null, 2) \
    macro(op_is_boolean, 2) \
    macro(op_is_number, 2) \
    macro(op_is_big_int, 2) \
    macro(op_is_object, 2) \
    macro(op_is_callable, 2) \
    macro(op_is_constructor, 2) \
    macro(op_inc, 2) \
    macro(op_dec, 2) \
    macro(op_negate, 4) \
    macro(op_not, 2) \
    macro(op_identity_with_profile, 3) \
    macro(op_overrides_has_instance, 3) \
    macro(op_instanceof, 3) \
    macro(op_instanceof_custom, 4) \
    macro(op_typeof, 2) \
    macro(op_is_cell_with_type, 3) \

#define NUMBER_OF_BYTECODE_IDS 190
#define MAX_LENGTH_OF_BYTECODE_IDS 8
static constexpr unsigned bytecodeCheckpointCountTable[] = {
    2,
    2,
    3,
    2,
    2,
    0, // this unused entry is needed since MSVC won't compile empty arrays
};

#define NUMBER_OF_BYTECODE_WITH_CHECKPOINTS 5

#define FOR_EACH_BYTECODE_METADATA_SIZE(macro) \
    macro(sizeof(OpTailCallVarargs::Metadata))\
    macro(sizeof(OpCallVarargs::Metadata))\
    macro(sizeof(OpIteratorNext::Metadata))\
    macro(sizeof(OpConstructVarargs::Metadata))\
    macro(sizeof(OpIteratorOpen::Metadata))\
    macro(sizeof(OpSetPrivateBrand::Metadata))\
    macro(sizeof(OpCheckPrivateBrand::Metadata))\
    macro(sizeof(OpPutById::Metadata))\
    macro(sizeof(OpConstruct::Metadata))\
    macro(sizeof(OpBitand::Metadata))\
    macro(sizeof(OpBitor::Metadata))\
    macro(sizeof(OpBitxor::Metadata))\
    macro(sizeof(OpLshift::Metadata))\
    macro(sizeof(OpRshift::Metadata))\
    macro(sizeof(OpToObject::Metadata))\
    macro(sizeof(OpToNumber::Metadata))\
    macro(sizeof(OpToNumeric::Metadata))\
    macro(sizeof(OpTailCall::Metadata))\
    macro(sizeof(OpCallDirectEval::Metadata))\
    macro(sizeof(OpTailCallForwardArguments::Metadata))\
    macro(sizeof(OpCreateGenerator::Metadata))\
    macro(sizeof(OpCreateAsyncGenerator::Metadata))\
    macro(sizeof(OpGetByVal::Metadata))\
    macro(sizeof(OpGetPrivateName::Metadata))\
    macro(sizeof(OpCreatePromise::Metadata))\
    macro(sizeof(OpBitnot::Metadata))\
    macro(sizeof(OpCatch::Metadata))\
    macro(sizeof(OpNewArrayWithSize::Metadata))\
    macro(sizeof(OpNewArrayBuffer::Metadata))\
    macro(sizeof(OpGetById::Metadata))\
    macro(sizeof(OpGetByIdWithThis::Metadata))\
    macro(sizeof(OpProfileType::Metadata))\
    macro(sizeof(OpProfileControlFlow::Metadata))\
    macro(sizeof(OpGetByValWithThis::Metadata))\
    macro(sizeof(OpEnumeratorGetByVal::Metadata))\
    macro(sizeof(OpGetByIdDirect::Metadata))\
    macro(sizeof(OpGetPrototypeOf::Metadata))\
    macro(sizeof(OpGetInternalField::Metadata))\
    macro(sizeof(OpTryGetById::Metadata))\
    macro(sizeof(OpNewArrayWithSpecies::Metadata))\
    macro(sizeof(OpCall::Metadata))\
    macro(sizeof(OpGetArgument::Metadata))\
    macro(sizeof(OpPutPrivateName::Metadata))\
    macro(sizeof(OpResolveScope::Metadata))\
    macro(sizeof(OpGetFromScope::Metadata))\
    macro(sizeof(OpPutToScope::Metadata))\
    macro(sizeof(OpGetFromArguments::Metadata))\
    macro(sizeof(OpCreateThis::Metadata))\
    macro(sizeof(OpNewObject::Metadata))\
    macro(sizeof(OpToThis::Metadata))\
    macro(sizeof(OpNewArray::Metadata))\
    macro(sizeof(OpPutByVal::Metadata))\
    macro(sizeof(OpPutByValDirect::Metadata))\
    macro(sizeof(OpInByVal::Metadata))\
    macro(sizeof(OpEnumeratorNext::Metadata))\
    macro(sizeof(OpEnumeratorInByVal::Metadata))\
    macro(sizeof(OpEnumeratorHasOwnProperty::Metadata))\
    macro(sizeof(OpJneqPtr::Metadata))\

#define NUMBER_OF_BYTECODE_WITH_METADATA 58

#define FOR_EACH_BYTECODE_METADATA_ALIGNMENT(macro) \
    macro(alignof(OpTailCallVarargs::Metadata))\
    macro(alignof(OpCallVarargs::Metadata))\
    macro(alignof(OpIteratorNext::Metadata))\
    macro(alignof(OpConstructVarargs::Metadata))\
    macro(alignof(OpIteratorOpen::Metadata))\
    macro(alignof(OpSetPrivateBrand::Metadata))\
    macro(alignof(OpCheckPrivateBrand::Metadata))\
    macro(alignof(OpPutById::Metadata))\
    macro(alignof(OpConstruct::Metadata))\
    macro(alignof(OpBitand::Metadata))\
    macro(alignof(OpBitor::Metadata))\
    macro(alignof(OpBitxor::Metadata))\
    macro(alignof(OpLshift::Metadata))\
    macro(alignof(OpRshift::Metadata))\
    macro(alignof(OpToObject::Metadata))\
    macro(alignof(OpToNumber::Metadata))\
    macro(alignof(OpToNumeric::Metadata))\
    macro(alignof(OpTailCall::Metadata))\
    macro(alignof(OpCallDirectEval::Metadata))\
    macro(alignof(OpTailCallForwardArguments::Metadata))\
    macro(alignof(OpCreateGenerator::Metadata))\
    macro(alignof(OpCreateAsyncGenerator::Metadata))\
    macro(alignof(OpGetByVal::Metadata))\
    macro(alignof(OpGetPrivateName::Metadata))\
    macro(alignof(OpCreatePromise::Metadata))\
    macro(alignof(OpBitnot::Metadata))\
    macro(alignof(OpCatch::Metadata))\
    macro(alignof(OpNewArrayWithSize::Metadata))\
    macro(alignof(OpNewArrayBuffer::Metadata))\
    macro(alignof(OpGetById::Metadata))\
    macro(alignof(OpGetByIdWithThis::Metadata))\
    macro(alignof(OpProfileType::Metadata))\
    macro(alignof(OpProfileControlFlow::Metadata))\
    macro(alignof(OpGetByValWithThis::Metadata))\
    macro(alignof(OpEnumeratorGetByVal::Metadata))\
    macro(alignof(OpGetByIdDirect::Metadata))\
    macro(alignof(OpGetPrototypeOf::Metadata))\
    macro(alignof(OpGetInternalField::Metadata))\
    macro(alignof(OpTryGetById::Metadata))\
    macro(alignof(OpNewArrayWithSpecies::Metadata))\
    macro(alignof(OpCall::Metadata))\
    macro(alignof(OpGetArgument::Metadata))\
    macro(alignof(OpPutPrivateName::Metadata))\
    macro(alignof(OpResolveScope::Metadata))\
    macro(alignof(OpGetFromScope::Metadata))\
    macro(alignof(OpPutToScope::Metadata))\
    macro(alignof(OpGetFromArguments::Metadata))\
    macro(alignof(OpCreateThis::Metadata))\
    macro(alignof(OpNewObject::Metadata))\
    macro(alignof(OpToThis::Metadata))\
    macro(alignof(OpNewArray::Metadata))\
    macro(alignof(OpPutByVal::Metadata))\
    macro(alignof(OpPutByValDirect::Metadata))\
    macro(alignof(OpInByVal::Metadata))\
    macro(alignof(OpEnumeratorNext::Metadata))\
    macro(alignof(OpEnumeratorInByVal::Metadata))\
    macro(alignof(OpEnumeratorHasOwnProperty::Metadata))\
    macro(alignof(OpJneqPtr::Metadata))\

#define op_tail_call_varargs_value_string "0"
#define op_call_varargs_value_string "1"
#define op_iterator_next_value_string "2"
#define op_construct_varargs_value_string "3"
#define op_iterator_open_value_string "4"
#define op_set_private_brand_value_string "5"
#define op_check_private_brand_value_string "6"
#define op_put_by_id_value_string "7"
#define op_construct_value_string "8"
#define op_bitand_value_string "9"
#define op_bitor_value_string "10"
#define op_bitxor_value_string "11"
#define op_lshift_value_string "12"
#define op_rshift_value_string "13"
#define op_to_object_value_string "14"
#define op_to_number_value_string "15"
#define op_to_numeric_value_string "16"
#define op_tail_call_value_string "17"
#define op_call_direct_eval_value_string "18"
#define op_tail_call_forward_arguments_value_string "19"
#define op_create_generator_value_string "20"
#define op_create_async_generator_value_string "21"
#define op_get_by_val_value_string "22"
#define op_get_private_name_value_string "23"
#define op_create_promise_value_string "24"
#define op_bitnot_value_string "25"
#define op_catch_value_string "26"
#define op_new_array_with_size_value_string "27"
#define op_new_array_buffer_value_string "28"
#define op_get_by_id_value_string "29"
#define op_get_by_id_with_this_value_string "30"
#define op_profile_type_value_string "31"
#define op_profile_control_flow_value_string "32"
#define op_get_by_val_with_this_value_string "33"
#define op_enumerator_get_by_val_value_string "34"
#define op_get_by_id_direct_value_string "35"
#define op_get_prototype_of_value_string "36"
#define op_get_internal_field_value_string "37"
#define op_try_get_by_id_value_string "38"
#define op_new_array_with_species_value_string "39"
#define op_call_value_string "40"
#define op_get_argument_value_string "41"
#define op_put_private_name_value_string "42"
#define op_resolve_scope_value_string "43"
#define op_get_from_scope_value_string "44"
#define op_put_to_scope_value_string "45"
#define op_get_from_arguments_value_string "46"
#define op_create_this_value_string "47"
#define op_new_object_value_string "48"
#define op_to_this_value_string "49"
#define op_new_array_value_string "50"
#define op_put_by_val_value_string "51"
#define op_put_by_val_direct_value_string "52"
#define op_in_by_val_value_string "53"
#define op_enumerator_next_value_string "54"
#define op_enumerator_in_by_val_value_string "55"
#define op_enumerator_has_own_property_value_string "56"
#define op_jneq_ptr_value_string "57"
#define op_in_by_id_value_string "58"
#define op_has_private_name_value_string "59"
#define op_has_private_brand_value_string "60"
#define op_put_by_id_with_this_value_string "61"
#define op_del_by_id_value_string "62"
#define op_put_by_val_with_this_value_string "63"
#define op_del_by_val_value_string "64"
#define op_put_getter_by_id_value_string "65"
#define op_put_setter_by_id_value_string "66"
#define op_put_getter_setter_by_id_value_string "67"
#define op_put_getter_by_val_value_string "68"
#define op_put_setter_by_val_value_string "69"
#define op_define_data_property_value_string "70"
#define op_define_accessor_property_value_string "71"
#define op_jmp_value_string "72"
#define op_jtrue_value_string "73"
#define op_jfalse_value_string "74"
#define op_jeq_null_value_string "75"
#define op_jneq_null_value_string "76"
#define op_jundefined_or_null_value_string "77"
#define op_jnundefined_or_null_value_string "78"
#define op_jeq_ptr_value_string "79"
#define op_jeq_value_string "80"
#define op_jstricteq_value_string "81"
#define op_jneq_value_string "82"
#define op_jnstricteq_value_string "83"
#define op_jless_value_string "84"
#define op_jlesseq_value_string "85"
#define op_jgreater_value_string "86"
#define op_jgreatereq_value_string "87"
#define op_jnless_value_string "88"
#define op_jnlesseq_value_string "89"
#define op_jngreater_value_string "90"
#define op_jngreatereq_value_string "91"
#define op_jbelow_value_string "92"
#define op_jbeloweq_value_string "93"
#define op_loop_hint_value_string "94"
#define op_switch_imm_value_string "95"
#define op_switch_char_value_string "96"
#define op_switch_string_value_string "97"
#define op_new_func_value_string "98"
#define op_new_func_exp_value_string "99"
#define op_new_generator_func_value_string "100"
#define op_new_generator_func_exp_value_string "101"
#define op_new_async_func_value_string "102"
#define op_new_async_func_exp_value_string "103"
#define op_new_async_generator_func_value_string "104"
#define op_new_async_generator_func_exp_value_string "105"
#define op_set_function_name_value_string "106"
#define op_ret_value_string "107"
#define op_strcat_value_string "108"
#define op_to_primitive_value_string "109"
#define op_to_property_key_value_string "110"
#define op_put_to_arguments_value_string "111"
#define op_push_with_scope_value_string "112"
#define op_create_lexical_environment_value_string "113"
#define op_create_generator_frame_environment_value_string "114"
#define op_get_parent_scope_value_string "115"
#define op_throw_value_string "116"
#define op_throw_static_error_value_string "117"
#define op_debug_value_string "118"
#define op_end_value_string "119"
#define op_get_property_enumerator_value_string "120"
#define op_unreachable_value_string "121"
#define op_create_rest_value_string "122"
#define op_get_rest_length_value_string "123"
#define op_yield_value_string "124"
#define op_check_traps_value_string "125"
#define op_log_shadow_chicken_prologue_value_string "126"
#define op_log_shadow_chicken_tail_value_string "127"
#define op_resolve_scope_for_hoisting_func_decl_in_eval_value_string "128"
#define op_put_internal_field_value_string "129"
#define op_nop_value_string "130"
#define op_super_sampler_begin_value_string "131"
#define op_wide16_value_string "132"
#define op_super_sampler_end_value_string "133"
#define op_wide32_value_string "134"
#define op_enter_value_string "135"
#define op_get_scope_value_string "136"
#define op_create_direct_arguments_value_string "137"
#define op_create_scoped_arguments_value_string "138"
#define op_create_cloned_arguments_value_string "139"
#define op_new_promise_value_string "140"
#define op_new_generator_value_string "141"
#define op_argument_count_value_string "142"
#define op_check_tdz_value_string "143"
#define op_new_array_with_spread_value_string "144"
#define op_spread_value_string "145"
#define op_new_regexp_value_string "146"
#define op_mov_value_string "147"
#define op_eq_value_string "148"
#define op_neq_value_string "149"
#define op_stricteq_value_string "150"
#define op_nstricteq_value_string "151"
#define op_less_value_string "152"
#define op_lesseq_value_string "153"
#define op_greater_value_string "154"
#define op_greatereq_value_string "155"
#define op_below_value_string "156"
#define op_beloweq_value_string "157"
#define op_mod_value_string "158"
#define op_pow_value_string "159"
#define op_urshift_value_string "160"
#define op_add_value_string "161"
#define op_mul_value_string "162"
#define op_div_value_string "163"
#define op_sub_value_string "164"
#define op_eq_null_value_string "165"
#define op_neq_null_value_string "166"
#define op_to_string_value_string "167"
#define op_unsigned_value_string "168"
#define op_is_empty_value_string "169"
#define op_typeof_is_undefined_value_string "170"
#define op_typeof_is_object_value_string "171"
#define op_typeof_is_function_value_string "172"
#define op_is_undefined_or_null_value_string "173"
#define op_is_boolean_value_string "174"
#define op_is_number_value_string "175"
#define op_is_big_int_value_string "176"
#define op_is_object_value_string "177"
#define op_is_callable_value_string "178"
#define op_is_constructor_value_string "179"
#define op_inc_value_string "180"
#define op_dec_value_string "181"
#define op_negate_value_string "182"
#define op_not_value_string "183"
#define op_identity_with_profile_value_string "184"
#define op_overrides_has_instance_value_string "185"
#define op_instanceof_value_string "186"
#define op_instanceof_custom_value_string "187"
#define op_typeof_value_string "188"
#define op_is_cell_with_type_value_string "189"
#define op_tail_call_varargs_wide16_value_string "549"
#define op_call_varargs_wide16_value_string "550"
#define op_iterator_next_wide16_value_string "551"
#define op_construct_varargs_wide16_value_string "552"
#define op_iterator_open_wide16_value_string "553"
#define op_set_private_brand_wide16_value_string "554"
#define op_check_private_brand_wide16_value_string "555"
#define op_put_by_id_wide16_value_string "556"
#define op_construct_wide16_value_string "557"
#define op_bitand_wide16_value_string "558"
#define op_bitor_wide16_value_string "559"
#define op_bitxor_wide16_value_string "560"
#define op_lshift_wide16_value_string "561"
#define op_rshift_wide16_value_string "562"
#define op_to_object_wide16_value_string "563"
#define op_to_number_wide16_value_string "564"
#define op_to_numeric_wide16_value_string "565"
#define op_tail_call_wide16_value_string "566"
#define op_call_direct_eval_wide16_value_string "567"
#define op_tail_call_forward_arguments_wide16_value_string "568"
#define op_create_generator_wide16_value_string "569"
#define op_create_async_generator_wide16_value_string "570"
#define op_get_by_val_wide16_value_string "571"
#define op_get_private_name_wide16_value_string "572"
#define op_create_promise_wide16_value_string "573"
#define op_bitnot_wide16_value_string "574"
#define op_catch_wide16_value_string "575"
#define op_new_array_with_size_wide16_value_string "576"
#define op_new_array_buffer_wide16_value_string "577"
#define op_get_by_id_wide16_value_string "578"
#define op_get_by_id_with_this_wide16_value_string "579"
#define op_profile_type_wide16_value_string "580"
#define op_profile_control_flow_wide16_value_string "581"
#define op_get_by_val_with_this_wide16_value_string "582"
#define op_enumerator_get_by_val_wide16_value_string "583"
#define op_get_by_id_direct_wide16_value_string "584"
#define op_get_prototype_of_wide16_value_string "585"
#define op_get_internal_field_wide16_value_string "586"
#define op_try_get_by_id_wide16_value_string "587"
#define op_new_array_with_species_wide16_value_string "588"
#define op_call_wide16_value_string "589"
#define op_get_argument_wide16_value_string "590"
#define op_put_private_name_wide16_value_string "591"
#define op_resolve_scope_wide16_value_string "592"
#define op_get_from_scope_wide16_value_string "593"
#define op_put_to_scope_wide16_value_string "594"
#define op_get_from_arguments_wide16_value_string "595"
#define op_create_this_wide16_value_string "596"
#define op_new_object_wide16_value_string "597"
#define op_to_this_wide16_value_string "598"
#define op_new_array_wide16_value_string "599"
#define op_put_by_val_wide16_value_string "600"
#define op_put_by_val_direct_wide16_value_string "601"
#define op_in_by_val_wide16_value_string "602"
#define op_enumerator_next_wide16_value_string "603"
#define op_enumerator_in_by_val_wide16_value_string "604"
#define op_enumerator_has_own_property_wide16_value_string "605"
#define op_jneq_ptr_wide16_value_string "606"
#define op_in_by_id_wide16_value_string "607"
#define op_has_private_name_wide16_value_string "608"
#define op_has_private_brand_wide16_value_string "609"
#define op_put_by_id_with_this_wide16_value_string "610"
#define op_del_by_id_wide16_value_string "611"
#define op_put_by_val_with_this_wide16_value_string "612"
#define op_del_by_val_wide16_value_string "613"
#define op_put_getter_by_id_wide16_value_string "614"
#define op_put_setter_by_id_wide16_value_string "615"
#define op_put_getter_setter_by_id_wide16_value_string "616"
#define op_put_getter_by_val_wide16_value_string "617"
#define op_put_setter_by_val_wide16_value_string "618"
#define op_define_data_property_wide16_value_string "619"
#define op_define_accessor_property_wide16_value_string "620"
#define op_jmp_wide16_value_string "621"
#define op_jtrue_wide16_value_string "622"
#define op_jfalse_wide16_value_string "623"
#define op_jeq_null_wide16_value_string "624"
#define op_jneq_null_wide16_value_string "625"
#define op_jundefined_or_null_wide16_value_string "626"
#define op_jnundefined_or_null_wide16_value_string "627"
#define op_jeq_ptr_wide16_value_string "628"
#define op_jeq_wide16_value_string "629"
#define op_jstricteq_wide16_value_string "630"
#define op_jneq_wide16_value_string "631"
#define op_jnstricteq_wide16_value_string "632"
#define op_jless_wide16_value_string "633"
#define op_jlesseq_wide16_value_string "634"
#define op_jgreater_wide16_value_string "635"
#define op_jgreatereq_wide16_value_string "636"
#define op_jnless_wide16_value_string "637"
#define op_jnlesseq_wide16_value_string "638"
#define op_jngreater_wide16_value_string "639"
#define op_jngreatereq_wide16_value_string "640"
#define op_jbelow_wide16_value_string "641"
#define op_jbeloweq_wide16_value_string "642"
#define op_loop_hint_wide16_value_string "643"
#define op_switch_imm_wide16_value_string "644"
#define op_switch_char_wide16_value_string "645"
#define op_switch_string_wide16_value_string "646"
#define op_new_func_wide16_value_string "647"
#define op_new_func_exp_wide16_value_string "648"
#define op_new_generator_func_wide16_value_string "649"
#define op_new_generator_func_exp_wide16_value_string "650"
#define op_new_async_func_wide16_value_string "651"
#define op_new_async_func_exp_wide16_value_string "652"
#define op_new_async_generator_func_wide16_value_string "653"
#define op_new_async_generator_func_exp_wide16_value_string "654"
#define op_set_function_name_wide16_value_string "655"
#define op_ret_wide16_value_string "656"
#define op_strcat_wide16_value_string "657"
#define op_to_primitive_wide16_value_string "658"
#define op_to_property_key_wide16_value_string "659"
#define op_put_to_arguments_wide16_value_string "660"
#define op_push_with_scope_wide16_value_string "661"
#define op_create_lexical_environment_wide16_value_string "662"
#define op_create_generator_frame_environment_wide16_value_string "663"
#define op_get_parent_scope_wide16_value_string "664"
#define op_throw_wide16_value_string "665"
#define op_throw_static_error_wide16_value_string "666"
#define op_debug_wide16_value_string "667"
#define op_end_wide16_value_string "668"
#define op_get_property_enumerator_wide16_value_string "669"
#define op_unreachable_wide16_value_string "670"
#define op_create_rest_wide16_value_string "671"
#define op_get_rest_length_wide16_value_string "672"
#define op_yield_wide16_value_string "673"
#define op_check_traps_wide16_value_string "674"
#define op_log_shadow_chicken_prologue_wide16_value_string "675"
#define op_log_shadow_chicken_tail_wide16_value_string "676"
#define op_resolve_scope_for_hoisting_func_decl_in_eval_wide16_value_string "677"
#define op_put_internal_field_wide16_value_string "678"
#define op_nop_wide16_value_string "679"
#define op_super_sampler_begin_wide16_value_string "680"
#define op_wide16_wide16_value_string "681"
#define op_super_sampler_end_wide16_value_string "682"
#define op_wide32_wide16_value_string "683"
#define op_enter_wide16_value_string "684"
#define op_get_scope_wide16_value_string "685"
#define op_create_direct_arguments_wide16_value_string "686"
#define op_create_scoped_arguments_wide16_value_string "687"
#define op_create_cloned_arguments_wide16_value_string "688"
#define op_new_promise_wide16_value_string "689"
#define op_new_generator_wide16_value_string "690"
#define op_argument_count_wide16_value_string "691"
#define op_check_tdz_wide16_value_string "692"
#define op_new_array_with_spread_wide16_value_string "693"
#define op_spread_wide16_value_string "694"
#define op_new_regexp_wide16_value_string "695"
#define op_mov_wide16_value_string "696"
#define op_eq_wide16_value_string "697"
#define op_neq_wide16_value_string "698"
#define op_stricteq_wide16_value_string "699"
#define op_nstricteq_wide16_value_string "700"
#define op_less_wide16_value_string "701"
#define op_lesseq_wide16_value_string "702"
#define op_greater_wide16_value_string "703"
#define op_greatereq_wide16_value_string "704"
#define op_below_wide16_value_string "705"
#define op_beloweq_wide16_value_string "706"
#define op_mod_wide16_value_string "707"
#define op_pow_wide16_value_string "708"
#define op_urshift_wide16_value_string "709"
#define op_add_wide16_value_string "710"
#define op_mul_wide16_value_string "711"
#define op_div_wide16_value_string "712"
#define op_sub_wide16_value_string "713"
#define op_eq_null_wide16_value_string "714"
#define op_neq_null_wide16_value_string "715"
#define op_to_string_wide16_value_string "716"
#define op_unsigned_wide16_value_string "717"
#define op_is_empty_wide16_value_string "718"
#define op_typeof_is_undefined_wide16_value_string "719"
#define op_typeof_is_object_wide16_value_string "720"
#define op_typeof_is_function_wide16_value_string "721"
#define op_is_undefined_or_null_wide16_value_string "722"
#define op_is_boolean_wide16_value_string "723"
#define op_is_number_wide16_value_string "724"
#define op_is_big_int_wide16_value_string "725"
#define op_is_object_wide16_value_string "726"
#define op_is_callable_wide16_value_string "727"
#define op_is_constructor_wide16_value_string "728"
#define op_inc_wide16_value_string "729"
#define op_dec_wide16_value_string "730"
#define op_negate_wide16_value_string "731"
#define op_not_wide16_value_string "732"
#define op_identity_with_profile_wide16_value_string "733"
#define op_overrides_has_instance_wide16_value_string "734"
#define op_instanceof_wide16_value_string "735"
#define op_instanceof_custom_wide16_value_string "736"
#define op_typeof_wide16_value_string "737"
#define op_is_cell_with_type_wide16_value_string "738"
#define op_tail_call_varargs_wide32_value_string "1098"
#define op_call_varargs_wide32_value_string "1099"
#define op_iterator_next_wide32_value_string "1100"
#define op_construct_varargs_wide32_value_string "1101"
#define op_iterator_open_wide32_value_string "1102"
#define op_set_private_brand_wide32_value_string "1103"
#define op_check_private_brand_wide32_value_string "1104"
#define op_put_by_id_wide32_value_string "1105"
#define op_construct_wide32_value_string "1106"
#define op_bitand_wide32_value_string "1107"
#define op_bitor_wide32_value_string "1108"
#define op_bitxor_wide32_value_string "1109"
#define op_lshift_wide32_value_string "1110"
#define op_rshift_wide32_value_string "1111"
#define op_to_object_wide32_value_string "1112"
#define op_to_number_wide32_value_string "1113"
#define op_to_numeric_wide32_value_string "1114"
#define op_tail_call_wide32_value_string "1115"
#define op_call_direct_eval_wide32_value_string "1116"
#define op_tail_call_forward_arguments_wide32_value_string "1117"
#define op_create_generator_wide32_value_string "1118"
#define op_create_async_generator_wide32_value_string "1119"
#define op_get_by_val_wide32_value_string "1120"
#define op_get_private_name_wide32_value_string "1121"
#define op_create_promise_wide32_value_string "1122"
#define op_bitnot_wide32_value_string "1123"
#define op_catch_wide32_value_string "1124"
#define op_new_array_with_size_wide32_value_string "1125"
#define op_new_array_buffer_wide32_value_string "1126"
#define op_get_by_id_wide32_value_string "1127"
#define op_get_by_id_with_this_wide32_value_string "1128"
#define op_profile_type_wide32_value_string "1129"
#define op_profile_control_flow_wide32_value_string "1130"
#define op_get_by_val_with_this_wide32_value_string "1131"
#define op_enumerator_get_by_val_wide32_value_string "1132"
#define op_get_by_id_direct_wide32_value_string "1133"
#define op_get_prototype_of_wide32_value_string "1134"
#define op_get_internal_field_wide32_value_string "1135"
#define op_try_get_by_id_wide32_value_string "1136"
#define op_new_array_with_species_wide32_value_string "1137"
#define op_call_wide32_value_string "1138"
#define op_get_argument_wide32_value_string "1139"
#define op_put_private_name_wide32_value_string "1140"
#define op_resolve_scope_wide32_value_string "1141"
#define op_get_from_scope_wide32_value_string "1142"
#define op_put_to_scope_wide32_value_string "1143"
#define op_get_from_arguments_wide32_value_string "1144"
#define op_create_this_wide32_value_string "1145"
#define op_new_object_wide32_value_string "1146"
#define op_to_this_wide32_value_string "1147"
#define op_new_array_wide32_value_string "1148"
#define op_put_by_val_wide32_value_string "1149"
#define op_put_by_val_direct_wide32_value_string "1150"
#define op_in_by_val_wide32_value_string "1151"
#define op_enumerator_next_wide32_value_string "1152"
#define op_enumerator_in_by_val_wide32_value_string "1153"
#define op_enumerator_has_own_property_wide32_value_string "1154"
#define op_jneq_ptr_wide32_value_string "1155"
#define op_in_by_id_wide32_value_string "1156"
#define op_has_private_name_wide32_value_string "1157"
#define op_has_private_brand_wide32_value_string "1158"
#define op_put_by_id_with_this_wide32_value_string "1159"
#define op_del_by_id_wide32_value_string "1160"
#define op_put_by_val_with_this_wide32_value_string "1161"
#define op_del_by_val_wide32_value_string "1162"
#define op_put_getter_by_id_wide32_value_string "1163"
#define op_put_setter_by_id_wide32_value_string "1164"
#define op_put_getter_setter_by_id_wide32_value_string "1165"
#define op_put_getter_by_val_wide32_value_string "1166"
#define op_put_setter_by_val_wide32_value_string "1167"
#define op_define_data_property_wide32_value_string "1168"
#define op_define_accessor_property_wide32_value_string "1169"
#define op_jmp_wide32_value_string "1170"
#define op_jtrue_wide32_value_string "1171"
#define op_jfalse_wide32_value_string "1172"
#define op_jeq_null_wide32_value_string "1173"
#define op_jneq_null_wide32_value_string "1174"
#define op_jundefined_or_null_wide32_value_string "1175"
#define op_jnundefined_or_null_wide32_value_string "1176"
#define op_jeq_ptr_wide32_value_string "1177"
#define op_jeq_wide32_value_string "1178"
#define op_jstricteq_wide32_value_string "1179"
#define op_jneq_wide32_value_string "1180"
#define op_jnstricteq_wide32_value_string "1181"
#define op_jless_wide32_value_string "1182"
#define op_jlesseq_wide32_value_string "1183"
#define op_jgreater_wide32_value_string "1184"
#define op_jgreatereq_wide32_value_string "1185"
#define op_jnless_wide32_value_string "1186"
#define op_jnlesseq_wide32_value_string "1187"
#define op_jngreater_wide32_value_string "1188"
#define op_jngreatereq_wide32_value_string "1189"
#define op_jbelow_wide32_value_string "1190"
#define op_jbeloweq_wide32_value_string "1191"
#define op_loop_hint_wide32_value_string "1192"
#define op_switch_imm_wide32_value_string "1193"
#define op_switch_char_wide32_value_string "1194"
#define op_switch_string_wide32_value_string "1195"
#define op_new_func_wide32_value_string "1196"
#define op_new_func_exp_wide32_value_string "1197"
#define op_new_generator_func_wide32_value_string "1198"
#define op_new_generator_func_exp_wide32_value_string "1199"
#define op_new_async_func_wide32_value_string "1200"
#define op_new_async_func_exp_wide32_value_string "1201"
#define op_new_async_generator_func_wide32_value_string "1202"
#define op_new_async_generator_func_exp_wide32_value_string "1203"
#define op_set_function_name_wide32_value_string "1204"
#define op_ret_wide32_value_string "1205"
#define op_strcat_wide32_value_string "1206"
#define op_to_primitive_wide32_value_string "1207"
#define op_to_property_key_wide32_value_string "1208"
#define op_put_to_arguments_wide32_value_string "1209"
#define op_push_with_scope_wide32_value_string "1210"
#define op_create_lexical_environment_wide32_value_string "1211"
#define op_create_generator_frame_environment_wide32_value_string "1212"
#define op_get_parent_scope_wide32_value_string "1213"
#define op_throw_wide32_value_string "1214"
#define op_throw_static_error_wide32_value_string "1215"
#define op_debug_wide32_value_string "1216"
#define op_end_wide32_value_string "1217"
#define op_get_property_enumerator_wide32_value_string "1218"
#define op_unreachable_wide32_value_string "1219"
#define op_create_rest_wide32_value_string "1220"
#define op_get_rest_length_wide32_value_string "1221"
#define op_yield_wide32_value_string "1222"
#define op_check_traps_wide32_value_string "1223"
#define op_log_shadow_chicken_prologue_wide32_value_string "1224"
#define op_log_shadow_chicken_tail_wide32_value_string "1225"
#define op_resolve_scope_for_hoisting_func_decl_in_eval_wide32_value_string "1226"
#define op_put_internal_field_wide32_value_string "1227"
#define op_nop_wide32_value_string "1228"
#define op_super_sampler_begin_wide32_value_string "1229"
#define op_wide16_wide32_value_string "1230"
#define op_super_sampler_end_wide32_value_string "1231"
#define op_wide32_wide32_value_string "1232"
#define op_enter_wide32_value_string "1233"
#define op_get_scope_wide32_value_string "1234"
#define op_create_direct_arguments_wide32_value_string "1235"
#define op_create_scoped_arguments_wide32_value_string "1236"
#define op_create_cloned_arguments_wide32_value_string "1237"
#define op_new_promise_wide32_value_string "1238"
#define op_new_generator_wide32_value_string "1239"
#define op_argument_count_wide32_value_string "1240"
#define op_check_tdz_wide32_value_string "1241"
#define op_new_array_with_spread_wide32_value_string "1242"
#define op_spread_wide32_value_string "1243"
#define op_new_regexp_wide32_value_string "1244"
#define op_mov_wide32_value_string "1245"
#define op_eq_wide32_value_string "1246"
#define op_neq_wide32_value_string "1247"
#define op_stricteq_wide32_value_string "1248"
#define op_nstricteq_wide32_value_string "1249"
#define op_less_wide32_value_string "1250"
#define op_lesseq_wide32_value_string "1251"
#define op_greater_wide32_value_string "1252"
#define op_greatereq_wide32_value_string "1253"
#define op_below_wide32_value_string "1254"
#define op_beloweq_wide32_value_string "1255"
#define op_mod_wide32_value_string "1256"
#define op_pow_wide32_value_string "1257"
#define op_urshift_wide32_value_string "1258"
#define op_add_wide32_value_string "1259"
#define op_mul_wide32_value_string "1260"
#define op_div_wide32_value_string "1261"
#define op_sub_wide32_value_string "1262"
#define op_eq_null_wide32_value_string "1263"
#define op_neq_null_wide32_value_string "1264"
#define op_to_string_wide32_value_string "1265"
#define op_unsigned_wide32_value_string "1266"
#define op_is_empty_wide32_value_string "1267"
#define op_typeof_is_undefined_wide32_value_string "1268"
#define op_typeof_is_object_wide32_value_string "1269"
#define op_typeof_is_function_wide32_value_string "1270"
#define op_is_undefined_or_null_wide32_value_string "1271"
#define op_is_boolean_wide32_value_string "1272"
#define op_is_number_wide32_value_string "1273"
#define op_is_big_int_wide32_value_string "1274"
#define op_is_object_wide32_value_string "1275"
#define op_is_callable_wide32_value_string "1276"
#define op_is_constructor_wide32_value_string "1277"
#define op_inc_wide32_value_string "1278"
#define op_dec_wide32_value_string "1279"
#define op_negate_wide32_value_string "1280"
#define op_not_wide32_value_string "1281"
#define op_identity_with_profile_wide32_value_string "1282"
#define op_overrides_has_instance_wide32_value_string "1283"
#define op_instanceof_wide32_value_string "1284"
#define op_instanceof_custom_wide32_value_string "1285"
#define op_typeof_wide32_value_string "1286"
#define op_is_cell_with_type_wide32_value_string "1287"

#define FOR_EACH_CLOOP_BYTECODE_HELPER_ID(macro) \
    macro(llint_cloop_did_return_from_js_49, 0) \
    macro(llint_return_to_host, 0) \
    macro(llint_vm_entry_to_javascript, 0) \
    macro(llint_vm_entry_to_native, 0) \
    macro(llint_cloop_did_return_from_js_1, 0) \
    macro(llint_cloop_did_return_from_js_2, 0) \
    macro(llint_cloop_did_return_from_js_3, 0) \
    macro(llint_cloop_did_return_from_js_4, 0) \
    macro(llint_cloop_did_return_from_js_5, 0) \
    macro(llint_cloop_did_return_from_js_6, 0) \
    macro(llint_cloop_did_return_from_js_7, 0) \
    macro(llint_cloop_did_return_from_js_8, 0) \
    macro(llint_cloop_did_return_from_js_9, 0) \
    macro(llint_cloop_did_return_from_js_10, 0) \
    macro(llint_cloop_did_return_from_js_11, 0) \
    macro(llint_cloop_did_return_from_js_12, 0) \
    macro(llint_cloop_did_return_from_js_13, 0) \
    macro(llint_cloop_did_return_from_js_14, 0) \
    macro(llint_cloop_did_return_from_js_15, 0) \
    macro(llint_cloop_did_return_from_js_16, 0) \
    macro(llint_cloop_did_return_from_js_17, 0) \
    macro(llint_cloop_did_return_from_js_18, 0) \
    macro(llint_cloop_did_return_from_js_19, 0) \
    macro(llint_cloop_did_return_from_js_20, 0) \
    macro(llint_cloop_did_return_from_js_21, 0) \
    macro(llint_cloop_did_return_from_js_22, 0) \
    macro(llint_cloop_did_return_from_js_23, 0) \
    macro(llint_cloop_did_return_from_js_24, 0) \
    macro(llint_cloop_did_return_from_js_25, 0) \
    macro(llint_cloop_did_return_from_js_26, 0) \
    macro(llint_cloop_did_return_from_js_27, 0) \
    macro(llint_cloop_did_return_from_js_28, 0) \
    macro(llint_cloop_did_return_from_js_29, 0) \
    macro(llint_cloop_did_return_from_js_30, 0) \
    macro(llint_cloop_did_return_from_js_31, 0) \
    macro(llint_cloop_did_return_from_js_32, 0) \
    macro(llint_cloop_did_return_from_js_33, 0) \
    macro(llint_cloop_did_return_from_js_34, 0) \
    macro(llint_cloop_did_return_from_js_35, 0) \
    macro(llint_cloop_did_return_from_js_36, 0) \
    macro(llint_cloop_did_return_from_js_37, 0) \
    macro(llint_cloop_did_return_from_js_38, 0) \
    macro(llint_cloop_did_return_from_js_39, 0) \
    macro(llint_cloop_did_return_from_js_40, 0) \
    macro(llint_cloop_did_return_from_js_41, 0) \
    macro(llint_cloop_did_return_from_js_42, 0) \
    macro(llint_cloop_did_return_from_js_43, 0) \
    macro(llint_cloop_did_return_from_js_44, 0) \
    macro(llint_cloop_did_return_from_js_45, 0) \
    macro(llint_cloop_did_return_from_js_46, 0) \
    macro(llint_cloop_did_return_from_js_47, 0) \
    macro(llint_cloop_did_return_from_js_48, 0) \
    macro(llint_entry, 0) \

#define NUMBER_OF_CLOOP_BYTECODE_HELPER_IDS 53
#define MAX_LENGTH_OF_CLOOP_BYTECODE_HELPER_IDS 0

#define FOR_EACH_BYTECODE_HELPER_ID(macro) \
    macro(wasm_trampoline_wasm_tail_call_indirect, 0) \
    macro(llint_eval_prologue, 0) \
    macro(llint_module_program_prologue, 0) \
    macro(llint_function_for_call_prologue, 0) \
    macro(llint_function_for_construct_prologue, 0) \
    macro(llint_function_for_call_arity_check, 0) \
    macro(llint_function_for_construct_arity_check, 0) \
    macro(llint_generic_return_point, 0) \
    macro(llint_throw_from_slow_path_trampoline, 0) \
    macro(llint_throw_during_call_trampoline, 0) \
    macro(llint_native_call_trampoline, 0) \
    macro(llint_native_construct_trampoline, 0) \
    macro(llint_internal_function_call_trampoline, 0) \
    macro(llint_internal_function_construct_trampoline, 0) \
    macro(llint_link_call_trampoline, 0) \
    macro(llint_virtual_call_trampoline, 0) \
    macro(llint_virtual_construct_trampoline, 0) \
    macro(llint_virtual_tail_call_trampoline, 0) \
    macro(checkpoint_osr_exit_from_inlined_call_trampoline, 0) \
    macro(checkpoint_osr_exit_trampoline, 0) \
    macro(normal_osr_exit_trampoline, 0) \
    macro(fuzzer_return_early_from_loop_hint, 0) \
    macro(llint_get_host_call_return_value, 0) \
    macro(llint_handle_uncaught_exception, 0) \
    macro(op_call_return_location, 0) \
    macro(op_construct_return_location, 0) \
    macro(op_call_varargs_return_location, 0) \
    macro(op_construct_varargs_return_location, 0) \
    macro(op_call_varargs_slow_return_location, 0) \
    macro(op_construct_varargs_slow_return_location, 0) \
    macro(op_get_by_id_return_location, 0) \
    macro(op_get_by_val_return_location, 0) \
    macro(op_put_by_id_return_location, 0) \
    macro(op_put_by_val_return_location, 0) \
    macro(op_iterator_open_return_location, 0) \
    macro(op_iterator_next_return_location, 0) \
    macro(wasm_function_prologue, 0) \
    macro(llint_program_prologue, 0) \
    macro(op_call_slow_return_location, 0) \
    macro(op_construct_slow_return_location, 0) \
    macro(op_iterator_open_slow_return_location, 0) \
    macro(op_iterator_next_slow_return_location, 0) \
    macro(op_tail_call_slow_return_location, 0) \
    macro(op_tail_call_forward_arguments_slow_return_location, 0) \
    macro(op_tail_call_varargs_slow_return_location, 0) \
    macro(op_call_direct_eval_slow_return_location, 0) \
    macro(js_trampoline_op_call, 0) \
    macro(js_trampoline_op_construct, 0) \
    macro(js_trampoline_op_call_varargs, 0) \
    macro(js_trampoline_op_construct_varargs, 0) \
    macro(js_trampoline_op_iterator_next, 0) \
    macro(js_trampoline_op_iterator_open, 0) \
    macro(js_trampoline_op_call_slow, 0) \
    macro(js_trampoline_op_tail_call_slow, 0) \
    macro(js_trampoline_op_construct_slow, 0) \
    macro(js_trampoline_op_call_varargs_slow, 0) \
    macro(js_trampoline_op_tail_call_varargs_slow, 0) \
    macro(js_trampoline_op_tail_call_forward_arguments_slow, 0) \
    macro(js_trampoline_op_construct_varargs_slow, 0) \
    macro(js_trampoline_op_call_direct_eval_slow, 0) \
    macro(js_trampoline_op_iterator_next_slow, 0) \
    macro(js_trampoline_op_iterator_open_slow, 0) \
    macro(js_trampoline_llint_function_for_call_arity_check_untag, 0) \
    macro(js_trampoline_llint_function_for_call_arity_check_tag, 0) \
    macro(js_trampoline_llint_function_for_construct_arity_check_untag, 0) \
    macro(js_trampoline_llint_function_for_construct_arity_check_tag, 0) \
    macro(wasm_trampoline_wasm_call, 0) \
    macro(wasm_trampoline_wasm_call_indirect, 0) \
    macro(wasm_trampoline_wasm_call_ref, 0) \
    macro(wasm_trampoline_wasm_tail_call, 0) \
    macro(wasm_function_prologue_simd, 0) \

#define NUMBER_OF_BYTECODE_HELPER_IDS 71
#define MAX_LENGTH_OF_BYTECODE_HELPER_IDS 0

#define FOR_EACH_WASM_ID(macro) \
    macro(wasm_struct_set, 3) \
    macro(wasm_i32_sub, 3) \
    macro(wasm_i32_mul, 3) \
    macro(wasm_i32_div_s, 3) \
    macro(wasm_i32_div_u, 3) \
    macro(wasm_i32_rem_s, 3) \
    macro(wasm_i32_rem_u, 3) \
    macro(wasm_i32_and, 3) \
    macro(wasm_i32_or, 3) \
    macro(wasm_i32_xor, 3) \
    macro(wasm_i32_shl, 3) \
    macro(wasm_i32_shr_u, 3) \
    macro(wasm_i32_shr_s, 3) \
    macro(wasm_i32_rotr, 3) \
    macro(wasm_i32_rotl, 3) \
    macro(wasm_i32_eq, 3) \
    macro(wasm_i32_ne, 3) \
    macro(wasm_i32_lt_s, 3) \
    macro(wasm_i32_le_s, 3) \
    macro(wasm_i32_lt_u, 3) \
    macro(wasm_i32_le_u, 3) \
    macro(wasm_i32_gt_s, 3) \
    macro(wasm_i32_ge_s, 3) \
    macro(wasm_i32_gt_u, 3) \
    macro(wasm_i32_ge_u, 3) \
    macro(wasm_i32_clz, 2) \
    macro(wasm_i32_ctz, 2) \
    macro(wasm_i32_popcnt, 2) \
    macro(wasm_i32_eqz, 2) \
    macro(wasm_i64_add, 3) \
    macro(wasm_i64_sub, 3) \
    macro(wasm_i64_mul, 3) \
    macro(wasm_i64_div_s, 3) \
    macro(wasm_i64_div_u, 3) \
    macro(wasm_i64_rem_s, 3) \
    macro(wasm_i64_rem_u, 3) \
    macro(wasm_i64_and, 3) \
    macro(wasm_i64_or, 3) \
    macro(wasm_i64_xor, 3) \
    macro(wasm_i64_shl, 3) \
    macro(wasm_i64_shr_u, 3) \
    macro(wasm_i64_shr_s, 3) \
    macro(wasm_i64_rotr, 3) \
    macro(wasm_i64_rotl, 3) \
    macro(wasm_i64_eq, 3) \
    macro(wasm_i64_ne, 3) \
    macro(wasm_i64_lt_s, 3) \
    macro(wasm_i64_le_s, 3) \
    macro(wasm_i64_lt_u, 3) \
    macro(wasm_i64_le_u, 3) \
    macro(wasm_i64_gt_s, 3) \
    macro(wasm_i64_ge_s, 3) \
    macro(wasm_i64_gt_u, 3) \
    macro(wasm_i64_ge_u, 3) \
    macro(wasm_i64_clz, 2) \
    macro(wasm_i64_ctz, 2) \
    macro(wasm_i64_popcnt, 2) \
    macro(wasm_i64_eqz, 2) \
    macro(wasm_f32_add, 3) \
    macro(wasm_f32_sub, 3) \
    macro(wasm_f32_mul, 3) \
    macro(wasm_f32_div, 3) \
    macro(wasm_f32_min, 3) \
    macro(wasm_f32_max, 3) \
    macro(wasm_f32_abs, 2) \
    macro(wasm_f32_neg, 2) \
    macro(wasm_f32_copysign, 3) \
    macro(wasm_f32_ceil, 2) \
    macro(wasm_f32_floor, 2) \
    macro(wasm_f32_trunc, 2) \
    macro(wasm_f32_nearest, 2) \
    macro(wasm_f32_sqrt, 2) \
    macro(wasm_f32_eq, 3) \
    macro(wasm_f32_ne, 3) \
    macro(wasm_f32_lt, 3) \
    macro(wasm_f32_le, 3) \
    macro(wasm_f32_gt, 3) \
    macro(wasm_f32_ge, 3) \
    macro(wasm_f64_add, 3) \
    macro(wasm_f64_sub, 3) \
    macro(wasm_f64_mul, 3) \
    macro(wasm_f64_div, 3) \
    macro(wasm_f64_min, 3) \
    macro(wasm_f64_max, 3) \
    macro(wasm_f64_abs, 2) \
    macro(wasm_f64_neg, 2) \
    macro(wasm_f64_copysign, 3) \
    macro(wasm_f64_ceil, 2) \
    macro(wasm_f64_floor, 2) \
    macro(wasm_f64_trunc, 2) \
    macro(wasm_f64_nearest, 2) \
    macro(wasm_f64_sqrt, 2) \
    macro(wasm_f64_eq, 3) \
    macro(wasm_f64_ne, 3) \
    macro(wasm_f64_lt, 3) \
    macro(wasm_f64_le, 3) \
    macro(wasm_f64_gt, 3) \
    macro(wasm_f64_ge, 3) \
    macro(wasm_i32_trunc_s_f32, 2) \
    macro(wasm_i32_trunc_s_f64, 2) \
    macro(wasm_i32_trunc_u_f32, 2) \
    macro(wasm_i32_trunc_u_f64, 2) \
    macro(wasm_i32_wrap_i64, 2) \
    macro(wasm_i64_trunc_s_f32, 2) \
    macro(wasm_i64_trunc_s_f64, 2) \
    macro(wasm_i64_trunc_u_f32, 2) \
    macro(wasm_i64_trunc_u_f64, 2) \
    macro(wasm_i64_extend_s_i32, 2) \
    macro(wasm_i64_extend_u_i32, 2) \
    macro(wasm_f32_convert_s_i32, 2) \
    macro(wasm_f32_convert_u_i32, 2) \
    macro(wasm_f32_convert_s_i64, 2) \
    macro(wasm_f32_convert_u_i64, 2) \
    macro(wasm_f32_demote_f64, 2) \
    macro(wasm_f32_reinterpret_i32, 2) \
    macro(wasm_f64_convert_s_i32, 2) \
    macro(wasm_f64_convert_u_i32, 2) \
    macro(wasm_f64_convert_s_i64, 2) \
    macro(wasm_f64_convert_u_i64, 2) \
    macro(wasm_f64_promote_f32, 2) \
    macro(wasm_f64_reinterpret_i64, 2) \
    macro(wasm_i32_reinterpret_f32, 2) \
    macro(wasm_i64_reinterpret_f64, 2) \
    macro(wasm_i32_extend8_s, 2) \
    macro(wasm_i32_extend16_s, 2) \
    macro(wasm_i64_extend8_s, 2) \
    macro(wasm_i64_extend16_s, 2) \
    macro(wasm_i64_extend32_s, 2) \
    macro(wasm_i32_trunc_sat_f32_s, 2) \
    macro(wasm_i32_trunc_sat_f32_u, 2) \
    macro(wasm_i32_trunc_sat_f64_s, 2) \
    macro(wasm_i32_trunc_sat_f64_u, 2) \
    macro(wasm_i64_trunc_sat_f32_s, 2) \
    macro(wasm_i64_trunc_sat_f32_u, 2) \
    macro(wasm_i64_trunc_sat_f64_s, 2) \
    macro(wasm_i64_trunc_sat_f64_u, 2) \
    macro(wasm_throw_from_slow_path_trampoline, 0) \
    macro(wasm_throw_from_fault_handler_trampoline_reg_instance, 0) \
    macro(wasm_call_return_location, 0) \
    macro(wasm_call_indirect_return_location, 0) \
    macro(wasm_call_ref_return_location, 0) \
    macro(wasm_wide16, 0) \
    macro(wasm_wide32, 0) \
    macro(wasm_enter, 0) \
    macro(wasm_nop, 0) \
    macro(wasm_loop_hint, 0) \
    macro(wasm_mov, 2) \
    macro(wasm_jtrue, 2) \
    macro(wasm_jfalse, 2) \
    macro(wasm_jmp, 1) \
    macro(wasm_ret, 0) \
    macro(wasm_switch, 2) \
    macro(wasm_unreachable, 0) \
    macro(wasm_ret_void, 0) \
    macro(wasm_drop_keep, 3) \
    macro(wasm_ref_is_null, 2) \
    macro(wasm_ref_func, 2) \
    macro(wasm_ref_as_non_null, 2) \
    macro(wasm_get_global, 2) \
    macro(wasm_set_global, 2) \
    macro(wasm_set_global_ref, 2) \
    macro(wasm_get_global_portable_binding, 2) \
    macro(wasm_set_global_portable_binding, 2) \
    macro(wasm_set_global_ref_portable_binding, 2) \
    macro(wasm_table_get, 3) \
    macro(wasm_table_set, 3) \
    macro(wasm_table_init, 5) \
    macro(wasm_table_grow, 4) \
    macro(wasm_table_fill, 4) \
    macro(wasm_call, 3) \
    macro(wasm_tail_call, 4) \
    macro(wasm_call_indirect, 5) \
    macro(wasm_tail_call_indirect, 6) \
    macro(wasm_call_ref, 4) \
    macro(wasm_call_builtin, 3) \
    macro(wasm_grow_memory, 2) \
    macro(wasm_select, 4) \
    macro(wasm_load8_u, 3) \
    macro(wasm_load16_u, 3) \
    macro(wasm_load32_u, 3) \
    macro(wasm_load64_u, 3) \
    macro(wasm_i32_load8_s, 3) \
    macro(wasm_i64_load8_s, 3) \
    macro(wasm_i32_load16_s, 3) \
    macro(wasm_i64_load16_s, 3) \
    macro(wasm_i64_load32_s, 3) \
    macro(wasm_store8, 3) \
    macro(wasm_store16, 3) \
    macro(wasm_store32, 3) \
    macro(wasm_store64, 3) \
    macro(wasm_i64_atomic_rmw_add, 4) \
    macro(wasm_i64_atomic_rmw8_add_u, 4) \
    macro(wasm_i64_atomic_rmw16_add_u, 4) \
    macro(wasm_i64_atomic_rmw32_add_u, 4) \
    macro(wasm_i64_atomic_rmw_sub, 4) \
    macro(wasm_i64_atomic_rmw8_sub_u, 4) \
    macro(wasm_i64_atomic_rmw16_sub_u, 4) \
    macro(wasm_i64_atomic_rmw32_sub_u, 4) \
    macro(wasm_i64_atomic_rmw_and, 4) \
    macro(wasm_i64_atomic_rmw8_and_u, 4) \
    macro(wasm_i64_atomic_rmw16_and_u, 4) \
    macro(wasm_i64_atomic_rmw32_and_u, 4) \
    macro(wasm_i64_atomic_rmw_or, 4) \
    macro(wasm_i64_atomic_rmw8_or_u, 4) \
    macro(wasm_i64_atomic_rmw16_or_u, 4) \
    macro(wasm_i64_atomic_rmw32_or_u, 4) \
    macro(wasm_i64_atomic_rmw_xor, 4) \
    macro(wasm_i64_atomic_rmw8_xor_u, 4) \
    macro(wasm_i64_atomic_rmw16_xor_u, 4) \
    macro(wasm_i64_atomic_rmw32_xor_u, 4) \
    macro(wasm_i64_atomic_rmw_xchg, 4) \
    macro(wasm_i64_atomic_rmw8_xchg_u, 4) \
    macro(wasm_i64_atomic_rmw16_xchg_u, 4) \
    macro(wasm_i64_atomic_rmw32_xchg_u, 4) \
    macro(wasm_i64_atomic_rmw_cmpxchg, 5) \
    macro(wasm_i64_atomic_rmw8_cmpxchg_u, 5) \
    macro(wasm_i64_atomic_rmw16_cmpxchg_u, 5) \
    macro(wasm_i64_atomic_rmw32_cmpxchg_u, 5) \
    macro(wasm_memory_atomic_wait32, 5) \
    macro(wasm_memory_atomic_wait64, 5) \
    macro(wasm_memory_atomic_notify, 4) \
    macro(wasm_atomic_fence, 0) \
    macro(wasm_throw, 2) \
    macro(wasm_rethrow, 1) \
    macro(wasm_catch, 4) \
    macro(wasm_catch_all, 1) \
    macro(wasm_i31_new, 2) \
    macro(wasm_i31_get, 3) \
    macro(wasm_array_new, 5) \
    macro(wasm_array_get, 5) \
    macro(wasm_array_set, 4) \
    macro(wasm_array_len, 2) \
    macro(wasm_struct_new, 4) \
    macro(wasm_struct_get, 3) \
    macro(wasm_i32_add, 3) \

#define NUMBER_OF_WASM_IDS 235
#define MAX_LENGTH_OF_WASM_IDS 6
static constexpr unsigned wasmCheckpointCountTable[] = {
    0, // this unused entry is needed since MSVC won't compile empty arrays
};

#define NUMBER_OF_WASM_WITH_CHECKPOINTS 0

#define FOR_EACH_WASM_METADATA_SIZE(macro) \

#define NUMBER_OF_WASM_WITH_METADATA 0

#define FOR_EACH_WASM_METADATA_ALIGNMENT(macro) \


#define FOR_EACH_BYTECODE_STRUCT(macro) \
    macro(OpTailCallVarargs) \
    macro(OpCallVarargs) \
    macro(OpIteratorNext) \
    macro(OpConstructVarargs) \
    macro(OpIteratorOpen) \
    macro(OpSetPrivateBrand) \
    macro(OpCheckPrivateBrand) \
    macro(OpPutById) \
    macro(OpConstruct) \
    macro(OpBitand) \
    macro(OpBitor) \
    macro(OpBitxor) \
    macro(OpLshift) \
    macro(OpRshift) \
    macro(OpToObject) \
    macro(OpToNumber) \
    macro(OpToNumeric) \
    macro(OpTailCall) \
    macro(OpCallDirectEval) \
    macro(OpTailCallForwardArguments) \
    macro(OpCreateGenerator) \
    macro(OpCreateAsyncGenerator) \
    macro(OpGetByVal) \
    macro(OpGetPrivateName) \
    macro(OpCreatePromise) \
    macro(OpBitnot) \
    macro(OpCatch) \
    macro(OpNewArrayWithSize) \
    macro(OpNewArrayBuffer) \
    macro(OpGetById) \
    macro(OpGetByIdWithThis) \
    macro(OpProfileType) \
    macro(OpProfileControlFlow) \
    macro(OpGetByValWithThis) \
    macro(OpEnumeratorGetByVal) \
    macro(OpGetByIdDirect) \
    macro(OpGetPrototypeOf) \
    macro(OpGetInternalField) \
    macro(OpTryGetById) \
    macro(OpNewArrayWithSpecies) \
    macro(OpCall) \
    macro(OpGetArgument) \
    macro(OpPutPrivateName) \
    macro(OpResolveScope) \
    macro(OpGetFromScope) \
    macro(OpPutToScope) \
    macro(OpGetFromArguments) \
    macro(OpCreateThis) \
    macro(OpNewObject) \
    macro(OpToThis) \
    macro(OpNewArray) \
    macro(OpPutByVal) \
    macro(OpPutByValDirect) \
    macro(OpInByVal) \
    macro(OpEnumeratorNext) \
    macro(OpEnumeratorInByVal) \
    macro(OpEnumeratorHasOwnProperty) \
    macro(OpJneqPtr) \
    macro(OpInById) \
    macro(OpHasPrivateName) \
    macro(OpHasPrivateBrand) \
    macro(OpPutByIdWithThis) \
    macro(OpDelById) \
    macro(OpPutByValWithThis) \
    macro(OpDelByVal) \
    macro(OpPutGetterById) \
    macro(OpPutSetterById) \
    macro(OpPutGetterSetterById) \
    macro(OpPutGetterByVal) \
    macro(OpPutSetterByVal) \
    macro(OpDefineDataProperty) \
    macro(OpDefineAccessorProperty) \
    macro(OpJmp) \
    macro(OpJtrue) \
    macro(OpJfalse) \
    macro(OpJeqNull) \
    macro(OpJneqNull) \
    macro(OpJundefinedOrNull) \
    macro(OpJnundefinedOrNull) \
    macro(OpJeqPtr) \
    macro(OpJeq) \
    macro(OpJstricteq) \
    macro(OpJneq) \
    macro(OpJnstricteq) \
    macro(OpJless) \
    macro(OpJlesseq) \
    macro(OpJgreater) \
    macro(OpJgreatereq) \
    macro(OpJnless) \
    macro(OpJnlesseq) \
    macro(OpJngreater) \
    macro(OpJngreatereq) \
    macro(OpJbelow) \
    macro(OpJbeloweq) \
    macro(OpLoopHint) \
    macro(OpSwitchImm) \
    macro(OpSwitchChar) \
    macro(OpSwitchString) \
    macro(OpNewFunc) \
    macro(OpNewFuncExp) \
    macro(OpNewGeneratorFunc) \
    macro(OpNewGeneratorFuncExp) \
    macro(OpNewAsyncFunc) \
    macro(OpNewAsyncFuncExp) \
    macro(OpNewAsyncGeneratorFunc) \
    macro(OpNewAsyncGeneratorFuncExp) \
    macro(OpSetFunctionName) \
    macro(OpRet) \
    macro(OpStrcat) \
    macro(OpToPrimitive) \
    macro(OpToPropertyKey) \
    macro(OpPutToArguments) \
    macro(OpPushWithScope) \
    macro(OpCreateLexicalEnvironment) \
    macro(OpCreateGeneratorFrameEnvironment) \
    macro(OpGetParentScope) \
    macro(OpThrow) \
    macro(OpThrowStaticError) \
    macro(OpDebug) \
    macro(OpEnd) \
    macro(OpGetPropertyEnumerator) \
    macro(OpUnreachable) \
    macro(OpCreateRest) \
    macro(OpGetRestLength) \
    macro(OpYield) \
    macro(OpCheckTraps) \
    macro(OpLogShadowChickenPrologue) \
    macro(OpLogShadowChickenTail) \
    macro(OpResolveScopeForHoistingFuncDeclInEval) \
    macro(OpPutInternalField) \
    macro(OpNop) \
    macro(OpSuperSamplerBegin) \
    macro(OpWide16) \
    macro(OpSuperSamplerEnd) \
    macro(OpWide32) \
    macro(OpEnter) \
    macro(OpGetScope) \
    macro(OpCreateDirectArguments) \
    macro(OpCreateScopedArguments) \
    macro(OpCreateClonedArguments) \
    macro(OpNewPromise) \
    macro(OpNewGenerator) \
    macro(OpArgumentCount) \
    macro(OpCheckTdz) \
    macro(OpNewArrayWithSpread) \
    macro(OpSpread) \
    macro(OpNewRegexp) \
    macro(OpMov) \
    macro(OpEq) \
    macro(OpNeq) \
    macro(OpStricteq) \
    macro(OpNstricteq) \
    macro(OpLess) \
    macro(OpLesseq) \
    macro(OpGreater) \
    macro(OpGreatereq) \
    macro(OpBelow) \
    macro(OpBeloweq) \
    macro(OpMod) \
    macro(OpPow) \
    macro(OpUrshift) \
    macro(OpAdd) \
    macro(OpMul) \
    macro(OpDiv) \
    macro(OpSub) \
    macro(OpEqNull) \
    macro(OpNeqNull) \
    macro(OpToString) \
    macro(OpUnsigned) \
    macro(OpIsEmpty) \
    macro(OpTypeofIsUndefined) \
    macro(OpTypeofIsObject) \
    macro(OpTypeofIsFunction) \
    macro(OpIsUndefinedOrNull) \
    macro(OpIsBoolean) \
    macro(OpIsNumber) \
    macro(OpIsBigInt) \
    macro(OpIsObject) \
    macro(OpIsCallable) \
    macro(OpIsConstructor) \
    macro(OpInc) \
    macro(OpDec) \
    macro(OpNegate) \
    macro(OpNot) \
    macro(OpIdentityWithProfile) \
    macro(OpOverridesHasInstance) \
    macro(OpInstanceof) \
    macro(OpInstanceofCustom) \
    macro(OpTypeof) \
    macro(OpIsCellWithType) \

#define FOR_EACH_WASM_STRUCT(macro) \
    macro(WasmStructSet) \
    macro(WasmI32Sub) \
    macro(WasmI32Mul) \
    macro(WasmI32DivS) \
    macro(WasmI32DivU) \
    macro(WasmI32RemS) \
    macro(WasmI32RemU) \
    macro(WasmI32And) \
    macro(WasmI32Or) \
    macro(WasmI32Xor) \
    macro(WasmI32Shl) \
    macro(WasmI32ShrU) \
    macro(WasmI32ShrS) \
    macro(WasmI32Rotr) \
    macro(WasmI32Rotl) \
    macro(WasmI32Eq) \
    macro(WasmI32Ne) \
    macro(WasmI32LtS) \
    macro(WasmI32LeS) \
    macro(WasmI32LtU) \
    macro(WasmI32LeU) \
    macro(WasmI32GtS) \
    macro(WasmI32GeS) \
    macro(WasmI32GtU) \
    macro(WasmI32GeU) \
    macro(WasmI32Clz) \
    macro(WasmI32Ctz) \
    macro(WasmI32Popcnt) \
    macro(WasmI32Eqz) \
    macro(WasmI64Add) \
    macro(WasmI64Sub) \
    macro(WasmI64Mul) \
    macro(WasmI64DivS) \
    macro(WasmI64DivU) \
    macro(WasmI64RemS) \
    macro(WasmI64RemU) \
    macro(WasmI64And) \
    macro(WasmI64Or) \
    macro(WasmI64Xor) \
    macro(WasmI64Shl) \
    macro(WasmI64ShrU) \
    macro(WasmI64ShrS) \
    macro(WasmI64Rotr) \
    macro(WasmI64Rotl) \
    macro(WasmI64Eq) \
    macro(WasmI64Ne) \
    macro(WasmI64LtS) \
    macro(WasmI64LeS) \
    macro(WasmI64LtU) \
    macro(WasmI64LeU) \
    macro(WasmI64GtS) \
    macro(WasmI64GeS) \
    macro(WasmI64GtU) \
    macro(WasmI64GeU) \
    macro(WasmI64Clz) \
    macro(WasmI64Ctz) \
    macro(WasmI64Popcnt) \
    macro(WasmI64Eqz) \
    macro(WasmF32Add) \
    macro(WasmF32Sub) \
    macro(WasmF32Mul) \
    macro(WasmF32Div) \
    macro(WasmF32Min) \
    macro(WasmF32Max) \
    macro(WasmF32Abs) \
    macro(WasmF32Neg) \
    macro(WasmF32Copysign) \
    macro(WasmF32Ceil) \
    macro(WasmF32Floor) \
    macro(WasmF32Trunc) \
    macro(WasmF32Nearest) \
    macro(WasmF32Sqrt) \
    macro(WasmF32Eq) \
    macro(WasmF32Ne) \
    macro(WasmF32Lt) \
    macro(WasmF32Le) \
    macro(WasmF32Gt) \
    macro(WasmF32Ge) \
    macro(WasmF64Add) \
    macro(WasmF64Sub) \
    macro(WasmF64Mul) \
    macro(WasmF64Div) \
    macro(WasmF64Min) \
    macro(WasmF64Max) \
    macro(WasmF64Abs) \
    macro(WasmF64Neg) \
    macro(WasmF64Copysign) \
    macro(WasmF64Ceil) \
    macro(WasmF64Floor) \
    macro(WasmF64Trunc) \
    macro(WasmF64Nearest) \
    macro(WasmF64Sqrt) \
    macro(WasmF64Eq) \
    macro(WasmF64Ne) \
    macro(WasmF64Lt) \
    macro(WasmF64Le) \
    macro(WasmF64Gt) \
    macro(WasmF64Ge) \
    macro(WasmI32TruncSF32) \
    macro(WasmI32TruncSF64) \
    macro(WasmI32TruncUF32) \
    macro(WasmI32TruncUF64) \
    macro(WasmI32WrapI64) \
    macro(WasmI64TruncSF32) \
    macro(WasmI64TruncSF64) \
    macro(WasmI64TruncUF32) \
    macro(WasmI64TruncUF64) \
    macro(WasmI64ExtendSI32) \
    macro(WasmI64ExtendUI32) \
    macro(WasmF32ConvertSI32) \
    macro(WasmF32ConvertUI32) \
    macro(WasmF32ConvertSI64) \
    macro(WasmF32ConvertUI64) \
    macro(WasmF32DemoteF64) \
    macro(WasmF32ReinterpretI32) \
    macro(WasmF64ConvertSI32) \
    macro(WasmF64ConvertUI32) \
    macro(WasmF64ConvertSI64) \
    macro(WasmF64ConvertUI64) \
    macro(WasmF64PromoteF32) \
    macro(WasmF64ReinterpretI64) \
    macro(WasmI32ReinterpretF32) \
    macro(WasmI64ReinterpretF64) \
    macro(WasmI32Extend8S) \
    macro(WasmI32Extend16S) \
    macro(WasmI64Extend8S) \
    macro(WasmI64Extend16S) \
    macro(WasmI64Extend32S) \
    macro(WasmI32TruncSatF32S) \
    macro(WasmI32TruncSatF32U) \
    macro(WasmI32TruncSatF64S) \
    macro(WasmI32TruncSatF64U) \
    macro(WasmI64TruncSatF32S) \
    macro(WasmI64TruncSatF32U) \
    macro(WasmI64TruncSatF64S) \
    macro(WasmI64TruncSatF64U) \
    macro(WasmThrowFromSlowPathTrampoline) \
    macro(WasmThrowFromFaultHandlerTrampolineRegInstance) \
    macro(WasmCallReturnLocation) \
    macro(WasmCallIndirectReturnLocation) \
    macro(WasmCallRefReturnLocation) \
    macro(WasmWide16) \
    macro(WasmWide32) \
    macro(WasmEnter) \
    macro(WasmNop) \
    macro(WasmLoopHint) \
    macro(WasmMov) \
    macro(WasmJtrue) \
    macro(WasmJfalse) \
    macro(WasmJmp) \
    macro(WasmRet) \
    macro(WasmSwitch) \
    macro(WasmUnreachable) \
    macro(WasmRetVoid) \
    macro(WasmDropKeep) \
    macro(WasmRefIsNull) \
    macro(WasmRefFunc) \
    macro(WasmRefAsNonNull) \
    macro(WasmGetGlobal) \
    macro(WasmSetGlobal) \
    macro(WasmSetGlobalRef) \
    macro(WasmGetGlobalPortableBinding) \
    macro(WasmSetGlobalPortableBinding) \
    macro(WasmSetGlobalRefPortableBinding) \
    macro(WasmTableGet) \
    macro(WasmTableSet) \
    macro(WasmTableInit) \
    macro(WasmTableGrow) \
    macro(WasmTableFill) \
    macro(WasmCall) \
    macro(WasmTailCall) \
    macro(WasmCallIndirect) \
    macro(WasmTailCallIndirect) \
    macro(WasmCallRef) \
    macro(WasmCallBuiltin) \
    macro(WasmGrowMemory) \
    macro(WasmSelect) \
    macro(WasmLoad8U) \
    macro(WasmLoad16U) \
    macro(WasmLoad32U) \
    macro(WasmLoad64U) \
    macro(WasmI32Load8S) \
    macro(WasmI64Load8S) \
    macro(WasmI32Load16S) \
    macro(WasmI64Load16S) \
    macro(WasmI64Load32S) \
    macro(WasmStore8) \
    macro(WasmStore16) \
    macro(WasmStore32) \
    macro(WasmStore64) \
    macro(WasmI64AtomicRmwAdd) \
    macro(WasmI64AtomicRmw8AddU) \
    macro(WasmI64AtomicRmw16AddU) \
    macro(WasmI64AtomicRmw32AddU) \
    macro(WasmI64AtomicRmwSub) \
    macro(WasmI64AtomicRmw8SubU) \
    macro(WasmI64AtomicRmw16SubU) \
    macro(WasmI64AtomicRmw32SubU) \
    macro(WasmI64AtomicRmwAnd) \
    macro(WasmI64AtomicRmw8AndU) \
    macro(WasmI64AtomicRmw16AndU) \
    macro(WasmI64AtomicRmw32AndU) \
    macro(WasmI64AtomicRmwOr) \
    macro(WasmI64AtomicRmw8OrU) \
    macro(WasmI64AtomicRmw16OrU) \
    macro(WasmI64AtomicRmw32OrU) \
    macro(WasmI64AtomicRmwXor) \
    macro(WasmI64AtomicRmw8XorU) \
    macro(WasmI64AtomicRmw16XorU) \
    macro(WasmI64AtomicRmw32XorU) \
    macro(WasmI64AtomicRmwXchg) \
    macro(WasmI64AtomicRmw8XchgU) \
    macro(WasmI64AtomicRmw16XchgU) \
    macro(WasmI64AtomicRmw32XchgU) \
    macro(WasmI64AtomicRmwCmpxchg) \
    macro(WasmI64AtomicRmw8CmpxchgU) \
    macro(WasmI64AtomicRmw16CmpxchgU) \
    macro(WasmI64AtomicRmw32CmpxchgU) \
    macro(WasmMemoryAtomicWait32) \
    macro(WasmMemoryAtomicWait64) \
    macro(WasmMemoryAtomicNotify) \
    macro(WasmAtomicFence) \
    macro(WasmThrow) \
    macro(WasmRethrow) \
    macro(WasmCatch) \
    macro(WasmCatchAll) \
    macro(WasmI31New) \
    macro(WasmI31Get) \
    macro(WasmArrayNew) \
    macro(WasmArrayGet) \
    macro(WasmArraySet) \
    macro(WasmArrayLen) \
    macro(WasmStructNew) \
    macro(WasmStructGet) \
    macro(WasmI32Add) \

//  SHA1Hash: 3c98026d978d333593807214f5530da1ee95f3f7
