% LTFAT - Operators
%
%  Peter L. Soendergaard, 2013 - 2018.
%
%  General operator framework
%    OPERATORNEW       - Construct a new operator
%    OPERATOR          - Apply an operator
%    IOPERATOR         - Apply the inverse of an operator
%    OPERATORADJ       - Apply the adjoint of an operator
%    OPERATORAPPR      - Best approx. by operator
%    OPERATOREIGS      - Eigenpairs of an operator
%    OPERATORMATRIX    - Matrix representation of an operator
%
%  Frame multipliers
%    FRAMEMUL          - Apply frame multiplier
%    IFRAMEMUL         - Apply the inverse of a frame multipllier
%    FRAMEMULADJ       - Apply the adjoint of a frame multiplier
%    FRAMEMULAPPR      - Best approx. by frame multiplier
%    FRAMEMULEIGS      - Eigenpairs of a frame multiplier
%    GABMULAPPR        - Best approximation by a Gabor mult.
%
%  Spreading operators
%    SPREADOP          - Spreading operator
%    SPREADINV         - Apply inverse spreading operator
%    SPREADADJ         - Symbol of adjoint spreading operator
%    SPREADFUN         - Symbol of operator expressed as a matrix
%    SPREADEIGS        - Eigenpairs of spreading operator
%
%  For help, bug reports, suggestions etc. please visit 
%  http://github.com/ltfat/ltfat/issues
%
%   Url: http://ltfat.github.io/doc/operators/Contents.html

% Copyright (C) 2005-2016 Peter L. Soendergaard <peter@sonderport.dk>.
% This file is part of LTFAT version 2.3.1
%
% This program is free software: you can redistribute it and/or modify
% it under the terms of the GNU General Public License as published by
% the Free Software Foundation, either version 3 of the License, or
% (at your option) any later version.
%
% This program is distributed in the hope that it will be useful,
% but WITHOUT ANY WARRANTY; without even the implied warranty of
% MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
% GNU General Public License for more details.
%
% You should have received a copy of the GNU General Public License
% along with this program.  If not, see <http://www.gnu.org/licenses/>.

