/*
 * Decompiled with CFR 0.152.
 */
package gnu.text;

import gnu.text.LineBufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import java.nio.ByteBuffer;
import java.nio.CharBuffer;
import java.nio.charset.Charset;
import java.nio.charset.CharsetDecoder;
import java.nio.charset.CoderResult;

public class LineInputStreamReader
extends LineBufferedReader {
    InputStream istrm;
    byte[] barr = new byte[8192];
    ByteBuffer bbuf = ByteBuffer.wrap(this.barr);
    char[] carr;
    CharBuffer cbuf = null;
    Charset cset;
    CharsetDecoder decoder;

    public void setCharset(Charset charset) {
        this.cset = charset;
        this.decoder = charset.newDecoder();
    }

    public void setCharset(String string) {
        Charset charset = Charset.forName(string);
        if (this.cset == null) {
            this.setCharset(charset);
        } else if (!charset.equals(this.cset)) {
            throw new RuntimeException("encoding " + string + " does not match previous " + this.cset);
        }
    }

    public LineInputStreamReader(InputStream inputStream) {
        super((Reader)null);
        this.bbuf.position(this.barr.length);
        this.istrm = inputStream;
    }

    public void close() throws IOException {
        if (this.in != null) {
            this.in.close();
        }
        this.istrm.close();
    }

    private int fillBytes(int n) throws IOException {
        int n2 = this.istrm.read(this.barr, n, this.barr.length - n);
        this.bbuf.position(0);
        this.bbuf.limit(n + (n2 < 0 ? 0 : n2));
        return n2;
    }

    public void markStart() throws IOException {
    }

    public void resetStart(int n) throws IOException {
        this.bbuf.position(n);
    }

    public int getByte() throws IOException {
        int n;
        if (!this.bbuf.hasRemaining() && (n = this.fillBytes(0)) <= 0) {
            return -1;
        }
        return this.bbuf.get() & 0xFF;
    }

    public int fill(int n) throws IOException {
        int n2;
        boolean bl;
        block3: {
            int n3;
            int n4;
            if (this.cset == null) {
                this.setCharset("UTF-8");
            }
            if (this.buffer != this.carr) {
                this.cbuf = CharBuffer.wrap(this.buffer);
                this.carr = this.buffer;
            }
            this.cbuf.limit(this.pos + n);
            this.cbuf.position(this.pos);
            bl = false;
            do {
                CoderResult coderResult = this.decoder.decode(this.bbuf, this.cbuf, bl);
                n2 = this.cbuf.position() - this.pos;
                if (n2 > 0 || !coderResult.isUnderflow()) break block3;
                n3 = this.bbuf.remaining();
                if (n3 <= 0) continue;
                this.bbuf.compact();
            } while ((n4 = this.fillBytes(n3)) >= 0);
            bl = true;
        }
        return n2 == 0 && bl ? -1 : n2;
    }

    public boolean ready() throws IOException {
        return this.pos < this.limit || this.bbuf.hasRemaining() || this.istrm.available() > 0;
    }
}

