/*
 * Decompiled with CFR 0.152.
 */
package gnu.kawa.lispexpr;

import gnu.expr.BeginExp;
import gnu.expr.Compilation;
import gnu.expr.Expression;
import gnu.expr.Interpreter;
import gnu.expr.ModuleExp;
import gnu.kawa.lispexpr.LispReader;
import gnu.lists.LList;
import gnu.lists.PairWithPosition;
import gnu.lists.Sequence;
import gnu.mapping.Environment;
import gnu.mapping.InPort;
import gnu.text.Lexer;
import gnu.text.SourceMessages;
import gnu.text.SyntaxException;
import java.io.IOException;
import java.util.Vector;
import kawa.lang.Translator;

public abstract class LispInterpreter
extends Interpreter {
    public static ModuleExp makeModuleExp(Object object2, Translator translator) {
        ModuleExp moduleExp = new ModuleExp();
        Vector vector = new Vector(20);
        SourceMessages sourceMessages = translator.getMessages();
        translator.push(moduleExp);
        translator.scan_body(object2, vector, moduleExp);
        translator.finishModule(moduleExp, vector);
        return moduleExp;
    }

    public Compilation parse(Environment environment, Lexer lexer) throws IOException, SyntaxException {
        SourceMessages sourceMessages = lexer.getMessages();
        Translator translator = new Translator(environment, sourceMessages);
        translator.immediate = true;
        lexer.clearErrors();
        PairWithPosition pairWithPosition = PairWithPosition.make(null, LList.Empty, lexer.getName(), lexer.getLineNumber() + 1, lexer.getColumnNumber() + 1);
        Object object2 = ((LispReader)lexer).readObject();
        if (object2 == Sequence.eofValue) {
            return null;
        }
        pairWithPosition.car = object2;
        LispInterpreter.makeModuleExp(pairWithPosition, translator);
        return translator;
    }

    public Compilation parseFile(InPort inPort, boolean bl, SourceMessages sourceMessages) throws IOException, SyntaxException {
        Object object2;
        Translator translator = new Translator(this.environ, sourceMessages);
        translator.immediate = bl;
        ModuleExp moduleExp = new ModuleExp();
        if (Compilation.generateAppletDefault) {
            moduleExp.setFlag(16384);
        }
        moduleExp.setFile(inPort.getName());
        Vector vector = new Vector(20);
        translator.push(moduleExp);
        LispReader lispReader = (LispReader)this.getLexer(inPort, sourceMessages);
        while ((object2 = lispReader.readObject()) != Sequence.eofValue && translator.scan_form(object2, vector, moduleExp)) {
        }
        if (inPort.peek() == 41) {
            lispReader.fatal("An unexpected close paren was read.");
        }
        translator.finishModule(moduleExp, vector);
        return translator;
    }

    public Expression makeBody(Expression[] expressionArray) {
        return new BeginExp(expressionArray);
    }
}

