/*
 * Decompiled with CFR 0.152.
 */
package gnu.kawa.reflect;

import gnu.bytecode.CodeAttr;
import gnu.bytecode.Type;
import gnu.bytecode.Variable;
import gnu.expr.ApplyExp;
import gnu.expr.CanInline;
import gnu.expr.Compilation;
import gnu.expr.Declaration;
import gnu.expr.ExpWalker;
import gnu.expr.Expression;
import gnu.expr.Inlineable;
import gnu.expr.LambdaExp;
import gnu.expr.Target;
import gnu.expr.TypeValue;
import gnu.mapping.CallContext;
import gnu.mapping.CpsProcedure;
import gnu.mapping.MethodProc;
import gnu.mapping.Procedure;

public class TypeSwitch
extends CpsProcedure
implements CanInline,
Inlineable {
    public static final TypeSwitch typeSwitch = new TypeSwitch("typeswitch");

    public TypeSwitch(String string) {
        super(string);
    }

    public int numArgs() {
        return -4094;
    }

    public void apply(CallContext callContext) throws Throwable {
        Object object2 = callContext.getNextArg();
        Object[] objectArray = new Object[]{object2};
        for (int i = 2; i < callContext.count; ++i) {
            MethodProc methodProc = (MethodProc)callContext.getNextArg();
            if (methodProc.match(callContext, objectArray) < 0) continue;
            methodProc.apply(callContext);
            return;
        }
        Procedure procedure = (Procedure)callContext.getNextArg();
        callContext.setArgs();
        procedure.apply(callContext);
    }

    public Expression inline(ApplyExp applyExp, ExpWalker expWalker) {
        Expression[] expressionArray = applyExp.getArgs();
        for (int i = 1; i < expressionArray.length; ++i) {
            if (!(expressionArray[i] instanceof LambdaExp)) continue;
            LambdaExp lambdaExp = (LambdaExp)expressionArray[i];
            lambdaExp.setInlineOnly(true);
            lambdaExp.returnContinuation = applyExp;
        }
        return applyExp;
    }

    public void compile(ApplyExp applyExp, Compilation compilation, Target target) {
        LambdaExp lambdaExp;
        int n;
        Expression[] expressionArray = applyExp.getArgs();
        CodeAttr codeAttr = compilation.getCode();
        codeAttr.pushScope();
        Variable variable = codeAttr.addLocal(Type.pointer_type);
        expressionArray[0].compile(compilation, Target.pushObject);
        codeAttr.emitStore(variable);
        for (n = 1; n < expressionArray.length - 1; ++n) {
            if (n > 1) {
                codeAttr.emitElse();
            }
            if (expressionArray[n] instanceof LambdaExp) {
                lambdaExp = (LambdaExp)expressionArray[n];
                Declaration declaration = lambdaExp.firstDecl();
                Type type = declaration.getType();
                declaration.allocateVariable(codeAttr);
                if (type instanceof TypeValue) {
                    ((TypeValue)((Object)type)).emitTestIf(variable, declaration, compilation);
                } else {
                    codeAttr.emitLoad(variable);
                    type.emitIsInstance(codeAttr);
                    codeAttr.emitIfIntNotZero();
                    codeAttr.emitLoad(variable);
                    declaration.compileStore(compilation);
                }
            } else {
                throw new Error("not implemented: typeswitch arg not LambdaExp");
            }
            lambdaExp.allocChildClasses(compilation);
            lambdaExp.body.compileWithPosition(compilation, target);
        }
        n = expressionArray.length - 2;
        if (n > 0) {
            codeAttr.emitElse();
        }
        lambdaExp = (LambdaExp)expressionArray[expressionArray.length - 1];
        lambdaExp.allocChildClasses(compilation);
        lambdaExp.body.compileWithPosition(compilation, target);
        while (--n >= 0) {
            codeAttr.emitFi();
        }
        codeAttr.popScope();
    }

    public Type getReturnType(Expression[] expressionArray) {
        return Type.pointer_type;
    }
}

