/*
 * Decompiled with CFR 0.152.
 */
package gnu.prolog.vm.buildins.imphooks;

import gnu.prolog.term.AtomTerm;
import gnu.prolog.term.Term;
import gnu.prolog.term.VariableTerm;
import gnu.prolog.vm.BacktrackInfo;
import gnu.prolog.vm.ExecuteOnlyCode;
import gnu.prolog.vm.Interpreter;
import gnu.prolog.vm.PrologException;
import gnu.prolog.vm.TermConstants;
import java.util.Iterator;
import java.util.Map;

public class Predicate_current_prolog_flag
extends ExecuteOnlyCode {
    @Override
    public int execute(Interpreter interpreter, boolean backtrackMode, Term[] args) throws PrologException {
        if (backtrackMode) {
            CurrentPrologFlagBacktrackInfo bi = (CurrentPrologFlagBacktrackInfo)interpreter.popBacktrackInfo();
            interpreter.undo(bi.startUndoPosition);
            return this.nextSolution(interpreter, bi);
        }
        Term flag = args[0];
        Term value = args[1];
        if (flag instanceof AtomTerm) {
            Term val = interpreter.getEnvironment().getPrologFlag((AtomTerm)flag);
            if (val == null) {
                PrologException.domainError(TermConstants.prologFlagAtom, flag);
                return -1;
            }
            return interpreter.unify(value, val.dereference());
        }
        if (!(flag instanceof VariableTerm)) {
            PrologException.typeError(TermConstants.atomAtom, flag);
        }
        CurrentPrologFlagBacktrackInfo bi = new CurrentPrologFlagBacktrackInfo();
        bi.map = interpreter.getEnvironment().getPrologFlags();
        bi.keys = bi.map.keySet().iterator();
        bi.startUndoPosition = interpreter.getUndoPosition();
        bi.flag = flag;
        bi.value = value;
        return this.nextSolution(interpreter, bi);
    }

    private int nextSolution(Interpreter interpreter, CurrentPrologFlagBacktrackInfo bi) throws PrologException {
        while (bi.keys.hasNext()) {
            AtomTerm f = bi.keys.next();
            Term v = bi.map.get(f);
            int rc = interpreter.simpleUnify(f, bi.flag);
            if (rc == -1) {
                interpreter.undo(bi.startUndoPosition);
                continue;
            }
            rc = interpreter.simpleUnify(v, bi.value);
            if (rc == -1) {
                interpreter.undo(bi.startUndoPosition);
                continue;
            }
            interpreter.pushBacktrackInfo(bi);
            return 0;
        }
        return -1;
    }

    private static class CurrentPrologFlagBacktrackInfo
    extends BacktrackInfo {
        Map<AtomTerm, Term> map;
        Iterator<AtomTerm> keys;
        int startUndoPosition;
        Term flag;
        Term value;

        CurrentPrologFlagBacktrackInfo() {
            super(-1, -1);
        }
    }
}

