/*
 * Decompiled with CFR 0.152.
 */
package com.sun.electric.tool.simulation.test;

import com.sun.electric.tool.simulation.test.BitVector;
import com.sun.electric.tool.simulation.test.ChainNode;
import com.sun.electric.tool.simulation.test.ChipNode;
import com.sun.electric.tool.simulation.test.Infrastructure;
import com.sun.electric.tool.simulation.test.MyTreeNode;
import com.sun.electric.tool.simulation.test.TestNode;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class SubchainNode
extends TestNode {
    private int length;
    public String pin;
    private DataNet dataNet;
    private DataNet dataNet2;

    public SubchainNode(String name, int length, String comment) {
        super(name, comment);
        this.setLength(length);
        this.pin = null;
    }

    public SubchainNode(String name, int length, String pin, String comment, String dataNet, String dataNet2) {
        super(name, comment);
        this.setLength(length);
        this.pin = pin;
        if (dataNet == null) {
            dataNet = "";
        }
        if (dataNet2 == null) {
            dataNet2 = "";
        }
        this.dataNet = new DataNet(dataNet);
        this.dataNet2 = new DataNet(dataNet2);
    }

    @Override
    public String toString() {
        return super.toString() + " (len=" + this.getLength() + ")";
    }

    protected void setLength(int length) {
        this.length = length;
    }

    int getLength() {
        return this.length;
    }

    public DataNet getDataNet() {
        return this.dataNet;
    }

    public DataNet getDataNet2() {
        return this.dataNet2;
    }

    @Override
    void addChild(MyTreeNode newNode) {
        super.addChild(newNode);
        this.lengthChanged();
    }

    void lengthChanged() {
        this.computeLength();
        if (this.getParent() == null || this.getParent().getClass() == ChipNode.class) {
            return;
        }
        ((SubchainNode)this.getParent()).lengthChanged();
    }

    BitVector getInBits() {
        ChainNode root = this.getParentChain();
        BitVector bitVector = root.getInBits().get(this.getBitIndex(), this.getLength());
        return bitVector;
    }

    BitVector getOutBits() {
        ChainNode root = this.getParentChain();
        return root.getOutBits().get(this.getBitIndex(), this.getLength());
    }

    BitVector getOldOutBitsExpected() {
        ChainNode root = this.getParentChain();
        return root.getOldOutBitsExpected().getIndiscriminate(this.getBitIndex(), this.getLength());
    }

    void setInBits(BitVector newBits) {
        int nbitsNode;
        int nbits = newBits.getNumBits();
        if (nbits != (nbitsNode = this.getLength())) {
            Infrastructure.fatal("Length of input BitVector " + newBits + " is " + nbits + ", but it must equal length " + nbitsNode + " of SubchainNode " + this);
        }
        ChainNode chainRoot = this.getParentChain();
        int fromIndex = this.getBitIndex();
        chainRoot.getInBits().put(fromIndex, newBits);
    }

    void setInBits(String newBits) {
        int nbitsNode;
        int nbits = newBits.length();
        if (nbits != (nbitsNode = this.getLength())) {
            Infrastructure.fatal("Length of input BitVector " + newBits + " is " + nbits + ", but it must equal length " + nbitsNode + " of SubchainNode " + this);
        }
        ChainNode chainRoot = this.getParentChain();
        int fromIndex = this.getBitIndex();
        chainRoot.getInBits().put(fromIndex, newBits);
    }

    protected void computeLength() {
        int childCount = this.getChildCount();
        if (childCount > 0) {
            int newLength = 0;
            for (int ind = 0; ind < childCount; ++ind) {
                newLength += ((SubchainNode)this.getChildAt(ind)).getLength();
            }
            this.setLength(newLength);
        }
    }

    protected BitVector getOutBitsIndiscriminate() {
        ChainNode root = this.getParentChain();
        return root.getOutBits().getIndiscriminate(this.getBitIndex(), this.getLength());
    }

    protected BitVector getInBitsIndiscriminate() {
        ChainNode root = this.getParentChain();
        return root.getInBits().getIndiscriminate(this.getBitIndex(), this.getLength());
    }

    public int getBitIndex() {
        if (this.getParent() == null || this.getParent().getClass() == ChipNode.class || this.getParent().getClass() == TestNode.class) {
            return 0;
        }
        int sumSibling = 0;
        for (int iChild = 0; iChild < this.getParent().getIndex(this); ++iChild) {
            sumSibling += ((SubchainNode)this.getParent().getChildAt(iChild)).getLength();
        }
        int addr = ((SubchainNode)this.getParent()).getBitIndex() + sumSibling;
        return addr;
    }

    public ChainNode getParentChain() {
        MyTreeNode node = this;
        while (!ChainNode.class.isInstance(node)) {
            node = node.getParent();
        }
        return (ChainNode)node;
    }

    public String getPathString() {
        return this.getPathString(1);
    }

    public static void main(String[] args) {
        ChainNode level0 = new ChainNode("level0", "001", 0, "");
        SubchainNode level1a = new SubchainNode("level1a", 5, "frog");
        SubchainNode level1b = new SubchainNode("level1b", 0, "frog");
        SubchainNode level2a = new SubchainNode("level2a", 7, "frog");
        SubchainNode level2b = new SubchainNode("level2b", 3, "frog");
        level0.addChild(level1a);
        level0.addChild(level1b);
        level1b.addChild(level2a);
        level1b.addChild(level2b);
        String path = level2a.getPathString();
        System.out.println("path string, starting at level 1: " + path);
        System.out.println("  length = " + level2a.getLength());
        level2a.setInBits("1000111");
        System.out.println("Set bits in level2a = " + level2a.getInBits());
        System.out.println("Full bit sequence in level0 = " + level0.getInBits());
    }

    public static class DataNet {
        private final String name;
        private final boolean readable;
        private final boolean writeable;
        private final boolean inverted;
        private static final Pattern namePat = Pattern.compile("(.+?)\\((.+?)\\)");

        protected DataNet(String xmlNetName) {
            String netname;
            Matcher m = namePat.matcher(xmlNetName);
            if (m.matches()) {
                netname = m.group(1);
                String options = m.group(2).toLowerCase();
                this.readable = options.indexOf(114) != -1;
                this.writeable = options.indexOf(119) != -1;
                this.inverted = options.indexOf(105) != -1;
            } else {
                netname = xmlNetName;
                this.readable = false;
                this.writeable = false;
                this.inverted = false;
            }
            this.name = netname;
        }

        protected DataNet(String netName, boolean readable, boolean writeable, boolean inverted) {
            this.name = netName;
            this.readable = readable;
            this.writeable = writeable;
            this.inverted = inverted;
        }

        public String getName() {
            return this.name;
        }

        public boolean isReadable() {
            return this.readable;
        }

        public boolean isWriteable() {
            return this.writeable;
        }

        public boolean isInverted() {
            return this.inverted;
        }

        public String toString() {
            return "DataNet " + this.name + "(" + (this.readable ? "R" : "") + (this.writeable ? "W" : "") + (this.inverted ? "I" : "") + ")";
        }
    }
}

