/*
 * Decompiled with CFR 0.152.
 */
package com.sun.electric.tool.user.dialogs;

import com.sun.electric.database.change.DatabaseChangeEvent;
import com.sun.electric.database.change.DatabaseChangeListener;
import com.sun.electric.database.hierarchy.Cell;
import com.sun.electric.database.hierarchy.Export;
import com.sun.electric.database.topology.ArcInst;
import com.sun.electric.database.topology.NodeInst;
import com.sun.electric.database.variable.AbstractTextDescriptor;
import com.sun.electric.database.variable.ElectricObject;
import com.sun.electric.database.variable.TextDescriptor;
import com.sun.electric.database.variable.Variable;
import com.sun.electric.technology.technologies.Artwork;
import com.sun.electric.tool.Client;
import com.sun.electric.tool.Job;
import com.sun.electric.tool.JobException;
import com.sun.electric.tool.io.output.Verilog;
import com.sun.electric.tool.simulation.SimulationTool;
import com.sun.electric.tool.user.Highlight;
import com.sun.electric.tool.user.HighlightListener;
import com.sun.electric.tool.user.Highlighter;
import com.sun.electric.tool.user.User;
import com.sun.electric.tool.user.UserInterfaceMain;
import com.sun.electric.tool.user.dialogs.EDialog;
import com.sun.electric.tool.user.dialogs.EModelessDialog;
import com.sun.electric.tool.user.dialogs.TextAttributesPanel;
import com.sun.electric.tool.user.dialogs.TextInfoPanel;
import com.sun.electric.tool.user.menus.EMenuBar;
import com.sun.electric.tool.user.ui.EditWindow;
import com.sun.electric.tool.user.ui.TopLevel;
import com.sun.electric.tool.user.ui.WindowFrame;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Frame;
import java.awt.Graphics;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.Point;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import java.awt.event.MouseWheelEvent;
import java.awt.event.MouseWheelListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.awt.event.WindowFocusListener;
import java.awt.font.GlyphVector;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.util.ArrayList;
import java.util.EventListener;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JEditorPane;
import javax.swing.JLabel;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import javax.swing.border.EmptyBorder;
import javax.swing.event.UndoableEditEvent;
import javax.swing.event.UndoableEditListener;
import javax.swing.text.Document;
import javax.swing.text.JTextComponent;
import javax.swing.undo.CannotUndoException;
import javax.swing.undo.UndoManager;

public class GetInfoText
extends EModelessDialog
implements HighlightListener,
DatabaseChangeListener {
    private static GetInfoText theDialog = null;
    private CachedTextInfo cti;
    private TextPropertiesFocusListener dialogFocusListener;
    private JButton apply;
    private JButton cancel;
    private JLabel evaluation;
    private JLabel header;
    private JButton ok;
    private JTextComponent theText;
    private TextInfoPanel textPanel;
    private TextAttributesPanel attrPanel;
    private JCheckBox multiLine;

    public static void showDialog() {
        if (Client.getOperatingSystem() == Client.OS.UNIX) {
            if (theDialog != null) {
                theDialog.removeWindowFocusListener(GetInfoText.theDialog.dialogFocusListener);
                theDialog.dispose();
            }
            theDialog = null;
        }
        if (theDialog == null) {
            TopLevel jf = null;
            if (TopLevel.isMDIMode()) {
                jf = TopLevel.getCurrentJFrame();
            }
            theDialog = new GetInfoText(jf);
        }
        theDialog.loadTextInfo();
        if (!theDialog.isVisible()) {
            theDialog.pack();
            theDialog.ensureProperSize();
            theDialog.setVisible(true);
        }
        theDialog.toFront();
    }

    private GetInfoText(Frame parent) {
        super(parent);
        this.initComponents();
        this.getRootPane().setDefaultButton(this.ok);
        UserInterfaceMain.addDatabaseChangeListener(this);
        Highlighter.addHighlightListener(this);
        this.dialogFocusListener = new TextPropertiesFocusListener();
        this.addWindowFocusListener(this.dialogFocusListener);
        this.loadTextInfo();
        this.finishInitialization();
    }

    @Override
    public void highlightChanged(Highlighter which) {
        if (!this.isVisible()) {
            return;
        }
        this.loadTextInfo();
    }

    @Override
    public void highlighterLostFocus(Highlighter highlighterGainedFocus) {
        if (!this.isVisible()) {
            return;
        }
        this.loadTextInfo();
    }

    @Override
    public void databaseChanged(DatabaseChangeEvent e) {
        if (!this.isVisible()) {
            return;
        }
        if (this.cti != null && e.objectChanged(this.cti.owner)) {
            this.loadTextInfo();
        }
    }

    private void loadTextInfo() {
        Highlight textHighlight = null;
        EditWindow curWnd = EditWindow.getCurrent();
        int textCount = 0;
        if (curWnd != null) {
            for (Highlight h : curWnd.getHighlighter().getHighlights()) {
                if (!h.isHighlightText() || h.getVarKey() == Export.EXPORT_NAME) continue;
                textHighlight = h;
                ++textCount;
            }
        }
        if (textCount > 1) {
            textHighlight = null;
        }
        boolean enabled = textHighlight != null;
        EDialog.focusClearOnTextField(this.theText);
        for (int i = 0; i < this.getComponentCount(); ++i) {
            Component c = this.getComponent(i);
            c.setEnabled(enabled);
        }
        if (!enabled) {
            this.header.setText("No Text Selected");
            this.evaluation.setText(" ");
            this.theText.setText("");
            this.cti = null;
            this.textPanel.setTextDescriptor(null, null);
            this.attrPanel.setVariable(null, null);
            this.ok.setEnabled(false);
            this.apply.setEnabled(false);
            this.multiLine.setEnabled(false);
            return;
        }
        this.cti = new CachedTextInfo(textHighlight);
        this.ok.setEnabled(true);
        this.apply.setEnabled(true);
        this.header.setText(this.cti.description);
        this.theText.setText(this.cti.initialText);
        this.theText.setEditable(true);
        if (this.cti.initialText.indexOf(10) != -1) {
            if (this.cti.shownText != null && (this.cti.varKey == NodeInst.NODE_NAME || this.cti.varKey == ArcInst.ARC_NAME)) {
                this.multiLine.setEnabled(false);
                this.multiLine.setSelected(false);
            } else {
                this.multiLine.setEnabled(true);
                this.multiLine.setSelected(true);
            }
        } else {
            if (this.cti.shownText != null && (this.cti.varKey == NodeInst.NODE_NAME || this.cti.varKey == ArcInst.ARC_NAME)) {
                this.multiLine.setEnabled(false);
            } else {
                this.multiLine.setEnabled(true);
            }
            this.multiLine.setSelected(false);
        }
        this.evaluation.setText(" ");
        if (this.cti.var != null && this.cti.var.isCode()) {
            this.evaluation.setText("Evaluation: " + this.cti.var.describe(-1));
        }
        this.textPanel.setTextDescriptor(this.cti.varKey, this.cti.owner);
        this.attrPanel.setVariable(this.cti.varKey, this.cti.owner);
        this.changeTextComponent(this.cti.initialText, this.multiLine.isSelected());
        EDialog.focusOnTextField(this.theText);
        if (this.cti.varKey == NodeInst.NODE_PROTO) {
            this.theText.setEditable(false);
            this.theText.setEnabled(false);
            this.multiLine.setEnabled(false);
        }
    }

    @Override
    protected void escapePressed() {
        this.cancelActionPerformed(null);
    }

    public static void editTextInPlace() {
        EditWindow curWnd = EditWindow.getCurrent();
        if (curWnd == null) {
            return;
        }
        Highlight theHigh = null;
        int textCount = 0;
        for (Highlight h : curWnd.getHighlighter().getHighlights()) {
            if (!h.isHighlightText()) continue;
            theHigh = h;
            ++textCount;
        }
        if (textCount > 1) {
            theHigh = null;
        }
        if (theHigh == null) {
            return;
        }
        CachedTextInfo cti = new CachedTextInfo(theHigh);
        if (cti.isInstanceName()) {
            GetInfoText.showDialog();
            return;
        }
        Font theFont = curWnd.getFont(cti.td);
        if (theFont == null) {
            GetInfoText.showDialog();
            return;
        }
        Point2D[] points = Highlighter.describeHighlightText(curWnd, cti.owner, cti.varKey);
        int lowX = 0;
        int highX = 0;
        int lowY = 0;
        int highY = 0;
        for (int i = 0; i < points.length; ++i) {
            Point pt = curWnd.databaseToScreen(points[i]);
            if (i == 0) {
                lowX = highX = pt.x;
                lowY = highY = pt.y;
                continue;
            }
            if (pt.x < lowX) {
                lowX = pt.x;
            }
            if (pt.x > highX) {
                highX = pt.x;
            }
            if (pt.y < lowY) {
                lowY = pt.y;
            }
            if (pt.y <= highY) continue;
            highY = pt.y;
        }
        if (cti.td.getDispPart() != AbstractTextDescriptor.DispPos.VALUE && (cti.var == null || cti.var.getLength() == 1)) {
            GlyphVector gv = curWnd.getGlyphs(cti.initialText, theFont);
            Rectangle2D glyphBounds = gv.getLogicalBounds();
            lowX = highX - (int)glyphBounds.getWidth();
        }
        new EditInPlaceListener(cti, curWnd, theFont, lowX, lowY);
    }

    private void initComponents() {
        this.cancel = new JButton();
        this.ok = new JButton();
        this.header = new JLabel();
        this.apply = new JButton();
        this.evaluation = new JLabel();
        this.theText = new JTextField();
        this.textPanel = new TextInfoPanel(false, false);
        this.attrPanel = new TextAttributesPanel(false);
        this.multiLine = new JCheckBox();
        this.getContentPane().setLayout(new GridBagLayout());
        this.getRootPane().setDefaultButton(this.ok);
        this.setTitle("Text Properties");
        this.setName("");
        this.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent evt) {
                GetInfoText.this.closeDialog(evt);
            }
        });
        this.header.setText("");
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(4, 4, 4, 4);
        this.getContentPane().add((Component)this.header, gridBagConstraints);
        this.changeTextComponent("", false);
        this.multiLine.setText("Multi-Line Text");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(4, 4, 4, 4);
        gridBagConstraints.anchor = 13;
        this.getContentPane().add((Component)this.multiLine, gridBagConstraints);
        this.multiLine.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                GetInfoText.this.multiLineStateChanged();
            }
        });
        this.evaluation.setText(" ");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.gridwidth = 3;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(2, 4, 2, 4);
        this.getContentPane().add((Component)this.evaluation, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.gridwidth = 3;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(2, 4, 2, 4);
        this.getContentPane().add((Component)this.textPanel, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 4;
        gridBagConstraints.gridwidth = 3;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(2, 4, 2, 4);
        this.getContentPane().add((Component)this.attrPanel, gridBagConstraints);
        this.cancel.setText("Cancel");
        this.cancel.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                GetInfoText.this.cancelActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 5;
        gridBagConstraints.weightx = 0.1;
        gridBagConstraints.insets = new Insets(4, 4, 4, 4);
        this.getContentPane().add((Component)this.cancel, gridBagConstraints);
        this.apply.setText("Apply");
        this.apply.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                GetInfoText.this.applyActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 5;
        gridBagConstraints.weightx = 0.1;
        gridBagConstraints.insets = new Insets(4, 4, 4, 4);
        this.getContentPane().add((Component)this.apply, gridBagConstraints);
        this.ok.setText("OK");
        this.ok.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                GetInfoText.this.okActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 5;
        gridBagConstraints.weightx = 0.1;
        gridBagConstraints.insets = new Insets(4, 4, 4, 4);
        this.getContentPane().add((Component)this.ok, gridBagConstraints);
        this.pack();
    }

    private void multiLineStateChanged() {
        this.changeTextComponent(this.theText.getText(), this.multiLine.isSelected());
    }

    private void changeTextComponent(String currentText, boolean multipleLines) {
        if (this.cti == null || this.cti.shownText == null) {
            return;
        }
        this.getContentPane().remove(this.theText);
        if (currentText == null) {
            currentText = "";
        }
        if (multipleLines) {
            int size2;
            this.theText = new JTextArea();
            String[] text2 = currentText.split("\\n");
            if (text2.length > (size2 = 1)) {
                size2 = text2.length;
            }
            ((JTextArea)this.theText).setRows(size2);
            ((JTextArea)this.theText).setBorder(BorderFactory.createBevelBorder(1));
            this.theText.addKeyListener(new KeyListener(){

                @Override
                public void keyPressed(KeyEvent e) {
                }

                @Override
                public void keyTyped(KeyEvent e) {
                }

                @Override
                public void keyReleased(KeyEvent e) {
                    JTextArea area = (JTextArea)GetInfoText.this.theText;
                    area.setRows(area.getLineCount());
                    GetInfoText.this.pack();
                    GetInfoText.this.ensureProperSize();
                }
            });
        } else {
            this.theText = new JTextField();
            if (currentText.matches(".*?\\n.*")) {
                currentText = currentText.substring(0, currentText.indexOf(10));
            }
        }
        this.theText.setText(currentText);
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.gridwidth = 3;
        gridBagConstraints.fill = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.insets = new Insets(4, 4, 4, 4);
        this.getContentPane().add((Component)this.theText, gridBagConstraints);
        this.pack();
    }

    private void applyActionPerformed(ActionEvent evt) {
        if (this.cti.shownText == null) {
            return;
        }
        this.textPanel.applyChanges(true);
        this.attrPanel.applyChanges();
        boolean changed = false;
        String currentText = this.theText.getText();
        if (!currentText.equals(this.cti.initialText)) {
            changed = true;
        }
        if (changed) {
            String str;
            int i;
            String[] textArray = currentText.split("\\n");
            ArrayList<String> textList = new ArrayList<String>();
            for (i = 0; i < textArray.length; ++i) {
                str = textArray[i];
                if (SimulationTool.getPreserveVerilogFormating() && this.cti.td.getPos() == AbstractTextDescriptor.Position.RIGHT && (this.cti.varKey == Verilog.VERILOG_PARAMETER_KEY || this.cti.varKey == Verilog.VERILOG_CODE_KEY || this.cti.varKey == Verilog.VERILOG_EXTERNAL_CODE_KEY || this.cti.varKey == Verilog.VERILOG_DECLARATION_KEY)) {
                    textList.add(str);
                    continue;
                }
                if ((str = str.trim()).equals("")) continue;
                textList.add(str);
            }
            textArray = new String[textList.size()];
            for (i = 0; i < textList.size(); ++i) {
                textArray[i] = str = (String)textList.get(i);
            }
            if (textArray.length > 0) {
                new ChangeText(this.cti.owner, this.cti.varKey, textArray);
                this.cti.initialText = currentText;
            }
        }
    }

    private void okActionPerformed(ActionEvent evt) {
        this.applyActionPerformed(evt);
        this.closeDialog(null);
    }

    private void cancelActionPerformed(ActionEvent evt) {
        this.closeDialog(null);
    }

    private void closeDialog(WindowEvent evt) {
        super.closeDialog();
    }

    private static class ChangeText
    extends Job {
        private ElectricObject owner;
        private Variable.Key key;
        private String[] newText;

        private ChangeText(ElectricObject owner, Variable.Key key, String[] newText) {
            super("Modify Text", User.getUserTool(), Job.Type.CHANGE, null, null, Job.Priority.USER);
            this.owner = owner;
            this.key = key;
            this.newText = newText;
            this.startJob();
        }

        @Override
        public boolean doIt() throws JobException {
            if (this.key == null) {
                return false;
            }
            if (this.key == Export.EXPORT_NAME) {
                Export pp = (Export)this.owner;
                pp.rename(this.newText[0]);
            } else if (this.key == NodeInst.NODE_NAME) {
                ((NodeInst)this.owner).setName(this.newText[0]);
            } else if (this.key == ArcInst.ARC_NAME) {
                ((ArcInst)this.owner).setName(this.newText[0]);
            } else if (this.owner instanceof Cell && this.owner.isParam(this.key)) {
                Cell.CellGroup cellGroup = ((Cell)this.owner).getCellGroup();
                if (this.newText.length > 1) {
                    cellGroup.updateParam((Variable.AttrKey)this.key, this.newText);
                } else {
                    cellGroup.updateParamText((Variable.AttrKey)this.key, this.newText[0]);
                }
            } else if (this.newText.length > 1) {
                this.owner.updateVar(this.key, this.newText);
            } else {
                this.owner.updateVarText(this.key, this.newText[0]);
            }
            return true;
        }
    }

    public static class EditInPlaceListener
    implements MouseMotionListener,
    MouseListener,
    MouseWheelListener,
    KeyListener {
        private CachedTextInfo cti;
        private EditWindow wnd;
        private EventListener oldListener;
        private JTextComponent tc;
        private EMenuBar.Instance mb;
        private UndoManager undo;

        public EditInPlaceListener(CachedTextInfo cti, EditWindow wnd, Font theFont, int lowX, int lowY) {
            this.cti = cti;
            this.wnd = wnd;
            if (cti.isMultiLineCapable() || cti.var != null && cti.var.getLength() > 1) {
                EIPEditorPane ep = new EIPEditorPane(cti.initialText);
                this.tc = ep;
            } else {
                EIPTextField tf = new EIPTextField(cti.initialText);
                tf.addActionListener(new ActionListener(){

                    @Override
                    public void actionPerformed(ActionEvent evt) {
                        EditInPlaceListener.this.closeEditInPlace();
                    }
                });
                this.tc = tf;
            }
            Document doc = this.tc.getDocument();
            this.undo = new UndoManager();
            doc.addUndoableEditListener(new UndoableEditListener(){

                @Override
                public void undoableEditHappened(UndoableEditEvent evt) {
                    EditInPlaceListener.this.undo.addEdit(evt.getEdit());
                }
            });
            this.tc.addKeyListener(this);
            this.tc.setSize(this.figureSize());
            this.tc.setLocation(lowX, lowY);
            this.tc.setBorder(new EmptyBorder(0, 0, 0, 0));
            if (theFont != null) {
                this.tc.setFont(theFont);
            }
            this.tc.selectAll();
            wnd.addInPlaceTextObject(this);
            this.tc.setVisible(true);
            this.tc.repaint();
            this.oldListener = WindowFrame.getListener();
            WindowFrame.setListener(this);
            TopLevel top = TopLevel.getCurrentJFrame();
            this.mb = top.getTheMenuBar();
            this.mb.setIgnoreTextEditKeys(true);
        }

        public JTextComponent getTextComponent() {
            return this.tc;
        }

        public void undo() {
            try {
                if (this.undo.canUndo()) {
                    this.undo.undo();
                }
            }
            catch (CannotUndoException cannotUndoException) {
                // empty catch block
            }
        }

        public void redo() {
            try {
                if (this.undo.canRedo()) {
                    this.undo.redo();
                }
            }
            catch (CannotUndoException cannotUndoException) {
                // empty catch block
            }
        }

        private Dimension figureSize() {
            Font theFont = this.wnd.getFont(this.cti.td);
            double size2 = EditWindow.getDefaultFontSize();
            if (this.cti.td != null) {
                size2 = this.cti.td.getTrueSize(this.wnd);
            }
            if (size2 <= 0.0) {
                size2 = 1.0;
            }
            size2 = theFont.getSize();
            String[] textArray = this.tc.getText().split("\\n", -1);
            double totalHeight = 0.0;
            double totalWidth = 0.0;
            for (int i = 0; i < textArray.length; ++i) {
                String str = textArray[i];
                GlyphVector gv = this.wnd.getGlyphs(str, theFont);
                Rectangle2D glyphBounds = gv.getLogicalBounds();
                totalHeight += size2;
                if (!(glyphBounds.getWidth() > totalWidth)) continue;
                totalWidth = glyphBounds.getWidth();
            }
            if (textArray.length > 1) {
                totalHeight *= 2.0;
            }
            return new Dimension((int)(totalWidth + 0.5 * size2), (int)(totalHeight + 0.2 * size2));
        }

        public void closeEditInPlace() {
            String currentText = this.tc.getText();
            if (!currentText.equals(this.cti.initialText)) {
                String str;
                int i;
                String[] textArray = currentText.split("\\n");
                ArrayList<String> textList = new ArrayList<String>();
                for (i = 0; i < textArray.length; ++i) {
                    str = textArray[i];
                    if (SimulationTool.getPreserveVerilogFormating() && this.cti.td.getPos() == AbstractTextDescriptor.Position.RIGHT && (this.cti.varKey == Verilog.VERILOG_PARAMETER_KEY || this.cti.varKey == Verilog.VERILOG_CODE_KEY || this.cti.varKey == Verilog.VERILOG_EXTERNAL_CODE_KEY || this.cti.varKey == Verilog.VERILOG_DECLARATION_KEY)) {
                        textList.add(str);
                        continue;
                    }
                    if ((str = str.trim()).equals("")) continue;
                    textList.add(str);
                }
                textArray = new String[textList.size()];
                for (i = 0; i < textList.size(); ++i) {
                    textArray[i] = str = (String)textList.get(i);
                }
                if (textArray.length > 0) {
                    new ChangeText(this.cti.owner, this.cti.varKey, textArray);
                }
            }
            this.tc.removeKeyListener(this);
            WindowFrame.setListener(this.oldListener);
            this.wnd.removeInPlaceTextObject(this);
            this.wnd.repaint();
            this.wnd.requestFocus();
            this.mb.setIgnoreTextEditKeys(false);
        }

        @Override
        public void mouseEntered(MouseEvent evt) {
        }

        @Override
        public void mouseExited(MouseEvent evt) {
        }

        @Override
        public void mousePressed(MouseEvent evt) {
            this.closeEditInPlace();
        }

        @Override
        public void mouseReleased(MouseEvent evt) {
        }

        @Override
        public void mouseClicked(MouseEvent evt) {
        }

        @Override
        public void mouseMoved(MouseEvent evt) {
        }

        @Override
        public void mouseDragged(MouseEvent evt) {
        }

        @Override
        public void mouseWheelMoved(MouseWheelEvent evt) {
        }

        @Override
        public void keyPressed(KeyEvent evt) {
        }

        @Override
        public void keyReleased(KeyEvent evt) {
            int chr = evt.getKeyCode();
            if (chr == 27) {
                this.tc.setText(this.cti.initialText);
                this.closeEditInPlace();
                return;
            }
            this.tc.setSize(this.figureSize());
        }

        @Override
        public void keyTyped(KeyEvent evt) {
        }
    }

    public static class EIPEditorPane
    extends JEditorPane {
        EIPEditorPane(String text2) {
            super("text/plain", text2);
        }

        @Override
        public void paint(Graphics g) {
            this.requestFocus();
            super.paint(g);
        }
    }

    public static class EIPTextField
    extends JTextField {
        EIPTextField(String text2) {
            super(text2);
        }

        @Override
        public void paint(Graphics g) {
            this.requestFocus();
            super.paint(g);
        }
    }

    private class TextPropertiesFocusListener
    implements WindowFocusListener {
        private TextPropertiesFocusListener() {
        }

        @Override
        public synchronized void windowGainedFocus(WindowEvent e) {
            GetInfoText.this.theText.requestFocus();
        }

        @Override
        public void windowLostFocus(WindowEvent e) {
        }
    }

    private static class CachedTextInfo {
        private Highlight shownText;
        private String initialText;
        private Variable var;
        private Variable.Key varKey;
        private TextDescriptor td;
        private ElectricObject owner;
        private String description;
        private boolean instanceName;
        private boolean multiLineCapable;

        CachedTextInfo(Highlight h) {
            this.shownText = h;
            this.description = "Unknown text";
            this.initialText = "";
            this.td = null;
            this.owner = this.shownText.getElectricObject();
            this.multiLineCapable = false;
            this.instanceName = false;
            NodeInst ni = null;
            if (this.owner instanceof NodeInst) {
                ni = (NodeInst)this.owner;
            }
            this.varKey = this.shownText.getVarKey();
            if (this.varKey != null) {
                if (ni != null && ni.isInvisiblePinWithText() && this.varKey == Artwork.ART_MESSAGE) {
                    this.multiLineCapable = true;
                }
                this.var = this.owner.getParameterOrVariable(this.varKey);
                if (this.var != null) {
                    Object obj = this.var.getObject();
                    if (obj instanceof Object[]) {
                        Object[] theArray = (Object[])obj;
                        this.initialText = "";
                        for (int i = 0; i < theArray.length; ++i) {
                            if (i != 0) {
                                this.initialText = this.initialText + "\n";
                            }
                            this.initialText = this.initialText + theArray[i];
                        }
                        this.multiLineCapable = true;
                    } else {
                        this.initialText = this.var.getPureValue(-1);
                    }
                    this.description = this.var.getFullDescription(this.owner);
                } else if (this.varKey == NodeInst.NODE_NAME) {
                    this.description = "Name of " + ni.getProto();
                    this.varKey = NodeInst.NODE_NAME;
                    this.initialText = ni.getName();
                } else if (this.varKey == ArcInst.ARC_NAME) {
                    ArcInst ai = (ArcInst)this.owner;
                    this.description = "Name of " + ai.getProto();
                    this.varKey = ArcInst.ARC_NAME;
                    this.initialText = ai.getName();
                } else if (this.varKey == NodeInst.NODE_PROTO) {
                    this.description = "Name of cell instance " + ni.describe(true);
                    this.varKey = NodeInst.NODE_PROTO;
                    this.initialText = ni.getProto().describe(true);
                    this.instanceName = true;
                } else if (this.varKey == Export.EXPORT_NAME) {
                    Export pp = (Export)this.owner;
                    this.description = "Name of export " + pp.getName();
                    this.varKey = Export.EXPORT_NAME;
                    this.initialText = pp.getName();
                }
            }
            this.td = this.owner.getTextDescriptor(this.varKey);
        }

        public boolean isInstanceName() {
            return this.instanceName;
        }

        public boolean isMultiLineCapable() {
            return this.multiLineCapable;
        }
    }
}

