/*
 * Decompiled with CFR 0.152.
 */
package com.sun.electric.tool.simulation.test;

import com.sun.electric.tool.simulation.test.BitVector;
import com.sun.electric.tool.simulation.test.ChainModel;
import com.sun.electric.tool.simulation.test.ChipNode;
import com.sun.electric.tool.simulation.test.Infrastructure;
import com.sun.electric.tool.simulation.test.JtagTester;
import com.sun.electric.tool.simulation.test.Logger;
import com.sun.electric.tool.simulation.test.MyTreeNode;
import com.sun.electric.tool.simulation.test.SubchainNode;
import java.util.ArrayList;
import java.util.List;

public class ChainNode
extends SubchainNode {
    private final String opcode;
    protected BitVector inBits;
    protected BitVector outBits;
    protected BitVector outBitsExpected;
    protected BitVector oldOutBitsExpected;
    protected BitVector shadowState;
    private boolean initialized = false;
    private List<ShiftListener> listeners;

    public ChainNode(String name, String opcode, int newLength, String comment2) {
        super(name, newLength, comment2);
        this.opcode = opcode;
        this.listeners = new ArrayList<ShiftListener>();
        this.createBitVectors();
    }

    public String toString() {
        return super.toString() + " (op=" + this.opcode + ")";
    }

    String getOpcode() {
        return this.opcode;
    }

    void setOutBits(BitVector newOutBits) {
        this.outBits.put(0, newOutBits);
    }

    public BitVector getInBits() {
        return this.inBits;
    }

    public BitVector getOutBits() {
        return this.outBits;
    }

    public BitVector getOutBitsExpected() {
        return this.outBitsExpected;
    }

    public BitVector getOldOutBitsExpected() {
        return this.oldOutBitsExpected;
    }

    public BitVector getShadowState() {
        return this.shadowState;
    }

    protected BitVector getOutBitsIndiscriminate() {
        return this.outBits;
    }

    ChipNode getParentChip() {
        MyTreeNode node = this;
        while (node.getClass() != ChipNode.class) {
            if ((node = node.getParent()) != null) continue;
            Infrastructure.fatal(node + " does not have a ChipNode as an ancestor");
        }
        return (ChipNode)node;
    }

    void processMasterClear() {
        for (int ind = 0; ind < this.getLength(); ++ind) {
            SubchainNode node = this.findNodeAtIndex(ind);
            if (!node.usesShadow() && !node.usesDualPortedShadow()) continue;
            int clears = node.getClearBehavior();
            if (clears == 1) {
                this.shadowState.clear(ind);
                continue;
            }
            if (clears == 2) {
                this.shadowState.set(ind);
                continue;
            }
            if (clears != 3) continue;
            this.shadowState.invalidate(ind);
        }
    }

    public void resetInBits(boolean useMasterClearState) {
        for (int i = 0; i < this.getLength(); ++i) {
            SubchainNode node = this.findNodeAtIndex(i);
            if (useMasterClearState && node.getClearBehavior() == 2) {
                this.inBits.set(i, true);
                continue;
            }
            this.inBits.set(i, false);
        }
    }

    void invalidate() {
        this.outBitsExpected.invalidate();
        this.initialized = false;
    }

    boolean shift(JtagTester jtag, boolean readEnable, boolean writeEnable, int irBadSeverity, int noTestSeverity, int errTestSeverity, Logger logger) {
        boolean state;
        SubchainNode node;
        int ind;
        logger.logOther("------ " + this.getPathString() + ", R=" + readEnable + ", W=" + writeEnable);
        jtag.shift(this, readEnable, writeEnable, irBadSeverity);
        boolean noErrors = this.checkOutBits(readEnable, noTestSeverity, errTestSeverity);
        this.oldOutBitsExpected.putIndiscriminate(0, this.outBitsExpected);
        this.outBitsExpected.put(0, this.inBits);
        if (readEnable) {
            for (ind = 0; ind < this.getLength(); ++ind) {
                node = this.findNodeAtIndex(ind);
                if (!node.isReadable() || !node.usesShadow() || node.usesDualPortedShadow() || !this.shadowState.isValid(ind)) continue;
                state = this.shadowState.get(ind);
                this.outBitsExpected.set(ind, state);
            }
        }
        if (writeEnable) {
            for (ind = 0; ind < this.getLength(); ++ind) {
                node = this.findNodeAtIndex(ind);
                if (!node.isWriteable() || !node.usesShadow() && !node.usesDualPortedShadow()) continue;
                state = this.inBits.get(ind);
                this.shadowState.set(ind, state);
            }
        }
        this.shiftCompleted();
        return noErrors;
    }

    boolean shiftOneBit(JtagTester jtag, boolean readEnable, boolean writeEnable, int irBadSeverity, Logger logger) {
        logger.logOther("***** " + this.getPathString() + ", inBits=" + this.inBits);
        int length = this.getLength();
        this.setLength(1);
        jtag.shift(this, readEnable, writeEnable, irBadSeverity);
        boolean outbit = this.outBits.get(0);
        this.setLength(length);
        this.outBitsExpected.invalidate();
        this.oldOutBitsExpected.invalidate();
        this.shadowState.invalidate();
        return outbit;
    }

    void lengthChanged() {
        this.computeLength();
        this.createBitVectors();
    }

    SubchainNode findNodeAtIndex(int bitIndex) {
        if (bitIndex < 0 || bitIndex > this.getLength()) {
            throw new IllegalArgumentException("bitIndex " + bitIndex + " not in allowed range 0.." + this.getLength());
        }
        SubchainNode node = this;
        MyTreeNode parent = null;
        int indChild = 0;
        int nodeIndex = 0;
        while (true) {
            int nextIndex;
            if ((nextIndex = nodeIndex + node.getLength()) <= bitIndex) {
                nodeIndex = nextIndex;
            } else {
                int nkids = node.getChildCount();
                if (nkids == 0) {
                    return node;
                }
                parent = node;
                indChild = 0;
            }
            node = (SubchainNode)parent.getChildAt(indChild);
            ++indChild;
        }
    }

    protected void createBitVectors() {
        int newLength = this.getLength();
        if (newLength < 0) {
            newLength = 0;
        }
        this.inBits = new BitVector(newLength, this.getPathString() + ".inBits");
        this.outBitsExpected = new BitVector(newLength, this.getPathString() + ".outBitsExpected");
        this.oldOutBitsExpected = new BitVector(newLength, this.getPathString() + ".oldOutBitsExpected");
        this.outBits = new BitVector(newLength, this.getPathString() + ".outBits");
        this.shadowState = new BitVector(newLength, this.getPathString() + ".shadowState");
    }

    private boolean checkOutBits(boolean readEnable, int noTestSeverity, int errTestSeverity) {
        int length = this.getLength();
        for (int ind = 0; ind < length; ++ind) {
            SubchainNode node = this.findNodeAtIndex(ind);
            if (node.isUnpredictable()) {
                this.outBitsExpected.invalidate(ind);
                continue;
            }
            if (!readEnable || !node.isReadable()) continue;
            if (node.usesShadow() && this.shadowState.isValid(ind)) {
                this.outBitsExpected.set(ind, this.shadowState.get(ind));
                continue;
            }
            this.outBitsExpected.invalidate(ind);
        }
        if (this.outBitsExpected.isInvalid() && (this.initialized || noTestSeverity == 3 || noTestSeverity == 2)) {
            Infrastructure.error(noTestSeverity, this.getPathString() + ".shift() warning: no bits being compared, " + "see ${TEST_ROOT}/FAQ.html");
        }
        this.initialized = true;
        BitVector errors = new BitVector(length, "checkOutBits()-errors");
        for (int iBit = 0; iBit < length; ++iBit) {
            if (this.outBitsExpected.isValid(iBit) && this.outBits.get(iBit) != this.outBitsExpected.get(iBit)) {
                errors.set(iBit);
                continue;
            }
            errors.clear(iBit);
        }
        boolean noErrors = errors.isEmpty();
        if (!noErrors) {
            Infrastructure.error(errTestSeverity, this.getPathString() + ".shift() error:\n  expected: " + this.outBitsExpected + "\n  outBits: " + this.outBits + "\nFor details, see the Appendix in 'Using the Test" + "\nSoftware Library' for details about this error.");
        }
        return noErrors;
    }

    int findRun(int indStart) {
        int ind;
        SubchainNode start = this.findNodeAtIndex(indStart);
        int clears = start.getClearBehavior();
        boolean read2 = start.isReadable();
        boolean write2 = start.isWriteable();
        boolean shadow = start.usesShadow();
        boolean unpredictable = start.isUnpredictable();
        for (ind = indStart; ind < this.getLength(); ++ind) {
            SubchainNode subchain = this.findNodeAtIndex(ind);
            if (subchain.getClearBehavior() == clears && subchain.isReadable() == read2 && subchain.isWriteable() == write2 && subchain.usesShadow() == shadow && subchain.isUnpredictable() == unpredictable) continue;
            return ind;
        }
        return ind;
    }

    void compare(ChainNode that, String thisFile, String thatFile) {
        super.compare(that, thisFile, thatFile);
        int length = this.getLength();
        if (that.getLength() != length) {
            System.out.println("**** Chain " + thisFile + ":" + this + " has length " + length + ", but " + thatFile + ":" + that + " has " + that.getLength() + ".  Aborting comparison");
            Infrastructure.exit(1);
        }
        int thisIndex = 0;
        int thatIndex = 0;
        while (thisIndex < length && thatIndex < length) {
            String thatState;
            String thisState;
            SubchainNode thisSubchain = this.findNodeAtIndex(thisIndex);
            SubchainNode thatSubchain = that.findNodeAtIndex(thatIndex);
            int thisStartIndex = thisIndex;
            int thatStartIndex = thatIndex;
            if ((thisIndex = this.findRun(thisIndex)) - thisStartIndex != (thatIndex = that.findRun(thatIndex)) - thatStartIndex) {
                System.out.println("**** " + thisFile + " has subchain run of length " + (thisIndex - thisStartIndex) + " starting at subchain " + thisSubchain.getPathString() + ", but " + thatFile + " has run of length " + (thatIndex - thatStartIndex) + " starting at subchain " + thatSubchain.getPathString());
            }
            if ((thisState = thisSubchain.getState()).equals(thatState = thatSubchain.getState())) continue;
            System.out.println("**** Subchain run starting at " + thisFile + ":" + thisSubchain.getPathString() + " has mode " + thisState + ", but run starting at " + thatFile + ": " + thatSubchain.getPathString() + " has mode " + thatState);
        }
    }

    public void addListener(ShiftListener l) {
        this.listeners.add(l);
    }

    public void removeListener(ShiftListener l) {
        this.listeners.remove(l);
    }

    private void shiftCompleted() {
        for (ShiftListener l : this.listeners) {
            l.shiftCompleted(this);
        }
    }

    public static void main(String[] args) {
        int index2;
        String path;
        String filename;
        if (args.length >= 3) {
            filename = args[0];
            path = args[1];
            index2 = Integer.parseInt(args[2]);
        } else {
            filename = "heater.xml";
            path = "heater.pScan";
            index2 = 40;
        }
        ChainModel cm = new ChainModel(filename);
        ChainNode node = (ChainNode)cm.findNode(path);
        SubchainNode found = node.findNodeAtIndex(index2);
        System.out.println(found.getPathString());
    }

    public static interface ShiftListener {
        public void shiftCompleted(ChainNode var1);
    }
}

