/*
 * Decompiled with CFR 0.152.
 */
package com.sun.electric.tool.drc;

import com.sun.electric.database.hierarchy.Cell;
import com.sun.electric.database.prototype.NodeProto;
import com.sun.electric.technology.Layer;
import com.sun.electric.technology.Technology;
import com.sun.electric.tool.drc.DRC;
import com.sun.electric.util.math.GenMath;
import java.io.Serializable;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class CellLayersContainer
implements Serializable {
    private Map<NodeProto, Set<Layer>> cellLayersMap = new HashMap<NodeProto, Set<Layer>>();

    CellLayersContainer() {
    }

    Set<Layer> getLayersSet(NodeProto cell) {
        return this.cellLayersMap.get(cell);
    }

    boolean getWorstSpacingDistance(NodeProto cell, GenMath.MutableDouble mutableDist) {
        Set<Layer> layers = this.getLayersSet(cell);
        Technology tech = cell.getTechnology();
        return DRC.getWorstSpacingDistance(tech, layers, mutableDist);
    }

    void addCellLayers(Cell cell, Set<Layer> set) {
        this.cellLayersMap.put(cell, set);
    }

    boolean addCellLayers(Cell cell, Layer layer) {
        Set<Layer> set = this.cellLayersMap.get(cell);
        if (set == null) {
            set = new HashSet<Layer>(1);
            this.cellLayersMap.put(cell, set);
        }
        return set.add(layer);
    }
}

