/*
 * Decompiled with CFR 0.152.
 */
package com.sun.electric.tool.io.output;

import com.sun.electric.database.geometry.DBMath;
import com.sun.electric.database.geometry.EGraphics;
import com.sun.electric.database.geometry.ERectangle;
import com.sun.electric.database.geometry.Poly;
import com.sun.electric.database.geometry.PolyBase;
import com.sun.electric.database.hierarchy.Cell;
import com.sun.electric.database.hierarchy.Export;
import com.sun.electric.database.text.TextUtils;
import com.sun.electric.database.text.Version;
import com.sun.electric.database.topology.ArcInst;
import com.sun.electric.database.topology.Connection;
import com.sun.electric.database.topology.Geometric;
import com.sun.electric.database.topology.NodeInst;
import com.sun.electric.database.topology.PortInst;
import com.sun.electric.database.variable.AbstractTextDescriptor;
import com.sun.electric.database.variable.EditWindow0;
import com.sun.electric.database.variable.EditWindow_;
import com.sun.electric.database.variable.TextDescriptor;
import com.sun.electric.database.variable.UserInterface;
import com.sun.electric.database.variable.VarContext;
import com.sun.electric.technology.Layer;
import com.sun.electric.technology.PrimitiveNode;
import com.sun.electric.technology.TechPool;
import com.sun.electric.technology.Technology;
import com.sun.electric.technology.technologies.Generic;
import com.sun.electric.tool.Job;
import com.sun.electric.tool.io.IOTool;
import com.sun.electric.tool.io.output.Output;
import com.sun.electric.tool.user.GraphicsPreferences;
import com.sun.electric.tool.user.ui.LayerVisibility;
import java.awt.Color;
import java.awt.geom.AffineTransform;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;

public class SVG
extends Output {
    private static final double SVGTEXTSCALE = 0.75;
    private Cell cell;
    private int currentLayer;
    private AffineTransform matrix;
    private static EGraphics blackGraphics = new EGraphics(false, false, null, 0, 100, 100, 100, 1.0, true, new int[]{0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0});
    private SVGPreferences localPrefs;

    private SVG(SVGPreferences pp, Cell cell) {
        this.localPrefs = pp;
        this.cell = cell;
    }

    private boolean writeCellToFile(String filePath) {
        if (this.localPrefs.printBounds == null) {
            return true;
        }
        boolean error = false;
        if (this.openTextOutputStream(filePath)) {
            error = true;
        } else {
            if (this.start()) {
                this.scanCircuit();
                this.done();
            }
            if (this.closeTextOutputStream()) {
                error = true;
            }
        }
        if (!error) {
            System.out.println(filePath + " written");
        }
        return error;
    }

    private boolean start() {
        double j;
        double i;
        double pageMarginSVG;
        double pageWid = this.localPrefs.pageWidth * 75.0;
        double pageHei = this.localPrefs.pageHeight * 75.0;
        double pageMargin = pageMarginSVG = this.localPrefs.printMargin * 75.0;
        boolean rotatePlot = false;
        switch (this.localPrefs.printRotation) {
            case 1: {
                rotatePlot = true;
                break;
            }
            case 2: {
                if ((!(pageHei > pageWid) && !this.localPrefs.printForPlotter || !(this.localPrefs.printBounds.getWidth() > this.localPrefs.printBounds.getHeight())) && (!(pageWid > pageHei) || !(this.localPrefs.printBounds.getHeight() > this.localPrefs.printBounds.getWidth()))) break;
                rotatePlot = true;
            }
        }
        if (this.localPrefs.printForPlotter) {
            pageHei = rotatePlot ? pageWid * this.localPrefs.printBounds.getWidth() / this.localPrefs.printBounds.getHeight() : pageWid * this.localPrefs.printBounds.getHeight() / this.localPrefs.printBounds.getWidth();
        }
        double cX = this.localPrefs.printBounds.getCenterX();
        double cY = this.localPrefs.printBounds.getCenterY();
        double unitsX = pageWid - pageMargin * 2.0;
        double unitsY = pageHei - pageMargin * 2.0;
        if (this.localPrefs.printForPlotter) {
            i = unitsX / this.localPrefs.printBounds.getWidth();
            j = unitsX / this.localPrefs.printBounds.getHeight();
        } else {
            i = Math.min(unitsX / this.localPrefs.printBounds.getWidth(), unitsY / this.localPrefs.printBounds.getHeight());
            j = Math.min(unitsX / this.localPrefs.printBounds.getHeight(), unitsY / this.localPrefs.printBounds.getWidth());
        }
        if (rotatePlot) {
            i = j;
        }
        double matrix00 = i;
        double matrix01 = 0.0;
        double matrix10 = 0.0;
        double matrix11 = -i;
        double matrix20 = -i * cX + unitsX / 2.0 + pageMarginSVG;
        double matrix21 = this.localPrefs.printForPlotter ? i * this.localPrefs.printBounds.getMinY() - pageMarginSVG : i * cY + unitsY / 2.0 - pageMarginSVG;
        this.matrix = new AffineTransform(matrix00, matrix01, matrix10, matrix11, matrix20, matrix21);
        this.printWriter.println("<?xml version=\"1.0\" standalone=\"no\"?>");
        this.printWriter.println("<!DOCTYPE svg PUBLIC \"-//W3C//DTD SVG 1.1//EN\" \"http://www.w3.org/Graphics/SVG/1.1/DTD/svg11.dtd\">");
        this.printWriter.println();
        this.printWriter.println("<!-- Title: " + this.cell.describe(false) + "-->");
        if (this.localPrefs.includeDateAndVersionInOutput) {
            this.printWriter.println("<!-- Creator: Electric VLSI Design System version " + Version.getVersion() + "-->");
            Date now = new Date();
            this.printWriter.println("<!-- Date: " + TextUtils.formatDate(now) + "-->");
        } else {
            this.printWriter.println("<!-- Creator: Electric VLSI Design System -->");
        }
        this.emitCopyright("<!-- ", "-->");
        this.printWriter.println("<svg width=\"100%\" height=\"100%\" version=\"1.1\" xmlns=\"http://www.w3.org/2000/svg\">");
        this.printWriter.println();
        return true;
    }

    private void done() {
        SVGFrame pf = new SVGFrame(this.cell, this);
        pf.renderFrame();
        this.printWriter.println();
        this.printWriter.println("</svg>");
    }

    private void scanCircuit() {
        Job.getUserInterface().startProgressDialog("Writing SVG", null);
        Job.getUserInterface().setProgressNote("Counting SVG objects...");
        this.printWriter.println("<defs>");
        long totalObjects = this.recurseCircuitLevel(this.cell, DBMath.MATID, true, false, 0L);
        this.printWriter.println("</defs>");
        List<Layer> layerList = this.cell.getTechnology().getLayersSortedByHeight();
        ArrayList<Layer> contactLayers = new ArrayList<Layer>();
        ArrayList<Layer> regularLayers = new ArrayList<Layer>();
        for (Layer layer : layerList) {
            if (layer.getFunction().isContact()) {
                contactLayers.add(layer);
                continue;
            }
            regularLayers.add(layer);
        }
        for (Layer layer : contactLayers) {
            regularLayers.add(layer);
        }
        for (Layer layer : regularLayers) {
            if (this.localPrefs.invisibleLayers.contains(layer)) continue;
            Job.getUserInterface().setProgressNote("Writing layer " + layer.getName() + " (" + totalObjects + " objects...");
            EGraphics gra = this.localPrefs.gp.getGraphics(layer);
            Color col = gra.getColor();
            boolean opaque = gra.getTransparentLayer() == 0;
            String patternName = null;
            if (gra.isPatternedOnDisplay()) {
                patternName = layer.getName();
            }
            this.printWriter.print("<g id=\"Layer-" + layer.getName() + "\"");
            if (patternName != null) {
                this.printWriter.print(" fill=\"url(#" + patternName + ")\"");
            } else {
                this.printWriter.print(" fill=\"" + this.getColorDescription(col) + "\"");
                if (!opaque) {
                    this.printWriter.print(" opacity=\"0.5\"");
                }
            }
            this.printWriter.println(">");
            this.currentLayer = layer.getIndex() + 1;
            this.recurseCircuitLevel(this.cell, DBMath.MATID, true, true, totalObjects);
            this.printWriter.println("</g>");
        }
        this.currentLayer = 0;
        Job.getUserInterface().setProgressNote("Writing cell information (" + totalObjects + " objects...");
        this.recurseCircuitLevel(this.cell, DBMath.MATID, true, true, totalObjects);
        Job.getUserInterface().stopProgressDialog();
    }

    private int recurseCircuitLevel(Cell cell, AffineTransform trans, boolean topLevel, boolean real, long progressTotal) {
        int numObjects = 0;
        Iterator<Geometric> it = cell.getNodes();
        while (it.hasNext()) {
            NodeInst ni = it.next();
            AffineTransform subRot = ni.rotateOut();
            subRot.preConcatenate(trans);
            if (!ni.isCellInstance()) {
                if (!topLevel && (ni.isVisInside() || ni.getProto() == Generic.tech().essentialBoundsNode || ni.getProto() == Generic.tech().cellCenterNode)) continue;
                PrimitiveNode prim = (PrimitiveNode)ni.getProto();
                Technology tech = prim.getTechnology();
                Poly[] polys = tech.getShapeOfNode(ni);
                for (int i = 0; i < polys.length; ++i) {
                    polys[i].transform(subRot);
                    this.svgPoly(polys[i], real);
                }
                if (progressTotal != 0L && ++numObjects % 100 == 0) {
                    long pct = (long)(numObjects * 100) / progressTotal;
                    Job.getUserInterface().setProgressValue((int)pct);
                }
            } else {
                Cell subCell = (Cell)ni.getProto();
                AffineTransform subTrans = ni.translateOut();
                subTrans.preConcatenate(subRot);
                if (!ni.isExpanded()) {
                    ERectangle bounds = subCell.getBounds();
                    Poly poly = new Poly(bounds.getCenterX(), bounds.getCenterY(), ni.getXSize(), ni.getYSize());
                    poly.transform(subTrans);
                    poly.setStyle(Poly.Type.CLOSED);
                    poly.setLayer(null);
                    poly.setGraphicsOverride(blackGraphics);
                    this.svgPoly(poly, real);
                    if (real) {
                        if (this.localPrefs.gp.isTextVisibilityOn(AbstractTextDescriptor.TextType.INSTANCE)) {
                            poly.setStyle(Poly.Type.TEXTBOX);
                            TextDescriptor td = TextDescriptor.getInstanceTextDescriptor().withAbsSize(24);
                            poly.setTextDescriptor(td);
                            poly.setString(ni.getProto().describe(false));
                            this.svgPoly(poly, true);
                        }
                        if (topLevel) {
                            this.showCellPorts(ni, trans, null);
                        }
                    }
                    if (progressTotal != 0L && ++numObjects % 100 == 0) {
                        long pct = (long)(numObjects * 100) / progressTotal;
                        Job.getUserInterface().setProgressValue((int)pct);
                    }
                } else {
                    this.recurseCircuitLevel(subCell, subTrans, false, real, progressTotal);
                    if (topLevel && real) {
                        this.showCellPorts(ni, trans, Color.BLACK);
                    }
                }
            }
            if (real && this.localPrefs.gp.isTextVisibilityOn(AbstractTextDescriptor.TextType.NODE)) {
                Poly[] textPolys = ni.getDisplayableVariables(this.localPrefs.wnd);
                for (int i = 0; i < textPolys.length; ++i) {
                    textPolys[i].transform(subRot);
                    this.svgPoly(textPolys[i], true);
                }
            }
            if (!topLevel || !this.localPrefs.gp.isTextVisibilityOn(AbstractTextDescriptor.TextType.EXPORT)) continue;
            Iterator<Export> eIt = ni.getExports();
            while (eIt.hasNext()) {
                Export e = eIt.next();
                if (real) {
                    Poly poly = e.getNamePoly();
                    if (this.localPrefs.gp.exportDisplayLevel == 2) {
                        this.drawCross(poly.getCenterX(), poly.getCenterY(), Color.BLACK, false);
                    } else {
                        if (this.localPrefs.gp.exportDisplayLevel == 1) {
                            String portName = e.getShortName();
                            poly.setString(portName);
                        }
                        TextDescriptor descript = poly.getTextDescriptor();
                        Poly.Type style = descript.getPos().getPolyType();
                        style = Poly.rotateType(style, ni);
                        poly.setStyle(style);
                        this.svgPoly(poly, true);
                    }
                    Rectangle2D rect = (Rectangle2D)poly.getBounds2D().clone();
                    Poly[] polys = e.getDisplayableVariables(rect, this.localPrefs.wnd, true);
                    for (int i = 0; i < polys.length; ++i) {
                        this.svgPoly(polys[i], true);
                    }
                }
                if (progressTotal == 0L || ++numObjects % 100 != 0) continue;
                long pct = (long)(numObjects * 100) / progressTotal;
                Job.getUserInterface().setProgressValue((int)pct);
            }
        }
        it = cell.getArcs();
        while (it.hasNext()) {
            ArcInst ai = (ArcInst)it.next();
            Technology tech = ai.getProto().getTechnology();
            Poly[] polys = tech.getShapeOfArc(ai);
            for (int i = 0; i < polys.length; ++i) {
                polys[i].transform(trans);
                this.svgPoly(polys[i], real);
            }
            if (real && topLevel && this.localPrefs.gp.isTextVisibilityOn(AbstractTextDescriptor.TextType.ARC)) {
                Poly[] textPolys = ai.getDisplayableVariables(this.localPrefs.wnd);
                for (int i = 0; i < textPolys.length; ++i) {
                    textPolys[i].transform(trans);
                    this.svgPoly(textPolys[i], true);
                }
            }
            if (progressTotal == 0L || ++numObjects % 100 != 0) continue;
            long pct = (long)(numObjects * 100) / progressTotal;
            Job.getUserInterface().setProgressValue((int)pct);
        }
        if (topLevel && real && this.localPrefs.gp.isTextVisibilityOn(AbstractTextDescriptor.TextType.CELL)) {
            Rectangle2D.Double CENTERRECT = new Rectangle2D.Double(0.0, 0.0, 0.0, 0.0);
            Poly[] polys = cell.getDisplayableVariables(CENTERRECT, this.localPrefs.wnd, true);
            for (int i = 0; i < polys.length; ++i) {
                this.svgPoly(polys[i], true);
            }
        }
        return numObjects;
    }

    private void showCellPorts(NodeInst ni, AffineTransform trans, Color col) {
        PortInst pi;
        int numPorts = ni.getProto().getNumPorts();
        boolean[] shownPorts = new boolean[numPorts];
        Iterator<Object> it = ni.getConnections();
        while (it.hasNext()) {
            Connection con = it.next();
            pi = con.getPortInst();
            shownPorts[pi.getPortIndex()] = true;
        }
        it = ni.getExports();
        while (it.hasNext()) {
            Export exp = (Export)it.next();
            pi = exp.getOriginalPort();
            shownPorts[pi.getPortIndex()] = true;
        }
        for (int i = 0; i < numPorts; ++i) {
            Export pp;
            Poly portPoly;
            if (shownPorts[i] || (portPoly = ni.getShapeOfPort(pp = (Export)ni.getProto().getPort(i))) == null) continue;
            portPoly.transform(trans);
            Color portColor = col;
            if (portColor == null) {
                portColor = pp.getBasePort().getPortColor(this.localPrefs.gp);
            }
            if (this.localPrefs.gp.portDisplayLevel == 2) {
                this.drawCross(portPoly.getCenterX(), portPoly.getCenterY(), portColor, false);
                continue;
            }
            if (!this.localPrefs.gp.isTextVisibilityOn(AbstractTextDescriptor.TextType.PORT)) continue;
            TextDescriptor descript = portPoly.getTextDescriptor();
            if (descript == null) {
                descript = AbstractTextDescriptor.TextType.EXPORT.getFactoryTextDescriptor();
            }
            TextDescriptor portDescript = pp.getTextDescriptor(Export.EXPORT_NAME).withColorIndex(descript.getColorIndex());
            Poly.Type type = descript.getPos().getPolyType();
            portPoly.setStyle(type);
            String portName = pp.getName();
            if (this.localPrefs.gp.portDisplayLevel == 1) {
                portName = pp.getShortName();
            }
            portPoly.setString(portName);
            portPoly.setTextDescriptor(portDescript);
            this.svgText(portPoly, portColor);
        }
    }

    private void svgPoly(PolyBase poly, boolean real) {
        int k;
        Layer layer = poly.getLayer();
        EGraphics gra = null;
        int index = 0;
        Technology tech = this.cell.getTechnology();
        if (layer != null) {
            EGraphics overGra;
            tech = layer.getTechnology();
            index = layer.getIndex();
            if (this.localPrefs.invisibleLayers.contains(layer)) {
                return;
            }
            if (!real || this.currentLayer == 0) {
                gra = this.localPrefs.gp.getGraphics(layer);
            }
            if (poly instanceof Poly && (overGra = ((Poly)poly).getGraphicsOverride()) != null) {
                gra = overGra;
            }
        }
        Color col = null;
        boolean opaque = true;
        String patternName = null;
        if (gra != null) {
            col = gra.getColor();
            boolean bl = opaque = gra.getTransparentLayer() == 0;
            if (gra.isPatternedOnDisplay()) {
                patternName = layer.getName();
            }
        }
        if (patternName != null && !real) {
            int i;
            int[] pattern = gra.getPattern();
            boolean sol = true;
            for (i = 0; i < 8; ++i) {
                if (pattern[i] == 65535) continue;
                sol = false;
                break;
            }
            if (sol) {
                patternName = null;
            } else {
                this.printWriter.println("  <pattern id=\"" + patternName + "\" x=\"0\" y=\"0\" width=\"16\" height=\"8\" patternUnits=\"userSpaceOnUse\">");
                for (i = 0; i < 8; ++i) {
                    for (k = 0; k < 16; ++k) {
                        if ((pattern[i] >> k & 1) == 0) continue;
                        this.printWriter.println("    <rect x=\"" + (15 - k) + "\" y=\"" + i + "\" width=\"1\" height=\"1\" fill=\"" + this.getColorDescription(col) + "\"/>");
                    }
                }
                this.printWriter.println("  </pattern>");
            }
        }
        if (this.currentLayer >= 0 && (this.currentLayer == 0 ? tech == this.cell.getTechnology() : tech != this.cell.getTechnology() || this.currentLayer - 1 != index)) {
            return;
        }
        Poly.Type type = poly.getStyle();
        Point2D[] points = poly.getPoints();
        if (type == Poly.Type.FILLED) {
            Rectangle2D polyBox = poly.getBox();
            if (polyBox != null) {
                if (polyBox.getWidth() == 0.0) {
                    if (!real) {
                        return;
                    }
                    if (polyBox.getHeight() == 0.0) {
                        this.svgDot(new Point2D.Double(polyBox.getCenterX(), polyBox.getCenterY()), col, opaque, patternName);
                    } else {
                        this.svgLine(new Point2D.Double(polyBox.getCenterX(), polyBox.getMinY()), new Point2D.Double(polyBox.getCenterX(), polyBox.getMaxY()), col, 0);
                    }
                    return;
                }
                if (polyBox.getHeight() == 0.0) {
                    if (real) {
                        this.svgLine(new Point2D.Double(polyBox.getMinX(), polyBox.getCenterY()), new Point2D.Double(polyBox.getMaxX(), polyBox.getCenterY()), col, 0);
                    }
                    return;
                }
                this.svgBox(polyBox, col, opaque, patternName);
                return;
            }
            if (points.length == 1) {
                if (real) {
                    this.svgDot(points[0], col, opaque, patternName);
                }
                return;
            }
            if (points.length == 2) {
                if (real) {
                    this.svgLine(points[0], points[1], col, 0);
                }
                return;
            }
            this.svgPolygon(poly, col, opaque, patternName);
            return;
        }
        if (!real) {
            return;
        }
        if (type == Poly.Type.CLOSED) {
            Point2D lastPt = points[points.length - 1];
            for (k = 0; k < points.length; ++k) {
                this.svgLine(lastPt, points[k], col, 0);
                lastPt = points[k];
            }
            return;
        }
        if (type == Poly.Type.OPENED || type == Poly.Type.OPENEDT1 || type == Poly.Type.OPENEDT2 || type == Poly.Type.OPENEDT3) {
            int lineType = 0;
            if (type == Poly.Type.OPENEDT1) {
                lineType = 1;
            } else if (type == Poly.Type.OPENEDT2) {
                lineType = 2;
            } else if (type == Poly.Type.OPENEDT3) {
                lineType = 3;
            }
            for (k = 1; k < points.length; ++k) {
                this.svgLine(points[k - 1], points[k], col, lineType);
            }
            return;
        }
        if (type == Poly.Type.VECTORS) {
            for (int k2 = 0; k2 < points.length; k2 += 2) {
                this.svgLine(points[k2], points[k2 + 1], col, 0);
            }
            return;
        }
        if (type == Poly.Type.CROSS || type == Poly.Type.BIGCROSS) {
            double x = poly.getCenterX();
            double y = poly.getCenterY();
            this.drawCross(x, y, col, type == Poly.Type.BIGCROSS);
            return;
        }
        if (type == Poly.Type.CROSSED) {
            Rectangle2D bounds = poly.getBounds2D();
            this.svgLine(new Point2D.Double(bounds.getMinX(), bounds.getMinY()), new Point2D.Double(bounds.getMinX(), bounds.getMaxY()), col, 0);
            this.svgLine(new Point2D.Double(bounds.getMinX(), bounds.getMaxY()), new Point2D.Double(bounds.getMaxX(), bounds.getMaxY()), col, 0);
            this.svgLine(new Point2D.Double(bounds.getMaxX(), bounds.getMaxY()), new Point2D.Double(bounds.getMaxX(), bounds.getMinY()), col, 0);
            this.svgLine(new Point2D.Double(bounds.getMaxX(), bounds.getMinY()), new Point2D.Double(bounds.getMinX(), bounds.getMinY()), col, 0);
            this.svgLine(new Point2D.Double(bounds.getMinX(), bounds.getMinY()), new Point2D.Double(bounds.getMaxX(), bounds.getMaxY()), col, 0);
            this.svgLine(new Point2D.Double(bounds.getMinX(), bounds.getMaxY()), new Point2D.Double(bounds.getMaxX(), bounds.getMinY()), col, 0);
            return;
        }
        if (type == Poly.Type.DISC) {
            this.svgDisc(points[0], points[1], col, opaque, patternName);
            return;
        }
        if (type == Poly.Type.CIRCLE || type == Poly.Type.THICKCIRCLE) {
            this.svgCircle(points[0], points[1], col, opaque, patternName);
            return;
        }
        if (type == Poly.Type.CIRCLEARC || type == Poly.Type.THICKCIRCLEARC) {
            this.svgArc(points[0], points[1], points[2], col);
            return;
        }
        this.svgText((Poly)poly, col == null ? Color.black : col);
    }

    private void drawCross(double x, double y, Color col, boolean bigCross) {
        double amount = 0.25;
        if (bigCross) {
            amount = 0.5;
        }
        this.svgLine(new Point2D.Double(x - amount, y), new Point2D.Double(x + amount, y), col, 0);
        this.svgLine(new Point2D.Double(x, y + amount), new Point2D.Double(x, y - amount), col, 0);
    }

    private void svgDot(Point2D pt, Color col, boolean opaque, String patternName) {
        Point2D ps = this.svgXform(pt);
        String style = this.getStyleDescription(col, opaque, patternName);
        this.printWriter.println("<rect x=\"" + TextUtils.formatDouble(ps.getX()) + "\" y=\"" + TextUtils.formatDouble(ps.getY()) + "\" width=\"1\" height=\"1\" " + style + "/>");
    }

    private void svgLine(Point2D from, Point2D to, Color col, int pattern) {
        Point2D pt1 = this.svgXform(from);
        Point2D pt2 = this.svgXform(to);
        this.printWriter.print("<line x1=\"" + pt1.getX() + "\" y1=\"" + pt1.getY() + "\" x2=\"" + pt2.getX() + "\" y2=\"" + pt2.getY() + "\"");
        switch (pattern) {
            case 0: {
                this.printWriter.print(" style=\"stroke:" + this.getColorDescription(col) + "\"");
                break;
            }
            case 1: {
                this.printWriter.print(" style=\"stroke-dasharray:1,5;stroke:" + this.getColorDescription(col) + "\"");
                break;
            }
            case 2: {
                this.printWriter.print(" style=\"stroke-dasharray:8,4;stroke:" + this.getColorDescription(col) + "\"");
                break;
            }
            case 3: {
                this.printWriter.print(" style=\"stroke-width:3;stroke:" + this.getColorDescription(col) + "\"");
            }
        }
        this.printWriter.println("/>");
    }

    private void svgArc(Point2D center, Point2D pt1, Point2D pt2, Color col) {
        Point2D pc = this.svgXform(center);
        Point2D ps1 = this.svgXform(pt1);
        Point2D ps2 = this.svgXform(pt2);
        double radius = pc.distance(ps1);
        double startAngle = (3600 - DBMath.figureAngle(pc, ps2)) % 3600 / 10;
        double endAngle = (3600 - DBMath.figureAngle(pc, ps1)) % 3600 / 10;
        double angleDiff = endAngle - startAngle;
        if (angleDiff < 0.0) {
            angleDiff += 360.0;
        }
        int largeAngle = angleDiff >= 180.0 ? 1 : 0;
        int positive = 1;
        this.printWriter.println("<path d=\"M " + ps1.getX() + "," + ps1.getY() + " A" + radius + "," + radius + " " + startAngle + " " + largeAngle + "," + positive + " " + ps2.getX() + "," + ps2.getY() + "\" fill=\"none\" stroke=\"" + this.getColorDescription(col) + "\" />");
    }

    private void svgCircle(Point2D center, Point2D pt, Color col, boolean opaque, String patternName) {
        Point2D pc = this.svgXform(center);
        Point2D ps = this.svgXform(pt);
        double radius = pc.distance(ps);
        String style = "style=\"stroke:" + this.getColorDescription(col) + (opaque ? "" : ";opacity:0.5") + ";fill:none\"";
        this.printWriter.println("<circle cx=\"" + TextUtils.formatDouble(pc.getX()) + "\" cy=\"" + TextUtils.formatDouble(pc.getY()) + "\" r=\"" + radius + "\" " + style + "/>");
    }

    private void svgDisc(Point2D center, Point2D pt, Color col, boolean opaque, String patternName) {
        Point2D pc = this.svgXform(center);
        Point2D ps = this.svgXform(pt);
        double radius = pc.distance(ps);
        String style = this.getStyleDescription(col, opaque, patternName);
        this.printWriter.println("<circle cx=\"" + TextUtils.formatDouble(pc.getX()) + "\" cy=\"" + TextUtils.formatDouble(pc.getY()) + "\" r=\"" + radius + "\" " + style + "/>");
    }

    private void svgBox(Rectangle2D polyBox, Color col, boolean opaque, String patternName) {
        Point2D pLow = this.svgXform(new Point2D.Double(polyBox.getMinX(), polyBox.getMaxY()));
        Point2D pHigh = this.svgXform(new Point2D.Double(polyBox.getMaxX(), polyBox.getMinY()));
        String style = this.getStyleDescription(col, opaque, patternName);
        this.printWriter.println("<rect x=\"" + pLow.getX() + "\" y=\"" + pLow.getY() + "\" width=\"" + (pHigh.getX() - pLow.getX()) + "\" height=\"" + (pHigh.getY() - pLow.getY()) + "\" " + style + "/>");
    }

    private void svgPolygon(PolyBase poly, Color col, boolean opaque, String patternName) {
        Point2D[] points = poly.getPoints();
        if (points.length == 0) {
            return;
        }
        this.printWriter.print("<polygon points=\"");
        for (int i = 0; i < points.length; ++i) {
            if (i != 0) {
                this.printWriter.print(" ");
            }
            Point2D ps = this.svgXform(points[i]);
            this.printWriter.print(TextUtils.formatDouble(ps.getX()) + "," + TextUtils.formatDouble(ps.getY()));
        }
        this.printWriter.println("\" " + this.getStyleDescription(col, opaque, patternName) + "/>");
    }

    private String getStyleDescription(Color col, boolean opaque, String patternName) {
        if (patternName != null) {
            return "fill=\"url(#" + patternName + ")\"";
        }
        if (col == null) {
            return "";
        }
        String style = "style=\"fill:" + this.getColorDescription(col) + (opaque ? "" : ";opacity:0.5") + "\"";
        return style;
    }

    private String getColorDescription(Color col) {
        if (col == null) {
            return "";
        }
        String style = "rgb(" + col.getRed() + "," + col.getGreen() + "," + col.getBlue() + ")";
        return style;
    }

    private void svgText(Poly poly, Color col) {
        AbstractTextDescriptor.Rotation rot;
        AbstractTextDescriptor.ActiveFont af;
        double y;
        double x;
        Poly.Type style = poly.getStyle();
        TextDescriptor td = poly.getTextDescriptor();
        if (td == null) {
            return;
        }
        int size = (int)(td.getTrueSize(this.localPrefs.wnd) * 0.75);
        Rectangle2D bounds = poly.getBounds2D();
        if (size <= 0) {
            return;
        }
        String text = poly.getString().trim();
        if (text.length() == 0) {
            return;
        }
        if (poly.getStyle() == Poly.Type.TEXTBOX) {
            style = Poly.Type.TEXTCENT;
        }
        String styleMsg = null;
        if (style == Poly.Type.TEXTCENT) {
            Point2D p = this.svgXform(new Point2D.Double(bounds.getCenterX(), bounds.getCenterY()));
            x = p.getX();
            y = p.getY() + (double)(size / 2);
            styleMsg = "text-anchor:middle";
        } else if (style == Poly.Type.TEXTTOP) {
            Point2D p = this.svgXform(new Point2D.Double(bounds.getCenterX(), bounds.getMinY()));
            x = p.getX();
            y = p.getY() + (double)size;
            styleMsg = "text-anchor:middle";
        } else if (style == Poly.Type.TEXTBOT) {
            Point2D p = this.svgXform(new Point2D.Double(bounds.getCenterX(), bounds.getMaxY()));
            x = p.getX();
            y = p.getY();
            styleMsg = "text-anchor:middle";
        } else if (style == Poly.Type.TEXTLEFT) {
            Point2D p = this.svgXform(new Point2D.Double(bounds.getMinX(), bounds.getCenterY()));
            x = p.getX();
            y = p.getY() + (double)(size / 2);
        } else if (style == Poly.Type.TEXTRIGHT) {
            Point2D p = this.svgXform(new Point2D.Double(bounds.getMaxX(), bounds.getCenterY()));
            x = p.getX();
            y = p.getY() + (double)(size / 2);
            styleMsg = "text-anchor:end";
        } else if (style == Poly.Type.TEXTTOPLEFT) {
            Point2D p = this.svgXform(new Point2D.Double(bounds.getMinX(), bounds.getMinY()));
            x = p.getX();
            y = p.getY() + (double)size;
        } else if (style == Poly.Type.TEXTTOPRIGHT) {
            Point2D p = this.svgXform(new Point2D.Double(bounds.getMaxX(), bounds.getMinY()));
            x = p.getX();
            y = p.getY() + (double)size;
            styleMsg = "text-anchor:end";
        } else if (style == Poly.Type.TEXTBOTLEFT) {
            Point2D p = this.svgXform(new Point2D.Double(bounds.getMinX(), bounds.getMaxY()));
            x = p.getX();
            y = p.getY();
        } else if (style == Poly.Type.TEXTBOTRIGHT) {
            Point2D p = this.svgXform(new Point2D.Double(bounds.getMaxX(), bounds.getMaxY()));
            x = p.getX();
            y = p.getY();
            styleMsg = "text-anchor:end";
        } else {
            return;
        }
        if (td.isBold()) {
            styleMsg = styleMsg + "; font-weight: bold";
        }
        if (td.isItalic()) {
            styleMsg = styleMsg + "; font-style: italic";
        }
        this.printWriter.print("<text x=\"" + x + "\" y=\"" + y + "\" fill=\"" + this.getColorDescription(col) + "\" font-size=\"" + size + "\"");
        String faceName = null;
        int faceNumber = td.getFace();
        if (faceNumber != 0 && (af = AbstractTextDescriptor.ActiveFont.findActiveFont(faceNumber)) != null) {
            faceName = af.getName();
        }
        if (faceName != null) {
            String fixedFaceName = faceName.replace(' ', '-');
            this.printWriter.println(" font-family=\"" + fixedFaceName + "\"");
        }
        if (styleMsg != null) {
            this.printWriter.print(" style=\"" + styleMsg + "\"");
        }
        if ((rot = td.getRotation()) != AbstractTextDescriptor.Rotation.ROT0) {
            int amt = 270;
            if (rot == AbstractTextDescriptor.Rotation.ROT180) {
                amt = 180;
            } else if (rot == AbstractTextDescriptor.Rotation.ROT270) {
                amt = 90;
            }
            this.printWriter.println(" transform=\"rotate(" + amt + " " + x + "," + y + ")\"");
        }
        this.printWriter.println(">");
        this.printWriter.println("  " + text);
        this.printWriter.println("</text>");
    }

    private Point2D svgXform(Point2D pt) {
        Point2D.Double result = new Point2D.Double();
        this.matrix.transform(pt, result);
        return result;
    }

    private static class SVGFrame
    extends Cell.FrameDescription {
        private SVG writer;

        public SVGFrame(Cell cell, SVG writer) {
            super(cell, 0);
            this.writer = writer;
        }

        public void showFrameLine(Point2D from, Point2D to) {
            this.writer.svgLine(from, to, Color.BLACK, 0);
        }

        public void showFrameText(Point2D ctr, double size, double maxWid, double maxHei, String string) {
            Poly poly = null;
            if (maxWid > 0.0 && maxHei > 0.0) {
                poly = new Poly(ctr.getX(), ctr.getY(), maxWid, maxHei);
                poly.setStyle(Poly.Type.TEXTBOX);
            } else {
                Point2D[] points = new Point2D[]{ctr};
                poly = new Poly(points);
                poly.setStyle(Poly.Type.TEXTCENT);
            }
            poly.setString(string);
            TextDescriptor td = TextDescriptor.getNodeTextDescriptor().withRelSize(size * 0.75);
            poly.setTextDescriptor(td);
            this.writer.svgText(poly, Color.BLACK);
        }
    }

    public static class SVGPreferences
    extends Output.OutputPreferences {
        boolean printForPlotter = IOTool.isFactoryPrintForPlotter();
        double pageWidth = IOTool.getFactoryPrintWidth();
        double pageHeight = IOTool.getFactoryPrintHeight();
        double printMargin = IOTool.getFactoryPrintMargin();
        int printRotation = IOTool.getFactoryPrintRotation();
        GraphicsPreferences gp;
        EditWindow0.EditWindowSmall wnd;
        ERectangle printBounds;
        Set<Layer> invisibleLayers = new HashSet<Layer>();
        boolean isGrid = false;
        double gridXSpacing;
        double gridYSpacing;

        SVGPreferences(boolean factory) {
            super(factory);
            this.gp = new GraphicsPreferences(factory);
            LayerVisibility lv = new LayerVisibility(factory);
            for (Technology tech : TechPool.getThreadTechPool().values()) {
                Iterator<Layer> it = tech.getLayers();
                while (it.hasNext()) {
                    Layer layer = it.next();
                    if (lv.isVisible(layer)) continue;
                    this.invisibleLayers.add(layer);
                }
            }
            if (!factory) {
                this.fillPrefs();
            }
        }

        private void fillPrefs() {
            this.printForPlotter = IOTool.isPrintForPlotter();
            this.pageWidth = IOTool.getPrintWidth();
            this.pageHeight = IOTool.getPrintHeight();
            this.printMargin = IOTool.getPrintMargin();
            this.printRotation = IOTool.getPrintRotation();
            UserInterface ui = Job.getUserInterface();
            EditWindow_ localWnd = ui.getCurrentEditWindow_();
            this.wnd = new EditWindow0.EditWindowSmall(localWnd);
            this.isGrid = localWnd.isGrid();
            this.gridXSpacing = localWnd.getGridXSpacing();
            this.gridYSpacing = localWnd.getGridYSpacing();
            Cell cell = localWnd.getCell();
            this.printBounds = ERectangle.fromLambda(Output.getAreaToPrint(cell, false, localWnd));
        }

        public Output doOutput(Cell cell, VarContext context, String filePath) {
            SVG out = new SVG(this, cell);
            out.writeCellToFile(filePath);
            return out.finishWrite();
        }
    }
}

