/*
 * Decompiled with CFR 0.152.
 */
package com.sun.electric.tool.simulation;

import com.sun.electric.database.geometry.btree.BTree;
import com.sun.electric.tool.simulation.NewSignal;
import com.sun.electric.tool.simulation.NewSignalSimpleImpl;
import com.sun.electric.tool.simulation.ScalarSample;
import com.sun.electric.tool.simulation.Waveform;
import java.io.Serializable;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class BTreeNewSignal
extends NewSignalSimpleImpl
implements Waveform {
    public final int numEvents;
    public final int eventWithMinValue;
    public final int eventWithMaxValue;
    private NewSignal.Approximation<ScalarSample> preferredApproximation = null;
    private final BTree<Double, Double, Serializable> tree;

    public BTreeNewSignal(int eventWithMinValue, int eventWithMaxValue, BTree<Double, Double, Serializable> tree) {
        this.numEvents = tree.size();
        this.eventWithMinValue = eventWithMinValue;
        this.eventWithMaxValue = eventWithMaxValue;
        if (tree == null) {
            throw new RuntimeException();
        }
        this.tree = tree;
        this.preferredApproximation = new BTreeNewSignalApproximation();
    }

    @Override
    public synchronized NewSignal.Approximation<ScalarSample> getPreferredApproximation() {
        return this.preferredApproximation;
    }

    @Override
    protected ScalarSample getSampleForTime(double t, boolean justLessThan) {
        Double d = this.tree.getValFromKeyFloor(t);
        if (d == null) {
            throw new RuntimeException("index out of bounds");
        }
        return new ScalarSample(d);
    }

    @Override
    public int getNumEvents() {
        return this.numEvents;
    }

    @Override
    protected int getEventForTime(double t, boolean justLessThan) {
        return this.tree.getOrdFromKeyFloor(t);
    }

    @Override
    public void getEvent(int index, double[] result) {
        result[0] = this.getPreferredApproximation().getTime(index);
        result[1] = result[2] = this.getPreferredApproximation().getSample(index).getValue();
    }

    @Override
    public NewSignal.Approximation<ScalarSample> getPixelatedApproximation(double t0, double t1, int numRegions) {
        return new BTreePixelatedApproximation(t0, t1, numRegions);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class BTreePixelatedApproximation
    implements NewSignal.Approximation<ScalarSample> {
        int[] events;

        public BTreePixelatedApproximation(double t0, double t1, int numRegions) {
            int[] events = new int[numRegions];
            int j = 0;
            double stride = (t1 - t0) / (double)(numRegions * 2);
            for (int i = 0; i < numRegions; ++i) {
                int idx;
                double t = t0 + (double)(2 * i + 1) * stride;
                int n = idx = i == numRegions - 1 ? BTreeNewSignal.this.tree.getOrdFromKeyCeiling(t) : BTreeNewSignal.this.tree.getOrdFromKeyFloor(t);
                if (j > 0 && events[j - 1] == idx) {
                    idx = BTreeNewSignal.this.tree.getOrdFromKeyCeiling(t);
                }
                if (j > 0 && events[j - 1] == idx || idx == BTreeNewSignal.this.tree.size() || idx == -1 || j < numRegions - 1 && (Double)BTreeNewSignal.this.tree.getKeyFromOrd(idx) > t + 2.0 * stride) continue;
                events[j++] = idx;
            }
            this.events = new int[j];
            System.arraycopy(events, 0, this.events, 0, j);
        }

        @Override
        public int getNumEvents() {
            return this.events.length;
        }

        @Override
        public double getTime(int index) {
            Double d = (Double)BTreeNewSignal.this.tree.getKeyFromOrd(this.events[index]);
            if (d == null) {
                throw new RuntimeException("index " + index + "/" + this.events[index] + " out of bounds, size=" + BTreeNewSignal.this.tree.size());
            }
            return d;
        }

        @Override
        public ScalarSample getSample(int index) {
            Double d = (Double)BTreeNewSignal.this.tree.getValFromOrd(this.events[index]);
            if (d == null) {
                throw new RuntimeException("index out of bounds");
            }
            return new ScalarSample(d);
        }

        @Override
        public int getTimeNumerator(int index) {
            throw new RuntimeException("not implemented");
        }

        @Override
        public int getTimeDenominator() {
            throw new RuntimeException("not implemented");
        }

        @Override
        public int getEventWithMaxValue() {
            throw new RuntimeException("not implemented");
        }

        @Override
        public int getEventWithMinValue() {
            throw new RuntimeException("not implemented");
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class BTreeNewSignalApproximation
    implements NewSignal.Approximation<ScalarSample> {
        private BTreeNewSignalApproximation() {
        }

        @Override
        public int getNumEvents() {
            return BTreeNewSignal.this.numEvents;
        }

        @Override
        public double getTime(int index) {
            Double d = (Double)BTreeNewSignal.this.tree.getKeyFromOrd(index);
            if (d == null) {
                throw new RuntimeException("index out of bounds");
            }
            return d;
        }

        @Override
        public ScalarSample getSample(int index) {
            Double d = (Double)BTreeNewSignal.this.tree.getValFromOrd(index);
            if (d == null) {
                throw new RuntimeException("index out of bounds");
            }
            return new ScalarSample(d);
        }

        @Override
        public int getTimeNumerator(int index) {
            throw new RuntimeException("not implemented");
        }

        @Override
        public int getTimeDenominator() {
            throw new RuntimeException("not implemented");
        }

        @Override
        public int getEventWithMaxValue() {
            return BTreeNewSignal.this.eventWithMaxValue;
        }

        @Override
        public int getEventWithMinValue() {
            return BTreeNewSignal.this.eventWithMinValue;
        }
    }
}

