/*
 * Decompiled with CFR 0.152.
 */
package com.sun.electric.tool.user.redisplay;

import com.sun.electric.database.CellBackup;
import com.sun.electric.database.CellRevision;
import com.sun.electric.database.ImmutableArcInst;
import com.sun.electric.database.ImmutableExport;
import com.sun.electric.database.ImmutableIconInst;
import com.sun.electric.database.ImmutableNodeInst;
import com.sun.electric.database.Snapshot;
import com.sun.electric.database.geometry.DBMath;
import com.sun.electric.database.geometry.EGraphics;
import com.sun.electric.database.geometry.ERectangle;
import com.sun.electric.database.geometry.GenMath;
import com.sun.electric.database.geometry.Orientation;
import com.sun.electric.database.geometry.Poly;
import com.sun.electric.database.hierarchy.Cell;
import com.sun.electric.database.hierarchy.EDatabase;
import com.sun.electric.database.hierarchy.Export;
import com.sun.electric.database.id.CellId;
import com.sun.electric.database.id.CellUsage;
import com.sun.electric.database.id.PrimitivePortId;
import com.sun.electric.database.prototype.NodeProto;
import com.sun.electric.database.text.TextUtils;
import com.sun.electric.database.topology.ArcInst;
import com.sun.electric.database.topology.Connection;
import com.sun.electric.database.topology.NodeInst;
import com.sun.electric.database.topology.PortInst;
import com.sun.electric.database.variable.AbstractTextDescriptor;
import com.sun.electric.database.variable.EditWindow0;
import com.sun.electric.database.variable.TextDescriptor;
import com.sun.electric.database.variable.VarContext;
import com.sun.electric.database.variable.Variable;
import com.sun.electric.technology.ArcProto;
import com.sun.electric.technology.Layer;
import com.sun.electric.technology.PrimitiveNode;
import com.sun.electric.technology.PrimitivePort;
import com.sun.electric.technology.Technology;
import com.sun.electric.technology.technologies.Generic;
import com.sun.electric.technology.technologies.Schematics;
import com.sun.electric.tool.user.User;
import java.awt.Color;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.geom.AffineTransform;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.util.ArrayList;
import java.util.BitSet;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class VectorCache {
    public static boolean DEBUG = false;
    public static final VectorCache theCache = new VectorCache(EDatabase.clientDatabase());
    public final EDatabase database;
    private final ArrayList<VectorCellGroup> cachedCells = new ArrayList();
    private final Map<CellId, List<VectorBase>> addPolyToCell = new HashMap<CellId, List<VectorBase>>();
    private final Map<CellId, List<VectorLine>> addInstToCell = new HashMap<CellId, List<VectorLine>>();
    private final ArrayList<VectorManhattanBuilder> boxBuilders = new ArrayList();
    private final ArrayList<VectorManhattanBuilder> pureBoxBuilders = new ArrayList();
    private VarContext varContext;
    private double curScale;
    private boolean clearFadeImages;
    private boolean clearCache;
    private final Rectangle2D CENTERRECT = new Rectangle2D.Double(0.0, 0.0, 0.0, 0.0);
    private EGraphics instanceGraphics = new EGraphics(false, false, null, 0, 0, 0, 0, 1.0, true, new int[]{0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0});
    private final EditWindow0 dummyWnd = new EditWindow0(){

        public VarContext getVarContext() {
            return VectorCache.this.varContext;
        }

        public double getScale() {
            return VectorCache.this.curScale;
        }

        public double getGlobalTextScale() {
            return User.getGlobalTextScale();
        }
    };
    private static final PrimitivePortId busPinPortId = Schematics.tech().busPinNode.getPort(0).getId();
    public static Comparator<VectorBase> shapeByLayer = new Comparator<VectorBase>(){

        @Override
        public int compare(VectorBase vb1, VectorBase vb2) {
            Layer.Function fun;
            int level1 = 1000;
            int level2 = 1000;
            boolean isContact1 = false;
            boolean isContact2 = false;
            if (vb1.layer != null) {
                fun = vb1.layer.getFunction();
                level1 = fun.getLevel();
                isContact1 = fun.isContact();
            }
            if (vb2.layer != null) {
                fun = vb2.layer.getFunction();
                level2 = fun.getLevel();
                isContact2 = fun.isContact();
            }
            if (isContact1 != isContact2) {
                return isContact1 ? -1 : 1;
            }
            return level1 - level2;
        }
    };

    VectorCellGroup findCellGroup(CellId cellId) {
        int cellIndex = cellId.cellIndex;
        while (cellIndex >= this.cachedCells.size()) {
            this.cachedCells.add(null);
        }
        VectorCellGroup vcg = this.cachedCells.get(cellIndex);
        if (vcg == null) {
            vcg = new VectorCellGroup(cellId);
            this.cachedCells.set(cellIndex, vcg);
        }
        return vcg;
    }

    public VectorCache(EDatabase database) {
        this.database = database;
    }

    VectorCell findVectorCell(CellId cellId, Orientation orient) {
        VectorCellGroup vcg = this.findCellGroup(cellId);
        VectorCell vc = vcg.orientations.get(orient = orient.canonic());
        if (vc == null) {
            vc = new VectorCell(vcg, orient);
            vcg.orientations.put(orient, vc);
        }
        return vc;
    }

    VectorCell drawCell(CellId cellId, Orientation prevTrans, VarContext context, double scale) {
        VectorCell vc = this.findVectorCell(cellId, prevTrans);
        if (vc.vcg.isParameterized || !vc.valid) {
            this.varContext = vc.vcg.isParameterized ? context : null;
            this.curScale = scale;
            vc.init(this.database.getCell(cellId));
        }
        return vc;
    }

    public static VectorBase[] drawNode(NodeInst ni) {
        VectorCache cache = new VectorCache(EDatabase.clientDatabase());
        VectorCell vc = cache.newDummyVectorCell();
        cache.drawNode(ni, GenMath.MATID, vc);
        ArrayList<VectorBase> allShapes = new ArrayList<VectorBase>();
        allShapes.addAll(vc.filledShapes);
        allShapes.addAll(vc.shapes);
        Collections.sort(allShapes, shapeByLayer);
        return allShapes.toArray(new VectorBase[allShapes.size()]);
    }

    public static VectorBase[] drawPolys(Poly[] polys) {
        VectorCache cache = new VectorCache(EDatabase.clientDatabase());
        VectorCell vc = cache.newDummyVectorCell();
        cache.drawPolys(polys, GenMath.MATID, vc, false, 4, false);
        ArrayList<VectorBase> allShapes = new ArrayList<VectorBase>();
        allShapes.addAll(vc.filledShapes);
        allShapes.addAll(vc.shapes);
        Collections.sort(allShapes, shapeByLayer);
        return allShapes.toArray(new VectorBase[allShapes.size()]);
    }

    private VectorCell newDummyVectorCell() {
        return new VectorCell();
    }

    public void addBoxToCell(double lX, double lY, double hX, double hY, Layer layer, CellId cellId) {
        List<VectorBase> addToThisCell = this.addPolyToCell.get(cellId);
        if (addToThisCell == null) {
            addToThisCell = new ArrayList<VectorBase>();
            this.addPolyToCell.put(cellId, addToThisCell);
        }
        EGraphics graphics = null;
        if (layer != null) {
            graphics = layer.getGraphics();
        }
        VectorManhattan vm = new VectorManhattan(lX, lY, hX, hY, layer, graphics, false);
        addToThisCell.add(vm);
    }

    public void addInstanceToCell(double lX, double lY, double hX, double hY, CellId cellId) {
        List<VectorLine> addToThisCell = this.addInstToCell.get(cellId);
        if (addToThisCell == null) {
            addToThisCell = new ArrayList<VectorLine>();
            this.addInstToCell.put(cellId, addToThisCell);
        }
        addToThisCell.add(new VectorLine(lX, lY, hX, lY, 0, null, this.instanceGraphics));
        addToThisCell.add(new VectorLine(hX, lY, hX, hY, 0, null, this.instanceGraphics));
        addToThisCell.add(new VectorLine(hX, hY, lX, hY, 0, null, this.instanceGraphics));
        addToThisCell.add(new VectorLine(lX, hY, lX, lY, 0, null, this.instanceGraphics));
    }

    private static boolean isCellParameterized(CellRevision cellRevision) {
        Variable var;
        Iterator<Variable> vIt;
        if (cellRevision.d.getNumParameters() > 0) {
            return true;
        }
        for (ImmutableNodeInst n : cellRevision.nodes) {
            if (n instanceof ImmutableIconInst) {
                vIt = ((ImmutableIconInst)n).getDefinedParameters();
                while (vIt.hasNext()) {
                    var = vIt.next();
                    if (!var.isCode()) continue;
                    return true;
                }
            }
            vIt = n.getVariables();
            while (vIt.hasNext()) {
                var = vIt.next();
                if (!var.isCode()) continue;
                return true;
            }
        }
        for (ImmutableArcInst a : cellRevision.arcs) {
            vIt = a.getVariables();
            while (vIt.hasNext()) {
                var = vIt.next();
                if (!var.isCode()) continue;
                return true;
            }
        }
        for (ImmutableExport e : cellRevision.exports) {
            if (e.originalPortId != busPinPortId) continue;
            return true;
        }
        return false;
    }

    public Set<CellId> forceRedrawAfterChange(Set<CellId> topCells) {
        BitSet visibleCells = new BitSet();
        for (CellId cellId : topCells) {
            if (this.database.getCell(cellId) == null) continue;
            this.markDown(cellId, visibleCells);
        }
        for (int cellIndex = 0; cellIndex < this.cachedCells.size(); ++cellIndex) {
            if (this.cachedCells.get(cellIndex) == null || visibleCells.get(cellIndex)) continue;
            this.cachedCells.set(cellIndex, null);
        }
        Snapshot snapshot = this.database.backup();
        BitSet changedExports = new BitSet();
        BitSet changedBounds = new BitSet();
        BitSet changedParams = new BitSet();
        HashSet<CellId> changedVisibility = new HashSet<CellId>();
        for (CellId cellId : snapshot.getCellsDownTop()) {
            int cellIndex = cellId.cellIndex;
            if (!visibleCells.get(cellIndex)) continue;
            while (cellIndex >= this.cachedCells.size()) {
                this.cachedCells.add(null);
            }
            VectorCellGroup vcg = this.cachedCells.get(cellIndex);
            boolean changedVis = false;
            if (vcg == null) {
                vcg = new VectorCellGroup(cellId);
                changedExports.set(cellIndex);
                changedBounds.set(cellIndex);
                if (cellId.isIcon()) {
                    changedParams.set(cellIndex);
                }
                changedVis = true;
            } else if (vcg.cellBackup != snapshot.getCell(cellId)) {
                if (vcg.changedExports()) {
                    changedExports.set(cellIndex);
                }
                if (vcg.updateBounds(snapshot)) {
                    changedBounds.set(cellIndex);
                }
                if (cellId.isIcon()) {
                    changedParams.set(cellIndex);
                }
                vcg.init();
                changedVis = true;
            } else {
                CellRevision cellRevision = snapshot.getCell((CellId)cellId).cellRevision;
                int[] instCounts = cellRevision.getInstCounts();
                boolean subExportsChanged = false;
                boolean subParamsChanged = false;
                for (int i = 0; i < instCounts.length; ++i) {
                    if (instCounts[i] == 0) continue;
                    int subCellIndex = cellId.getUsageIn((int)i).protoId.cellIndex;
                    if (changedExports.get(subCellIndex)) {
                        subExportsChanged = true;
                    }
                    if (!changedParams.get(subCellIndex)) continue;
                    subParamsChanged = true;
                }
                if (vcg.updateBounds(snapshot)) {
                    changedBounds.set(cellIndex);
                    changedVis = true;
                }
                if (subExportsChanged && vcg.changedExports()) {
                    changedExports.set(cellIndex);
                    vcg.updateExports();
                    changedVis = true;
                }
                if (subParamsChanged) {
                    vcg.clear();
                }
                if (!changedVis) {
                    Cell cell = this.database.getCell(cellId);
                    for (ImmutableNodeInst n : cellRevision.nodes) {
                        if (!(n.protoId instanceof CellId)) continue;
                        CellId subCellId = (CellId)n.protoId;
                        int subCellIndex = subCellId.cellIndex;
                        if (cell.isExpanded(n.nodeId)) {
                            if (!changedVisibility.contains(subCellId)) continue;
                            changedVis = true;
                            break;
                        }
                        if (!changedBounds.get(subCellIndex) && !changedExports.get(subCellIndex)) continue;
                        changedVis = true;
                        break;
                    }
                }
            }
            if (!changedVis) continue;
            changedVisibility.add(cellId);
        }
        return changedVisibility;
    }

    private void markDown(CellId cellId, BitSet visibleCells) {
        if (visibleCells.get(cellId.cellIndex)) {
            return;
        }
        visibleCells.set(cellId.cellIndex);
        Cell cell = this.database.getCell(cellId);
        Iterator<CellUsage> it = cell.getUsagesIn();
        while (it.hasNext()) {
            CellUsage cu = it.next();
            this.markDown(cu.protoId, visibleCells);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void forceRedraw() {
        boolean clearFadeImages;
        boolean clearCache;
        VectorCache vectorCache = this;
        synchronized (vectorCache) {
            clearCache = this.clearCache;
            this.clearCache = false;
            clearFadeImages = this.clearFadeImages;
            this.clearFadeImages = false;
        }
        Snapshot snapshot = this.database.backup();
        int size = this.cachedCells.size();
        for (int cellIndex = 0; cellIndex < size; ++cellIndex) {
            VectorCellGroup vcg = this.cachedCells.get(cellIndex);
            if (vcg == null) continue;
            if (clearCache) {
                vcg.clear();
            }
            if (clearFadeImages) {
                for (VectorCell vc : vcg.orientations.values()) {
                    vc.fadeImageColors = null;
                    vc.fadeImage = false;
                }
            }
            assert (vcg.bounds == snapshot.getCellBounds(cellIndex));
        }
    }

    public synchronized void clearCache() {
        this.clearCache = true;
    }

    public synchronized void clearFadeImages() {
        this.clearFadeImages = true;
    }

    private static int databaseToGrid(double lambdaValue) {
        return (int)DBMath.lambdaToGrid(lambdaValue);
    }

    private void addBoxesFromBuilder(VectorCell vc, Technology tech, ArrayList<VectorManhattanBuilder> boxBuilders, boolean pureArray) {
        for (int layerIndex = 0; layerIndex < boxBuilders.size(); ++layerIndex) {
            VectorManhattanBuilder b = boxBuilders.get(layerIndex);
            if (b.size == 0) continue;
            Layer layer = tech.getLayer(layerIndex);
            VectorManhattan vm = new VectorManhattan(b.toArray(), layer, layer.getGraphics(), pureArray);
            vc.filledShapes.add(vm);
        }
    }

    private void drawNode(NodeInst ni, AffineTransform trans, VectorCell vc) {
        NodeProto np = ni.getProto();
        AffineTransform localTrans = ni.rotateOut(trans);
        if (ni.isCellInstance()) {
            Export e;
            PortInst pi;
            Point2D.Double ctrShift = new Point2D.Double(ni.getAnchorCenterX(), ni.getAnchorCenterY());
            localTrans.transform(ctrShift, ctrShift);
            VectorSubCell vsc = new VectorSubCell(ni, ctrShift);
            vc.subCells.add(vsc);
            Iterator<Object> it = ni.getConnections();
            while (it.hasNext()) {
                Connection con = it.next();
                pi = con.getPortInst();
                e = (Export)pi.getPortProto();
                if (e.isAlwaysDrawn()) continue;
                vsc.shownPorts.set(e.getId().getChronIndex());
            }
            it = ni.getExports();
            while (it.hasNext()) {
                Export exp = (Export)it.next();
                pi = exp.getOriginalPort();
                e = (Export)pi.getPortProto();
                if (e.isAlwaysDrawn()) continue;
                vsc.shownPorts.set(e.getId().getChronIndex());
            }
            Poly[] polys = ni.getDisplayableVariables(this.dummyWnd);
            this.drawPolys(polys, localTrans, vc, false, 3, false);
        } else {
            PrimitiveNode prim = (PrimitiveNode)np;
            int textType = 3;
            if (prim == Generic.tech().invisiblePinNode) {
                textType = 5;
            }
            Technology tech = prim.getTechnology();
            boolean hideOnLowLevel = ni.isVisInside() || np == Generic.tech().cellCenterNode;
            boolean pureLayer = ni.getFunction() == PrimitiveNode.Function.NODE;
            this.drawPolys(tech.getShapeOfNode(ni, false, false, null), localTrans, vc, hideOnLowLevel, textType, pureLayer);
            this.drawPolys(ni.getDisplayableVariables(this.dummyWnd), localTrans, vc, hideOnLowLevel, textType, pureLayer);
        }
    }

    private void drawArc(ArcInst ai, AffineTransform trans, VectorCell vc) {
        ArcProto ap = ai.getProto();
        Technology tech = ap.getTechnology();
        boolean pureLayer = ap.getNumArcLayers() == 1;
        this.drawPolys(tech.getShapeOfArc(ai), trans, vc, false, 4, pureLayer);
        this.drawPolys(ai.getDisplayableVariables(this.dummyWnd), trans, vc, false, 4, false);
    }

    private void drawPolys(Poly[] polys, AffineTransform trans, VectorCell vc, boolean hideOnLowLevel, int textType, boolean pureLayer) {
        if (polys == null) {
            return;
        }
        for (int i = 0; i < polys.length; ++i) {
            Poly poly = polys[i];
            if (poly == null) continue;
            poly.transform(trans);
            this.renderPoly(poly, vc, hideOnLowLevel, textType, pureLayer);
        }
    }

    private void renderPoly(Poly poly, VectorCell vc, boolean hideOnLowLevel, int textType, boolean pureLayer) {
        ArrayList<VectorBase> shapes;
        Point2D[] points = poly.getPoints();
        Layer layer = poly.getLayer();
        EGraphics graphics = null;
        if (layer != null) {
            graphics = layer.getGraphics();
        }
        Poly.Type style = poly.getStyle();
        ArrayList<VectorBase> filledShapes = hideOnLowLevel ? vc.topOnlyShapes : vc.filledShapes;
        ArrayList<VectorBase> arrayList = shapes = hideOnLowLevel ? vc.topOnlyShapes : vc.shapes;
        if (style == Poly.Type.FILLED) {
            Rectangle2D bounds = poly.getBox();
            if (bounds != null) {
                Layer.Function fun;
                Technology tech;
                double lX = bounds.getMinX();
                double hX = bounds.getMaxX();
                double lY = bounds.getMinY();
                double hY = bounds.getMaxY();
                float minSize = (float)Math.min(hX - lX, hY - lY);
                int layerIndex = -1;
                if (layer != null && (tech = layer.getTechnology()) != null && vc.vcg != null && tech.getTechName().equals(vc.vcg.cellBackup.cellRevision.d.techId.techName)) {
                    layerIndex = layer.getIndex();
                }
                if (layerIndex >= 0) {
                    VectorCache.putBox(layerIndex, pureLayer ? this.pureBoxBuilders : this.boxBuilders, lX, lY, hX, hY);
                } else {
                    VectorManhattan vm = new VectorManhattan(lX, lY, hX, hY, layer, graphics, pureLayer);
                    filledShapes.add(vm);
                }
                if (layer != null && (fun = layer.getFunction()).isSubstrate()) {
                    minSize = 0.0f;
                }
                vc.maxFeatureSize = Math.max(vc.maxFeatureSize, minSize);
                return;
            }
            VectorPolygon vp = new VectorPolygon(points, layer, graphics);
            filledShapes.add(vp);
            return;
        }
        if (style == Poly.Type.CROSSED) {
            VectorLine vl1 = new VectorLine(points[0].getX(), points[0].getY(), points[1].getX(), points[1].getY(), 0, layer, graphics);
            VectorLine vl2 = new VectorLine(points[1].getX(), points[1].getY(), points[2].getX(), points[2].getY(), 0, layer, graphics);
            VectorLine vl3 = new VectorLine(points[2].getX(), points[2].getY(), points[3].getX(), points[3].getY(), 0, layer, graphics);
            VectorLine vl4 = new VectorLine(points[3].getX(), points[3].getY(), points[0].getX(), points[0].getY(), 0, layer, graphics);
            VectorLine vl5 = new VectorLine(points[0].getX(), points[0].getY(), points[2].getX(), points[2].getY(), 0, layer, graphics);
            VectorLine vl6 = new VectorLine(points[1].getX(), points[1].getY(), points[3].getX(), points[3].getY(), 0, layer, graphics);
            shapes.add(vl1);
            shapes.add(vl2);
            shapes.add(vl3);
            shapes.add(vl4);
            shapes.add(vl5);
            shapes.add(vl6);
            return;
        }
        if (style.isText()) {
            Rectangle2D bounds = poly.getBounds2D();
            TextDescriptor descript = poly.getTextDescriptor();
            String str = poly.getString();
            VectorText vt = new VectorText(bounds, style, descript, str, textType, null, layer, graphics);
            shapes.add(vt);
            vc.maxFeatureSize = Math.max(vc.maxFeatureSize, vt.height);
            return;
        }
        if (style == Poly.Type.CLOSED || style == Poly.Type.OPENED || style == Poly.Type.OPENEDT1 || style == Poly.Type.OPENEDT2 || style == Poly.Type.OPENEDT3) {
            int lineType = 0;
            if (style == Poly.Type.OPENEDT1) {
                lineType = 1;
            } else if (style == Poly.Type.OPENEDT2) {
                lineType = 2;
            } else if (style == Poly.Type.OPENEDT3) {
                lineType = 3;
            }
            for (int j = 1; j < points.length; ++j) {
                Point2D oldPt = points[j - 1];
                Point2D newPt = points[j];
                VectorLine vl = new VectorLine(oldPt.getX(), oldPt.getY(), newPt.getX(), newPt.getY(), lineType, layer, graphics);
                shapes.add(vl);
            }
            if (style == Poly.Type.CLOSED) {
                Point2D oldPt = points[points.length - 1];
                Point2D newPt = points[0];
                VectorLine vl = new VectorLine(oldPt.getX(), oldPt.getY(), newPt.getX(), newPt.getY(), lineType, layer, graphics);
                shapes.add(vl);
            }
            return;
        }
        if (style == Poly.Type.VECTORS) {
            for (int j = 0; j < points.length; j += 2) {
                Point2D oldPt = points[j];
                Point2D newPt = points[j + 1];
                VectorLine vl = new VectorLine(oldPt.getX(), oldPt.getY(), newPt.getX(), newPt.getY(), 0, layer, graphics);
                shapes.add(vl);
            }
            return;
        }
        if (style == Poly.Type.CIRCLE) {
            VectorCircle vci = new VectorCircle(points[0].getX(), points[0].getY(), points[1].getX(), points[1].getY(), 0, layer, graphics);
            shapes.add(vci);
            return;
        }
        if (style == Poly.Type.THICKCIRCLE) {
            VectorCircle vci = new VectorCircle(points[0].getX(), points[0].getY(), points[1].getX(), points[1].getY(), 1, layer, graphics);
            shapes.add(vci);
            return;
        }
        if (style == Poly.Type.DISC) {
            VectorCircle vci = new VectorCircle(points[0].getX(), points[0].getY(), points[1].getX(), points[1].getY(), 2, layer, graphics);
            filledShapes.add(vci);
            return;
        }
        if (style == Poly.Type.CIRCLEARC || style == Poly.Type.THICKCIRCLEARC) {
            VectorCircleArc vca = new VectorCircleArc(points[0].getX(), points[0].getY(), points[1].getX(), points[1].getY(), points[2].getX(), points[2].getY(), style == Poly.Type.THICKCIRCLEARC, layer, graphics);
            shapes.add(vca);
            return;
        }
        if (style == Poly.Type.CROSS) {
            VectorCross vcr = new VectorCross(points[0].getX(), points[0].getY(), true, layer, graphics);
            shapes.add(vcr);
            return;
        }
        if (style == Poly.Type.BIGCROSS) {
            VectorCross vcr = new VectorCross(points[0].getX(), points[0].getY(), false, layer, graphics);
            shapes.add(vcr);
            return;
        }
    }

    private static void putBox(int layerIndex, ArrayList<VectorManhattanBuilder> boxBuilders, double lX, double lY, double hX, double hY) {
        while (layerIndex >= boxBuilders.size()) {
            boxBuilders.add(new VectorManhattanBuilder());
        }
        VectorManhattanBuilder b = boxBuilders.get(layerIndex);
        b.add(lX, lY, hX, hY);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    class VectorCell {
        final VectorCellGroup vcg;
        final Orientation orient;
        int[] outlinePoints = new int[8];
        int lX;
        int lY;
        int hX;
        int hY;
        int[] portCenters;
        boolean valid;
        ArrayList<VectorBase> filledShapes = new ArrayList();
        ArrayList<VectorBase> shapes = new ArrayList();
        private ArrayList<VectorBase> topOnlyShapes;
        ArrayList<VectorSubCell> subCells = new ArrayList();
        boolean hasFadeColor;
        int fadeColor;
        float maxFeatureSize;
        boolean fadeImage;
        int fadeOffsetX;
        int fadeOffsetY;
        int[] fadeImageColors;
        int fadeImageWid;
        int fadeImageHei;

        VectorCell(VectorCellGroup vcg, Orientation orient) {
            this.vcg = vcg;
            this.orient = orient;
            this.updateBounds();
        }

        private VectorCell() {
            this.vcg = null;
            this.orient = null;
        }

        private void init(Cell cell) {
            List addTheseInsts;
            long startTime = DEBUG ? System.currentTimeMillis() : 0L;
            this.vcg.init();
            this.updateBounds();
            this.clear();
            this.maxFeatureSize = 0.0f;
            AffineTransform trans = this.orient.pureRotate();
            this.vcg.updateExports();
            for (VectorManhattanBuilder b : VectorCache.this.boxBuilders) {
                b.clear();
            }
            for (VectorManhattanBuilder b : VectorCache.this.pureBoxBuilders) {
                b.clear();
            }
            Iterator<ArcInst> arcs = cell.getArcs();
            while (arcs.hasNext()) {
                ArcInst ai = arcs.next();
                VectorCache.this.drawArc(ai, trans, this);
            }
            Iterator<NodeInst> nodes = cell.getNodes();
            while (nodes.hasNext()) {
                NodeInst ni = nodes.next();
                boolean hideOnLowLevel = false;
                if (!ni.isCellInstance()) {
                    boolean bl = hideOnLowLevel = ni.isVisInside() || ni.getProto() == Generic.tech().cellCenterNode;
                }
                if (hideOnLowLevel) continue;
                VectorCache.this.drawNode(ni, trans, this);
            }
            CellId cellId = cell.getId();
            List addThesePolys = (List)VectorCache.this.addPolyToCell.get(cellId);
            if (addThesePolys != null) {
                for (VectorBase vb : addThesePolys) {
                    this.filledShapes.add(vb);
                }
            }
            if ((addTheseInsts = (List)VectorCache.this.addInstToCell.get(cellId)) != null) {
                for (VectorLine vl : addTheseInsts) {
                    this.shapes.add(vl);
                }
            }
            VectorCache.this.addBoxesFromBuilder(this, cell.getTechnology(), VectorCache.this.boxBuilders, false);
            VectorCache.this.addBoxesFromBuilder(this, cell.getTechnology(), VectorCache.this.pureBoxBuilders, true);
            Collections.sort(this.filledShapes, shapeByLayer);
            Collections.sort(this.shapes, shapeByLayer);
            if (cell.isIcon()) {
                this.maxFeatureSize = 0.0f;
            }
            this.valid = true;
            if (DEBUG) {
                long stopTime = System.currentTimeMillis();
                System.out.println(stopTime - startTime + " init " + this.vcg.cellId + " " + this.orient);
            }
        }

        private void updateBounds() {
            this.lY = Integer.MAX_VALUE;
            this.lX = Integer.MAX_VALUE;
            this.hY = Integer.MIN_VALUE;
            this.hX = Integer.MIN_VALUE;
            ERectangle bounds = this.vcg.bounds;
            if (bounds == null) {
                return;
            }
            double[] points = new double[8];
            points[0] = points[6] = bounds.getMinX();
            points[1] = points[3] = bounds.getMinY();
            points[2] = points[4] = bounds.getMaxX();
            points[5] = points[7] = bounds.getMaxY();
            this.orient.pureRotate().transform(points, 0, points, 0, 4);
            for (int i = 0; i < 4; ++i) {
                int x = VectorCache.databaseToGrid(points[i * 2]);
                int y = VectorCache.databaseToGrid(points[i * 2 + 1]);
                this.lX = Math.min(this.lX, x);
                this.lY = Math.min(this.lY, y);
                this.hX = Math.max(this.hX, x);
                this.hY = Math.max(this.hY, y);
                this.outlinePoints[i * 2] = x;
                this.outlinePoints[i * 2 + 1] = y;
            }
        }

        private void clear() {
            this.clearExports();
            this.fadeImage = false;
            this.hasFadeColor = false;
            this.valid = false;
            this.filledShapes.clear();
            this.shapes.clear();
            this.subCells.clear();
            this.fadeImageColors = null;
        }

        private void clearExports() {
            this.portCenters = null;
            this.topOnlyShapes = null;
        }

        int[] getPortCenters() {
            if (this.portCenters == null) {
                this.initPortCenters();
            }
            return this.portCenters;
        }

        private void initPortCenters() {
            List<VectorCellExport> portShapes = this.vcg.getPortShapes();
            this.portCenters = new int[portShapes.size() * 2];
            AffineTransform trans = this.orient.pureRotate();
            Point2D.Double tmpPt = new Point2D.Double();
            int numPorts = portShapes.size();
            for (int i = 0; i < numPorts; ++i) {
                VectorCellExport vce = portShapes.get(i);
                trans.transform(vce.exportCtr, tmpPt);
                this.portCenters[i * 2] = VectorCache.databaseToGrid(tmpPt.getX());
                this.portCenters[i * 2 + 1] = VectorCache.databaseToGrid(tmpPt.getY());
            }
        }

        ArrayList<VectorBase> getTopOnlyShapes() {
            if (this.topOnlyShapes == null) {
                this.initTopOnlyShapes();
            }
            return this.topOnlyShapes;
        }

        private void initTopOnlyShapes() {
            Cell cell = VectorCache.this.database.getCell(this.vcg.cellId);
            this.topOnlyShapes = new ArrayList();
            Poly[] polys = cell.getDisplayableVariables(VectorCache.this.CENTERRECT, VectorCache.this.dummyWnd, true);
            VectorCache.this.drawPolys(polys, DBMath.MATID, this, true, 1, false);
            AffineTransform trans = this.orient.pureRotate();
            Iterator<NodeInst> nodes = cell.getNodes();
            while (nodes.hasNext()) {
                boolean hideOnLowLevel;
                NodeInst ni = nodes.next();
                if (ni.isCellInstance() || !(hideOnLowLevel = ni.isVisInside() || ni.getProto() == Generic.tech().cellCenterNode)) continue;
                VectorCache.this.drawNode(ni, trans, this);
            }
            Iterator<Export> it = cell.getExports();
            while (it.hasNext()) {
                Export e = it.next();
                Poly poly = e.getNamePoly();
                Rectangle2D rect = (Rectangle2D)poly.getBounds2D().clone();
                TextDescriptor descript = poly.getTextDescriptor();
                Poly.Type style = descript.getPos().getPolyType();
                style = Poly.rotateType(style, e.getOriginalPort().getNodeInst());
                VectorText vt = new VectorText(poly.getBounds2D(), style, descript, e.getName(), 2, e, null, null);
                this.topOnlyShapes.add(vt);
                polys = e.getDisplayableVariables(rect, VectorCache.this.dummyWnd, true);
                VectorCache.this.drawPolys(polys, trans, this, true, 2, false);
            }
            Collections.sort(this.topOnlyShapes, shapeByLayer);
        }
    }

    static class VectorCellExport {
        String exportName;
        Point2D exportCtr;
        private ImmutableExport e;
        Poly.Type style;
        TextDescriptor descript;
        float height;
        private Color portColor;

        VectorCellExport(Export e) {
            this.e = e.getD();
            this.exportName = e.getName();
            this.descript = this.e.nameDescriptor;
            Poly portPoly = e.getNamePoly();
            assert (portPoly.getPoints().length == 1);
            this.exportCtr = portPoly.getPoints()[0];
            this.style = Poly.Type.TEXTCENT;
            this.height = 1.0f;
            if (this.descript != null) {
                this.style = this.descript.getPos().getPolyType();
                AbstractTextDescriptor.Size tds = this.descript.getSize();
                if (!tds.isAbsolute()) {
                    this.height = (float)tds.getSize();
                }
            }
            this.e = e.getD();
            this.portColor = e.getBasePort().getPortColor();
        }

        int getChronIndex() {
            return this.e.exportId.chronIndex;
        }

        String getName(boolean shortName) {
            String name = this.e.name.toString();
            if (shortName) {
                int len = name.length();
                for (int i = 0; i < len; ++i) {
                    char ch = name.charAt(i);
                    if (TextUtils.isLetterOrDigit(ch)) continue;
                    return name.substring(0, i);
                }
            }
            return name;
        }

        Color getPortColor() {
            return this.portColor;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    class VectorCellGroup {
        CellId cellId;
        ERectangle bounds;
        float cellArea;
        float cellMinSize;
        CellBackup cellBackup;
        boolean isParameterized;
        Map<Orientation, VectorCell> orientations = new HashMap<Orientation, VectorCell>();
        List<VectorCellExport> exports;

        VectorCellGroup(CellId cellId) {
            this.cellId = cellId;
            this.init();
            this.updateExports();
        }

        private void init() {
            this.updateBounds(VectorCache.this.database.backup());
            CellBackup cellBackup = VectorCache.this.database.backup().getCell(this.cellId);
            if (this.cellBackup == cellBackup) {
                return;
            }
            this.cellBackup = cellBackup;
            this.clear();
            this.isParameterized = VectorCache.isCellParameterized(cellBackup.cellRevision);
        }

        private boolean updateBounds(Snapshot snapshot) {
            ERectangle newBounds = snapshot.getCellBounds(this.cellId);
            if (newBounds == this.bounds) {
                return false;
            }
            this.bounds = newBounds;
            if (this.bounds != null) {
                this.cellArea = (float)(this.bounds.getWidth() * this.bounds.getHeight());
                this.cellMinSize = (float)Math.min(this.bounds.getWidth(), this.bounds.getHeight());
            } else {
                this.cellArea = 0.0f;
                this.cellMinSize = 0.0f;
            }
            for (VectorCell vc : this.orientations.values()) {
                vc.updateBounds();
            }
            return true;
        }

        private boolean changedExports() {
            Cell cell = VectorCache.this.database.getCell(this.cellId);
            if (cell == null) {
                return this.exports != null;
            }
            if (this.exports == null) {
                return true;
            }
            Iterator<VectorCellExport> cIt = this.exports.iterator();
            Iterator<Export> it = cell.getExports();
            while (it.hasNext()) {
                Export e = it.next();
                if (!cIt.hasNext()) {
                    return true;
                }
                VectorCellExport vce = cIt.next();
                if (!vce.exportName.equals(e.getName())) {
                    return true;
                }
                Poly poly = e.getOriginalPort().getPoly();
                if (vce.exportCtr.getX() == poly.getCenterX() && vce.exportCtr.getY() == poly.getCenterY()) continue;
                return true;
            }
            return cIt.hasNext();
        }

        private void updateExports() {
            for (VectorCell vc : this.orientations.values()) {
                vc.clearExports();
            }
            Cell cell = VectorCache.this.database.getCell(this.cellId);
            if (DEBUG) {
                System.out.println("updateExports " + this.cellId);
            }
            if (cell == null) {
                this.exports = null;
                return;
            }
            this.exports = new ArrayList<VectorCellExport>();
            Iterator<Export> it = cell.getExports();
            while (it.hasNext()) {
                Export e = it.next();
                VectorCellExport vce = new VectorCellExport(e);
                this.exports.add(vce);
            }
        }

        List<VectorCellExport> getPortShapes() {
            if (this.exports == null) {
                this.updateExports();
            }
            return this.exports;
        }

        void clear() {
            for (VectorCell vc : this.orientations.values()) {
                vc.clear();
            }
            if (this.exports != null) {
                this.exports = null;
            }
            if (DEBUG) {
                System.out.println("clear " + this.cellId);
            }
        }

        VectorCell getAnyCell() {
            for (VectorCell vc : this.orientations.values()) {
                if (!vc.valid) continue;
                return vc;
            }
            return null;
        }
    }

    static class VectorSubCell {
        ImmutableNodeInst n;
        CellId subCellId;
        int offsetX;
        int offsetY;
        BitSet shownPorts = new BitSet();

        VectorSubCell(NodeInst ni, Point2D offset) {
            this.n = ni.getD();
            Cell subCell = (Cell)ni.getProto();
            this.subCellId = subCell.getId();
            this.offsetX = VectorCache.databaseToGrid(offset.getX());
            this.offsetY = VectorCache.databaseToGrid(offset.getY());
        }
    }

    static class VectorCross
    extends VectorBase {
        int x;
        int y;
        boolean small;

        VectorCross(double x, double y, boolean small, Layer layer, EGraphics graphics) {
            super(layer, graphics);
            this.x = VectorCache.databaseToGrid(x);
            this.y = VectorCache.databaseToGrid(y);
            this.small = small;
        }
    }

    static class VectorText
    extends VectorBase {
        static final int TEXTTYPECELL = 1;
        static final int TEXTTYPEEXPORT = 2;
        static final int TEXTTYPENODE = 3;
        static final int TEXTTYPEARC = 4;
        static final int TEXTTYPEANNOTATION = 5;
        static final int TEXTTYPEINSTANCE = 6;
        Rectangle bounds;
        Poly.Type style;
        TextDescriptor descript;
        String str;
        float height;
        int textType;
        PrimitivePort basePort;

        VectorText(Rectangle2D bounds, Poly.Type style, TextDescriptor descript, String str, int textType, Export e, Layer layer, EGraphics graphics) {
            super(layer, graphics);
            AbstractTextDescriptor.Size tds;
            this.bounds = new Rectangle(VectorCache.databaseToGrid(bounds.getX()), VectorCache.databaseToGrid(bounds.getY()), VectorCache.databaseToGrid(bounds.getWidth()), VectorCache.databaseToGrid(bounds.getHeight()));
            this.style = style;
            this.descript = descript;
            this.str = str;
            this.textType = textType;
            if (e != null) {
                this.basePort = e.getBasePort();
            }
            this.height = 1.0f;
            if (descript != null && !(tds = descript.getSize()).isAbsolute()) {
                this.height = (float)tds.getSize();
            }
        }
    }

    static class VectorCircleArc
    extends VectorBase {
        int cX;
        int cY;
        int eX1;
        int eY1;
        int eX2;
        int eY2;
        boolean thick;

        VectorCircleArc(double cX, double cY, double eX1, double eY1, double eX2, double eY2, boolean thick, Layer layer, EGraphics graphics) {
            super(layer, graphics);
            this.cX = VectorCache.databaseToGrid(cX);
            this.cY = VectorCache.databaseToGrid(cY);
            this.eX1 = VectorCache.databaseToGrid(eX1);
            this.eY1 = VectorCache.databaseToGrid(eY1);
            this.eX2 = VectorCache.databaseToGrid(eX2);
            this.eY2 = VectorCache.databaseToGrid(eY2);
            this.thick = thick;
        }
    }

    static class VectorCircle
    extends VectorBase {
        int cX;
        int cY;
        int eX;
        int eY;
        int nature;

        VectorCircle(double cX, double cY, double eX, double eY, int nature, Layer layer, EGraphics graphics) {
            super(layer, graphics);
            this.cX = VectorCache.databaseToGrid(cX);
            this.cY = VectorCache.databaseToGrid(cY);
            this.eX = VectorCache.databaseToGrid(eX);
            this.eY = VectorCache.databaseToGrid(eY);
            this.nature = nature;
        }

        boolean isFilled() {
            return this.nature == 2;
        }
    }

    static class VectorLine
    extends VectorBase {
        int fX;
        int fY;
        int tX;
        int tY;
        int texture;

        VectorLine(double fX, double fY, double tX, double tY, int texture, Layer layer, EGraphics graphics) {
            super(layer, graphics);
            this.fX = VectorCache.databaseToGrid(fX);
            this.fY = VectorCache.databaseToGrid(fY);
            this.tX = VectorCache.databaseToGrid(tX);
            this.tY = VectorCache.databaseToGrid(tY);
            this.texture = texture;
        }
    }

    static class VectorPolygon
    extends VectorBase {
        Point[] points;

        VectorPolygon(Point2D[] points, Layer layer, EGraphics graphics) {
            super(layer, graphics);
            this.points = new Point[points.length];
            for (int i = 0; i < points.length; ++i) {
                Point2D p = points[i];
                this.points[i] = new Point(VectorCache.databaseToGrid(p.getX()), VectorCache.databaseToGrid(p.getY()));
            }
        }

        boolean isFilled() {
            return true;
        }
    }

    static class VectorManhattanBuilder {
        int size;
        int[] coords = new int[4];

        VectorManhattanBuilder() {
        }

        private void add(double lX, double lY, double hX, double hY) {
            if (this.size * 4 >= this.coords.length) {
                int[] newCoords = new int[this.coords.length * 2];
                System.arraycopy(this.coords, 0, newCoords, 0, this.coords.length);
                this.coords = newCoords;
            }
            int i = this.size * 4;
            this.coords[i] = VectorCache.databaseToGrid(lX);
            this.coords[i + 1] = VectorCache.databaseToGrid(lY);
            this.coords[i + 2] = VectorCache.databaseToGrid(hX);
            this.coords[i + 3] = VectorCache.databaseToGrid(hY);
            ++this.size;
        }

        int[] toArray() {
            int[] a = new int[this.size * 4];
            System.arraycopy(this.coords, 0, a, 0, a.length);
            return a;
        }

        private void clear() {
            this.size = 0;
        }
    }

    static class VectorManhattan
    extends VectorBase {
        int[] coords;
        boolean pureLayer;

        VectorManhattan(int[] coords, Layer layer, EGraphics graphics, boolean pureLayer) {
            super(layer, graphics);
            this.coords = coords;
            this.pureLayer = pureLayer;
        }

        VectorManhattan(double c1X, double c1Y, double c2X, double c2Y, Layer layer, EGraphics graphics, boolean pureLayer) {
            this(new int[]{VectorCache.databaseToGrid(c1X), VectorCache.databaseToGrid(c1Y), VectorCache.databaseToGrid(c2X), VectorCache.databaseToGrid(c2Y)}, layer, graphics, pureLayer);
        }

        boolean isFilled() {
            return true;
        }
    }

    public static abstract class VectorBase {
        Layer layer;
        EGraphics graphics;

        VectorBase(Layer layer, EGraphics graphics) {
            this.layer = layer;
            this.graphics = graphics;
        }

        boolean isFilled() {
            return false;
        }
    }
}

