/*
 * Decompiled with CFR 0.152.
 */
package com.sun.electric.tool.ncc.trees;

import com.sun.electric.tool.generator.layout.LayoutLib;
import com.sun.electric.tool.ncc.NccGlobals;
import com.sun.electric.tool.ncc.lists.LeafList;
import com.sun.electric.tool.ncc.strategy.Strategy;
import com.sun.electric.tool.ncc.trees.EquivRecord;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.ListIterator;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class LeafEquivRecords {
    private static final LeafList EMPTY_LIST = new LeafList();
    private NccGlobals globals;
    private List<EquivRecord> matched = new ArrayList<EquivRecord>();
    private LinkedList<EquivRecord> notMatched = new LinkedList();

    private void processInternalEquivRecords() {
        ArrayList<EquivRecord> newMatched = new ArrayList<EquivRecord>();
        ArrayList<EquivRecord> newNotMatched = new ArrayList<EquivRecord>();
        ListIterator it = this.notMatched.listIterator();
        while (it.hasNext()) {
            EquivRecord er = (EquivRecord)it.next();
            if (er.isLeaf()) {
                LayoutLib.error(er.isMatched(), "notMatched list has matched");
                continue;
            }
            it.remove();
            new FindLeaves(newMatched, newNotMatched, er, this.globals);
        }
        this.matched.addAll(newMatched);
        this.notMatched.addAll(newNotMatched);
    }

    public LeafEquivRecords(EquivRecord root, NccGlobals globals) {
        this.globals = globals;
        if (root == null) {
            return;
        }
        if (root.isLeaf() && root.isMatched()) {
            this.matched.add(root);
        } else {
            this.notMatched.add(root);
        }
    }

    public Iterator<EquivRecord> getNotMatched() {
        this.processInternalEquivRecords();
        return Collections.unmodifiableList(this.notMatched).iterator();
    }

    public int numNotMatched() {
        this.processInternalEquivRecords();
        return this.notMatched.size();
    }

    public Iterator<EquivRecord> getMatched() {
        this.processInternalEquivRecords();
        return Collections.unmodifiableList(this.matched).iterator();
    }

    public int numMatched() {
        this.processInternalEquivRecords();
        return this.matched.size();
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class FindLeaves
    extends Strategy {
        private List<EquivRecord> matched;
        private List<EquivRecord> notMatched;

        @Override
        public LeafList doFor(EquivRecord j) {
            if (j.isLeaf()) {
                EquivRecord er = j;
                if (er.isMatched()) {
                    this.matched.add(er);
                } else {
                    this.notMatched.add(er);
                }
            } else {
                super.doFor(j);
            }
            return EMPTY_LIST;
        }

        public FindLeaves(List<EquivRecord> newMatched, List<EquivRecord> newNotMatched, EquivRecord er, NccGlobals globals) {
            super(globals);
            this.matched = newMatched;
            this.notMatched = newNotMatched;
            this.doFor(er);
        }
    }
}

