/*
 * Decompiled with CFR 0.152.
 */
package com.sun.electric.tool.user.ui;

import com.sun.electric.technology.ArcProto;
import com.sun.electric.technology.Layer;
import com.sun.electric.technology.PrimitiveNode;
import com.sun.electric.technology.Technology;
import com.sun.electric.technology.technologies.Generic;
import com.sun.electric.tool.user.User;
import com.sun.electric.tool.user.ui.EditWindow;
import com.sun.electric.tool.user.ui.PixelDrawing;
import com.sun.electric.tool.user.ui.VectorDrawing;
import com.sun.electric.tool.user.ui.WindowFrame;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import javax.swing.DefaultListModel;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.border.TitledBorder;

public class LayerTab
extends JPanel {
    private JList layerList;
    private DefaultListModel layerListModel;
    private HashMap highlighted;
    private List layersInList;
    private boolean loading;
    private static HashMap visibility;
    private JCheckBox annotationText;
    private JCheckBox arcText;
    private JCheckBox cellText;
    private JCheckBox exportText;
    private JCheckBox instanceNames;
    private JPanel jPanel1;
    private JPanel jPanel2;
    private JScrollPane layerPane;
    private JButton makeInvisible;
    private JButton makeVisible;
    private JCheckBox nodeText;
    private JCheckBox portText;
    private JButton selectAll;
    private JComboBox technology;
    private JButton toggleHighlight;
    private JButton unhighlightAll;

    public LayerTab(WindowFrame wf) {
        this.initComponents();
        this.layerListModel = new DefaultListModel();
        this.layerList = new JList(this.layerListModel);
        this.layerList.setSelectionMode(2);
        this.layerPane.setViewportView(this.layerList);
        this.layerList.addMouseListener(new MouseAdapter(){

            public void mouseClicked(MouseEvent e) {
                LayerTab.this.apply(e);
            }
        });
        this.nodeText.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                LayerTab.this.update();
            }
        });
        this.arcText.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                LayerTab.this.update();
            }
        });
        this.portText.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                LayerTab.this.update();
            }
        });
        this.exportText.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                LayerTab.this.update();
            }
        });
        this.annotationText.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                LayerTab.this.update();
            }
        });
        this.instanceNames.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                LayerTab.this.update();
            }
        });
        this.cellText.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                LayerTab.this.update();
            }
        });
        this.technology.setLightWeightPopupEnabled(false);
        this.loadTechnologies(true);
        this.updateLayersTab();
        this.technology.addActionListener(new WindowFrame.CurTechControlListener(wf));
    }

    public void loadTechnologies(boolean makeCurrent) {
        Technology tech;
        Technology cur = Technology.getCurrent();
        if (!makeCurrent) {
            cur = Technology.findTechnology((String)this.technology.getSelectedItem());
        }
        this.loading = true;
        this.technology.removeAllItems();
        Iterator it = Technology.getTechnologies();
        while (it.hasNext()) {
            tech = (Technology)it.next();
            if (tech == Generic.tech) continue;
            this.technology.addItem(tech.getTechName());
        }
        this.setSelectedTechnology(cur);
        this.loading = false;
        visibility = new HashMap();
        it = Technology.getTechnologies();
        while (it.hasNext()) {
            tech = (Technology)it.next();
            Iterator lIt = tech.getLayers();
            while (lIt.hasNext()) {
                Layer layer = (Layer)lIt.next();
                if ((layer.getFunctionExtras() & 0x1000) != 0) continue;
                visibility.put(layer, new Boolean(layer.isVisible()));
            }
        }
    }

    public void setSelectedTechnology(Technology tech) {
        this.technology.setSelectedItem(tech.getTechName());
    }

    public void updateLayersTab() {
        Layer layer;
        Iterator lIt;
        Technology tech;
        if (this.loading) {
            return;
        }
        this.nodeText.setSelected(User.isTextVisibilityOnNode());
        this.arcText.setSelected(User.isTextVisibilityOnArc());
        this.portText.setSelected(User.isTextVisibilityOnPort());
        this.exportText.setSelected(User.isTextVisibilityOnExport());
        this.annotationText.setSelected(User.isTextVisibilityOnAnnotation());
        this.instanceNames.setSelected(User.isTextVisibilityOnInstance());
        this.cellText.setSelected(User.isTextVisibilityOnCell());
        boolean noDimming = true;
        Iterator it = Technology.getTechnologies();
        while (it.hasNext()) {
            tech = (Technology)it.next();
            lIt = tech.getLayers();
            while (lIt.hasNext()) {
                layer = (Layer)lIt.next();
                if (!layer.isDimmed()) continue;
                noDimming = false;
            }
        }
        this.highlighted = new HashMap();
        it = Technology.getTechnologies();
        while (it.hasNext()) {
            tech = (Technology)it.next();
            lIt = tech.getLayers();
            while (lIt.hasNext()) {
                layer = (Layer)lIt.next();
                if ((layer.getFunctionExtras() & 0x1000) != 0) continue;
                if (noDimming) {
                    this.highlighted.put(layer, new Boolean(false));
                    continue;
                }
                this.highlighted.put(layer, new Boolean(!layer.isDimmed()));
            }
        }
        Technology tech2 = Technology.getCurrent();
        this.technology.setSelectedItem(tech2.getTechName());
        this.layerListModel.clear();
        this.layersInList = new ArrayList();
        Iterator it2 = tech2.getLayersSortedByHeight().iterator();
        while (it2.hasNext()) {
            Layer layer2 = (Layer)it2.next();
            if ((layer2.getFunctionExtras() & 0x1000) != 0) continue;
            this.layersInList.add(layer2);
            this.layerListModel.addElement(this.lineName(layer2));
        }
        this.layerList.setSelectedIndex(0);
    }

    private String lineName(Layer layer) {
        StringBuffer layerName = new StringBuffer();
        Boolean layerVisible = (Boolean)visibility.get(layer);
        if (layerVisible.booleanValue()) {
            layerName.append("\u2713 ");
        } else {
            layerName.append("  ");
        }
        if ((layer.getFunctionExtras() & 0x1000) != 0) {
            layerName.append(" (for pins)");
        }
        Boolean layerHighlighted = (Boolean)this.highlighted.get(layer);
        layerName.append(layer.getName());
        if (layerHighlighted.booleanValue()) {
            layerName.append(" (HIGHLIGHTED)");
        }
        return layerName.toString();
    }

    private void apply(MouseEvent e) {
        if (e.getClickCount() == 2) {
            int[] indices = this.layerList.getSelectedIndices();
            for (int i = 0; i < indices.length; ++i) {
                int line;
                this.setVisibility(line, !this.isLineChecked(line = indices[i]), true);
            }
        }
    }

    private void clearAllHighlight() {
        for (int i = 0; i < this.layerListModel.size(); ++i) {
            this.changeHighlighted(i, 0);
        }
    }

    private void toggleHighlight() {
        int[] indices = this.layerList.getSelectedIndices();
        for (int i = 0; i < indices.length; ++i) {
            int line = indices[i];
            this.changeHighlighted(line, 1);
        }
    }

    private void selectAll() {
        int len = this.layerListModel.size();
        int[] indices = new int[len];
        for (int i = 0; i < len; ++i) {
            indices[i] = i;
        }
        this.layerList.setSelectedIndices(indices);
    }

    private void setVisibility(boolean on) {
        int[] indices = this.layerList.getSelectedIndices();
        for (int i = 0; i < indices.length; ++i) {
            int line = indices[i];
            this.setVisibility(line, on, false);
        }
        this.update();
    }

    private boolean isLineChecked(int i) {
        String s = (String)this.layerListModel.get(i);
        return s.charAt(0) != ' ';
    }

    private void setVisibility(int i, boolean on, boolean doUpdate) {
        Layer layer;
        String name = (String)this.layerListModel.get(i);
        if (name != null) {
            name = name.substring(2);
        }
        String techName = (String)this.technology.getSelectedItem();
        Technology tech = Technology.findTechnology(techName);
        int spacePos = name.indexOf(32);
        if (spacePos >= 0) {
            name = name.substring(0, spacePos);
        }
        if ((layer = tech.findLayer(name)) == null) {
            System.out.println("Can't find " + name);
            return;
        }
        visibility.put(layer, new Boolean(on));
        this.layerListModel.set(i, this.lineName(layer));
        if (doUpdate) {
            this.update();
        }
    }

    private void changeHighlighted(int i, int how) {
        Layer layer;
        String name = (String)this.layerListModel.get(i);
        if (name != null) {
            name = name.substring(2);
        }
        String techName = (String)this.technology.getSelectedItem();
        Technology tech = Technology.findTechnology(techName);
        int spacePos = name.indexOf(32);
        if (spacePos >= 0) {
            name = name.substring(0, spacePos);
        }
        if ((layer = tech.findLayer(name)) == null) {
            System.out.println("Can't find " + name);
            return;
        }
        boolean newState = false;
        if (how == 1) {
            newState = (Boolean)this.highlighted.get(layer) == false;
        }
        this.highlighted.put(layer, new Boolean(newState));
        this.layerListModel.set(i, this.lineName(layer));
        this.update();
    }

    private void update() {
        boolean currentTextOnCell;
        boolean currentTextOnInstance;
        boolean currentTextOnAnnotation;
        boolean currentTextOnExport;
        boolean currentTextOnPort;
        boolean currentTextOnArc;
        Layer layer;
        Iterator lIt;
        Technology tech;
        boolean changed = false;
        boolean anyHighlighted = false;
        Iterator it = Technology.getTechnologies();
        while (it.hasNext()) {
            tech = (Technology)it.next();
            lIt = tech.getLayers();
            while (lIt.hasNext()) {
                layer = (Layer)lIt.next();
                Boolean layerHighlighted = (Boolean)this.highlighted.get(layer.getNonPseudoLayer());
                if (layerHighlighted == null || !layerHighlighted.booleanValue()) continue;
                anyHighlighted = true;
            }
        }
        it = Technology.getTechnologies();
        while (it.hasNext()) {
            tech = (Technology)it.next();
            lIt = tech.getLayers();
            while (lIt.hasNext()) {
                Boolean layerHighlighted;
                layer = (Layer)lIt.next();
                Boolean layerVis = (Boolean)visibility.get(layer.getNonPseudoLayer());
                if (layerVis != null && layer.isVisible() != layerVis.booleanValue()) {
                    changed = true;
                    layer.setVisible(layerVis);
                    layer.getGraphics().notifyVisibility(layerVis);
                }
                if ((layerHighlighted = (Boolean)this.highlighted.get(layer.getNonPseudoLayer())) == null) continue;
                boolean newState = false;
                if (anyHighlighted && !layerHighlighted.booleanValue()) {
                    newState = true;
                }
                if (newState == layer.isDimmed()) continue;
                layer.setDimmed(newState);
                changed = true;
            }
        }
        it = Technology.getTechnologies();
        while (it.hasNext()) {
            Object lay;
            int i;
            boolean invisible;
            Object[] layers;
            tech = (Technology)it.next();
            Iterator nIt = tech.getNodes();
            while (nIt.hasNext()) {
                PrimitiveNode np = (PrimitiveNode)nIt.next();
                layers = np.getLayers();
                invisible = true;
                for (i = 0; i < layers.length; ++i) {
                    lay = layers[i];
                    if (!((Technology.NodeLayer)lay).getLayer().isVisible()) continue;
                    invisible = false;
                    break;
                }
                np.setNodeInvisible(invisible);
            }
            Iterator aIt = tech.getArcs();
            while (aIt.hasNext()) {
                ArcProto ap = (ArcProto)aIt.next();
                layers = ap.getLayers();
                invisible = true;
                for (i = 0; i < layers.length; ++i) {
                    lay = layers[i];
                    if (!((Technology.ArcLayer)lay).getLayer().isVisible()) continue;
                    invisible = false;
                    break;
                }
                ap.setArcInvisible(invisible);
            }
        }
        boolean textVisChanged = false;
        boolean currentTextOnNode = this.nodeText.isSelected();
        if (currentTextOnNode != User.isTextVisibilityOnNode()) {
            textVisChanged = true;
            User.setTextVisibilityOnNode(currentTextOnNode);
        }
        if ((currentTextOnArc = this.arcText.isSelected()) != User.isTextVisibilityOnArc()) {
            textVisChanged = true;
            User.setTextVisibilityOnArc(currentTextOnArc);
        }
        if ((currentTextOnPort = this.portText.isSelected()) != User.isTextVisibilityOnPort()) {
            textVisChanged = true;
            User.setTextVisibilityOnPort(currentTextOnPort);
        }
        if ((currentTextOnExport = this.exportText.isSelected()) != User.isTextVisibilityOnExport()) {
            textVisChanged = true;
            User.setTextVisibilityOnExport(currentTextOnExport);
        }
        if ((currentTextOnAnnotation = this.annotationText.isSelected()) != User.isTextVisibilityOnAnnotation()) {
            textVisChanged = true;
            User.setTextVisibilityOnAnnotation(currentTextOnAnnotation);
        }
        if ((currentTextOnInstance = this.instanceNames.isSelected()) != User.isTextVisibilityOnInstance()) {
            textVisChanged = true;
            User.setTextVisibilityOnInstance(currentTextOnInstance);
        }
        if ((currentTextOnCell = this.cellText.isSelected()) != User.isTextVisibilityOnCell()) {
            textVisChanged = true;
            User.setTextVisibilityOnCell(currentTextOnCell);
        }
        Iterator it2 = WindowFrame.getWindows();
        while (it2.hasNext()) {
            WindowFrame wf = (WindowFrame)it2.next();
            LayerTab lt = wf.getLayersTab();
            if (lt == this) continue;
            lt.updateLayersTab();
        }
        if (changed || textVisChanged) {
            PixelDrawing.clearSubCellCache();
            EditWindow.repaintAllContents();
        }
        if (changed) {
            VectorDrawing.layerVisibilityChanged();
        }
    }

    private void initComponents() {
        this.layerPane = new JScrollPane();
        this.technology = new JComboBox();
        this.selectAll = new JButton();
        this.makeVisible = new JButton();
        this.makeInvisible = new JButton();
        this.jPanel1 = new JPanel();
        this.unhighlightAll = new JButton();
        this.toggleHighlight = new JButton();
        this.jPanel2 = new JPanel();
        this.cellText = new JCheckBox();
        this.arcText = new JCheckBox();
        this.annotationText = new JCheckBox();
        this.instanceNames = new JCheckBox();
        this.exportText = new JCheckBox();
        this.portText = new JCheckBox();
        this.nodeText = new JCheckBox();
        this.setLayout(new GridBagLayout());
        this.setName("");
        this.layerPane.setMinimumSize(new Dimension(100, 300));
        this.layerPane.setPreferredSize(new Dimension(100, 300));
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.fill = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.insets = new Insets(4, 4, 4, 4);
        this.add((Component)this.layerPane, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(0, 4, 0, 4);
        this.add((Component)this.technology, gridBagConstraints);
        this.selectAll.setText("Select All");
        this.selectAll.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                LayerTab.this.selectAllActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.insets = new Insets(2, 4, 1, 4);
        this.add((Component)this.selectAll, gridBagConstraints);
        this.makeVisible.setText("Make Visible");
        this.makeVisible.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                LayerTab.this.makeVisibleActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.insets = new Insets(1, 4, 1, 4);
        this.add((Component)this.makeVisible, gridBagConstraints);
        this.makeInvisible.setText("Make Invisible");
        this.makeInvisible.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                LayerTab.this.makeInvisibleActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 4;
        gridBagConstraints.insets = new Insets(1, 4, 2, 4);
        this.add((Component)this.makeInvisible, gridBagConstraints);
        this.jPanel1.setLayout(new GridBagLayout());
        this.jPanel1.setBorder(new TitledBorder("Highlighting"));
        this.unhighlightAll.setText("Clear");
        this.unhighlightAll.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                LayerTab.this.unhighlightAllActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.insets = new Insets(1, 4, 2, 4);
        this.jPanel1.add((Component)this.unhighlightAll, gridBagConstraints);
        this.toggleHighlight.setText("Toggle");
        this.toggleHighlight.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                LayerTab.this.toggleHighlightActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.insets = new Insets(2, 4, 1, 4);
        this.jPanel1.add((Component)this.toggleHighlight, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 5;
        gridBagConstraints.fill = 2;
        gridBagConstraints.weightx = 1.0;
        this.add((Component)this.jPanel1, gridBagConstraints);
        this.jPanel2.setLayout(new GridBagLayout());
        this.jPanel2.setBorder(new TitledBorder("Text Visibility"));
        this.cellText.setText("Cell text");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.anchor = 17;
        this.jPanel2.add((Component)this.cellText, gridBagConstraints);
        this.arcText.setText("Arc text");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.anchor = 17;
        this.jPanel2.add((Component)this.arcText, gridBagConstraints);
        this.annotationText.setText("Annotation text");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 5;
        gridBagConstraints.anchor = 17;
        this.jPanel2.add((Component)this.annotationText, gridBagConstraints);
        this.instanceNames.setText("Instance names");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 4;
        gridBagConstraints.anchor = 17;
        this.jPanel2.add((Component)this.instanceNames, gridBagConstraints);
        this.exportText.setText("Export text");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 6;
        gridBagConstraints.anchor = 17;
        this.jPanel2.add((Component)this.exportText, gridBagConstraints);
        this.portText.setText("Port text");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.anchor = 17;
        this.jPanel2.add((Component)this.portText, gridBagConstraints);
        this.nodeText.setText("Node text");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(2, 0, 0, 0);
        this.jPanel2.add((Component)this.nodeText, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 6;
        gridBagConstraints.fill = 2;
        this.add((Component)this.jPanel2, gridBagConstraints);
    }

    private void toggleHighlightActionPerformed(ActionEvent evt) {
        this.toggleHighlight();
    }

    private void unhighlightAllActionPerformed(ActionEvent evt) {
        this.clearAllHighlight();
    }

    private void makeInvisibleActionPerformed(ActionEvent evt) {
        this.setVisibility(false);
    }

    private void makeVisibleActionPerformed(ActionEvent evt) {
        this.setVisibility(true);
    }

    private void selectAllActionPerformed(ActionEvent evt) {
        this.selectAll();
    }
}

