/*
 * Decompiled with CFR 0.152.
 */
package com.sun.electric.tool.simulation;

import com.sun.electric.tool.simulation.Stimuli;
import java.awt.geom.Rectangle2D;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;

public class Signal {
    private String signalName;
    private String signalContext;
    protected Stimuli sd;
    private boolean useCommonTime;
    protected Rectangle2D bounds;
    protected boolean boundsCurrent;
    private double[] time;
    private double[] controlPoints;
    private List bussedSignals;
    private int busCount;
    private Object appObject;
    public int flags;
    public List tempList;

    protected Signal(Stimuli sd) {
        this.sd = sd;
        this.useCommonTime = true;
        this.boundsCurrent = false;
        this.busCount = 0;
        this.controlPoints = null;
        if (sd != null) {
            sd.addSignal(this);
        }
    }

    public void setSignalName(String signalName) {
        this.signalName = signalName;
        this.sd.nameSignal(this, this.getFullName());
    }

    public String getSignalName() {
        return this.signalName;
    }

    public void setSignalContext(String signalContext) {
        this.signalContext = signalContext;
    }

    public String getSignalContext() {
        return this.signalContext;
    }

    public String getFullName() {
        if (this.signalContext != null) {
            return this.signalContext + this.sd.getSeparatorChar() + this.signalName;
        }
        return this.signalName;
    }

    public int getNumEvents() {
        return 0;
    }

    public void buildBussedSignalList() {
        this.bussedSignals = new ArrayList();
        if (this.sd == null) {
            System.out.println("SD IS NULL!!!!!!!");
        }
        this.sd.getBussedSignals().add(this);
    }

    public List getBussedSignals() {
        return this.bussedSignals;
    }

    public void clearBussedSignalList() {
        Iterator it = this.bussedSignals.iterator();
        while (it.hasNext()) {
            Signal sig = (Signal)it.next();
            --sig.busCount;
        }
        this.bussedSignals.clear();
    }

    public void addToBussedSignalList(Signal ws) {
        this.bussedSignals.add(ws);
        ++ws.busCount;
    }

    public boolean isInBus() {
        return this.busCount != 0;
    }

    public double[] getControlPoints() {
        return this.controlPoints;
    }

    public void clearControlPoints() {
        this.controlPoints = null;
    }

    public void addControlPoint(double time) {
        if (this.controlPoints == null) {
            this.controlPoints = new double[1];
            this.controlPoints[0] = time;
        } else {
            for (int i = 0; i < this.controlPoints.length; ++i) {
                if (this.controlPoints[i] != time) continue;
                return;
            }
            double[] newCP = new double[this.controlPoints.length + 1];
            for (int i = 0; i < this.controlPoints.length; ++i) {
                newCP[i] = this.controlPoints[i];
            }
            newCP[this.controlPoints.length] = time;
            this.controlPoints = newCP;
        }
    }

    public void removeControlPoint(double time) {
        if (this.controlPoints == null) {
            return;
        }
        boolean found = false;
        for (int i = 0; i < this.controlPoints.length; ++i) {
            if (this.controlPoints[i] != time) continue;
            found = true;
            break;
        }
        if (!found) {
            return;
        }
        double[] newCP = new double[this.controlPoints.length - 1];
        int j = 0;
        for (int i = 0; i < this.controlPoints.length; ++i) {
            if (this.controlPoints[i] == time) continue;
            newCP[j++] = this.controlPoints[i];
        }
        this.controlPoints = newCP;
    }

    public void setAppObject(Object appObject) {
        this.appObject = appObject;
    }

    public Object getAppObject() {
        return this.appObject;
    }

    public void buildTime(int numEvents) {
        this.useCommonTime = false;
        this.time = new double[numEvents];
    }

    public double getTime(int index) {
        if (this.useCommonTime) {
            return this.sd.getCommonTimeArray()[index];
        }
        return this.time[index];
    }

    public double getTime(int index, int sweep) {
        if (this.useCommonTime) {
            double[] sct = this.sd.getCommonTimeArray(sweep);
            return sct[index];
        }
        return this.time[index];
    }

    public double[] getTimeVector() {
        return this.time;
    }

    public void setTimeVector(double[] time) {
        this.useCommonTime = false;
        this.boundsCurrent = false;
        this.time = time;
    }

    public void setTime(int entry, double t) {
        this.boundsCurrent = false;
        this.time[entry] = t;
    }

    public Rectangle2D getBounds() {
        if (!this.boundsCurrent) {
            this.calcBounds();
            this.boundsCurrent = true;
        }
        return this.bounds;
    }

    protected void calcBounds() {
    }
}

