/*
 * Decompiled with CFR 0.152.
 */
package com.sun.electric.tool.routing;

import com.sun.electric.database.geometry.GenMath;
import com.sun.electric.database.geometry.Poly;
import com.sun.electric.database.hierarchy.Cell;
import com.sun.electric.database.prototype.NodeProto;
import com.sun.electric.database.prototype.PortProto;
import com.sun.electric.database.topology.ArcInst;
import com.sun.electric.database.topology.Connection;
import com.sun.electric.database.topology.NodeInst;
import com.sun.electric.database.topology.PortInst;
import com.sun.electric.technology.ArcProto;
import com.sun.electric.technology.Layer;
import com.sun.electric.technology.PrimitiveNode;
import com.sun.electric.technology.Technology;
import com.sun.electric.technology.technologies.Generic;
import com.sun.electric.tool.Job;
import com.sun.electric.tool.drc.DRC;
import com.sun.electric.tool.routing.Routing;
import com.sun.electric.tool.user.Highlighter;
import com.sun.electric.tool.user.menus.MenuCommands;
import com.sun.electric.tool.user.ui.WindowFrame;
import java.awt.geom.Point2D;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;

public class River {
    private static final int ROUTEINX = 1;
    private static final int ROUTEINY = 2;
    private static final int ILLEGALROUTE = -1;
    private static final int BOTTOP = 1;
    private static final int FROMSIDE = 2;
    private static final int TOSIDE = 3;
    private List rightP;
    private List leftP;
    private double fromLine;
    private double toLine;
    private int routDirection;
    private double startRight;
    private double startLeft;
    private RCOORD xAxis;
    private RCOORD yAxis;
    private double height;
    private double routBoundLX;
    private double routBoundLY;
    private double routBoundHX;
    private double routBoundHY;
    private double wireBoundLX;
    private double wireBoundLY;
    private double wireBoundHX;
    private double wireBoundHY;
    private NodeInst moveCell;
    private boolean moveCellValid;
    private static final TRANSFORM xfNoRot = new TRANSFORM(1.0, 0.0, 0.0, 1.0, 0.0, 0.0);
    private static final TRANSFORM xfRot90 = new TRANSFORM(0.0, 1.0, -1.0, 0.0, 0.0, 0.0);
    private static final TRANSFORM xfRot180 = new TRANSFORM(-1.0, 0.0, 0.0, -1.0, 0.0, 0.0);
    private static final TRANSFORM xfRot270 = new TRANSFORM(0.0, -1.0, 1.0, 0.0, 0.0, 0.0);
    private static final TRANSFORM xfMirrorX = new TRANSFORM(-1.0, 0.0, 0.0, 1.0, 0.0, 0.0);
    private static final TRANSFORM xfRot90MirrorX = new TRANSFORM(0.0, 1.0, 1.0, 0.0, 0.0, 0.0);
    private static final TRANSFORM xfMirrorY = new TRANSFORM(1.0, 0.0, 0.0, -1.0, 0.0, 0.0);
    private static final TRANSFORM xfMirrorXRot90 = new TRANSFORM(0.0, -1.0, -1.0, 0.0, 0.0, 0.0);
    private static final TRANSFORM xfInverse = new TRANSFORM(1.0, 0.0, 0.0, 1.0, 0.0, 0.0);

    public static void riverRoute() {
        Cell curCell = WindowFrame.needCurCell();
        if (curCell == null) {
            return;
        }
        RiverRouteJob job = new RiverRouteJob(curCell);
    }

    public void river(Cell cell) {
        if (this.findWires(cell)) {
            RDESC q;
            Iterator it = this.rightP.iterator();
            while (it.hasNext()) {
                q = (RDESC)it.next();
                this.checkTheCell(q.unroutedWire2.getPortInst(q.unroutedEnd2).getNodeInst());
            }
            it = this.leftP.iterator();
            while (it.hasNext()) {
                q = (RDESC)it.next();
                this.checkTheCell(q.unroutedWire2.getPortInst(q.unroutedEnd2).getNodeInst());
            }
            if (this.moveCellValid && this.moveCell != null) {
                if (this.moveInstance()) {
                    this.makeTheGeometry(cell);
                }
            } else {
                this.makeTheGeometry(cell);
            }
        }
    }

    private void checkTheCell(NodeInst ni) {
        if (ni.getProto() instanceof Cell) {
            if (!this.moveCellValid) {
                return;
            }
            if (this.moveCell == null) {
                this.moveCell = ni;
            } else if (this.moveCell != ni) {
                this.moveCellValid = false;
            }
        }
    }

    private boolean findWires(Cell cell) {
        ArcInst ai;
        Iterator it;
        this.initialize();
        HashSet arcsSeen = new HashSet();
        ArrayList theList = new ArrayList();
        List allArcs = MenuCommands.getSelectedObjects(false, true);
        if (allArcs.size() != 0) {
            it = allArcs.iterator();
            while (it.hasNext()) {
                ai = (ArcInst)it.next();
                this.addWire(theList, ai, arcsSeen);
            }
        } else {
            it = cell.getArcs();
            while (it.hasNext()) {
                ai = (ArcInst)it.next();
                this.addWire(theList, ai, arcsSeen);
            }
        }
        boolean first = true;
        Iterator it2 = theList.iterator();
        while (it2.hasNext()) {
            RDESC rdesc = (RDESC)it2.next();
            if (first) {
                this.routBoundLX = Math.min(rdesc.from.x, rdesc.to.x);
                this.routBoundLY = Math.min(rdesc.from.y, rdesc.to.y);
                this.routBoundHX = Math.max(rdesc.from.x, rdesc.to.x);
                this.routBoundHY = Math.max(rdesc.from.y, rdesc.to.y);
                continue;
            }
            this.routBoundLX = Math.min(Math.min(this.routBoundLX, rdesc.from.x), rdesc.to.x);
            this.routBoundLY = Math.min(Math.min(this.routBoundLY, rdesc.from.y), rdesc.to.y);
            this.routBoundHX = Math.max(Math.max(this.routBoundHX, rdesc.from.x), rdesc.to.x);
            this.routBoundHY = Math.max(Math.max(this.routBoundHY, rdesc.from.y), rdesc.to.y);
        }
        HashMap arcProtoUsage = new HashMap();
        Iterator it3 = theList.iterator();
        while (it3.hasNext()) {
            RDESC rd = (RDESC)it3.next();
            this.sumUp(rd.unroutedWire1.getPortInst(rd.unroutedEnd1), arcProtoUsage);
            this.sumUp(rd.unroutedWire2.getPortInst(rd.unroutedEnd2), arcProtoUsage);
        }
        ArcProto wantAp = null;
        int mostUses = -1;
        int total = 0;
        Iterator it4 = arcProtoUsage.keySet().iterator();
        while (it4.hasNext()) {
            ArcProto ap = (ArcProto)it4.next();
            GenMath.MutableInteger mi = (GenMath.MutableInteger)arcProtoUsage.get(ap);
            if (mi == null) continue;
            total += mi.intValue();
            if (mi.intValue() <= mostUses) continue;
            mostUses = mi.intValue();
            wantAp = ap;
        }
        if (wantAp == null) {
            System.out.println("River router: Cannot find arc that will connect");
            return false;
        }
        System.out.println("River routing with " + wantAp.describe() + " arcs");
        this.figureOutRails(total);
        this.setWiresToRails(theList);
        Technology.ArcLayer[] arcLayers = wantAp.getLayers();
        Layer layer = arcLayers[0].getLayer();
        double amt = DRC.getMaxSurround(layer, Double.MAX_VALUE);
        if (amt < 0.0) {
            amt = 1.0;
        }
        return this.unsortedRivRot(wantAp, theList, wantAp.getDefaultWidth() - wantAp.getWidthOffset(), amt, amt, amt);
    }

    private boolean unsortedRivRot(ArcProto layerDesc, List lists, double width, double space, double cellOff1, double cellOff2) {
        Iterator it = lists.iterator();
        while (it.hasNext()) {
            RDESC rd = (RDESC)it.next();
            rd.sortVal = this.routDirection != 1 ? rd.from.x : rd.from.y;
        }
        Collections.sort(lists, new SortRDESC());
        return this.sortedRivRot(layerDesc, lists, width, space, cellOff1, cellOff2);
    }

    private boolean sortedRivRot(ArcProto layerDesc, List listR, double width, double space, double cellOff1, double cellOff2) {
        if (!this.checkPoints(listR, width, space)) {
            return false;
        }
        this.structurePoints(listR);
        if (!this.checkStructuredPoints(this.rightP, this.leftP, cellOff1, width, space)) {
            return false;
        }
        if (this.processRight(width, layerDesc, this.rightP, cellOff1, space, -1)) {
            return false;
        }
        if (this.processLeft(width, layerDesc, this.leftP, cellOff1, space, 1.0)) {
            return false;
        }
        Double dHeight = this.calculateHeightAndProcess(this.rightP, this.leftP, width, cellOff2);
        if (dHeight == null) {
            return false;
        }
        this.calculateBB(this.rightP, this.leftP);
        this.height = dHeight;
        return true;
    }

    private void calculateBB(List right, List left) {
        RPOINT rvp;
        this.routBoundLY = Double.MAX_VALUE;
        this.routBoundLX = Double.MAX_VALUE;
        this.routBoundHY = Double.MIN_VALUE;
        this.routBoundHX = Double.MIN_VALUE;
        Iterator it = right.iterator();
        while (it.hasNext()) {
            RDESC rRight = (RDESC)it.next();
            rvp = rRight.path.pathDesc;
            while (rvp != null) {
                this.routBoundLX = Math.min(this.routBoundLX, rvp.x);
                this.routBoundLY = Math.min(this.routBoundLY, rvp.y);
                this.routBoundHX = Math.max(this.routBoundHX, rvp.x);
                this.routBoundHY = Math.max(this.routBoundHY, rvp.y);
                rvp = rvp.next;
            }
        }
        it = left.iterator();
        while (it.hasNext()) {
            RDESC lLeft = (RDESC)it.next();
            rvp = lLeft.path.pathDesc;
            while (rvp != null) {
                this.routBoundLX = Math.min(this.routBoundLX, rvp.x);
                this.routBoundLY = Math.min(this.routBoundLY, rvp.y);
                this.routBoundHX = Math.max(this.routBoundHX, rvp.x);
                this.routBoundHY = Math.max(this.routBoundHY, rvp.y);
                rvp = rvp.next;
            }
        }
    }

    private Double calculateHeightAndProcess(List right, List left, double width, double co2) {
        RPOINT lastP;
        RDESC rd;
        double minHeight = 0.0;
        double maxHeight = Double.MIN_VALUE;
        Iterator it = right.iterator();
        while (it.hasNext()) {
            rd = (RDESC)it.next();
            maxHeight = Math.max(maxHeight, rd.path.lastP.second);
        }
        it = left.iterator();
        while (it.hasNext()) {
            rd = (RDESC)it.next();
            maxHeight = Math.max(maxHeight, rd.path.lastP.second);
        }
        maxHeight = minHeight != 0.0 ? Math.max(minHeight, maxHeight + width / 2.0 + co2) : maxHeight + width / 2.0 + co2;
        maxHeight = Math.max(maxHeight, this.toLine);
        it = right.iterator();
        while (it.hasNext()) {
            rd = (RDESC)it.next();
            lastP = rd.path.lastP;
            if (lastP.side != 2) {
                lastP.next = new RPOINT(rd.path, lastP.first, maxHeight, null);
            }
            this.remapPoints(rd.path.pathDesc, xfInverse);
        }
        it = left.iterator();
        while (it.hasNext()) {
            rd = (RDESC)it.next();
            lastP = rd.path.lastP;
            if (lastP.side != 4) {
                lastP.next = new RPOINT(rd.path, lastP.first, maxHeight, null);
            }
            this.remapPoints(rd.path.pathDesc, xfInverse);
        }
        this.toLine = this.remapSecond(this.toLine, xfInverse);
        this.fromLine = this.remapSecond(this.fromLine, xfInverse);
        return new Double(this.remapSecond(maxHeight, xfInverse));
    }

    private void remapPoints(RPOINT rp, TRANSFORM matrix) {
        while (rp != null) {
            rp.x = rp.first * matrix.t11 + rp.second * matrix.t21;
            rp.y = rp.first * matrix.t12 + rp.second * matrix.t22;
            rp = rp.next;
        }
    }

    private double remapSecond(double sec, TRANSFORM matrix) {
        if (this.routDirection == 2) {
            return sec * matrix.t22;
        }
        return sec * matrix.t12;
    }

    private boolean processLeft(double width, ArcProto ptype, List rout, double co1, double space, double dir) {
        boolean firstTime = true;
        RPATH lastP = null;
        double offset = this.startRight;
        Iterator it = rout.iterator();
        while (it.hasNext()) {
            RDESC rd = (RDESC)it.next();
            if (rd.from.side != 2) {
                if (firstTime) {
                    rd.path = this.makeOrigPath(width, ptype, co1, rd.from, rd.to);
                    if (rd.path == null) {
                        return true;
                    }
                    firstTime = false;
                } else {
                    rd.path = this.addPath(lastP, width, ptype, rd.from, rd.to, space, co1, dir);
                }
                if (rd.path == null) {
                    return true;
                }
            } else {
                if (firstTime) {
                    rd.path = this.makeSideOrigPath(width, ptype, offset, rd.from, rd.to);
                    if (rd.path == null) {
                        return true;
                    }
                    firstTime = false;
                } else {
                    rd.path = this.sideAddPath(lastP, width, ptype, rd.from, rd.to, space, offset, dir);
                    if (rd.path == null) {
                        return true;
                    }
                }
                offset += space + width;
            }
            lastP = rd.path;
        }
        return false;
    }

    private boolean processRight(double width, ArcProto ptype, List rout, double co1, double space, int dir) {
        boolean firstTime = true;
        RPATH lastP = null;
        double offset = this.startLeft;
        this.reverse(rout);
        Iterator it = rout.iterator();
        while (it.hasNext()) {
            RDESC rd = (RDESC)it.next();
            if (rd.from.side != 4) {
                if (firstTime) {
                    rd.path = this.makeOrigPath(width, ptype, co1, rd.from, rd.to);
                    if (rd.path == null) {
                        return true;
                    }
                    firstTime = false;
                } else {
                    rd.path = this.addPath(lastP, width, ptype, rd.from, rd.to, space, co1, dir);
                }
                if (rd.path == null) {
                    return true;
                }
            } else {
                if (firstTime) {
                    rd.path = this.makeSideOrigPath(width, ptype, offset, rd.from, rd.to);
                    if (rd.path == null) {
                        return true;
                    }
                    firstTime = false;
                } else {
                    rd.path = this.sideAddPath(lastP, width, ptype, rd.from, rd.to, space, offset, dir);
                    if (rd.path == null) {
                        return true;
                    }
                }
                offset += space + width;
            }
            lastP = rd.path;
        }
        this.reverse(rout);
        return false;
    }

    private RPATH sideAddPath(RPATH path, double width, ArcProto ptype, RPOINT b, RPOINT t, double space, double offset, double dir) {
        RPATH rp = new RPATH(width, ptype);
        rp.pathDesc = new RPOINT(rp, b.first, offset, null);
        double minFirst = Math.min(b.first, t.first);
        double maxFirst = Math.max(b.first, t.first);
        RPOINT lp = path.pathDesc;
        RPOINT lastP = rp.lastP;
        double newfirst = lp.first + dir * (space + rp.width);
        while (lp != null && minFirst <= newfirst && newfirst <= maxFirst) {
            if (lp == path.pathDesc) {
                lastP.next = new RPOINT(rp, newfirst, Math.min(lastP.second, offset), null);
            } else {
                lastP.next = new RPOINT(rp, newfirst, Math.max(lp.second + space + rp.width, offset), null);
            }
            lastP = lastP.next;
            if ((lp = lp.next) == null) continue;
            newfirst = lp.first + dir * (space + rp.width);
        }
        lastP.next = new RPOINT(rp, t.first, lastP.second, null);
        rp.lastP.side = t.side;
        return rp;
    }

    private RPATH addPath(RPATH path, double width, ArcProto ptype, RPOINT b, RPOINT t, double space, double co1, double dir) {
        RPATH rp = new RPATH(width, ptype);
        RPOINT i1 = new RPOINT(rp, b.first, b.second + rp.width / 2.0 + co1, null);
        rp.pathDesc = new RPOINT(rp, b.first, b.second, i1);
        double minFirst = Math.min(b.first, t.first);
        double maxFirst = Math.max(b.first, t.first);
        RPOINT lp = path.pathDesc;
        RPOINT lastP = rp.lastP;
        double newfirst = lp.first + dir * (space + rp.width);
        while (lp != null && minFirst <= newfirst && newfirst <= maxFirst) {
            if (lp == path.pathDesc) {
                lastP.next = new RPOINT(rp, newfirst, lastP.second, null);
            } else {
                lastP.next = new RPOINT(rp, newfirst, lp.second + space + rp.width, null);
            }
            lastP = lastP.next;
            if ((lp = lp.next) == null) continue;
            newfirst = lp.first + dir * (space + rp.width);
        }
        lastP.next = new RPOINT(rp, t.first, lastP.second, null);
        rp.lastP.side = t.side;
        return rp;
    }

    private RPATH makeOrigPath(double width, ArcProto ptype, double co1, RPOINT b, RPOINT t) {
        RPATH rp = new RPATH(width, ptype);
        RPOINT i1 = new RPOINT(rp, t.first, b.second + width / 2.0 + co1, null);
        RPOINT i2 = new RPOINT(rp, b.first, b.second + width / 2.0 + co1, i1);
        rp.pathDesc = new RPOINT(rp, b.first, b.second, i2);
        rp.lastP.side = t.side;
        return rp;
    }

    private RPATH makeSideOrigPath(double width, ArcProto ptype, double startoff, RPOINT b, RPOINT t) {
        RPATH rp = new RPATH(width, ptype);
        RPOINT i1 = new RPOINT(rp, t.first, startoff, null);
        rp.pathDesc = new RPOINT(rp, b.first, startoff, i1);
        rp.lastP.side = t.side;
        return rp;
    }

    private void reverse(List p) {
        int total = p.size();
        if (total <= 1) {
            return;
        }
        for (int i = 0; i < total / 2; ++i) {
            int otherI = total - i - 1;
            Object early = p.get(i);
            Object late = p.get(otherI);
            p.set(i, late);
            p.set(otherI, early);
        }
    }

    private boolean checkStructuredPoints(List right, List left, double co1, double width, double space) {
        boolean fromSide1 = false;
        boolean toSide2 = false;
        double botOffs2 = 0.0;
        Iterator it = right.iterator();
        block16: while (it.hasNext()) {
            RDESC r = (RDESC)it.next();
            switch (r.from.side) {
                case 1: {
                    fromSide1 = true;
                    break;
                }
                case 4: {
                    if (!fromSide1) break;
                    System.out.println("River router: Improper ordering of bottom right ports");
                    return false;
                }
                default: {
                    System.out.println("River router: Improper sides for bottom right ports (" + RPOINT.sideName(r.from.side) + ")");
                    return false;
                }
            }
            switch (r.to.side) {
                case 2: {
                    botOffs2 = !toSide2 ? this.fromLine + co1 + width / 2.0 : (botOffs2 += space + width);
                    toSide2 = true;
                    continue block16;
                }
                case 3: {
                    if (!toSide2) continue block16;
                    System.out.println("River router: Improper ordering of top right ports");
                    return false;
                }
            }
            System.out.println("River router: Improper sides for top right ports");
            return false;
        }
        boolean fromSide2 = false;
        boolean toSide3 = false;
        boolean toSide4 = false;
        double botOffs4 = 0.0;
        Iterator it2 = left.iterator();
        block17: while (it2.hasNext()) {
            RDESC l = (RDESC)it2.next();
            switch (l.from.side) {
                case 1: {
                    if (!fromSide2) break;
                    System.out.println("River router: Improper Ordering of Bottom Left Ports");
                    return false;
                }
                case 2: {
                    fromSide2 = true;
                    break;
                }
                default: {
                    System.out.println("River router: Improper sides for Bottom Left Ports");
                    return false;
                }
            }
            switch (l.to.side) {
                case 3: {
                    toSide3 = true;
                    continue block17;
                }
                case 4: {
                    if (!toSide3) {
                        botOffs4 = !toSide4 ? this.fromLine + co1 + width / 2.0 : (botOffs4 += space + width);
                    } else {
                        System.out.println("River router: Improper Ordering of Top Left Ports");
                        return false;
                    }
                    toSide4 = true;
                    continue block17;
                }
            }
            System.out.println("River router: Improper sides for Top Left Ports");
            return false;
        }
        this.startRight = botOffs2 == 0.0 ? this.fromLine + co1 + width / 2.0 : botOffs2 + space + width;
        this.startLeft = botOffs4 == 0.0 ? this.fromLine + co1 + width / 2.0 : botOffs4 + space + width;
        return true;
    }

    private void structurePoints(List listr) {
        this.rightP = new ArrayList();
        this.leftP = new ArrayList();
        Iterator it = listr.iterator();
        while (it.hasNext()) {
            RDESC rd = (RDESC)it.next();
            if (rd.to.first >= rd.from.first) {
                this.rightP.add(rd);
                continue;
            }
            this.leftP.add(rd);
        }
    }

    private boolean checkPoints(List rdescList, double width, double space) {
        int numRDesc = rdescList.size();
        if (numRDesc == 0) {
            System.out.println("River router: Not enought points");
            return false;
        }
        RDESC listLast = (RDESC)rdescList.get(numRDesc - 1);
        if (listLast.from == null || listLast.to == null) {
            System.out.println("River router: Not the same number of points");
            return false;
        }
        RDESC listP = (RDESC)rdescList.get(0);
        TRANSFORM tMatrix = null;
        double val1 = 0.0;
        double val2 = 0.0;
        if (this.routDirection == 1) {
            tMatrix = listP.to.x >= listP.from.x ? (listLast.from.y >= listP.from.y ? xfRot90MirrorX : xfRot90) : (listLast.from.y >= listP.from.y ? xfRot270 : xfMirrorXRot90);
            val1 = this.fromLine *= tMatrix.t12;
            val2 = this.toLine *= tMatrix.t12;
        } else if (this.routDirection == 2) {
            tMatrix = listP.to.y >= listP.from.y ? (listLast.from.x >= listP.from.x ? xfNoRot : xfMirrorX) : (listLast.from.x >= listP.from.x ? xfMirrorY : xfRot180);
            val1 = this.fromLine *= tMatrix.t22;
            val2 = this.toLine *= tMatrix.t22;
        } else {
            System.out.println("River router: Not between two parallel lines");
            return false;
        }
        for (int i = 0; i < numRDesc - 1; ++i) {
            RDESC lList = (RDESC)rdescList.get(i);
            RDESC lListNext = (RDESC)rdescList.get(i + 1);
            if (this.routDirection == 2) {
                if (!(lList.from.x > lListNext.from.x && lList.to.x < lListNext.to.x) && (!(lList.from.x < lListNext.from.x) || !(lList.to.x > lListNext.to.x))) continue;
                System.out.println("River router: Connections may not cross");
                return false;
            }
            if (!(lList.from.y > lListNext.from.y && lList.to.y < lListNext.to.y) && (!(lList.from.y < lListNext.from.y) || !(lList.to.y > lListNext.to.y))) continue;
            System.out.println("River router: Connections may not cross");
            return false;
        }
        double bound1 = this.routBoundLX * tMatrix.t11 + this.routBoundLY * tMatrix.t21;
        double bound2 = this.routBoundHX * tMatrix.t11 + this.routBoundHY * tMatrix.t21;
        if (bound2 < bound1) {
            double temp = bound2;
            bound2 = bound1;
            bound1 = temp;
        }
        RPOINT lastFrom = null;
        RPOINT lastTo = null;
        Iterator it = rdescList.iterator();
        while (it.hasNext()) {
            double diff2;
            double diff1;
            RDESC lList = (RDESC)it.next();
            lList.from.first = lList.from.x * tMatrix.t11 + lList.from.y * tMatrix.t21;
            lList.from.second = lList.from.x * tMatrix.t12 + lList.from.y * tMatrix.t22;
            lList.to.first = lList.to.x * tMatrix.t11 + lList.to.y * tMatrix.t21;
            lList.to.second = lList.to.x * tMatrix.t12 + lList.to.y * tMatrix.t22;
            if (lList.from.second != val1) {
                this.clipWire(lList.from, bound1, bound2);
            }
            if (lList.to.second != val2) {
                this.clipWire(lList.to, bound1, bound2);
            }
            if (lastFrom != null && lList.from.side == 1 && (diff1 = Math.abs(lastFrom.first - lList.from.first)) < width + space) {
                System.out.println("River router: Ports not design rule distance apart");
                return false;
            }
            if (lastTo != null && lList.to.side == 3 && (diff2 = Math.abs(lastTo.first - lList.to.first)) < width + space) {
                System.out.println("River router: Ports not design rule distance apart");
                return false;
            }
            lastFrom = lList.from.side == 1 ? lList.from : null;
            lastTo = lList.to.side == 3 ? lList.to : null;
        }
        xfInverse.t11 = tMatrix.t11;
        xfInverse.t12 = tMatrix.t21;
        xfInverse.t21 = tMatrix.t12;
        xfInverse.t22 = tMatrix.t22;
        xfInverse.tx = listP.from.first;
        xfInverse.ty = listP.from.second;
        this.fromLine = val1;
        this.toLine = val2;
        return true;
    }

    private void clipWire(RPOINT p, double b1, double b2) {
        double diff2;
        double diff1 = Math.abs(b1 - p.first);
        if (diff1 < (diff2 = Math.abs(b2 - p.first))) {
            p.first = b1;
            p.side = 4;
        } else {
            p.first = b2;
            p.side = 2;
        }
    }

    private void setWiresToRails(List lists) {
        Iterator it = lists.iterator();
        while (it.hasNext()) {
            RDESC r = (RDESC)it.next();
            double fVal = this.pointVal(r.from, this.routDirection);
            double tVal = this.pointVal(r.to, this.routDirection);
            if ((fVal == this.fromLine || tVal != this.fromLine) && (tVal == this.toLine || fVal != this.toLine)) continue;
            this.swapPoints(r);
        }
    }

    private void swapPoints(RDESC r) {
        if (r.from.side != 1 || r.to.side != 3) {
            System.out.println("River router: Unexpected side designation");
        }
        RPOINT tmp = r.from;
        r.from = r.to;
        r.to = tmp;
        r.from.side = 1;
        r.to.side = 3;
        ArcInst tmpwire = r.unroutedWire1;
        int tmpe = r.unroutedEnd1;
        r.unroutedWire1 = r.unroutedWire2;
        r.unroutedEnd1 = r.unroutedEnd2;
        r.unroutedWire2 = tmpwire;
        r.unroutedEnd2 = tmpe;
    }

    private double pointVal(RPOINT rp, int xx) {
        return xx == 1 ? rp.x : rp.y;
    }

    private void figureOutRails(int total) {
        RCOORD lX = this.largest(this.xAxis);
        RCOORD lY = this.largest(this.yAxis);
        RCOORD nLX = this.nextLargest(this.xAxis, lX);
        RCOORD nLY = this.nextLargest(this.yAxis, lY);
        RCOORD from = null;
        RCOORD to = null;
        int fxx = -1;
        if (lX != null && nLX != null && lX.total == total && nLX.total == total) {
            from = lX;
            to = nLX;
            fxx = 1;
        } else if (lY != null && nLY != null && lY.total == total && nLY.total == total) {
            from = lY;
            to = nLY;
            fxx = 2;
        } else if (lX != null && lX.total == 2 * total) {
            from = to = lX;
            fxx = 1;
        } else if (lY != null && lY.total == 2 * total) {
            from = to = lY;
            fxx = 2;
        }
        if (fxx == -1) {
            if (lX.total >= total) {
                fxx = 1;
                from = lX;
                to = lX.total > total ? lX : nLX;
            } else if (lY.total >= total) {
                fxx = 2;
                from = lY;
                to = lY.total > total ? lY : nLY;
            } else {
                fxx = lY.total + nLY.total >= lX.total + nLX.total ? 2 : 1;
                from = fxx == 2 ? lY : lX;
                RCOORD rCOORD = to = fxx == 2 ? nLY : nLX;
            }
        }
        if (to.val < from.val) {
            RCOORD tmp = from;
            from = to;
            to = tmp;
        }
        this.routDirection = fxx;
        this.fromLine = from.val;
        this.toLine = to.val;
    }

    private RCOORD largest(RCOORD cc) {
        RCOORD largest = cc;
        while (cc != null) {
            if (cc.total > largest.total) {
                largest = cc;
            }
            cc = cc.next;
        }
        return largest;
    }

    private RCOORD nextLargest(RCOORD cc, RCOORD largest) {
        RCOORD nLargest = null;
        while (cc != null) {
            if (nLargest == null && cc != largest) {
                nLargest = cc;
            } else if (nLargest != null && cc != largest && cc.total > nLargest.total) {
                nLargest = cc;
            }
            cc = cc.next;
        }
        return nLargest;
    }

    private void sumUp(PortInst pi, HashMap arcProtoUsage) {
        ArcProto[] possibleArcs = pi.getPortProto().getBasePort().getConnections();
        for (int i = 0; i < possibleArcs.length; ++i) {
            ArcProto ap = possibleArcs[i];
            if (ap.getTechnology() == Generic.tech) continue;
            GenMath.MutableInteger mi = (GenMath.MutableInteger)arcProtoUsage.get(ap);
            if (mi == null) {
                mi = new GenMath.MutableInteger(0);
                arcProtoUsage.put(ap, mi);
            }
            mi.increment();
        }
    }

    private void initialize() {
        this.rightP = null;
        this.leftP = null;
        this.toLine = Double.MIN_VALUE;
        this.fromLine = Double.MIN_VALUE;
        this.startRight = Double.MIN_VALUE;
        this.startLeft = Double.MIN_VALUE;
        this.height = Double.MIN_VALUE;
        this.routDirection = -1;
        this.xAxis = null;
        this.yAxis = null;
        RCOORD c = this.xAxis;
        while (c != null) {
            c.total = -1;
            c = c.next;
        }
        c = this.yAxis;
        while (c != null) {
            c.total = -1;
            c = c.next;
        }
        this.moveCell = null;
        this.moveCellValid = true;
    }

    private void addWire(List list, ArcInst ai, HashSet arcsSeen) {
        NodeInst ni;
        NodeInst ni2;
        if (!this.isInterestingArc(ai, arcsSeen)) {
            return;
        }
        arcsSeen.add(ai);
        ArcInst ae1 = ai;
        int e1 = 0;
        while (this.isUnroutedPin(ni2 = ae1.getPortInst(e1).getNodeInst())) {
            Connection con;
            ArcInst oAi = null;
            Iterator it = ni2.getConnections();
            while (it.hasNext() && arcsSeen.contains(oAi = (con = (Connection)it.next()).getArc())) {
                oAi = null;
            }
            if (oAi == null) break;
            arcsSeen.add(oAi);
            e1 = oAi.getPortInst(0).getNodeInst() == ni2 ? 1 : 0;
            ae1 = oAi;
        }
        ArcInst ae2 = ai;
        int e2 = 1;
        while (this.isUnroutedPin(ni = ae2.getPortInst(e2).getNodeInst())) {
            Connection con;
            ArcInst oAi = null;
            Iterator it = ni.getConnections();
            while (it.hasNext() && arcsSeen.contains(oAi = (con = (Connection)it.next()).getArc())) {
                oAi = null;
            }
            if (oAi == null) break;
            arcsSeen.add(oAi);
            e2 = oAi.getPortInst(0).getNodeInst() == ni ? 1 : 0;
            ae2 = oAi;
        }
        PortInst pi1 = ae1.getPortInst(e1);
        Poly poly1 = pi1.getPoly();
        double bx = poly1.getCenterX();
        double by = poly1.getCenterY();
        PortInst pi2 = ae2.getPortInst(e2);
        Poly poly2 = pi2.getPoly();
        double ex = poly2.getCenterX();
        double ey = poly2.getCenterY();
        RDESC rd = new RDESC(bx, by, 1, ex, ey, 3, ae1, e1, ae2, e2);
        list.add(rd);
        this.vote(rd.from.x, rd.from.y, rd.to.x, rd.to.y);
    }

    private void vote(double ffx, double ffy, double ttx, double tty) {
        this.xAxis = this.tallyVote(this.xAxis, ffx);
        this.yAxis = this.tallyVote(this.yAxis, ffy);
        this.xAxis = this.tallyVote(this.xAxis, ttx);
        this.yAxis = this.tallyVote(this.yAxis, tty);
    }

    private RCOORD tallyVote(RCOORD cc, double c) {
        if (cc == null) {
            cc = new RCOORD(c);
            cc.total = 1;
            return cc;
        }
        RCOORD ccInit = cc;
        RCOORD ccLast = null;
        while (cc != null && cc.total >= 0 && cc.val != c) {
            ccLast = cc;
            cc = cc.next;
        }
        if (cc == null) {
            cc = new RCOORD(c);
            ccLast.next = cc;
            cc.total = 1;
            return ccInit;
        }
        if (cc.total < 0) {
            cc.val = c;
            cc.total = 1;
        } else {
            cc.total++;
        }
        return ccInit;
    }

    private boolean isInterestingArc(ArcInst ai, HashSet arcsSeen) {
        if (arcsSeen.contains(ai)) {
            return false;
        }
        return ai.getProto() == Generic.tech.unrouted_arc;
    }

    private boolean isUnroutedPin(NodeInst ni) {
        return ni.getProto() == Generic.tech.unroutedPinNode || ni.getProto() == Generic.tech.universalPinNode;
    }

    private void makeTheGeometry(Cell cell) {
        RDESC q;
        Highlighter highlighter;
        WindowFrame wf = WindowFrame.getCurrentWindowFrame();
        if (wf != null && (highlighter = wf.getContent().getHighlighter()) != null) {
            highlighter.clear();
            highlighter.finished();
        }
        HashSet arcsToDelete = new HashSet();
        HashSet nodesToDelete = new HashSet();
        Iterator it = this.rightP.iterator();
        while (it.hasNext()) {
            q = (RDESC)it.next();
            this.makeGeometry(q, cell);
            this.markToBeDeleted(q.unroutedWire1, arcsToDelete, nodesToDelete);
            if (q.unroutedWire1 == q.unroutedWire2) continue;
            this.markToBeDeleted(q.unroutedWire2, arcsToDelete, nodesToDelete);
        }
        it = this.leftP.iterator();
        while (it.hasNext()) {
            q = (RDESC)it.next();
            this.makeGeometry(q, cell);
            this.markToBeDeleted(q.unroutedWire2, arcsToDelete, nodesToDelete);
            if (q.unroutedWire1 == q.unroutedWire2) continue;
            this.markToBeDeleted(q.unroutedWire2, arcsToDelete, nodesToDelete);
        }
        this.killWires(cell, arcsToDelete, nodesToDelete);
    }

    private void markToBeDeleted(ArcInst ai, HashSet arcsToDelete, HashSet nodesToDelete) {
        Connection con;
        Iterator it;
        ArcInst oAi;
        NodeInst ni;
        if (!this.isInterestingArc(ai, arcsToDelete)) {
            return;
        }
        this.setFlags(ai, arcsToDelete, nodesToDelete);
        ArcInst ae = ai;
        int e = 0;
        while (this.isUnroutedPin(ni = ae.getPortInst(e).getNodeInst())) {
            oAi = null;
            it = ni.getConnections();
            while (it.hasNext() && arcsToDelete.contains(oAi = (con = (Connection)it.next()).getArc())) {
                oAi = null;
            }
            if (oAi == null) break;
            this.setFlags(oAi, arcsToDelete, nodesToDelete);
            e = oAi.getPortInst(0).getNodeInst() == ae.getPortInst(e).getNodeInst() ? 1 : 0;
            ae = oAi;
        }
        ae = ai;
        e = 1;
        while (this.isUnroutedPin(ni = ae.getPortInst(e).getNodeInst())) {
            oAi = null;
            it = ni.getConnections();
            while (it.hasNext() && arcsToDelete.contains(oAi = (con = (Connection)it.next()).getArc())) {
                oAi = null;
            }
            if (oAi == null) break;
            this.setFlags(oAi, arcsToDelete, nodesToDelete);
            e = oAi.getPortInst(0).getNodeInst() == ae.getPortInst(e).getNodeInst() ? 1 : 0;
            ae = oAi;
        }
    }

    private void setFlags(ArcInst ai, HashSet arcsToDelete, HashSet nodesToDelete) {
        NodeInst niT;
        arcsToDelete.add(ai);
        NodeInst niH = ai.getHeadPortInst().getNodeInst();
        if (this.isUnroutedPin(niH)) {
            nodesToDelete.add(niH);
        }
        if (this.isUnroutedPin(niT = ai.getTailPortInst().getNodeInst())) {
            nodesToDelete.add(niT);
        }
    }

    private void killWires(Cell cell, HashSet arcsToDelete, HashSet nodesToDelete) {
        Iterator it = arcsToDelete.iterator();
        while (it.hasNext()) {
            ArcInst ai = (ArcInst)it.next();
            ai.kill();
        }
        it = nodesToDelete.iterator();
        while (it.hasNext()) {
            NodeInst ni = (NodeInst)it.next();
            if (!this.isUnroutedPin(ni)) continue;
            this.delNodeInst(ni);
        }
    }

    private void delNodeInst(NodeInst ni) {
        if (ni.getNumConnections() > 0) {
            return;
        }
        if (ni.getNumExports() > 0) {
            return;
        }
        ni.kill();
    }

    private void makeGeometry(RDESC rd, Cell cell) {
        RPATH path = rd.path;
        Poly poly1 = rd.unroutedWire1.getPortInst(rd.unroutedEnd1).getPoly();
        this.wireBoundLX = poly1.getCenterX();
        this.wireBoundLY = poly1.getCenterY();
        Poly poly2 = rd.unroutedWire2.getPortInst(rd.unroutedEnd2).getPoly();
        this.wireBoundHX = poly2.getCenterX();
        this.wireBoundHY = poly2.getCenterY();
        PrimitiveNode defNode = path.pathType.findPinProto();
        PortProto defPort = defNode.getPort(0);
        RPOINT prev = path.pathDesc;
        NodeInst prevNodeInst = this.theNode(rd, defNode, prev, cell);
        PortProto prevPort = this.thePort(defPort, rd, prev);
        PortInst prevPi = prevNodeInst.findPortInstFromProto(prevPort);
        RPOINT rp = prev.next;
        while (rp != null) {
            if (rp.next == null || (prev.x != rp.x || rp.x != rp.next.x) && (prev.y != rp.y || rp.y != rp.next.y)) {
                NodeInst rpNodeInst = this.theNode(rd, defNode, rp, cell);
                PortProto rpPort = this.thePort(defPort, rd, rp);
                PortInst rpPi = rpNodeInst.findPortInstFromProto(rpPort);
                ArcInst ai = ArcInst.makeInstance(path.pathType, path.width, prevPi, rpPi);
                prev = rp;
                prevPi = rpPi;
            }
            rp = rp.next;
        }
    }

    private NodeInst theNode(RDESC rd, NodeProto dn, RPOINT p, Cell cell) {
        if (p.x == this.wireBoundLX && p.y == this.wireBoundLY) {
            return rd.unroutedWire1.getPortInst(rd.unroutedEnd1).getNodeInst();
        }
        if (p.x == this.wireBoundHX && p.y == this.wireBoundHY) {
            return rd.unroutedWire2.getPortInst(rd.unroutedEnd2).getNodeInst();
        }
        double wid = dn.getDefWidth();
        double hei = dn.getDefHeight();
        NodeInst ni = NodeInst.makeInstance(dn, new Point2D.Double(p.x, p.y), wid, hei, cell);
        return ni;
    }

    private PortProto thePort(PortProto dp, RDESC rd, RPOINT p) {
        if (p.x == this.wireBoundLX && p.y == this.wireBoundLY) {
            return rd.unroutedWire1.getPortInst(rd.unroutedEnd1).getPortProto();
        }
        if (p.x == this.wireBoundHX && p.y == this.wireBoundHY) {
            return rd.unroutedWire2.getPortInst(rd.unroutedEnd2).getPortProto();
        }
        return dp;
    }

    private boolean moveInstance() {
        double ly;
        NodeInst ni = this.moveCell;
        if (!this.moveCellValid || ni == null) {
            System.out.println("River router: Cannot determine cell to move");
            return false;
        }
        double lx = this.routDirection == 1 ? this.height + ni.getAnchorCenterX() - this.toLine : ni.getAnchorCenterX();
        double d = ly = this.routDirection == 2 ? this.height + ni.getAnchorCenterY() - this.toLine : ni.getAnchorCenterY();
        if (lx == ni.getAnchorCenterX() && ly == ni.getAnchorCenterY()) {
            return true;
        }
        ni.modifyInstance(lx - ni.getAnchorCenterX(), ly - ni.getAnchorCenterY(), 0.0, 0.0, 0);
        return true;
    }

    private static class SortRDESC
    implements Comparator {
        private SortRDESC() {
        }

        public int compare(Object o1, Object o2) {
            RDESC r1 = (RDESC)o1;
            RDESC r2 = (RDESC)o2;
            if (r1.sortVal == r2.sortVal) {
                return 0;
            }
            if (r1.sortVal > r2.sortVal) {
                return 1;
            }
            return -1;
        }
    }

    private static class RiverRouteJob
    extends Job {
        private Cell cell;

        protected RiverRouteJob(Cell cell) {
            super("River Route", Routing.getRoutingTool(), Job.Type.CHANGE, null, null, Job.Priority.USER);
            this.cell = cell;
            this.startJob();
        }

        public boolean doIt() {
            River router = new River();
            router.river(this.cell);
            return true;
        }
    }

    static class RCOORD {
        private double val;
        private int total;
        private RCOORD next;

        RCOORD(double c) {
            this.val = c;
            this.total = 0;
            this.next = null;
        }
    }

    static class RDESC {
        private RPOINT from;
        private RPOINT to;
        private double sortVal;
        private ArcInst unroutedWire1;
        private ArcInst unroutedWire2;
        private int unroutedEnd1;
        private int unroutedEnd2;
        private RPATH path;

        RDESC(double fx, double fy, int fside, double sx, double sy, int sside, ArcInst ai1, int ae1, ArcInst ai2, int ae2) {
            this.from = new RPOINT(fx, fy, fside);
            this.to = new RPOINT(sx, sy, sside);
            this.unroutedWire1 = ai1;
            this.unroutedEnd1 = ae1;
            this.unroutedWire2 = ai2;
            this.unroutedEnd2 = ae2;
            this.path = null;
        }
    }

    static class RPATH {
        private double width;
        private ArcProto pathType;
        private RPOINT pathDesc;
        private RPOINT lastP;

        RPATH(double wid, ArcProto ptype) {
            this.width = wid;
            this.pathType = ptype;
            this.pathDesc = null;
            this.lastP = null;
        }
    }

    static class RPOINT {
        private static final int NOSIDE = -1;
        private static final int SIDE1 = 1;
        private static final int SIDE2 = 2;
        private static final int SIDE3 = 3;
        private static final int SIDE4 = 4;
        private int side;
        private double x;
        private double y;
        private double first;
        private double second;
        private RPOINT next;

        static String sideName(int side) {
            switch (side) {
                case 1: {
                    return "bottom";
                }
                case 2: {
                    return "right";
                }
                case 3: {
                    return "top";
                }
                case 4: {
                    return "left";
                }
            }
            return "unknown";
        }

        RPOINT(double xV, double yV, int s) {
            this.side = s;
            this.x = xV;
            this.y = yV;
            this.first = 0.0;
            this.second = 0.0;
            this.next = null;
        }

        RPOINT(RPATH rp, double fir, double sec, RPOINT next) {
            this.side = -1;
            this.x = 0.0;
            this.y = 0.0;
            this.first = fir;
            this.second = sec;
            this.next = next;
            if (next != null) {
                return;
            }
            rp.lastP = this;
        }
    }

    static class TRANSFORM {
        private double t11;
        private double t12;
        private double t21;
        private double t22;
        private double tx;
        private double ty;

        TRANSFORM(double t11, double t12, double t21, double t22, double tx, double ty) {
            this.t11 = t11;
            this.t12 = t12;
            this.t21 = t21;
            this.t22 = t22;
            this.tx = tx;
            this.ty = ty;
        }
    }
}

