/*
 * Decompiled with CFR 0.152.
 */
package com.sun.electric.tool.io.input;

import com.sun.electric.database.geometry.Poly;
import com.sun.electric.database.hierarchy.Cell;
import com.sun.electric.database.hierarchy.Export;
import com.sun.electric.database.hierarchy.Library;
import com.sun.electric.database.hierarchy.View;
import com.sun.electric.database.prototype.ArcProto;
import com.sun.electric.database.prototype.NodeProto;
import com.sun.electric.database.prototype.PortCharacteristic;
import com.sun.electric.database.prototype.PortOriginal;
import com.sun.electric.database.prototype.PortProto;
import com.sun.electric.database.text.Pref;
import com.sun.electric.database.text.TextUtils;
import com.sun.electric.database.text.Version;
import com.sun.electric.database.topology.ArcInst;
import com.sun.electric.database.topology.NodeInst;
import com.sun.electric.database.topology.PortInst;
import com.sun.electric.database.variable.ElectricObject;
import com.sun.electric.database.variable.TextDescriptor;
import com.sun.electric.database.variable.Variable;
import com.sun.electric.technology.PrimitiveArc;
import com.sun.electric.technology.PrimitiveNode;
import com.sun.electric.technology.PrimitivePort;
import com.sun.electric.technology.Technology;
import com.sun.electric.technology.technologies.Generic;
import com.sun.electric.tool.Tool;
import com.sun.electric.tool.io.FileType;
import com.sun.electric.tool.io.IOTool;
import com.sun.electric.tool.io.input.ELIB1;
import com.sun.electric.tool.io.input.Input;
import com.sun.electric.tool.io.input.LibraryFiles;
import com.sun.electric.tool.io.input.LibraryStatistics;
import com.sun.electric.tool.ncc.basic.TransitiveRelation;
import com.sun.electric.tool.user.ErrorLogger;
import java.awt.geom.AffineTransform;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.io.IOException;
import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Set;
import java.util.TreeSet;

public class LibraryContents {
    static final VariableContents[] NULL_VARS_ARRAY;
    private static List allLibraryContents;
    private static HashMap allCells;
    private LibraryFiles reader;
    private ELIB1.Header elibHeader;
    LinkedHashMap variableKeyRefs = new LinkedHashMap();
    private LinkedHashMap toolRefs = new LinkedHashMap();
    private LinkedHashMap viewRefs = new LinkedHashMap();
    private LinkedHashMap technologyRefs = new LinkedHashMap();
    private LinkedHashMap libraryRefs = new LinkedHashMap();
    private List cellContentses = new ArrayList();
    private List jelibCellGroups;
    LibraryRef myLibraryRef;
    private VariableContents[] vars;
    private VariableContents[] fakeVars;
    private int userBits;
    private HashMap cellGroups = new HashMap();
    private Version version;
    private int revision = 0;
    private boolean needDeclarations = false;
    private boolean needLibraryDeclarations = true;
    private boolean needLocalDeclarations = false;
    private CellContents currentCellContents;
    static final /* synthetic */ boolean $assertionsDisabled;

    LibraryContents(String name, LibraryFiles reader) {
        this.reader = reader;
        this.myLibraryRef = new LibraryRef(name, reader.filePath);
    }

    void setElibHeader(ELIB1.Header header) {
        this.elibHeader = header;
        this.needDeclarations = true;
        this.needLibraryDeclarations = false;
        this.needLocalDeclarations = true;
    }

    public static void initializeLibraryInput() {
        allLibraryContents = new ArrayList();
        allCells = new HashMap();
    }

    public static void terminateLibraryInput() {
        allLibraryContents = null;
        allCells = null;
    }

    LibraryRef getMyLibraryRef() {
        return this.myLibraryRef;
    }

    ToolRef newToolRef(String toolName) {
        ToolRef toolRef = (ToolRef)this.toolRefs.get(toolName);
        if (toolRef == null) {
            toolRef = new ToolRef(toolName);
        } else {
            this.logError("Tool " + toolRef.getFullName() + " declared twice");
        }
        return toolRef;
    }

    ToolRef getToolRef(String toolName) {
        ToolRef toolRef = (ToolRef)this.toolRefs.get(toolName);
        if (toolRef == null) {
            if (this.needDeclarations) {
                this.logError("Unknown tool: " + toolName);
            }
            toolRef = new ToolRef(toolName);
        }
        return toolRef;
    }

    ViewRef newViewRef(String viewName, String fullName) {
        ViewRef viewRef = (ViewRef)this.viewRefs.get(viewName);
        if (viewRef == null) {
            viewRef = new ViewRef(viewName, fullName);
        } else {
            this.logError("View " + viewRef.getFullName() + " declared twice");
        }
        return viewRef;
    }

    ViewRef getViewRef(String viewName) {
        ViewRef viewRef = (ViewRef)this.viewRefs.get(viewName);
        if (viewRef == null) {
            if (this.needDeclarations) {
                this.logError("Unknown view: " + viewName);
            }
            viewRef = new ViewRef(viewName, null);
        }
        return viewRef;
    }

    TechnologyRef newTechnologyRef(String techName) {
        TechnologyRef techRef = (TechnologyRef)this.technologyRefs.get(techName);
        if (techRef == null) {
            techRef = new TechnologyRef(techName);
        } else {
            this.logError("Technology " + techRef.getFullName() + " declared twice");
        }
        return techRef;
    }

    TechnologyRef getTechnologyRef(String techName) {
        TechnologyRef techRef = (TechnologyRef)this.technologyRefs.get(techName);
        if (techRef == null) {
            if (this.needDeclarations) {
                this.logError("Unknown technology: " + techName);
            }
            techRef = new TechnologyRef(techName);
        }
        return techRef;
    }

    LibraryRef newLibraryRef(String libName, String fileName) {
        LibraryRef libRef = (LibraryRef)this.libraryRefs.get(libName);
        if (libRef == null) {
            libRef = new LibraryRef(libName, fileName);
        } else {
            this.logError("External library " + libRef.getFullName() + " declared twice");
        }
        return libRef;
    }

    LibraryRef getLibraryRef(String libName) {
        LibraryRef libRef = (LibraryRef)this.libraryRefs.get(libName);
        if (libRef == null) {
            if (this.needLibraryDeclarations) {
                this.logError("Unknown library: " + libName);
            }
            libRef = new LibraryRef(libName, null);
        }
        return libRef;
    }

    PrimitiveNodeRef getPrimitiveNodeRef(TechnologyRef techRef, String name) {
        int colonPos = name.indexOf(58);
        if (colonPos >= 0) {
            String techName = name.substring(0, colonPos);
            techRef = this.getTechnologyRef(techName);
            name = name.substring(colonPos + 1);
        } else if (techRef == null) {
            this.logError("Badly formed PrimitiveNode (missing colon): " + name);
            techRef = this.getTechnologyRef("");
        }
        return techRef.getPrimitiveNodeRef(name);
    }

    ArcProtoRef getArcProtoRef(TechnologyRef techRef, String name) {
        int colonPos = name.indexOf(58);
        if (colonPos >= 0) {
            String techName = name.substring(0, colonPos);
            techRef = this.getTechnologyRef(techName);
            name = name.substring(colonPos + 1);
        } else if (techRef == null) {
            this.logError("Badly formed ArcProto (missing colon): " + name);
            techRef = this.getTechnologyRef("");
        }
        return techRef.getArcProtoRef(name);
    }

    CellContents newCellContents(String cellName, long creationDate, long revisionDate) {
        return this.myLibraryRef.newCellContents(cellName, creationDate, revisionDate);
    }

    CellRef getCellRef(String name) {
        int colonPos = name.indexOf(58);
        LibraryRef libRef = this.myLibraryRef;
        if (colonPos >= 0) {
            String libName = name.substring(0, colonPos);
            libRef = this.getLibraryRef(libName);
            name = name.substring(colonPos + 1);
        }
        return libRef.getCellRef(name);
    }

    VariableKeyRef newVariableKeyRef(String varName) {
        VariableKeyRef variableKeyRef = (VariableKeyRef)this.variableKeyRefs.get(varName);
        if (variableKeyRef == null) {
            variableKeyRef = new VariableKeyRef(varName);
        } else {
            this.logError("Variable key \"" + variableKeyRef.getName() + "\" declared twice");
        }
        return variableKeyRef;
    }

    VariableKeyRef getVariableKeyRef(String varName) {
        VariableKeyRef variableKeyRef = (VariableKeyRef)this.variableKeyRefs.get(varName);
        if (variableKeyRef == null) {
            variableKeyRef = new VariableKeyRef(varName);
        }
        return variableKeyRef;
    }

    VariableContents newVariableContents(VariableKeyRef variableKeyRef, String varBits, char type, Object value) {
        return new VariableContents(variableKeyRef, varBits, type, value);
    }

    void setVars(VariableContents[] vars) {
        this.vars = vars;
    }

    void addVars(VariableContents[] vars) {
        this.vars = this.addVars(this.vars, vars);
    }

    void addFakeVars(VariableContents[] vars) {
        this.fakeVars = this.addVars(this.fakeVars, vars);
    }

    private VariableContents[] addVars(VariableContents[] a, VariableContents[] b) {
        if (b == null) {
            return a;
        }
        block0: for (int i = 0; i < b.length; ++i) {
            int j;
            VariableContents v = b[i];
            if (v == null) continue;
            if (a == null) {
                a = new VariableContents[]{new VariableContents(this.getVariableKeyRef(v.variableKeyRef.getName()), v.varBits, v.type, v.value)};
                continue;
            }
            String vs = v.variableKeyRef.getName();
            int low = 0;
            int high = a.length - 1;
            while (low <= high) {
                int mid = low + high >> 1;
                VariableContents midVal = a[mid];
                int cmp = midVal.variableKeyRef.getName().compareTo(vs);
                if (cmp < 0) {
                    low = mid + 1;
                    continue;
                }
                if (cmp <= 0) continue block0;
                high = mid - 1;
            }
            VariableContents[] newA = new VariableContents[a.length + 1];
            for (j = 0; j < low; ++j) {
                newA[j] = a[j];
            }
            newA[low] = new VariableContents(this.getVariableKeyRef(v.variableKeyRef.getName()), v.varBits, v.type, v.value);
            for (j = low; j < a.length; ++j) {
                newA[j + 1] = a[j];
            }
            a = newA;
        }
        return a;
    }

    void setVersion(Version version) {
        this.version = version;
    }

    Version getVersion() {
        return this.version;
    }

    void setUserBits(int userBits) {
        this.userBits = userBits;
    }

    void addCellGroup(CellRef[] cellList) {
        if (this.jelibCellGroups == null) {
            this.jelibCellGroups = new ArrayList();
        }
        this.jelibCellGroups.add(cellList);
    }

    List checkTheLibrary(Library lib, boolean topLevelLibrary) throws IOException {
        Object group;
        CellRef cellRef;
        Iterator cit;
        LibraryRef libRef;
        Iterator lit = this.libraryRefs.values().iterator();
        while (lit.hasNext()) {
            libRef = (LibraryRef)lit.next();
            if (libRef.fileName == null || libRef.fileName.equals("")) {
                this.logError("Undeclared library " + libRef.getName());
                return null;
            }
            if (libRef == this.myLibraryRef) continue;
            cit = libRef.cells.values().iterator();
            while (cit.hasNext()) {
                cellRef = (CellRef)cit.next();
            }
        }
        allLibraryContents.add(this);
        this.myLibraryRef.lib = lib;
        lib.erase();
        this.addVariables(lib, this.vars);
        lib.setVersion(this.version);
        Iterator it = this.toolRefs.values().iterator();
        while (it.hasNext()) {
            ToolRef toolRef = (ToolRef)it.next();
            Tool tool = Tool.findTool(toolRef.getName());
            if (tool == null) {
                this.logError("Cannot identify tool " + toolRef.getName());
                continue;
            }
            if (!topLevelLibrary) continue;
            toolRef.addMeaningPrefs();
        }
        it = this.viewRefs.values().iterator();
        while (it.hasNext()) {
            ViewRef viewRef = (ViewRef)it.next();
            View view = View.findView(viewRef.getName());
            if (view != null || (view = View.newInstance(viewRef.getName(), viewRef.fullName)) != null) continue;
            this.logError("Cannot create view " + viewRef.getName());
        }
        Iterator tit = this.technologyRefs.values().iterator();
        while (tit.hasNext()) {
            TechnologyRef techRef = (TechnologyRef)tit.next();
            Technology tech = Technology.findTechnology(techRef.getName());
            if (tech == null) {
                this.logError("Cannot identify technology " + techRef.getName());
                continue;
            }
            if (topLevelLibrary) {
                techRef.addMeaningPrefs();
            }
            Iterator nit = techRef.primitiveNodes.values().iterator();
            while (nit.hasNext()) {
                PrimitiveNodeRef pnRef = (PrimitiveNodeRef)nit.next();
                PrimitiveNode pn = tech.findNodeProto(pnRef.getName());
                if (pn == null) {
                    this.logError("Cannot identify primitive node " + pnRef.getName());
                    continue;
                }
                Iterator pit = pnRef.getPorts();
                while (pit.hasNext()) {
                    PrimitivePortRef ppRef = (PrimitivePortRef)pit.next();
                    PrimitivePort pp = (PrimitivePort)pn.findPortProto(ppRef.getName());
                    if (pp != null) continue;
                    this.logError("Cannot identify primitive port " + ppRef.getName());
                }
            }
            Iterator ait = techRef.arcProtos.values().iterator();
            while (ait.hasNext()) {
                ArcProtoRef apRef = (ArcProtoRef)ait.next();
                PrimitiveArc ap = tech.findArcProto(apRef.getName());
                if (ap != null) continue;
                this.logError("Cannot identify primitive arc " + apRef.getName());
            }
        }
        lit = this.libraryRefs.values().iterator();
        while (lit.hasNext()) {
            libRef = (LibraryRef)lit.next();
            if (libRef == this.myLibraryRef) continue;
            libRef.lib = this.reader.readExternalLibraryFromFilename(libRef.fileName, FileType.JELIB);
            if (!$assertionsDisabled && libRef.lib == null) {
                throw new AssertionError();
            }
            cit = libRef.cells.values().iterator();
            while (cit.hasNext()) {
                cellRef = (CellRef)cit.next();
                CellContents cc = cellRef.cc;
            }
        }
        Iterator cit2 = this.myLibraryRef.cells.values().iterator();
        while (cit2.hasNext()) {
            CellRef cellRef2 = (CellRef)cit2.next();
            CellContents cc = cellRef2.cc;
            if (cc == null) continue;
            allCells.put(cellRef2.getFullName(), cc);
        }
        TransitiveRelation transitive = new TransitiveRelation();
        HashMap<String, String> protoNames = new HashMap<String, String>();
        cit = this.myLibraryRef.cells.values().iterator();
        while (cit.hasNext()) {
            cellRef = (CellRef)cit.next();
            String protoName = (String)protoNames.get(cellRef.protoName);
            if (protoName == null) {
                protoName = cellRef.protoName;
                protoNames.put(protoName, protoName);
            }
            transitive.theseAreRelated(cellRef, protoName);
            CellRef otherCellRef = cellRef.nextInGroup;
            if (otherCellRef == null || otherCellRef.isExternal()) continue;
            transitive.theseAreRelated(cellRef, otherCellRef);
        }
        Iterator git = this.jelibCellGroups.iterator();
        while (git.hasNext()) {
            group = (CellRef[])git.next();
            Object firstCell = null;
            for (int i = 0; i < ((CellRef[])group).length; ++i) {
                if (group[i] == null) continue;
                if (firstCell == null) {
                    firstCell = group[i];
                    continue;
                }
                transitive.theseAreRelated(firstCell, group[i]);
            }
        }
        git = transitive.getSetsOfRelatives();
        while (git.hasNext()) {
            group = (Set)git.next();
            Cell.CellGroup cg = new Cell.CellGroup();
            Iterator it2 = group.iterator();
            while (it2.hasNext()) {
                CellRef cellRef3;
                Object o = it2.next();
                if (!(o instanceof CellRef) || (cellRef3 = (CellRef)o).cc == null) continue;
                this.cellGroups.put(cellRef3.cc, cg);
            }
        }
        for (int i = 0; i < this.cellContentses.size(); ++i) {
            CellContents cc = (CellContents)this.cellContentses.get(i);
            cc.allocateCell();
        }
        lib.clearChangedMajor();
        lib.clearChangedMinor();
        lib.setFromDisk();
        return this.cellContentses;
    }

    void instantiateCellContents() {
        CellContents cc;
        CellRef cellRef;
        Iterator cit;
        LibraryContents libraryContents;
        System.out.println("Creating the circuitry...");
        int numToProcess = 0;
        Iterator lit = allLibraryContents.iterator();
        while (lit.hasNext()) {
            libraryContents = (LibraryContents)lit.next();
            cit = libraryContents.myLibraryRef.cells.values().iterator();
            while (cit.hasNext()) {
                cellRef = (CellRef)cit.next();
                cc = cellRef.cc;
                if (cc == null) continue;
                numToProcess += cc.size();
            }
        }
        this.setupProgress(numToProcess);
        lit = allLibraryContents.iterator();
        while (lit.hasNext()) {
            libraryContents = (LibraryContents)lit.next();
            cit = libraryContents.myLibraryRef.cells.values().iterator();
            while (cit.hasNext()) {
                cellRef = (CellRef)cit.next();
                cc = cellRef.cc;
                if (cc == null) continue;
                cc.instantiate();
            }
        }
        allLibraryContents = null;
        allCells = null;
    }

    private void setLineNumber(int lineNumber) {
        this.reader.setLineNumber(lineNumber);
    }

    private ErrorLogger.MessageLog logError(String message) {
        return this.reader.logError(message);
    }

    private ErrorLogger.MessageLog logWarning(String message) {
        return this.reader.logWarning(message);
    }

    private void setupProgress(int numToProcess) {
    }

    private void showProgress(int lineNumber) {
    }

    private void addVariables(ElectricObject eObj, VariableContents[] vars) {
        if (vars == null) {
            return;
        }
        for (int i = 0; i < vars.length; ++i) {
            if (vars[i] == null) continue;
            vars[i].addVariable(eObj);
        }
    }

    void addMeaningPrefs(Object obj, VariableContents[] vars) {
        if (vars == null) {
            return;
        }
        for (int i = 0; i < vars.length; ++i) {
            if (vars[i] == null) continue;
            vars[i].addMeaningPref(obj);
        }
    }

    private void loadTextDescriptor(TextDescriptor td, Variable var, String varBits) {
        double xoff = 0.0;
        double yoff = 0.0;
        block31: for (int j = 0; j < varBits.length(); ++j) {
            char varBit = varBits.charAt(j);
            switch (varBit) {
                case 'D': {
                    if (var != null) {
                        var.setDisplay(true);
                    }
                    if (++j >= varBits.length()) {
                        this.logError("Incorrect display specification: " + varBits);
                        continue block31;
                    }
                    switch (varBits.charAt(j)) {
                        case '5': {
                            td.setPos(TextDescriptor.Position.CENT);
                            break;
                        }
                        case '8': {
                            td.setPos(TextDescriptor.Position.UP);
                            break;
                        }
                        case '2': {
                            td.setPos(TextDescriptor.Position.DOWN);
                            break;
                        }
                        case '4': {
                            td.setPos(TextDescriptor.Position.LEFT);
                            break;
                        }
                        case '6': {
                            td.setPos(TextDescriptor.Position.RIGHT);
                            break;
                        }
                        case '7': {
                            td.setPos(TextDescriptor.Position.UPLEFT);
                            break;
                        }
                        case '9': {
                            td.setPos(TextDescriptor.Position.UPRIGHT);
                            break;
                        }
                        case '1': {
                            td.setPos(TextDescriptor.Position.DOWNLEFT);
                            break;
                        }
                        case '3': {
                            td.setPos(TextDescriptor.Position.DOWNRIGHT);
                            break;
                        }
                        case '0': {
                            td.setPos(TextDescriptor.Position.BOXED);
                        }
                    }
                    continue block31;
                }
                case 'N': {
                    td.setDispPart(TextDescriptor.DispPos.NAMEVALUE);
                    continue block31;
                }
                case 'A': {
                    int semiPos = varBits.indexOf(59, j);
                    if (semiPos < 0) {
                        this.logError("Bad absolute size (semicolon missing): " + varBits);
                        continue block31;
                    }
                    td.setAbsSize(TextUtils.atoi(varBits.substring(j + 1, semiPos)));
                    j = semiPos;
                    continue block31;
                }
                case 'G': {
                    int semiPos = varBits.indexOf(59, j);
                    if (semiPos < 0) {
                        this.logError("Bad relative size (semicolon missing): " + varBits);
                        continue block31;
                    }
                    td.setRelSize(TextUtils.atof(varBits.substring(j + 1, semiPos)));
                    j = semiPos;
                    continue block31;
                }
                case 'X': {
                    int semiPos = varBits.indexOf(59, j);
                    if (semiPos < 0) {
                        this.logError("Bad X offset (semicolon missing): " + varBits);
                        continue block31;
                    }
                    xoff = TextUtils.atof(varBits.substring(j + 1, semiPos));
                    j = semiPos;
                    continue block31;
                }
                case 'Y': {
                    int semiPos = varBits.indexOf(59, j);
                    if (semiPos < 0) {
                        this.logError("Bad Y offset (semicolon missing): " + varBits);
                        continue block31;
                    }
                    yoff = TextUtils.atof(varBits.substring(j + 1, semiPos));
                    j = semiPos;
                    continue block31;
                }
                case 'B': {
                    td.setBold(true);
                    continue block31;
                }
                case 'I': {
                    td.setItalic(true);
                    continue block31;
                }
                case 'L': {
                    td.setUnderline(true);
                    continue block31;
                }
                case 'F': {
                    int semiPos = varBits.indexOf(59, j);
                    if (semiPos < 0) {
                        this.logError("Bad font (semicolon missing): " + varBits);
                        continue block31;
                    }
                    TextDescriptor.ActiveFont af = TextDescriptor.ActiveFont.findActiveFont(varBits.substring(j + 1, semiPos));
                    td.setFace(af.getIndex());
                    j = semiPos;
                    continue block31;
                }
                case 'C': {
                    int semiPos = varBits.indexOf(59, j);
                    if (semiPos < 0) {
                        this.logError("Bad color (semicolon missing): " + varBits);
                        continue block31;
                    }
                    td.setColorIndex(TextUtils.atoi(varBits.substring(j + 1, semiPos)));
                    j = semiPos;
                    continue block31;
                }
                case 'R': {
                    TextDescriptor.Rotation rot = TextDescriptor.Rotation.ROT90;
                    if (j + 1 < varBits.length() && varBits.charAt(j + 1) == 'R') {
                        rot = TextDescriptor.Rotation.ROT180;
                        ++j;
                    }
                    if (j + 1 < varBits.length() && varBits.charAt(j + 1) == 'R') {
                        rot = TextDescriptor.Rotation.ROT270;
                        ++j;
                    }
                    td.setRotation(rot);
                    continue block31;
                }
                case 'H': {
                    td.setInherit(true);
                    continue block31;
                }
                case 'T': {
                    td.setInterior(true);
                    continue block31;
                }
                case 'P': {
                    td.setParam(true);
                    continue block31;
                }
                case 'O': {
                    if (++j >= varBits.length()) {
                        this.logError("Bad language specification: " + varBits);
                        continue block31;
                    }
                    char codeLetter = varBits.charAt(j);
                    if (var == null) {
                        this.logError("Illegal use of language specification: " + varBits);
                        continue block31;
                    }
                    if (codeLetter == 'J') {
                        var.setCode(Variable.Code.JAVA);
                        continue block31;
                    }
                    if (codeLetter == 'L') {
                        var.setCode(Variable.Code.LISP);
                        continue block31;
                    }
                    if (codeLetter == 'T') {
                        var.setCode(Variable.Code.TCL);
                        continue block31;
                    }
                    this.logError("Unknown language specification: " + varBits);
                    continue block31;
                }
                case 'U': {
                    if (++j >= varBits.length()) {
                        this.logError("Bad units specification: " + varBits);
                        continue block31;
                    }
                    char unitsLetter = varBits.charAt(j);
                    if (unitsLetter == 'R') {
                        td.setUnit(TextDescriptor.Unit.RESISTANCE);
                        continue block31;
                    }
                    if (unitsLetter == 'C') {
                        td.setUnit(TextDescriptor.Unit.CAPACITANCE);
                        continue block31;
                    }
                    if (unitsLetter == 'I') {
                        td.setUnit(TextDescriptor.Unit.INDUCTANCE);
                        continue block31;
                    }
                    if (unitsLetter == 'A') {
                        td.setUnit(TextDescriptor.Unit.CURRENT);
                        continue block31;
                    }
                    if (unitsLetter == 'V') {
                        td.setUnit(TextDescriptor.Unit.VOLTAGE);
                        continue block31;
                    }
                    if (unitsLetter == 'D') {
                        td.setUnit(TextDescriptor.Unit.DISTANCE);
                        continue block31;
                    }
                    if (unitsLetter == 'T') {
                        td.setUnit(TextDescriptor.Unit.TIME);
                        continue block31;
                    }
                    this.logError("Unknown units specification: " + varBits);
                }
            }
        }
        td.setOff(xoff, yoff);
    }

    void fillStat(LibraryStatistics.FileContents fc, LibraryContents total) {
        Iterator tit = this.toolRefs.values().iterator();
        while (tit.hasNext()) {
            ToolRef toolRef = (ToolRef)tit.next();
            ++fc.toolCount;
            fc.nameLength += toolRef.getName().length();
            ToolRef totalToolRef = total.getToolRef(toolRef.getName());
            totalToolRef.addVars(toolRef.vars);
        }
        tit = this.technologyRefs.values().iterator();
        while (tit.hasNext()) {
            TechnologyRef technologyRef = (TechnologyRef)tit.next();
            ++fc.techCount;
            fc.nameLength += technologyRef.getName().length();
            TechnologyRef totalTechnologyRef = total.getTechnologyRef(technologyRef.getName());
            totalTechnologyRef.addVars(technologyRef.vars);
            Iterator nit = technologyRef.primitiveNodes.values().iterator();
            while (nit.hasNext()) {
                PrimitiveNodeRef primitiveNodeRef = (PrimitiveNodeRef)nit.next();
                ++fc.primNodeProtoCount;
                fc.nameLength += primitiveNodeRef.getName().length();
                PrimitiveNodeRef totalPrimitiveNodeRef = totalTechnologyRef.getPrimitiveNodeRef(primitiveNodeRef.getName());
                totalPrimitiveNodeRef.addVars(primitiveNodeRef.vars);
                Iterator pit = primitiveNodeRef.getPorts();
                while (pit.hasNext()) {
                    PrimitivePortRef primitivePortRef = (PrimitivePortRef)pit.next();
                    ++fc.primPortProtoCount;
                    fc.nameLength += primitivePortRef.getName().length();
                    PrimitivePortRef totalPrimitivePortRef = (PrimitivePortRef)totalPrimitiveNodeRef.getPortProtoRef(primitivePortRef.getName());
                    totalPrimitivePortRef.addVars(primitivePortRef.vars);
                }
            }
            Iterator ait = technologyRef.arcProtos.values().iterator();
            while (ait.hasNext()) {
                ArcProtoRef arcProtoRef = (ArcProtoRef)ait.next();
                ++fc.arcProtoCount;
                fc.nameLength += arcProtoRef.getName().length();
                ArcProtoRef totalArcProtoRef = totalTechnologyRef.getArcProtoRef(arcProtoRef.getName());
                totalArcProtoRef.addVars(arcProtoRef.vars);
            }
        }
        Iterator vit = this.viewRefs.values().iterator();
        while (vit.hasNext()) {
            ViewRef viewRef = (ViewRef)vit.next();
            ++fc.viewCount;
            fc.nameLength += viewRef.getName().length();
            fc.nameLength += viewRef.fullName.length();
            ViewRef totalViewRef = total.getViewRef(viewRef.getName());
            totalViewRef.addVars(viewRef.vars);
        }
        vit = this.variableKeyRefs.values().iterator();
        while (vit.hasNext()) {
            VariableKeyRef variableKeyRef = (VariableKeyRef)vit.next();
            ++fc.varNameCount;
            fc.varNameLength += variableKeyRef.getName().length();
            total.getVariableKeyRef(variableKeyRef.getName());
        }
        fc.userBits |= this.userBits;
        total.userBits |= this.userBits;
        total.addVars(this.vars);
        total.addFakeVars(this.fakeVars);
    }

    void printJelib(PrintWriter out) {
        int i;
        Iterator it;
        out.print("# header information:");
        if (this.elibHeader != null) {
            out.print(" " + this.elibHeader);
        }
        if (this.userBits != 0) {
            out.print(" " + this.userBits);
        }
        out.println();
        out.print("H" + LibraryContents.convertJelibString(this.myLibraryRef.getName()) + "|" + this.version);
        LibraryContents.printJelibVars(out, this.vars);
        out.println();
        if (this.fakeVars != null) {
            out.print("# ");
            LibraryContents.printJelibVars(out, this.vars);
            out.println();
        }
        if (this.viewRefs.size() > 0) {
            out.println();
            out.println("# Views:");
            it = this.viewRefs.values().iterator();
            while (it.hasNext()) {
                ViewRef viewRef = (ViewRef)it.next();
                viewRef.printJelib(out);
            }
        }
        if (this.libraryRefs.size() > 1) {
            out.println();
            out.println("# External Libraries and cells:");
            it = this.libraryRefs.values().iterator();
            while (it.hasNext()) {
                LibraryRef libraryRef = (LibraryRef)it.next();
                if (libraryRef == this.myLibraryRef) continue;
                libraryRef.printJelib(out);
            }
        }
        if (this.toolRefs.size() > 0) {
            out.println();
            out.println("# Tools:");
            it = this.toolRefs.values().iterator();
            while (it.hasNext()) {
                ToolRef toolRef = (ToolRef)it.next();
                toolRef.printJelib(out);
            }
        }
        it = this.technologyRefs.values().iterator();
        while (it.hasNext()) {
            TechnologyRef technologyRef = (TechnologyRef)it.next();
            technologyRef.printJelib(out);
        }
        for (i = 0; i < this.cellContentses.size(); ++i) {
            CellContents cc = (CellContents)this.cellContentses.get(i);
            cc.printJelib(out);
        }
        if (this.jelibCellGroups != null) {
            out.println();
            out.println("# Groups:");
            for (i = 0; i < this.jelibCellGroups.size(); ++i) {
                CellRef[] group = (CellRef[])this.jelibCellGroups.get(i);
                out.print("G");
                for (int j = 0; j < group.length; ++j) {
                    if (j > 0) {
                        out.print("|");
                    }
                    if (group[j] == null) continue;
                    out.print(group[j].getFullName());
                }
                out.println();
            }
        }
    }

    private static void printJelibVars(PrintWriter out, VariableContents[] vars) {
        if (vars == null) {
            return;
        }
        for (int i = 0; i < vars.length; ++i) {
            if (vars[i] == null) continue;
            vars[i].printJelib(out);
        }
    }

    void printJelibVariableNames(PrintWriter out) {
        TreeSet sortedName = new TreeSet(this.variableKeyRefs.keySet());
        Iterator it = sortedName.iterator();
        while (it.hasNext()) {
            String s = (String)it.next();
            out.println(this.convertToJavaString(s));
        }
    }

    String convertToJavaString(String s) {
        int i;
        for (i = 0; i < s.length() && s.charAt(i) >= ' ' && s.charAt(i) != '\\'; ++i) {
        }
        if (i == s.length()) {
            return s;
        }
        String s1 = s.substring(0, i);
        while (i < s.length()) {
            char c = s.charAt(i);
            if (c == '\\') {
                s1 = s1 + "\\\\";
            } else if (c < ' ') {
                String s2 = Integer.toOctalString(c);
                while (s2.length() < 3) {
                    s2 = "0" + s2;
                }
                s1 = s1 + "\\" + s2;
            } else {
                s1 = s1 + c;
            }
            ++i;
        }
        return s1;
    }

    private String describeJelibDescriptor(Variable var, TextDescriptor td) {
        TextDescriptor.Unit unit;
        StringBuffer ret = new StringBuffer();
        boolean display = false;
        if (var == null || var.isDisplay()) {
            display = true;
        }
        if (display) {
            int color;
            TextDescriptor.Size size = td.getSize();
            if (size.isAbsolute()) {
                ret.append("A" + (int)size.getSize() + ";");
            }
            if (td.isBold()) {
                ret.append("B");
            }
            if ((color = td.getColorIndex()) != 0) {
                ret.append("C" + color + ";");
            }
            ret.append("D");
            TextDescriptor.Position pos = td.getPos();
            if (pos == TextDescriptor.Position.UP) {
                ret.append("8");
            } else if (pos == TextDescriptor.Position.DOWN) {
                ret.append("2");
            } else if (pos == TextDescriptor.Position.LEFT) {
                ret.append("4");
            } else if (pos == TextDescriptor.Position.RIGHT) {
                ret.append("6");
            } else if (pos == TextDescriptor.Position.UPLEFT) {
                ret.append("7");
            } else if (pos == TextDescriptor.Position.UPRIGHT) {
                ret.append("9");
            } else if (pos == TextDescriptor.Position.DOWNLEFT) {
                ret.append("1");
            } else if (pos == TextDescriptor.Position.DOWNRIGHT) {
                ret.append("3");
            } else if (pos == TextDescriptor.Position.BOXED) {
                ret.append("0");
            } else {
                ret.append("5");
            }
            int font = td.getFace();
            if (font != 0) {
                TextDescriptor.ActiveFont af = TextDescriptor.ActiveFont.findActiveFont(font);
                ret.append("F" + LibraryContents.convertJelibString(af.toString()) + ";");
            }
            if (!size.isAbsolute()) {
                ret.append("G" + TextUtils.formatDouble(size.getSize()) + ";");
            }
        }
        if (td.isInherit()) {
            ret.append("H");
        }
        if (display) {
            TextDescriptor.DispPos dispPos;
            if (td.isItalic()) {
                ret.append("I");
            }
            if (td.isUnderline()) {
                ret.append("L");
            }
            if ((dispPos = td.getDispPart()) == TextDescriptor.DispPos.NAMEVALUE) {
                ret.append("N");
            }
        }
        if (var != null && var.isCode()) {
            Variable.Code codeType = var.getCode();
            if (codeType == Variable.Code.JAVA) {
                ret.append("OJ");
            } else if (codeType == Variable.Code.LISP) {
                ret.append("OL");
            } else if (codeType == Variable.Code.TCL) {
                ret.append("OT");
            }
        }
        if (td.isParam()) {
            ret.append("P");
        }
        if (display) {
            TextDescriptor.Rotation rot = td.getRotation();
            if (rot == TextDescriptor.Rotation.ROT90) {
                ret.append("R");
            } else if (rot == TextDescriptor.Rotation.ROT180) {
                ret.append("RR");
            } else if (rot == TextDescriptor.Rotation.ROT270) {
                ret.append("RRR");
            }
        }
        if (td.isInterior()) {
            ret.append("T");
        }
        if ((unit = td.getUnit()) == TextDescriptor.Unit.RESISTANCE) {
            ret.append("UR");
        } else if (unit == TextDescriptor.Unit.CAPACITANCE) {
            ret.append("UC");
        } else if (unit == TextDescriptor.Unit.INDUCTANCE) {
            ret.append("UI");
        } else if (unit == TextDescriptor.Unit.CURRENT) {
            ret.append("UA");
        } else if (unit == TextDescriptor.Unit.VOLTAGE) {
            ret.append("UV");
        } else if (unit == TextDescriptor.Unit.DISTANCE) {
            ret.append("UD");
        } else if (unit == TextDescriptor.Unit.TIME) {
            ret.append("UT");
        }
        if (display) {
            double offY;
            double offX = td.getXOff();
            if (offX != 0.0) {
                ret.append("X" + TextUtils.formatDouble(offX, 0) + ";");
            }
            if ((offY = td.getYOff()) != 0.0) {
                ret.append("Y" + TextUtils.formatDouble(offY, 0) + ";");
            }
        }
        return ret.toString();
    }

    private static String convertJelibString(String str) {
        StringBuffer infstr = new StringBuffer();
        int len = str.length();
        for (int i = 0; i < len; ++i) {
            char ch = str.charAt(i);
            if (ch == '\n') {
                ch = ' ';
            }
            if (ch == '|' || ch == '^' || ch == '\"') {
                infstr.append('^');
            }
            infstr.append(ch);
        }
        return infstr.toString();
    }

    private static String convertJelibQuotedString(String str) {
        StringBuffer infstr = new StringBuffer();
        int len = str.length();
        for (int i = 0; i < len; ++i) {
            char ch = str.charAt(i);
            if (ch == '\n') {
                infstr.append("^\\n");
                continue;
            }
            if (ch == '\"' || ch == '^') {
                infstr.append('^');
            }
            infstr.append(ch);
        }
        return infstr.toString();
    }

    private static String convertJelibVariableName(String str) {
        StringBuffer infstr = new StringBuffer();
        int len = str.length();
        for (int i = 0; i < len; ++i) {
            char ch = str.charAt(i);
            if (ch == '\n') {
                ch = ' ';
            }
            if (ch == '|' || ch == '^' || ch == '\"' || ch == '(') {
                infstr.append('^');
            }
            infstr.append(ch);
        }
        return infstr.toString();
    }

    private static String jelibDouble(double x) {
        int i = (int)x;
        if ((double)i == x) {
            return i == 0 && 1.0 / x < 0.0 ? "-0" : Integer.toString(i);
        }
        return Double.toString(x);
    }

    static {
        $assertionsDisabled = !LibraryContents.class.desiredAssertionStatus();
        NULL_VARS_ARRAY = new VariableContents[0];
    }

    class VariableKeyRef
    extends ObjectRef {
        Variable.Key variableKey;

        VariableKeyRef(String name) {
            super(name);
            LibraryContents.this.variableKeyRefs.put(name, this);
        }

        Variable.Key getVariableKey() {
            if (this.variableKey == null) {
                this.variableKey = ElectricObject.newKey(this.getName());
            }
            return this.variableKey;
        }
    }

    class VariableContents {
        VariableKeyRef variableKeyRef;
        String varBits;
        char type;
        Object value;

        VariableContents(VariableKeyRef variableKeyRef, String varBits, char type, Object value) {
            this.variableKeyRef = variableKeyRef;
            this.varBits = varBits;
            this.type = type;
            this.value = value;
        }

        private void addVariable(ElectricObject eObj) {
            if (eObj == null) {
                return;
            }
            Variable.Key varKey = this.variableKeyRef.getVariableKey();
            if (eObj.isDeprecatedVariable(varKey)) {
                return;
            }
            Object[] obj = null;
            if (this.value instanceof Object[]) {
                Object[] objList = (Object[])this.value;
                int limit = objList.length;
                Object[] objArray = null;
                switch (this.type) {
                    case 'B': {
                        objArray = new Boolean[limit];
                        break;
                    }
                    case 'C': {
                        objArray = new Cell[limit];
                        break;
                    }
                    case 'D': {
                        objArray = new Double[limit];
                        break;
                    }
                    case 'E': {
                        objArray = new Export[limit];
                        break;
                    }
                    case 'F': {
                        objArray = new Float[limit];
                        break;
                    }
                    case 'G': {
                        objArray = new Long[limit];
                        break;
                    }
                    case 'H': {
                        objArray = new Short[limit];
                        break;
                    }
                    case 'I': {
                        objArray = new Integer[limit];
                        break;
                    }
                    case 'L': {
                        objArray = new Library[limit];
                        break;
                    }
                    case 'O': {
                        objArray = new Tool[limit];
                        break;
                    }
                    case 'P': {
                        objArray = new PrimitiveNode[limit];
                        break;
                    }
                    case 'R': {
                        objArray = new ArcProto[limit];
                        break;
                    }
                    case 'S': {
                        objArray = new String[limit];
                        break;
                    }
                    case 'T': {
                        objArray = new Technology[limit];
                        break;
                    }
                    case 'V': {
                        objArray = new Point2D[limit];
                        break;
                    }
                    case 'Y': {
                        objArray = new Byte[limit];
                    }
                }
                for (int j = 0; j < limit; ++j) {
                    objArray[j] = this.convertValue(objList[j]);
                }
                obj = objArray;
            } else {
                obj = this.convertValue(this.value);
            }
            Variable newVar = eObj.newVar(varKey, (Object)obj);
            if (newVar == null) {
                LibraryContents.this.logError("Cannot create variable: " + this.variableKeyRef.getName());
                return;
            }
            TextDescriptor td = newVar.getTextDescriptor();
            LibraryContents.this.loadTextDescriptor(td, newVar, this.varBits);
        }

        void addMeaningPref(Object obj) {
            if (obj == null) {
                return;
            }
            switch (this.type) {
                case 'D': 
                case 'F': 
                case 'G': 
                case 'I': 
                case 'S': {
                    break;
                }
                default: {
                    LibraryContents.this.logError("Meaning preference type invalid: " + this.type);
                    return;
                }
            }
            Object v = this.convertValue(this.value);
            Pref.Meaning meaning = Pref.getMeaningVariable(obj, this.variableKeyRef.getName());
            if (meaning != null) {
                Pref.changedMeaningVariable(meaning, v);
            } else if (!(obj instanceof Technology) || !((Technology)obj).convertOldVariable(this.variableKeyRef.getName(), v)) {
                // empty if block
            }
        }

        private Object convertValue(Object value) {
            switch (this.type) {
                case 'C': {
                    return ((CellRef)value).getNodeProto();
                }
                case 'E': {
                    return ((ExportRef)value).getPortProto();
                }
                case 'L': {
                    return ((LibraryRef)value).getLibrary();
                }
                case 'O': {
                    return ((ToolRef)value).getTool();
                }
                case 'P': {
                    return ((PrimitiveNodeRef)value).getNodeProto();
                }
                case 'R': {
                    return ((ArcProtoRef)value).getArcProto();
                }
                case 'T': {
                    return ((TechnologyRef)value).getTechnology();
                }
                case 'B': 
                case 'D': 
                case 'F': 
                case 'G': 
                case 'H': 
                case 'I': 
                case 'S': 
                case 'V': 
                case 'Y': {
                    return value;
                }
            }
            return null;
        }

        private void makeStringVar(PrintWriter out, Object obj) {
            if (obj instanceof Integer) {
                out.print((Integer)obj);
                return;
            }
            if (obj instanceof Short) {
                out.print(((Short)obj).shortValue());
                return;
            }
            if (obj instanceof Byte) {
                out.print(((Byte)obj).byteValue());
                return;
            }
            if (obj instanceof String) {
                out.print("\"");
                out.print(LibraryContents.convertJelibQuotedString((String)obj));
                out.print("\"");
                return;
            }
            if (obj instanceof Float) {
                out.print(((Float)obj).floatValue());
                return;
            }
            if (obj instanceof Double) {
                out.print((Double)obj);
                return;
            }
            if (obj instanceof Boolean) {
                out.print((Boolean)obj != false ? "T" : "F");
                return;
            }
            if (obj instanceof Long) {
                out.print((Long)obj);
                return;
            }
            if (obj instanceof Point2D) {
                Point2D pt2 = (Point2D)obj;
                out.print(LibraryContents.jelibDouble(pt2.getX()) + "/" + LibraryContents.jelibDouble(pt2.getY()));
                return;
            }
            if (obj instanceof TechnologyRef) {
                TechnologyRef techRef = (TechnologyRef)obj;
                out.print(techRef.getFullName());
                return;
            }
            if (obj instanceof LibraryRef) {
                LibraryRef libRef = (LibraryRef)obj;
                out.print(libRef.getFullName());
                return;
            }
            if (obj instanceof ToolRef) {
                ToolRef toolRef = (ToolRef)obj;
                out.print(toolRef.getFullName());
                return;
            }
            if (obj instanceof CellRef) {
                CellRef cellRef = (CellRef)obj;
                out.print(cellRef.getFullName());
                return;
            }
            if (obj instanceof PrimitiveNodeRef) {
                PrimitiveNodeRef npRef = (PrimitiveNodeRef)obj;
                out.print(npRef.getFullName());
                return;
            }
            if (obj instanceof ArcProtoRef) {
                ArcProtoRef apRef = (ArcProtoRef)obj;
                out.print(apRef.getFullName());
                return;
            }
            if (obj instanceof ExportRef) {
                ExportRef ppRef = (ExportRef)obj;
                out.print(LibraryContents.convertJelibString(ppRef.getFullName()));
                return;
            }
        }

        void printJelib(PrintWriter out) {
            out.print("|" + LibraryContents.convertJelibVariableName(this.variableKeyRef.getName()) + "(" + this.varBits + ")" + this.type);
            if (this.value instanceof Object[]) {
                Object[] objArray = (Object[])this.value;
                int len = objArray.length;
                for (int i = 0; i < len; ++i) {
                    Object oneObj = objArray[i];
                    out.print(i != 0 ? (char)',' : '[');
                    this.makeStringVar(out, oneObj);
                }
                out.print("]");
            } else {
                this.makeStringVar(out, this.value);
            }
        }
    }

    class ExportContents {
        private String name;
        private String textDescriptor;
        private NodeContents node;
        private PortProtoRef port;
        private double x;
        private double y;
        private PortCharacteristic characteristic;
        private boolean alwaysDrawn;
        private boolean bodyOnly;
        private VariableContents[] vars;
        private int lineNumber;

        ExportContents(String name, String textDescriptor, NodeContents node, PortProtoRef port, double x, double y) {
            this.name = name;
            this.textDescriptor = textDescriptor;
            this.node = node;
            this.port = port;
            this.x = x;
            this.y = y;
        }

        String getName() {
            return this.name;
        }

        void setCharacteristic(PortCharacteristic characteristic) {
            this.characteristic = characteristic;
        }

        void setAlwaysDrawn(boolean value) {
            this.alwaysDrawn = value;
        }

        void setBodyOnly(boolean value) {
            this.bodyOnly = value;
        }

        void setVars(VariableContents[] vars) {
            this.vars = vars;
        }

        void addVars(VariableContents[] vars) {
            this.vars = LibraryContents.this.addVars(this.vars, vars);
        }

        void setLineNumber(int lineNumber) {
            this.lineNumber = lineNumber;
        }

        void instantiate(Cell cell) {
            LibraryContents.this.showProgress(this.lineNumber);
            PortInst pi = this.node.figureOutPortInst(cell, this.port, this.x, this.y);
            if (pi == null) {
                return;
            }
            Export pp = Export.newInstance(cell, pi, this.name, false);
            if (pp == null) {
                ErrorLogger.MessageLog log = LibraryContents.this.logError("cannot create export " + this.name);
                log.addGeom(pi.getNodeInst(), true, cell, null);
                return;
            }
            LibraryContents.this.loadTextDescriptor(pp.getTextDescriptor(), null, this.textDescriptor);
            if (this.alwaysDrawn) {
                pp.setAlwaysDrawn();
            }
            if (this.bodyOnly) {
                pp.setBodyOnly();
            }
            pp.setCharacteristic(this.characteristic);
            LibraryContents.this.addVariables(pp, this.vars);
        }

        void printJelib(PrintWriter out) {
            out.print("E" + LibraryContents.convertJelibString(this.getName()) + "|" + this.textDescriptor);
            out.print("|" + LibraryContents.convertJelibString(this.node.jelibName) + "|" + LibraryContents.convertJelibString(this.port.getName()));
            out.print("|" + LibraryContents.jelibDouble(this.x) + "|" + LibraryContents.jelibDouble(this.y));
            out.print("|" + this.characteristic.getShortName());
            if (this.alwaysDrawn) {
                out.print("/A");
            }
            if (this.bodyOnly) {
                out.print("/B");
            }
            LibraryContents.printJelibVars(out, this.vars);
            out.println();
        }
    }

    class ArcContents {
        private ArcProtoRef apRef;
        private String name;
        private String textDescriptor;
        private double width;
        private NodeContents headNode;
        private PortProtoRef headPort;
        private double headX;
        private double headY;
        private NodeContents tailNode;
        private PortProtoRef tailPort;
        private double tailX;
        private double tailY;
        private boolean rigid;
        private boolean fixedAngle;
        private boolean slidable;
        private boolean extended;
        private boolean directional;
        private boolean reverseEnds;
        private boolean hardSelect;
        private boolean skipHead;
        private boolean skipTail;
        private boolean tailNegated;
        private boolean headNegated;
        private int angle;
        private VariableContents[] vars;
        private int lineNumber;

        ArcContents(ArcProtoRef apRef, String name, String textDescriptor, double width) {
            this.apRef = apRef;
            this.name = name;
            this.textDescriptor = textDescriptor;
            this.width = width;
        }

        String getName() {
            return this.name;
        }

        void setEnd(boolean tail, NodeContents node, PortProtoRef port, double x, double y) {
            if (tail) {
                this.tailNode = node;
                this.tailPort = port;
                this.tailX = x;
                this.tailY = y;
            } else {
                this.headNode = node;
                this.headPort = port;
                this.headX = x;
                this.headY = y;
            }
        }

        void setRigid(boolean value) {
            this.rigid = value;
        }

        void setFixedAngle(boolean value) {
            this.fixedAngle = value;
        }

        void setSlidable(boolean value) {
            this.slidable = value;
        }

        void setExtended(boolean value) {
            this.extended = value;
        }

        void setDirectional(boolean value) {
            this.directional = value;
        }

        void setReverseEnds(boolean value) {
            this.reverseEnds = value;
        }

        void setHardSelect(boolean value) {
            this.hardSelect = value;
        }

        void setSkipHead(boolean value) {
            this.skipHead = value;
        }

        void setSkipTail(boolean value) {
            this.skipTail = value;
        }

        void setTailNegated(boolean value) {
            this.tailNegated = value;
        }

        void setHeadNegated(boolean value) {
            this.headNegated = value;
        }

        void setAngle(int angle) {
            this.angle = angle;
        }

        void setVars(VariableContents[] vars) {
            this.vars = vars;
        }

        void addVars(VariableContents[] vars) {
            this.vars = LibraryContents.this.addVars(this.vars, vars);
        }

        void setLineNumber(int lineNumber) {
            this.lineNumber = lineNumber;
        }

        void instantiate(Cell cell) {
            LibraryContents.this.showProgress(this.lineNumber);
            PortInst headPI = this.headNode.figureOutPortInst(cell, this.headPort, this.headX, this.headY);
            if (headPI == null) {
                return;
            }
            PortInst tailPI = this.tailNode.figureOutPortInst(cell, this.tailPort, this.tailX, this.tailY);
            if (tailPI == null) {
                return;
            }
            String protoName = this.apRef.getFullName();
            ArcProto ap = ArcProto.findArcProto(protoName);
            if (ap == null) {
                LibraryContents.this.logError("cannot find arc " + protoName);
                return;
            }
            ArcInst ai = ArcInst.newInstance(ap, this.width, headPI, tailPI, new Point2D.Double(this.headX, this.headY), new Point2D.Double(this.tailX, this.tailY), this.name, this.angle);
            if (ai == null) {
                ErrorLogger.MessageLog log = LibraryContents.this.logError("cannot create arc " + this.apRef.getFullName());
                log.addGeom(headPI.getNodeInst(), true, cell, null);
                log.addGeom(tailPI.getNodeInst(), true, cell, null);
                return;
            }
            LibraryContents.this.loadTextDescriptor(ai.getNameTextDescriptor(), null, this.textDescriptor);
            ai.setRigid(this.rigid);
            ai.setFixedAngle(this.fixedAngle);
            ai.setSlidable(this.slidable);
            ai.setExtended(this.extended);
            ai.setDirectional(this.directional);
            ai.setReverseEnds(this.reverseEnds);
            ai.setHardSelect(this.hardSelect);
            ai.setSkipHead(this.skipHead);
            ai.setSkipTail(this.skipTail);
            ai.getHead().setNegated(this.headNegated);
            ai.getTail().setNegated(this.tailNegated);
            LibraryContents.this.addVariables(ai, this.vars);
        }

        void printJelib(PrintWriter out) {
            out.print("A" + this.apRef.getFullName() + "|" + LibraryContents.convertJelibString(this.name) + "|");
            if (this.textDescriptor != null) {
                out.print(this.textDescriptor);
            }
            out.print("|" + LibraryContents.jelibDouble(this.width) + "|");
            if (this.hardSelect) {
                out.print("A");
            }
            if (this.directional) {
                out.print("D");
            }
            if (!this.extended) {
                out.print("E");
            }
            if (!this.fixedAngle) {
                out.print("F");
            }
            if (this.headNegated) {
                out.print("G");
            }
            if (this.skipHead) {
                out.print("H");
            }
            if (this.tailNegated) {
                out.print("N");
            }
            if (this.rigid) {
                out.print("R");
            }
            if (this.slidable) {
                out.print("S");
            }
            if (this.skipTail) {
                out.print("T");
            }
            if (this.reverseEnds) {
                out.print("V");
            }
            out.print(this.angle);
            out.print("|" + LibraryContents.convertJelibString(this.headNode.jelibName) + "|" + LibraryContents.convertJelibString(this.headPort.getName()));
            out.print("|" + LibraryContents.jelibDouble(this.headX) + "|" + LibraryContents.jelibDouble(this.headY));
            out.print("|" + LibraryContents.convertJelibString(this.tailNode.jelibName) + "|" + LibraryContents.convertJelibString(this.tailPort.getName()));
            out.print("|" + LibraryContents.jelibDouble(this.tailX) + "|" + LibraryContents.jelibDouble(this.tailY));
            LibraryContents.printJelibVars(out, this.vars);
            out.println();
        }
    }

    class NodeContents {
        private NodeProtoRef protoRef;
        private String name;
        private String textDescriptor;
        private double x;
        private double y;
        private double wid;
        private double hei;
        private boolean mirX;
        private boolean mirY;
        private int angle;
        private boolean expanded;
        private boolean locked;
        private boolean shortened;
        private boolean visInside;
        private boolean wiped;
        private boolean hardSelect;
        private int techSpecific;
        private String protoTextDescriptor;
        private VariableContents[] vars;
        private int lineNumber;
        private char firstChar;
        private NodeInst ni;
        private String jelibName;

        NodeContents(NodeProtoRef protoRef, String name, String textDescriptor, double x, double y) {
            this.protoRef = protoRef;
            this.name = name;
            this.textDescriptor = textDescriptor;
            this.x = x;
            this.y = y;
        }

        String getName() {
            return this.name;
        }

        NodeProtoRef getNodeProtoRef() {
            return this.protoRef;
        }

        void setSize(double wid, double hei) {
            this.wid = wid;
            this.hei = hei;
        }

        void setOrientation(boolean mirX, boolean mirY, int angle) {
            this.mirX = mirX;
            this.mirY = mirY;
            this.angle = angle;
        }

        void setExpanded(boolean value) {
            this.expanded = value;
        }

        void setLocked(boolean value) {
            this.locked = value;
        }

        void setShortened(boolean value) {
            this.shortened = value;
        }

        void setVisInside(boolean value) {
            this.visInside = value;
        }

        void setWiped(boolean value) {
            this.wiped = value;
        }

        void setHardSelect(boolean value) {
            this.hardSelect = value;
        }

        void setTechSpecific(int techSpecific) {
            this.techSpecific = techSpecific;
        }

        void setProtoTextDescriptor(String protoTextDescriptor) {
            this.protoTextDescriptor = protoTextDescriptor;
        }

        void setVars(VariableContents[] vars) {
            this.vars = vars;
        }

        void addVars(VariableContents[] vars) {
            this.vars = LibraryContents.this.addVars(this.vars, vars);
        }

        void setLineNumber(int lineNumber, char firstChar) {
            this.lineNumber = lineNumber;
            this.firstChar = firstChar;
        }

        void setJelibName(String jelibName) {
            this.jelibName = jelibName;
        }

        private void instantiate(Cell cell) {
            String protoName;
            LibraryContents.this.showProgress(this.lineNumber);
            String prefixName = LibraryContents.this.myLibraryRef.getName();
            Library cellLib = ((LibraryContents)LibraryContents.this).reader.lib;
            NodeProto np = null;
            if (this.protoRef instanceof PrimitiveNodeRef) {
                protoName = ((PrimitiveNodeRef)this.protoRef).techRef.getName() + ":" + this.protoRef.getName();
                Technology tech = Technology.findTechnology(((PrimitiveNodeRef)this.protoRef).techRef.getName());
                if (tech != null) {
                    np = tech.findNodeProto(this.protoRef.getName());
                }
            } else {
                protoName = ((CellRef)this.protoRef).libraryRef.getName() + ":" + this.protoRef.getName();
                CellContents subCC = (CellContents)allCells.get(protoName);
                if (subCC != null && !subCC.filledIn) {
                    subCC.instantiate();
                }
                if ((cellLib = Library.findLibrary(((CellRef)this.protoRef).libraryRef.getName())) != null) {
                    np = cellLib.findNodeProto(this.protoRef.getName());
                }
            }
            double wid = this.wid;
            double hei = this.hei;
            if (this.mirX) {
                wid = -wid;
            }
            if (this.mirY) {
                hei = -hei;
            }
            if (np == null) {
                Cell dummyCell;
                if (cellLib == null) {
                    LibraryContents.this.logError("Creating dummy library " + prefixName);
                    cellLib = Library.newInstance(prefixName, null);
                }
                if ((dummyCell = Cell.makeInstance(cellLib, protoName)) == null) {
                    LibraryContents.this.logError("Unable to create dummy cell " + protoName + " in library " + cellLib.getName());
                    return;
                }
                LibraryContents.this.logError("Creating dummy cell " + protoName + " in library " + cellLib.getName());
                Rectangle2D bounds = null;
                if (this.protoRef instanceof CellRef) {
                    bounds = ((CellRef)this.protoRef).getBounds();
                }
                if (bounds == null) {
                    LibraryContents.this.logError("Warning: cannot find information about external cell " + protoName);
                    NodeInst.newInstance(Generic.tech.invisiblePinNode, new Point2D.Double(0.0, 0.0), wid, hei, dummyCell);
                } else {
                    NodeInst.newInstance(Generic.tech.invisiblePinNode, new Point2D.Double(bounds.getCenterX(), bounds.getCenterY()), bounds.getWidth(), bounds.getHeight(), dummyCell);
                }
                dummyCell.newVar(IOTool.IO_TRUE_LIBRARY, (Object)prefixName);
                dummyCell.newVar(Input.IO_DUMMY_OBJECT, (Object)protoName);
                np = dummyCell;
            }
            this.ni = NodeInst.newInstance(np, new Point2D.Double(this.x, this.y), wid, hei, cell, this.angle, this.name, this.techSpecific);
            if (this.ni == null) {
                LibraryContents.this.logError("cannot create node " + this.protoRef.getName());
                return;
            }
            LibraryContents.this.loadTextDescriptor(this.ni.getNameTextDescriptor(), null, this.textDescriptor);
            if (this.expanded) {
                this.ni.setExpanded();
            } else {
                this.ni.clearExpanded();
            }
            if (this.locked) {
                this.ni.setLocked();
            } else {
                this.ni.clearLocked();
            }
            if (this.shortened) {
                this.ni.setShortened();
            } else {
                this.ni.clearShortened();
            }
            if (this.visInside) {
                this.ni.setVisInside();
            } else {
                this.ni.clearVisInside();
            }
            if (this.wiped) {
                this.ni.setWiped();
            } else {
                this.ni.clearWiped();
            }
            if (this.hardSelect) {
                this.ni.setHardSelect();
            } else {
                this.ni.clearHardSelect();
            }
            if (this.protoTextDescriptor != null) {
                LibraryContents.this.loadTextDescriptor(this.ni.getProtoTextDescriptor(), null, this.protoTextDescriptor);
            }
            LibraryContents.this.addVariables(this.ni, this.vars);
        }

        private PortInst figureOutPortInst(Cell cell, PortProtoRef port, double xPos, double yPos) {
            Poly poly;
            if (this.ni == null) {
                LibraryContents.this.logError("cannot find node " + this.name);
                return null;
            }
            PortInst pi = null;
            String portName = port.getName();
            if (portName.length() == 0) {
                if (this.ni.getNumPortInsts() > 0) {
                    pi = this.ni.getPortInst(0);
                }
            } else {
                pi = this.ni.findPortInst(portName);
            }
            Point2D.Double headPt = new Point2D.Double(xPos, yPos);
            if (pi != null && !(poly = pi.getPoly()).isInside(headPt) && !(poly.polyDistance(xPos, yPos) < LibraryFiles.TINYDISTANCE)) {
                NodeProto np = this.ni.getProto();
                ErrorLogger.MessageLog log = LibraryContents.this.logError("point (" + ((Point2D)headPt).getX() + "," + ((Point2D)headPt).getY() + ") does not fit in port " + pi.describe() + " which is centered at (" + poly.getCenterX() + "," + poly.getCenterY() + ")");
                log.addPoint(((Point2D)headPt).getX(), ((Point2D)headPt).getY(), cell);
                if (np instanceof Cell) {
                    pi = null;
                }
            }
            if (pi != null) {
                return pi;
            }
            Cell subCell = (Cell)this.ni.getProto();
            Variable var = subCell.getVar(IOTool.IO_TRUE_LIBRARY);
            if (var == null) {
                NodeInst portNI = NodeInst.newInstance(Generic.tech.universalPinNode, headPt, 0.0, 0.0, cell);
                if (portNI == null) {
                    LibraryContents.this.logError("Unable to create dummy node in cell " + cell.describe() + " (cannot create source node)");
                    return null;
                }
                ErrorLogger.MessageLog log = LibraryContents.this.logError("Arc end and port discrepancy at (" + ((Point2D)headPt).getX() + "," + ((Point2D)headPt).getY() + "), port " + portName + " on node " + this.name);
                log.addGeom(portNI, true, cell, null);
                return portNI.getOnlyPortInst();
            }
            String name = portName;
            if (name.length() == 0) {
                name = "X";
            }
            AffineTransform unRot = this.ni.rotateIn();
            unRot.transform(headPt, headPt);
            AffineTransform unTrans = this.ni.translateIn();
            unTrans.transform(headPt, headPt);
            NodeInst portNI = NodeInst.newInstance(Generic.tech.universalPinNode, headPt, 0.0, 0.0, subCell);
            if (portNI == null) {
                LibraryContents.this.logError("Unable to create export " + name + " on dummy cell " + subCell.describe() + " (cannot create source node)");
                return null;
            }
            PortInst portPI = portNI.getOnlyPortInst();
            Export pp = Export.newInstance(subCell, portPI, name, false);
            if (pp == null) {
                LibraryContents.this.logError("Unable to create export " + name + " on dummy cell " + subCell.describe());
                return null;
            }
            pi = this.ni.findPortInstFromProto(pp);
            LibraryContents.this.logError("Creating export " + name + " on dummy cell " + subCell.describe());
            return pi;
        }

        void printJelib(PrintWriter out) {
            char firstChar = this.protoRef instanceof CellRef ? (char)'I' : 'N';
            out.print(firstChar + this.protoRef.getFullName());
            out.print("|" + LibraryContents.convertJelibString(this.jelibName) + "|");
            if (this.textDescriptor != null) {
                out.print(this.textDescriptor);
            }
            out.print("|" + LibraryContents.jelibDouble(this.x) + "|" + LibraryContents.jelibDouble(this.y));
            out.print("|" + LibraryContents.jelibDouble(this.mirX ? -this.wid : this.wid) + "|" + LibraryContents.jelibDouble(this.mirY ? -this.hei : this.hei) + "|" + this.angle + "|");
            if (this.hardSelect) {
                out.print("A");
            }
            if (this.expanded) {
                out.print("E");
            }
            if (this.locked) {
                out.print("L");
            }
            if (this.shortened) {
                out.print("S");
            }
            if (this.visInside) {
                out.print("V");
            }
            if (this.wiped) {
                out.print("W");
            }
            if (this.techSpecific != 0) {
                out.print(this.techSpecific);
            }
            out.print("|");
            if (this.protoTextDescriptor != null) {
                out.print(this.protoTextDescriptor);
            }
            LibraryContents.printJelibVars(out, this.vars);
            out.println();
        }
    }

    class CellContents {
        private CellRef myCellRef;
        private long creationDate;
        private long revisionDate;
        TechnologyRef techRef;
        private boolean wantExpanded;
        private boolean allLocked;
        private boolean instancesLocked;
        private boolean inCellLibrary;
        private boolean inTechnologyLibrary;
        NodeContents[] nodes;
        ArcContents[] arcs;
        ExportContents[] exports;
        private VariableContents[] vars;
        private boolean filledIn;
        private int lineNumber;
        private Cell cell;

        CellContents(CellRef myCellRef) {
            this.myCellRef = myCellRef;
            LibraryContents.this.cellContentses.add(this);
            this.filledIn = false;
        }

        String getName() {
            return this.myCellRef.getName();
        }

        Cell getCell() {
            return this.cell;
        }

        boolean isFilledIn() {
            return this.filledIn;
        }

        private String getFileName() {
            return ((LibraryContents)LibraryContents.this).reader.filePath;
        }

        LibraryContents getLibraryContents() {
            return LibraryContents.this;
        }

        void setDates(long creationDate, long revisionDate) {
            this.creationDate = creationDate;
            this.revisionDate = revisionDate;
        }

        void setTechRef(TechnologyRef techRef) {
            this.techRef = techRef;
        }

        void setWantExpanded(boolean value) {
            this.wantExpanded = value;
        }

        void setAllLocked(boolean value) {
            this.allLocked = value;
        }

        void setInstancesLocked(boolean value) {
            this.instancesLocked = value;
        }

        void setInCellLibrary(boolean value) {
            this.inCellLibrary = value;
        }

        void setInTechnologyLibrary(boolean value) {
            this.inTechnologyLibrary = value;
        }

        void setVars(VariableContents[] vars) {
            this.vars = vars;
        }

        void addVars(VariableContents[] vars) {
            this.vars = LibraryContents.this.addVars(this.vars, vars);
        }

        void setLineNumber(int lineNumber) {
            this.lineNumber = lineNumber;
        }

        boolean isDeclared() {
            return this.creationDate != 0L;
        }

        NodeContents newNodeContents(NodeProtoRef protoRef, String name, String textDescriptor, double x, double y) {
            return new NodeContents(protoRef, name, textDescriptor, x, y);
        }

        ArcContents newArcContents(ArcProtoRef apRef, String name, String textDescriptor, double width) {
            return new ArcContents(apRef, name, textDescriptor, width);
        }

        ExportContents newExportContents(String name, String textDescriptor, NodeContents node, PortProtoRef port, double x, double y) {
            return new ExportContents(name, textDescriptor, node, port, x, y);
        }

        private int size() {
            int count = 1;
            if (this.nodes != null) {
                count += this.nodes.length;
            }
            if (this.arcs != null) {
                count += this.arcs.length;
            }
            if (this.exports != null) {
                count += this.exports.length;
            }
            return count;
        }

        void instantiate() {
            int i;
            if (this.cell == null) {
                this.allocateCell();
            }
            if (this.cell == null) {
                return;
            }
            LibraryContents.this.currentCellContents = this;
            for (i = 0; i < this.nodes.length; ++i) {
                this.nodes[i].instantiate(this.cell);
            }
            for (i = 0; i < this.arcs.length; ++i) {
                this.arcs[i].instantiate(this.cell);
            }
            for (i = 0; i < this.exports.length; ++i) {
                this.exports[i].instantiate(this.cell);
            }
            this.filledIn = true;
            this.nodes = null;
            this.arcs = null;
        }

        private void allocateCell() {
            this.cell = Cell.newInstance(this.myCellRef.libraryRef.getLibrary(), this.getName());
            if (this.cell == null) {
                LibraryContents.this.logError("Unable to create cell " + this.getName());
                return;
            }
            Cell.CellGroup cellGroup = (Cell.CellGroup)LibraryContents.this.cellGroups.get(this);
            if (cellGroup != null) {
                this.cell.setCellGroup(cellGroup);
            }
            Technology myTech = Technology.findTechnology(this.techRef.getName());
            this.cell.setTechnology(myTech);
            this.cell.lowLevelSetCreationDate(new Date(this.creationDate));
            this.cell.lowLevelSetRevisionDate(new Date(this.revisionDate));
            if (this.wantExpanded) {
                this.cell.setWantExpanded();
            } else {
                this.cell.clearWantExpanded();
            }
            if (this.allLocked) {
                this.cell.setAllLocked();
            } else {
                this.cell.clearAllLocked();
            }
            if (this.instancesLocked) {
                this.cell.setInstancesLocked();
            } else {
                this.cell.clearInstancesLocked();
            }
            if (this.inCellLibrary) {
                this.cell.setInCellLibrary();
            } else {
                this.cell.clearInCellLibrary();
            }
            if (this.inTechnologyLibrary) {
                this.cell.setInTechnologyLibrary();
            } else {
                this.cell.clearInTechnologyLibrary();
            }
            LibraryContents.this.addVariables(this.cell, this.vars);
        }

        void printJelib(PrintWriter out) {
            int i;
            out.println();
            out.println("# Cell " + this.getName());
            out.print("C" + this.myCellRef.protoName + "|" + this.myCellRef.viewRef.getName() + "|" + this.myCellRef.version);
            out.print("|" + this.techRef.getName());
            out.print("|" + this.creationDate);
            out.print("|" + this.revisionDate);
            out.print("|");
            if (this.inCellLibrary) {
                out.print("C");
            }
            if (this.wantExpanded) {
                out.print("E");
            }
            if (this.instancesLocked) {
                out.print("I");
            }
            if (this.allLocked) {
                out.print("L");
            }
            if (this.inTechnologyLibrary) {
                out.print("T");
            }
            LibraryContents.printJelibVars(out, this.vars);
            out.println();
            for (i = 0; i < this.nodes.length; ++i) {
                this.nodes[i].printJelib(out);
            }
            for (i = 0; i < this.arcs.length; ++i) {
                this.arcs[i].printJelib(out);
            }
            for (i = 0; i < this.exports.length; ++i) {
                this.exports[i].printJelib(out);
            }
            out.println("X");
        }
    }

    class ExportRef
    extends PortProtoRef {
        Export export;

        ExportRef(CellRef cellRef, String name) {
            super(cellRef, name);
        }

        PortProto getPortProto() {
            LibraryContents.this.logError("Cannot identify export " + this.getName());
            return this.export;
        }

        void printJelib(PrintWriter out) {
            out.print("#" + this.getName());
            if (this.export != null) {
                out.print("|" + LibraryContents.this.describeJelibDescriptor(null, this.export.getTextDescriptor()));
                PortOriginal po = new PortOriginal(this.export.getOriginalPort());
                PrimitivePort pp = po.getBottomPortProto();
                PrimitiveNode pn = (PrimitiveNode)pp.getParent();
                out.print("|" + pn.getFullName() + "|");
                if (pn.getNumPorts() > 1) {
                    out.print(pp.getName());
                }
                Poly poly = this.export.getOriginalPort().getPoly();
                out.print("|" + TextUtils.formatDouble(poly.getCenterX(), 0) + "|" + TextUtils.formatDouble(poly.getCenterY(), 0));
                int angle = po.getAngleToTop();
                out.print(angle != 0 ? "|" + angle : "|");
                out.print("|" + this.export.getCharacteristic().getShortName());
                if (this.export.isAlwaysDrawn()) {
                    out.print("/A");
                }
                if (this.export.isBodyOnly()) {
                    out.print("/B");
                }
            }
            out.println();
        }
    }

    class CellRef
    extends NodeProtoRef {
        private LibraryRef libraryRef;
        private String protoName;
        private ViewRef viewRef;
        private int version;
        private long creationDate;
        private long revisionDate;
        Rectangle2D bounds;
        private CellRef nextInGroup;
        private CellContents cc;

        CellRef(LibraryRef libraryRef, String name) {
            super(name);
            this.libraryRef = libraryRef;
            this.protoName = this.getName();
            String viewName = "";
            int openCurly = this.protoName.indexOf(123);
            int closeCurly = this.protoName.indexOf(125);
            int semiColon = this.protoName.indexOf(59);
            if (!(this.protoName.lastIndexOf(123) != openCurly || this.protoName.lastIndexOf(125) != closeCurly || this.protoName.lastIndexOf(59) != semiColon || this.protoName.indexOf(10) >= 0 || this.protoName.indexOf(124) >= 0 || this.protoName.indexOf(58) >= 0 || this.protoName.indexOf(32) >= 0 || openCurly > closeCurly || closeCurly >= 0 && closeCurly != this.protoName.length() - 1 || semiColon >= 0 && openCurly >= 0 && semiColon >= openCurly)) {
                if (openCurly >= 0) {
                    viewName = this.protoName.substring(openCurly + 1, closeCurly);
                    this.protoName = this.protoName.substring(0, openCurly);
                }
                if (semiColon >= 0) {
                    try {
                        this.version = Integer.parseInt(this.protoName.substring(semiColon + 1));
                    }
                    catch (NumberFormatException e) {
                        LibraryContents.this.logError("Bad version number of cell " + this.protoName);
                    }
                    this.protoName = this.protoName.substring(0, semiColon);
                }
            } else {
                LibraryContents.this.logError("Badly formed cell name " + this.protoName);
            }
            this.viewRef = LibraryContents.this.getViewRef(viewName);
        }

        public int compareTo(Object o) {
            CellRef c = (CellRef)o;
            int cmp = TextUtils.nameSameNumeric(this.protoName, c.protoName);
            if (cmp != 0) {
                return cmp;
            }
            cmp = this.viewRef.compareTo(c.viewRef);
            if (cmp != 0) {
                return cmp;
            }
            if (this.version > 0) {
                return c.version > 0 ? c.version - this.version : 1;
            }
            return c.version > 0 ? -1 : 0;
        }

        void setBounds(double loX, double loY, double hiX, double hiY) {
            this.bounds = new Rectangle2D.Double(loX, loY, hiX - loX, hiY - loY);
        }

        LibraryRef getLibraryRef() {
            return this.libraryRef;
        }

        String getFullName() {
            return this.libraryRef.getName() + ":" + this.getName();
        }

        Rectangle2D getBounds() {
            return this.bounds;
        }

        boolean isExternal() {
            return this.libraryRef.isExternal();
        }

        void setNextInGroup(CellRef nextInGroup) {
            this.nextInGroup = nextInGroup;
        }

        ExportRef newExportRef(String exportName) {
            ExportRef exportRef = (ExportRef)this.findPortProtoRef(exportName);
            if (exportRef == null) {
                exportRef = new ExportRef(this, exportName);
            } else {
                LibraryContents.this.logError("Export " + exportRef.getFullName() + " declared twice");
            }
            return exportRef;
        }

        public NodeProto getNodeProto() {
            Library cellLib = this.libraryRef.getLibrary();
            if (cellLib == null) {
                return null;
            }
            return cellLib.findNodeProto(this.getName());
        }

        void printJelib(PrintWriter out) {
            Rectangle2D bounds = this.getBounds();
            out.print("R" + this.protoName + "|" + this.viewRef.getName() + "|" + this.version + "|" + bounds.getMinX() + "|" + bounds.getMaxX() + "|" + bounds.getMinY() + "|" + bounds.getMaxY());
            Iterator eIt = this.getPorts();
            while (eIt.hasNext()) {
                ExportRef exportRef = (ExportRef)eIt.next();
                exportRef.printJelib(out);
            }
        }
    }

    class LibraryRef
    extends ObjectRef {
        private String fileName;
        private LinkedHashMap cells;
        private Library lib;
        static final /* synthetic */ boolean $assertionsDisabled;

        LibraryRef(String name, String fileName) {
            super(name);
            this.cells = new LinkedHashMap();
            this.fileName = fileName;
            LibraryContents.this.libraryRefs.put(name, this);
        }

        boolean isExternal() {
            return this != LibraryContents.this.myLibraryRef;
        }

        String getFileName() {
            return this.fileName;
        }

        CellRef newExternalCellRef(String cellName, double lowX, double lowY, double highX, double highY) {
            if (!$assertionsDisabled && !this.isExternal()) {
                throw new AssertionError();
            }
            CellRef extCell = (CellRef)this.cells.get(cellName);
            if (extCell == null) {
                extCell = new CellRef(this, cellName);
                this.cells.put(cellName, extCell);
            } else {
                LibraryContents.this.logError("External Cell " + extCell.getFullName() + " declared twice");
            }
            extCell.setBounds(lowX, lowY, highX, highY);
            return extCell;
        }

        private CellContents newCellContents(String cellName, long creationDate, long revisionDate) {
            if (!$assertionsDisabled && this.isExternal()) {
                throw new AssertionError();
            }
            CellRef cellRef = (CellRef)this.cells.get(cellName);
            if (cellRef == null) {
                cellRef = new CellRef(this, cellName);
                this.cells.put(cellName, cellRef);
            }
            if (cellRef.cc == null) {
                cellRef.cc = new CellContents(cellRef);
            } else {
                LibraryContents.this.logError("Cell " + cellRef.getFullName() + " declared twice");
            }
            cellRef.cc.setDates(creationDate, revisionDate);
            return cellRef.cc;
        }

        CellRef getCellRef(String cellName) {
            CellRef cellRef = (CellRef)this.cells.get(cellName);
            if (cellRef == null) {
                cellRef = new CellRef(this, cellName);
                if (this.isExternal()) {
                    LibraryContents.this.logError("Unknown External Cell " + this.getFullName() + ":" + cellName);
                }
                this.cells.put(cellName, cellRef);
            }
            return cellRef;
        }

        Library getLibrary() {
            return this.lib;
        }

        void printJelib(PrintWriter out) {
            out.println("L" + this.getName() + "|" + LibraryContents.convertJelibString(this.fileName));
            Iterator cIt = this.cells.values().iterator();
            while (cIt.hasNext()) {
                CellRef cellRef = (CellRef)cIt.next();
                cellRef.printJelib(out);
            }
        }

        static {
            $assertionsDisabled = !(class$com$sun$electric$tool$io$input$LibraryContents == null ? (class$com$sun$electric$tool$io$input$LibraryContents = LibraryContents.class$("com.sun.electric.tool.io.input.LibraryContents")) : class$com$sun$electric$tool$io$input$LibraryContents).desiredAssertionStatus();
        }
    }

    class ArcProtoRef
    extends ObjectRef {
        private final TechnologyRef techRef;
        private VariableContents[] vars;
        private ArcProto ap;

        ArcProtoRef(TechnologyRef techRef, String name) {
            super(name);
            this.techRef = techRef;
            techRef.arcProtos.put(name, this);
        }

        void setVars(VariableContents[] vars) {
            this.vars = vars;
        }

        void addVars(VariableContents[] vars) {
            this.vars = LibraryContents.this.addVars(this.vars, vars);
        }

        VariableContents[] getVars() {
            return this.vars;
        }

        String getFullName() {
            return this.techRef.getName() + ":" + this.getName();
        }

        ArcProto getArcProto() {
            LibraryContents.this.logError("Cannot identify primitive arc " + this.getName());
            return this.ap;
        }

        void printJelib(PrintWriter out) {
            out.print("W" + this.getName());
            LibraryContents.printJelibVars(out, this.vars);
            out.println();
        }
    }

    class PrimitivePortRef
    extends PortProtoRef {
        private VariableContents[] vars;
        private PrimitivePort pp;

        PrimitivePortRef(PrimitiveNodeRef primitiveNodeRef, String name) {
            super(primitiveNodeRef, name);
        }

        void setVars(VariableContents[] vars) {
            this.vars = vars;
        }

        void addVars(VariableContents[] vars) {
            this.vars = LibraryContents.this.addVars(this.vars, vars);
        }

        VariableContents[] getVars() {
            return this.vars;
        }

        PortProto getPortProto() {
            LibraryContents.this.logError("Cannot identify primitive port " + this.getName());
            return this.pp;
        }

        void printJelib(PrintWriter out) {
            out.print("P" + this.getName());
            LibraryContents.printJelibVars(out, this.vars);
            out.println();
        }
    }

    class PrimitiveNodeRef
    extends NodeProtoRef {
        private final TechnologyRef techRef;
        private VariableContents[] vars;
        private PrimitiveNode pn;

        PrimitiveNodeRef(TechnologyRef techRef, String name) {
            super(name);
            this.techRef = techRef;
            techRef.primitiveNodes.put(name, this);
        }

        void setVars(VariableContents[] vars) {
            this.vars = vars;
        }

        void addVars(VariableContents[] vars) {
            this.vars = LibraryContents.this.addVars(this.vars, vars);
        }

        VariableContents[] getVars() {
            return this.vars;
        }

        String getFullName() {
            return this.techRef.getName() + ":" + this.getName();
        }

        PrimitivePortRef newPrimitivePortRef(String ppName) {
            PrimitivePortRef ppRef = (PrimitivePortRef)this.findPortProtoRef(ppName);
            if (ppRef == null) {
                ppRef = new PrimitivePortRef(this, ppName);
            } else {
                LibraryContents.this.logError("Primitive Port " + ppRef.getFullName() + " declared twice");
            }
            return ppRef;
        }

        NodeProto getNodeProto() {
            if (this.pn != null) {
                return this.pn;
            }
            Technology tech = this.techRef.getTechnology();
            if (tech == null) {
                return null;
            }
            this.pn = tech.findNodeProto(this.getName());
            if (this.pn == null) {
                LibraryContents.this.logError("Cannot identify primitive node " + this.getName());
            }
            return this.pn;
        }

        void printJelib(PrintWriter out) {
            out.print("D" + this.getName());
            LibraryContents.printJelibVars(out, this.vars);
            out.println();
            Iterator it = this.getPorts();
            while (it.hasNext()) {
                PrimitivePortRef primitivePortRef = (PrimitivePortRef)it.next();
                primitivePortRef.printJelib(out);
            }
        }
    }

    class TechnologyRef
    extends ObjectRef {
        private final LinkedHashMap primitiveNodes;
        private final LinkedHashMap arcProtos;
        private int lambda;
        private VariableContents[] vars;
        private Technology tech;

        private TechnologyRef(String name) {
            super(name);
            this.primitiveNodes = new LinkedHashMap();
            this.arcProtos = new LinkedHashMap();
            LibraryContents.this.technologyRefs.put(name, this);
        }

        void setLambda(int lambda) {
            this.lambda = lambda;
        }

        void setVars(VariableContents[] vars) {
            this.vars = vars;
        }

        void addVars(VariableContents[] vars) {
            this.vars = LibraryContents.this.addVars(this.vars, vars);
        }

        VariableContents[] getVars() {
            return this.vars;
        }

        PrimitiveNodeRef newPrimitiveNodeRef(String pnName) {
            PrimitiveNodeRef pnRef = (PrimitiveNodeRef)this.primitiveNodes.get(pnName);
            if (pnRef == null) {
                pnRef = new PrimitiveNodeRef(this, pnName);
            } else {
                LibraryContents.this.logError("Primitive Node " + pnRef.getFullName() + " declared twice");
            }
            return pnRef;
        }

        PrimitiveNodeRef getPrimitiveNodeRef(String pnName) {
            PrimitiveNodeRef pnRef = (PrimitiveNodeRef)this.primitiveNodes.get(pnName);
            if (pnRef == null) {
                if (LibraryContents.this.needDeclarations) {
                    LibraryContents.this.logError("Unknown Primitive Node " + this.getFullName() + ":" + pnName);
                }
                pnRef = new PrimitiveNodeRef(this, pnName);
            }
            return pnRef;
        }

        ArcProtoRef newArcProtoRef(String apName) {
            ArcProtoRef apRef = (ArcProtoRef)this.arcProtos.get(apName);
            if (apRef == null) {
                apRef = new ArcProtoRef(this, apName);
            } else {
                LibraryContents.this.logError("Arc Proto " + apRef.getFullName() + " declared twice");
            }
            return apRef;
        }

        ArcProtoRef getArcProtoRef(String apName) {
            ArcProtoRef apRef = (ArcProtoRef)this.arcProtos.get(apName);
            if (apRef == null) {
                if (LibraryContents.this.needDeclarations) {
                    LibraryContents.this.logError("Unknown Arc Proto " + this.getFullName() + ":" + apName);
                }
                apRef = new ArcProtoRef(this, apName);
            }
            return apRef;
        }

        private Technology getTechnology() {
            if (this.tech == null) {
                this.tech = Technology.findTechnology(this.getName());
                if (this.tech == null) {
                    LibraryContents.this.logError("Cannot identify technology " + this.getName());
                }
            }
            return this.tech;
        }

        void addMeaningPrefs() {
            if (this.getVars() != null) {
                LibraryContents.this.addMeaningPrefs(this.getTechnology(), this.getVars());
            }
        }

        void printJelib(PrintWriter out) {
            out.println();
            out.print("# Technology " + this.getName());
            if (this.lambda != 0) {
                out.print(" lambda " + (double)this.lambda * 0.5);
            }
            out.println();
            out.print("T" + this.getName());
            LibraryContents.printJelibVars(out, this.vars);
            out.println();
            Iterator it = this.primitiveNodes.values().iterator();
            while (it.hasNext()) {
                PrimitiveNodeRef primitiveNodeRef = (PrimitiveNodeRef)it.next();
                primitiveNodeRef.printJelib(out);
            }
            it = this.arcProtos.values().iterator();
            while (it.hasNext()) {
                ArcProtoRef arcProtoRef = (ArcProtoRef)it.next();
                arcProtoRef.printJelib(out);
            }
        }
    }

    class ViewRef
    extends ObjectRef {
        private String fullName;
        private VariableContents[] vars;
        private View view;

        ViewRef(String name, String fullName) {
            super(name);
            LibraryContents.this.viewRefs.put(name, this);
            this.fullName = fullName;
        }

        void setVars(VariableContents[] vars) {
            this.vars = vars;
        }

        void addVars(VariableContents[] vars) {
            this.vars = LibraryContents.this.addVars(this.vars, vars);
        }

        VariableContents[] getVars() {
            return this.vars;
        }

        void printJelib(PrintWriter out) {
            out.print("V" + (this.fullName != null ? LibraryContents.convertJelibString(this.fullName) : "") + "|" + this.getName());
            LibraryContents.printJelibVars(out, this.vars);
            out.println();
        }
    }

    class ToolRef
    extends ObjectRef {
        private VariableContents[] vars;
        private Tool tool;

        ToolRef(String name) {
            super(name);
            LibraryContents.this.toolRefs.put(name, this);
        }

        void setVars(VariableContents[] vars) {
            this.vars = vars;
        }

        void addVars(VariableContents[] vars) {
            this.vars = LibraryContents.this.addVars(this.vars, vars);
        }

        VariableContents[] getVars() {
            return this.vars;
        }

        Tool getTool() {
            if (this.tool == null) {
                this.tool = Tool.findTool(this.getName());
                if (this.tool == null) {
                    LibraryContents.this.logError("Cannot identify tool " + this.getName());
                }
            }
            return this.tool;
        }

        void addMeaningPrefs() {
            if (this.getVars() != null) {
                LibraryContents.this.addMeaningPrefs(this.getTool(), this.getVars());
            }
        }

        void printJelib(PrintWriter out) {
            out.print("O" + this.getName());
            LibraryContents.printJelibVars(out, this.vars);
            out.println();
        }
    }

    abstract class PortProtoRef
    extends ObjectRef {
        private final NodeProtoRef nodeProtoRef;

        private PortProtoRef(NodeProtoRef nodeProtoRef, String name) {
            super(name);
            this.nodeProtoRef = nodeProtoRef;
            nodeProtoRef.ports.put(name, this);
        }

        abstract PortProto getPortProto();

        String getFullName() {
            return this.nodeProtoRef.getFullName() + ":" + this.getName();
        }
    }

    abstract class NodeProtoRef
    extends ObjectRef {
        private final LinkedHashMap ports;

        private NodeProtoRef(String name) {
            super(name);
            this.ports = new LinkedHashMap();
        }

        Iterator getPorts() {
            return this.ports.values().iterator();
        }

        PortProtoRef findPortProtoRef(String portName) {
            return (PortProtoRef)this.ports.get(portName);
        }

        PortProtoRef getPortProtoRef(String portName) {
            PortProtoRef ppRef = (PortProtoRef)this.ports.get(portName);
            if (ppRef == null) {
                if (this instanceof PrimitiveNodeRef) {
                    if (LibraryContents.this.needDeclarations) {
                        LibraryContents.this.logError("Unknown Primitive Port " + this.getFullName() + ":" + portName);
                    }
                    ppRef = new PrimitivePortRef((PrimitiveNodeRef)this, portName);
                } else {
                    CellRef cellRef = (CellRef)this;
                    if (cellRef.isExternal() ? LibraryContents.this.needDeclarations : LibraryContents.this.needLocalDeclarations) {
                        LibraryContents.this.logError("Unknown Export " + this.getFullName() + ":" + portName);
                    }
                    ppRef = new ExportRef(cellRef, portName);
                }
            }
            return ppRef;
        }

        abstract NodeProto getNodeProto();
    }

    private abstract class ObjectRef
    implements Comparable {
        private final String name;
        private int tempInt;

        private ObjectRef(String name) {
            if (name == null) {
                throw new IllegalArgumentException();
            }
            this.name = name;
            if (((LibraryContents)LibraryContents.this).reader.lineReader != null) {
                this.tempInt = ((LibraryContents)LibraryContents.this).reader.lineReader.getLineNumber();
            }
        }

        public int compareTo(Object o) {
            return TextUtils.nameSameNumeric(this.name, ((ObjectRef)o).name);
        }

        String getName() {
            return this.name;
        }

        String getFullName() {
            return this.name;
        }
    }
}

