/*
 * Decompiled with CFR 0.152.
 */
package com.sun.electric.tool.user;

import com.sun.electric.database.geometry.DBMath;
import com.sun.electric.database.geometry.Poly;
import com.sun.electric.database.hierarchy.Cell;
import com.sun.electric.database.hierarchy.Export;
import com.sun.electric.database.network.Netlist;
import com.sun.electric.database.prototype.ArcProto;
import com.sun.electric.database.prototype.PortProto;
import com.sun.electric.database.text.TextUtils;
import com.sun.electric.database.topology.Connection;
import com.sun.electric.database.topology.NodeInst;
import com.sun.electric.database.topology.PortInst;
import com.sun.electric.database.variable.ElectricObject;
import com.sun.electric.database.variable.FlagSet;
import com.sun.electric.technology.Technology;
import com.sun.electric.technology.technologies.Generic;
import com.sun.electric.tool.Job;
import com.sun.electric.tool.user.CircuitChanges;
import com.sun.electric.tool.user.Highlight;
import com.sun.electric.tool.user.User;
import com.sun.electric.tool.user.dialogs.NewExport;
import com.sun.electric.tool.user.ui.EditWindow;
import com.sun.electric.tool.user.ui.TopLevel;
import com.sun.electric.tool.user.ui.WindowFrame;
import java.awt.Frame;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;
import javax.swing.JOptionPane;

public final class ExportChanges {
    static /* synthetic */ Class class$com$sun$electric$database$prototype$PortProto;

    public static void newExportCommand() {
        NewExport dialog = new NewExport((Frame)TopLevel.getCurrentJFrame(), true);
        dialog.setVisible(true);
    }

    public static void describeExports(boolean summarize) {
        Cell cell = WindowFrame.needCurCell();
        if (cell == null) {
            return;
        }
        Netlist netlist = cell.getUserNetlist();
        Cell wnp = cell.contentsView();
        if (wnp == null) {
            wnp = cell.iconView();
        }
        if (wnp == cell) {
            wnp = null;
        }
        if (cell.getNumPorts() == 0) {
            System.out.println("There are no exports on cell " + cell.describe());
            return;
        }
        ArrayList<ExportList> exports = new ArrayList<ExportList>();
        Iterator it = cell.getPorts();
        while (it.hasNext()) {
            ExportList el = new ExportList();
            el.pp = (Export)it.next();
            el.equiv = -1;
            el.busList = -1;
            exports.add(el);
        }
        Collections.sort(exports, new ExportSortedByNameAndType());
        int num_found = exports.size();
        if (summarize) {
            Export ppJ;
            int blJ;
            int eqJ;
            int j;
            block1: for (j = 0; j < num_found; ++j) {
                eqJ = ((ExportList)exports.get((int)j)).equiv;
                blJ = ((ExportList)exports.get((int)j)).busList;
                if (eqJ != -1 || blJ != -1) continue;
                ppJ = ((ExportList)exports.get((int)j)).pp;
                for (int k = j + 1; k < num_found; ++k) {
                    int eqK = ((ExportList)exports.get((int)k)).equiv;
                    int blK = ((ExportList)exports.get((int)k)).busList;
                    if (eqK != -1 || blK != -1) continue;
                    Export ppK = ((ExportList)exports.get((int)k)).pp;
                    if (ppJ.getCharacteristic() != ppK.getCharacteristic()) continue block1;
                    if (!netlist.sameNetwork(ppJ.getOriginalPort().getNodeInst(), ppJ.getOriginalPort().getPortProto(), ppK.getOriginalPort().getNodeInst(), ppK.getOriginalPort().getPortProto())) continue;
                    ((ExportList)exports.get((int)k)).equiv = j;
                    ((ExportList)exports.get((int)j)).equiv = -2;
                }
            }
            block3: for (j = 0; j < num_found; ++j) {
                String ptJ;
                int sqPosJ;
                eqJ = ((ExportList)exports.get((int)j)).equiv;
                blJ = ((ExportList)exports.get((int)j)).busList;
                if (eqJ != -1 || blJ != -1 || (sqPosJ = (ptJ = (ppJ = ((ExportList)exports.get((int)j)).pp).getName()).indexOf(91)) < 0) continue;
                for (int k = j + 1; k < num_found; ++k) {
                    int eqK = ((ExportList)exports.get((int)k)).equiv;
                    int blK = ((ExportList)exports.get((int)k)).busList;
                    if (eqK != -1 || blK != -1) continue;
                    Export ppK = ((ExportList)exports.get((int)k)).pp;
                    if (ppJ.getCharacteristic() != ppK.getCharacteristic()) continue block3;
                    String ptK = ppK.getName();
                    int sqPosK = ptK.indexOf(91);
                    if (sqPosJ != sqPosK || !ptJ.substring(0, sqPosJ).equalsIgnoreCase(ptK.substring(0, sqPosK))) continue;
                    ((ExportList)exports.get((int)k)).busList = j;
                    ((ExportList)exports.get((int)j)).busList = -2;
                }
            }
        }
        System.out.println("----- Exports on cell " + cell.describe() + " -----");
        FlagSet arcMark = ArcProto.getFlagSet(1);
        for (int j = 0; j < num_found; ++j) {
            int m;
            ExportList el = (ExportList)exports.get(j);
            Export pp = el.pp;
            if (el.equiv >= 0 || el.busList >= 0) continue;
            Iterator it2 = Technology.getTechnologies();
            while (it2.hasNext()) {
                Technology tech = (Technology)it2.next();
                Iterator aIt = tech.getArcs();
                while (aIt.hasNext()) {
                    ArcProto ap = (ArcProto)aIt.next();
                    ap.clearBit(arcMark);
                }
            }
            String infstr = "";
            String activity = pp.getCharacteristic().getFullName();
            for (m = j + 1; m < num_found && ((ExportList)exports.get((int)m)).equiv != j; ++m) {
            }
            double lx = 0.0;
            double hx = 0.0;
            double ly = 0.0;
            double hy = 0.0;
            if (m < num_found) {
                infstr = infstr + activity + " exports ";
                for (int k = j; k < num_found; ++k) {
                    if (j != k && ((ExportList)exports.get((int)k)).equiv != j) continue;
                    if (j != k) {
                        infstr = infstr + ", ";
                    }
                    Export opp = ((ExportList)exports.get((int)k)).pp;
                    infstr = infstr + "'" + opp.getName() + "'";
                    Poly poly = opp.getOriginalPort().getPoly();
                    double x = poly.getCenterX();
                    double y = poly.getCenterY();
                    if (j == k) {
                        lx = hx = x;
                        ly = hy = y;
                    } else {
                        if (x < lx) {
                            lx = x;
                        }
                        if (x > hx) {
                            hx = x;
                        }
                        if (y < ly) {
                            ly = y;
                        }
                        if (y > hy) {
                            hy = y;
                        }
                    }
                    ArcProto[] arcList = opp.getBasePort().getConnections();
                    for (int a = 0; a < arcList.length; ++a) {
                        arcList[a].setBit(arcMark);
                    }
                }
                infstr = infstr + " at (" + lx + "<=X<=" + hx + ", " + ly + "<=Y<=" + hy + "), electrically connected to";
                infstr = ExportChanges.addPossibleArcConnections(infstr, arcMark);
            } else {
                for (m = j + 1; m < num_found && ((ExportList)exports.get((int)m)).busList != j; ++m) {
                }
                if (m < num_found) {
                    int tot = 0;
                    for (int k = j; k < num_found; ++k) {
                        if (j != k && ((ExportList)exports.get((int)k)).busList != j) continue;
                        ++tot;
                        Export opp = ((ExportList)exports.get((int)k)).pp;
                        Poly poly = opp.getOriginalPort().getPoly();
                        double x = poly.getCenterX();
                        double y = poly.getCenterY();
                        if (j == k) {
                            lx = hx = x;
                            ly = hy = y;
                        } else {
                            if (x < lx) {
                                lx = x;
                            }
                            if (x > hx) {
                                hx = x;
                            }
                            if (y < ly) {
                                ly = y;
                            }
                            if (y > hy) {
                                hy = y;
                            }
                        }
                        ArcProto[] arcList = opp.getBasePort().getConnections();
                        for (int a = 0; a < arcList.length; ++a) {
                            arcList[a].setBit(arcMark);
                        }
                    }
                    ArrayList<Export> sortedBusList = new ArrayList<Export>();
                    sortedBusList.add(((ExportList)exports.get((int)j)).pp);
                    for (int k = j + 1; k < num_found; ++k) {
                        ExportList elK = (ExportList)exports.get(k);
                        if (elK.busList != j) continue;
                        sortedBusList.add(elK.pp);
                    }
                    Collections.sort(sortedBusList, new ExportSortedByBusIndex());
                    boolean first = true;
                    Iterator it3 = sortedBusList.iterator();
                    while (it3.hasNext()) {
                        Export ppS = (Export)it3.next();
                        String pt1 = ppS.getName();
                        int openPos = pt1.indexOf(91);
                        if (first) {
                            infstr = infstr + activity + " ports '" + pt1.substring(0, openPos) + "[";
                            first = false;
                        } else {
                            infstr = infstr + ",";
                        }
                        int closePos = pt1.lastIndexOf(93);
                        infstr = infstr + pt1.substring(openPos + 1, closePos);
                    }
                    infstr = infstr + "]' at (" + lx + "<=X<=" + hx + ", " + ly + "<=Y<=" + hy + "), same bus, connects to";
                    infstr = ExportChanges.addPossibleArcConnections(infstr, arcMark);
                } else {
                    Poly poly = pp.getOriginalPort().getPoly();
                    double x = poly.getCenterX();
                    double y = poly.getCenterY();
                    infstr = infstr + activity + " export '" + pp.getName() + "' at (" + x + ", " + y + ") connects to";
                    ArcProto[] arcList = pp.getBasePort().getConnections();
                    for (int a = 0; a < arcList.length; ++a) {
                        arcList[a].setBit(arcMark);
                    }
                    infstr = ExportChanges.addPossibleArcConnections(infstr, arcMark);
                    if (wnp != null && pp.getEquivalentPort(wnp) == null) {
                        infstr = infstr + " *** no equivalent in " + wnp.describe();
                    }
                }
            }
            TextUtils.printLongString(infstr);
        }
        if (wnp != null) {
            Iterator it4 = wnp.getPorts();
            while (it4.hasNext()) {
                Export pp = (Export)it4.next();
                if (pp.getEquivalentPort(cell) != null) continue;
                System.out.println("*** Export " + pp.getName() + ", found in cell " + wnp.describe() + ", is missing here");
            }
        }
        arcMark.freeFlagSet();
    }

    private static String addPossibleArcConnections(String infstr, FlagSet arcMark) {
        ArcProto ap;
        Iterator aIt;
        Technology tech;
        int i = 0;
        Iterator it = Technology.getTechnologies();
        while (it.hasNext()) {
            tech = (Technology)it.next();
            aIt = tech.getArcs();
            while (aIt.hasNext()) {
                ap = (ArcProto)aIt.next();
                if (ap.isBit(arcMark)) continue;
                ++i;
            }
        }
        if (i == 0) {
            infstr = infstr + " EVERYTHING";
        } else {
            i = 0;
            it = Technology.getTechnologies();
            while (it.hasNext()) {
                tech = (Technology)it.next();
                if (tech == Generic.tech) continue;
                aIt = tech.getArcs();
                while (aIt.hasNext()) {
                    ap = (ArcProto)aIt.next();
                    if (!ap.isBit(arcMark)) continue;
                    if (i != 0) {
                        infstr = infstr + ",";
                    }
                    ++i;
                    infstr = infstr + " " + ap.getName();
                }
            }
        }
        return infstr;
    }

    public static void reExportAll() {
        Cell cell = WindowFrame.needCurCell();
        if (cell == null) {
            return;
        }
        if (CircuitChanges.cantEdit(cell, null, true)) {
            return;
        }
        ReExport job = new ReExport(cell, null, false);
    }

    public static void reExportHighlighted() {
        Cell cell = WindowFrame.needCurCell();
        if (cell == null) {
            return;
        }
        if (CircuitChanges.cantEdit(cell, null, true)) {
            return;
        }
        Rectangle2D bounds = Highlight.getHighlightedArea(null);
        if (bounds == null) {
            JOptionPane.showMessageDialog(TopLevel.getCurrentJFrame(), "Must select something before re-exporting the highlighted objects", "Re-export failed", 0);
            return;
        }
        ReExport job = new ReExport(cell, bounds, false);
    }

    public static void reExportPowerAndGround() {
        Cell cell = WindowFrame.needCurCell();
        if (cell == null) {
            return;
        }
        if (CircuitChanges.cantEdit(cell, null, true)) {
            return;
        }
        ReExport job = new ReExport(cell, null, true);
    }

    public static void deleteExport() {
        Cell cell = WindowFrame.needCurCell();
        if (cell == null) {
            return;
        }
        if (CircuitChanges.cantEdit(cell, null, true)) {
            return;
        }
        ArrayList<Export> exportsToDelete = new ArrayList<Export>();
        List highs = Highlight.getHighlightedText(true);
        Iterator it = highs.iterator();
        while (it.hasNext()) {
            Highlight h = (Highlight)it.next();
            if (h.getVar() != null || h.getName() != null || !(h.getElectricObject() instanceof Export)) continue;
            Export pp = (Export)h.getElectricObject();
            exportsToDelete.add(pp);
        }
        if (exportsToDelete.size() == 0) {
            System.out.println("There are no selected exports to delete");
            return;
        }
        DeleteExports job = new DeleteExports(exportsToDelete);
    }

    public static void deleteExportsOnHighlighted() {
        Cell cell = WindowFrame.needCurCell();
        if (cell == null) {
            return;
        }
        if (CircuitChanges.cantEdit(cell, null, true)) {
            return;
        }
        ArrayList exportsToDelete = new ArrayList();
        List highs = Highlight.getHighlighted(true, false);
        Iterator it = highs.iterator();
        while (it.hasNext()) {
            NodeInst ni = (NodeInst)it.next();
            Iterator eIt = ni.getExports();
            while (eIt.hasNext()) {
                exportsToDelete.add(eIt.next());
            }
        }
        if (exportsToDelete.size() == 0) {
            JOptionPane.showMessageDialog(TopLevel.getCurrentJFrame(), "There are no exports on the highlighted objects", "Re-export failed", 0);
            return;
        }
        DeleteExports job = new DeleteExports(exportsToDelete);
    }

    public static void deleteExportsInArea() {
        Cell cell = WindowFrame.needCurCell();
        if (cell == null) {
            return;
        }
        if (CircuitChanges.cantEdit(cell, null, true)) {
            return;
        }
        ArrayList<Export> exportsToDelete = new ArrayList<Export>();
        Rectangle2D bounds = Highlight.getHighlightedArea(null);
        if (bounds == null) {
            JOptionPane.showMessageDialog(TopLevel.getCurrentJFrame(), "Must select something before deleting the highlighted exports", "Export delete failed", 0);
            return;
        }
        Iterator it = cell.getNodes();
        while (it.hasNext()) {
            NodeInst ni = (NodeInst)it.next();
            Iterator eIt = ni.getExports();
            while (eIt.hasNext()) {
                Export e = (Export)eIt.next();
                PortInst pi = e.getOriginalPort();
                Poly poly = pi.getPoly();
                if (!bounds.contains(poly.getCenterX(), poly.getCenterY())) continue;
                exportsToDelete.add(e);
            }
        }
        if (exportsToDelete.size() == 0) {
            JOptionPane.showMessageDialog(TopLevel.getCurrentJFrame(), "There are no exports in the highlighted area", "Re-export failed", 0);
            return;
        }
        DeleteExports job = new DeleteExports(exportsToDelete);
    }

    public static void moveExport() {
        Export source = null;
        PortInst dest = null;
        Iterator it = Highlight.getHighlights();
        while (it.hasNext()) {
            Highlight h = (Highlight)it.next();
            boolean used = false;
            if (h.getType() == Highlight.Type.EOBJ) {
                if (h.getElectricObject() instanceof PortInst) {
                    if (dest != null) {
                        System.out.println("Must select only one node-port as a destination of the move");
                        return;
                    }
                    dest = (PortInst)h.getElectricObject();
                    used = true;
                }
            } else if (h.getType() == Highlight.Type.TEXT && h.getVar() == null && h.getName() == null && h.getElectricObject() instanceof Export) {
                source = (Export)h.getElectricObject();
                used = true;
            }
            if (used) continue;
            System.out.println("Moving exports: select one export to move, and one node-port as its destination");
            return;
        }
        if (source == null || dest == null) {
            System.out.println("First select one export to move, and one node-port as its destination");
            return;
        }
        MoveExport job = new MoveExport(source, dest);
    }

    public static void renameExport() {
        Highlight h = Highlight.getOneHighlight();
        if (h.getVar() != null || h.getName() != null || !(h.getElectricObject() instanceof Export)) {
            System.out.println("Must select an export name before renaming it");
            return;
        }
        Export pp = (Export)h.getElectricObject();
        String response = JOptionPane.showInputDialog(TopLevel.getCurrentJFrame(), "Rename export", pp.getName());
        if (response == null) {
            return;
        }
        RenameExport job = new RenameExport(pp, response);
    }

    public static void showExports() {
        ExportChanges.showPortsAndExports(null);
    }

    public static void showPorts() {
        List nodes = Highlight.getHighlighted(true, false);
        if (nodes == null || nodes.size() == 0) {
            System.out.println("No nodes are highlighted");
            return;
        }
        ExportChanges.showPortsAndExports(nodes);
    }

    private static void showPortsAndExports(List nodes) {
        int i;
        Iterator it;
        int i2;
        int botSideCount;
        EditWindow wnd = EditWindow.needCurrent();
        if (wnd == null) {
            return;
        }
        Cell cell = wnd.getCell();
        if (cell == null) {
            System.out.println("No cell in this window");
            return;
        }
        int total = cell.getNumPorts();
        if (nodes != null) {
            total = 0;
            Iterator it2 = nodes.iterator();
            while (it2.hasNext()) {
                NodeInst ni = (NodeInst)it2.next();
                total += ni.getNumPortInsts();
            }
        }
        Rectangle2D displayable = wnd.displayableBounds();
        double digitIndentX = displayable.getWidth() / 15.0;
        double digitIndentY = displayable.getHeight() / 15.0;
        Point2D.Double[] labelLocs = new Point2D.Double[total];
        ShownPorts[] portList = new ShownPorts[total];
        int leftSideCount = botSideCount;
        int topSideCount = botSideCount;
        int numPerSide = (total + 3) / 4;
        int rightSideCount = botSideCount = numPerSide;
        if (leftSideCount + topSideCount + rightSideCount + botSideCount > total) {
            --botSideCount;
        }
        if (leftSideCount + topSideCount + rightSideCount + botSideCount > total) {
            --topSideCount;
        }
        if (leftSideCount + topSideCount + rightSideCount + botSideCount > total) {
            --rightSideCount;
        }
        int fill = 0;
        for (i2 = 0; i2 < leftSideCount; ++i2) {
            labelLocs[fill++] = new Point2D.Double(displayable.getMinX() + digitIndentX, displayable.getHeight() / (double)(leftSideCount + 1) * (double)(i2 + 1) + displayable.getMinY());
        }
        for (i2 = 0; i2 < topSideCount; ++i2) {
            labelLocs[fill++] = new Point2D.Double(displayable.getWidth() / (double)(topSideCount + 1) * (double)(i2 + 1) + displayable.getMinX(), displayable.getMaxY() - digitIndentY);
        }
        for (i2 = 0; i2 < rightSideCount; ++i2) {
            labelLocs[fill++] = new Point2D.Double(displayable.getMaxX() - digitIndentX, displayable.getMaxY() - displayable.getHeight() / (double)(rightSideCount + 1) * (double)(i2 + 1));
        }
        for (i2 = 0; i2 < botSideCount; ++i2) {
            labelLocs[fill++] = new Point2D.Double(displayable.getMaxX() - displayable.getWidth() / (double)(botSideCount + 1) * (double)(i2 + 1), displayable.getMinY() + digitIndentY);
        }
        total = 0;
        int ignored = 0;
        if (nodes == null) {
            it = cell.getPorts();
            while (it.hasNext()) {
                Export pp = (Export)it.next();
                Poly poly = pp.getOriginalPort().getPoly();
                Point2D.Double ptOut = new Point2D.Double(poly.getCenterX(), poly.getCenterY());
                if (((Point2D)ptOut).getX() < displayable.getMinX() || ((Point2D)ptOut).getX() > displayable.getMaxX() || ((Point2D)ptOut).getY() < displayable.getMinY() || ((Point2D)ptOut).getY() > displayable.getMaxY()) {
                    ++ignored;
                    continue;
                }
                portList[total] = new ShownPorts();
                portList[total].loc = new Point2D.Double(poly.getCenterX(), poly.getCenterY());
                portList[total].pp = pp;
                ++total;
            }
        } else {
            it = nodes.iterator();
            while (it.hasNext()) {
                NodeInst ni = (NodeInst)it.next();
                Iterator pIt = ni.getPortInsts();
                while (pIt.hasNext()) {
                    PortInst pi = (PortInst)pIt.next();
                    Poly poly = pi.getPoly();
                    Point2D.Double ptOut = new Point2D.Double(poly.getCenterX(), poly.getCenterY());
                    if (((Point2D)ptOut).getX() < displayable.getMinX() || ((Point2D)ptOut).getX() > displayable.getMaxX() || ((Point2D)ptOut).getY() < displayable.getMinY() || ((Point2D)ptOut).getY() > displayable.getMaxY()) {
                        ++ignored;
                        continue;
                    }
                    portList[total] = new ShownPorts();
                    portList[total].loc = new Point2D.Double(poly.getCenterX(), poly.getCenterY());
                    portList[total].pp = pi.getPortProto();
                    ++total;
                }
            }
        }
        double x = 0.0;
        double y = 0.0;
        for (int i3 = 0; i3 < total; ++i3) {
            x += portList[i3].loc.getX();
            y += portList[i3].loc.getY();
        }
        Point2D.Double center = new Point2D.Double(x / (double)total, y / (double)total);
        for (int i4 = 0; i4 < total; ++i4) {
            portList[i4].angle = ((Point2D)center).getX() == portList[i4].loc.getX() && ((Point2D)center).getY() == portList[i4].loc.getY() ? 0 : -DBMath.figureAngle(center, portList[i4].loc);
        }
        ArrayList<ShownPorts> portLabels = new ArrayList<ShownPorts>();
        for (int i5 = 0; i5 < total; ++i5) {
            portLabels.add(portList[i5]);
        }
        Collections.sort(portLabels, new SortPortAngle());
        total = 0;
        Iterator it3 = portLabels.iterator();
        while (it3.hasNext()) {
            portList[total++] = (ShownPorts)it3.next();
        }
        double bestDist = 0.0;
        int bestOff = 0;
        for (i = 0; i < total; ++i) {
            double dist = 0.0;
            for (int j = 0; j < total; ++j) {
                dist += labelLocs[j].distance(portList[(j + i) % total].loc);
            }
            if (!(dist < bestDist) && i != 0) continue;
            bestOff = i;
            bestDist = dist;
        }
        Highlight.clear();
        if (nodes != null) {
            Iterator it4 = nodes.iterator();
            while (it4.hasNext()) {
                NodeInst ni = (NodeInst)it4.next();
                Highlight.addElectricObject(ni, cell);
            }
        }
        for (i = 0; i < total; ++i) {
            int index = (bestOff + i) % total;
            Highlight.addMessage(cell, portList[index].pp.getName(), labelLocs[i]);
            Highlight.addLine(labelLocs[i], portList[index].loc, cell);
        }
        Highlight.finished();
        if (total == 0) {
            System.out.println("No exported ports to show");
        }
        if (ignored > 0) {
            System.out.println("Could not display " + ignored + " ports (outside of the window)");
        }
    }

    private static class SortPortAngle
    implements Comparator {
        private SortPortAngle() {
        }

        public int compare(Object o1, Object o2) {
            ShownPorts s1 = (ShownPorts)o1;
            ShownPorts s2 = (ShownPorts)o2;
            return s1.angle - s2.angle;
        }
    }

    private static class ShownPorts {
        Point2D loc;
        PortProto pp;
        int angle;

        private ShownPorts() {
        }
    }

    private static class RenameExport
    extends Job {
        Export pp;
        String newName;

        protected RenameExport(Export pp, String newName) {
            super("Rename Export" + pp.getName(), User.tool, Job.Type.CHANGE, null, null, Job.Priority.USER);
            this.pp = pp;
            this.newName = newName;
            this.startJob();
        }

        public boolean doIt() {
            this.pp.rename(this.newName);
            return true;
        }
    }

    private static class MoveExport
    extends Job {
        Export source;
        PortInst dest;

        protected MoveExport(Export source, PortInst dest) {
            super("Move export", User.tool, Job.Type.CHANGE, null, null, Job.Priority.USER);
            this.source = source;
            this.dest = dest;
            this.startJob();
        }

        public boolean doIt() {
            this.source.move(this.dest);
            return true;
        }
    }

    private static class DeleteExports
    extends Job {
        List exportsToDelete;

        protected DeleteExports(List exportsToDelete) {
            super("Delete exports", User.tool, Job.Type.CHANGE, null, null, Job.Priority.USER);
            this.exportsToDelete = exportsToDelete;
            this.startJob();
        }

        public boolean doIt() {
            Highlight.clear();
            Highlight.finished();
            int total = 0;
            Iterator it = this.exportsToDelete.iterator();
            while (it.hasNext()) {
                Export e = (Export)it.next();
                e.kill();
                ++total;
            }
            if (total == 0) {
                System.out.println("No exports deleted");
            } else {
                System.out.println(total + " exports deleted");
            }
            return true;
        }
    }

    private static class ReExport
    extends Job {
        Cell cell;
        Rectangle2D bounds;
        boolean pAndG;

        protected ReExport(Cell cell, Rectangle2D bounds, boolean pAndG) {
            super("Re-export ports", User.tool, Job.Type.CHANGE, null, null, Job.Priority.USER);
            this.cell = cell;
            this.bounds = bounds;
            this.pAndG = pAndG;
            this.startJob();
        }

        public boolean doIt() {
            FlagSet portMarked = PortProto.getFlagSet(1);
            int total = 0;
            Iterator it = this.cell.getNodes();
            while (it.hasNext()) {
                PortInst pi;
                NodeInst ni = (NodeInst)it.next();
                if (!(ni.getProto() instanceof Cell) || ni.isIconOfParent()) continue;
                Iterator pIt = ni.getProto().getPorts();
                while (pIt.hasNext()) {
                    PortProto pp = (PortProto)pIt.next();
                    pp.clearBit(portMarked);
                }
                pIt = ni.getConnections();
                while (pIt.hasNext()) {
                    Connection con = (Connection)pIt.next();
                    con.getPortInst().getPortProto().setBit(portMarked);
                }
                pIt = ni.getExports();
                while (pIt.hasNext()) {
                    Export e = (Export)pIt.next();
                    e.getOriginalPort().getPortProto().setBit(portMarked);
                }
                ArrayList<PortInst> queuedExports = new ArrayList<PortInst>();
                Iterator pIt2 = ni.getPortInsts();
                while (pIt2.hasNext()) {
                    Poly portPoly;
                    PortProto pp;
                    pi = (PortInst)pIt2.next();
                    if (pi.getPortProto().isBit(portMarked) || this.pAndG && !(pp = pi.getPortProto()).isPower() && !pp.isGround() || this.bounds != null && !this.bounds.contains((portPoly = pi.getPoly()).getCenterX(), portPoly.getCenterY())) continue;
                    queuedExports.add(pi);
                }
                Collections.sort(queuedExports, new PortInstSorted());
                pIt2 = queuedExports.iterator();
                while (pIt2.hasNext()) {
                    String portName;
                    pi = (PortInst)pIt2.next();
                    Export newPp = Export.newInstance(this.cell, pi, portName = ElectricObject.uniqueObjectName(pi.getPortProto().getName(), this.cell, class$com$sun$electric$database$prototype$PortProto == null ? ExportChanges.class$("com.sun.electric.database.prototype.PortProto") : class$com$sun$electric$database$prototype$PortProto));
                    if (newPp == null) continue;
                    newPp.setTextDescriptor(pi.getPortProto().getTextDescriptor());
                    newPp.copyVars(pi.getPortProto());
                    ++total;
                }
            }
            if (total == 0) {
                System.out.println("No ports to export");
            } else {
                System.out.println(total + " ports exported");
            }
            portMarked.freeFlagSet();
            return true;
        }

        static class PortInstSorted
        implements Comparator {
            PortInstSorted() {
            }

            public int compare(Object o1, Object o2) {
                PortInst pi1 = (PortInst)o1;
                PortInst pi2 = (PortInst)o2;
                String s1 = pi1.getPortProto().getName();
                String s2 = pi2.getPortProto().getName();
                return s1.compareToIgnoreCase(s2);
            }
        }
    }

    private static class ExportSortedByBusIndex
    implements Comparator {
        private ExportSortedByBusIndex() {
        }

        public int compare(Object o1, Object o2) {
            Export e1 = (Export)o1;
            Export e2 = (Export)o2;
            String s1 = e1.getName();
            String s2 = e2.getName();
            return TextUtils.nameSameNumeric(s1, s2);
        }
    }

    private static class ExportSortedByNameAndType
    implements Comparator {
        private ExportSortedByNameAndType() {
        }

        public int compare(Object o1, Object o2) {
            PortProto.Characteristic ch2;
            ExportList el1 = (ExportList)o1;
            ExportList el2 = (ExportList)o2;
            Export e1 = el1.pp;
            Export e2 = el2.pp;
            PortProto.Characteristic ch1 = e1.getCharacteristic();
            if (ch1 != (ch2 = e2.getCharacteristic())) {
                return ch1.getOrder() - ch2.getOrder();
            }
            String s1 = e1.getName();
            String s2 = e2.getName();
            return TextUtils.nameSameNumeric(s1, s2);
        }
    }

    private static class ExportList {
        Export pp;
        int equiv;
        int busList;

        private ExportList() {
        }
    }
}

