/* -*- tab-width: 4 -*-
 *
 * Electric(tm) VLSI Design System
 *
 * File: Gate.java
 *
 * Copyright (c) 2008 Sun Microsystems and Static Free Software
 *
 * Electric(tm) is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 3 of the License, or
 * (at your option) any later version.
 *
 * Electric(tm) is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with Electric(tm); see the file COPYING.  If not, write to
 * the Free Software Foundation, Inc., 59 Temple Place, Suite 330,
 * Boston, Mass 02111-1307, USA.
 */
package com.sun.electric.tool.user.tecEditWizard;

import com.sun.electric.database.text.TextUtils;
import com.sun.electric.tool.user.Resources;

import javax.swing.JPanel;

/**
 * Class to handle the "Gate" tab of the Numeric Technology Editor dialog.
 */
public class Gate extends TechEditWizardPanel
{
	/** Creates new form Gate */
	public Gate(TechEditWizard parent, boolean modal)
	{
		super(parent, modal);
		initComponents();
		image.setIcon(Resources.getResource(getClass(), "Gate.png"));
		pack();
	}

	/** return the panel to use for this Numeric Technology Editor tab. */
	public JPanel getPanel() { return gate; }

	/** return the name of this Numeric Technology Editor tab. */
	public String getName() { return "Gate"; }

	/**
	 * Method called at the start of the dialog.
	 * Caches current values and displays them in the Gate tab.
	 */
	public void init()
	{
		TechEditWizardData data = wizard.getTechEditData();
		length.setText(TextUtils.formatDouble(data.getGateLength().v));
		lengthRule.setText(data.getGateLength().rule);
		width.setText(TextUtils.formatDouble(data.getGateWidth().v));
		widthRule.setText(data.getGateWidth().rule);
		contactSpacing.setText(TextUtils.formatDouble(data.getGateContactSpacing().v));
		contactSpacingRule.setText(data.getGateContactSpacing().rule);
		spacing.setText(TextUtils.formatDouble(data.getGateSpacing().v));
		spacingRule.setText(data.getGateSpacing().rule);
	}

	/**
	 * Method called when the "OK" panel is hit.
	 * Updates any changed fields in the Gate tab.
	 */
	public void term()
	{
		TechEditWizardData data = wizard.getTechEditData();
		data.setGateLength(new WizardField(TextUtils.atof(length.getText()), lengthRule.getText()));
		data.setGateWidth(new WizardField(TextUtils.atof(width.getText()), widthRule.getText()));
		data.setGateContactSpacing(new WizardField(TextUtils.atof(contactSpacing.getText()), contactSpacingRule.getText()));
		data.setGateSpacing(new WizardField(TextUtils.atof(spacing.getText()), spacingRule.getText()));
	}

	/** This method is called from within the constructor to
	 * initialize the form.
	 * WARNING: Do NOT modify this code. The content of this method is
	 * always regenerated by the Form Editor.
	 */
    // <editor-fold defaultstate="collapsed" desc=" Generated Code ">//GEN-BEGIN:initComponents
    private void initComponents() {
        java.awt.GridBagConstraints gridBagConstraints;

        gate = new javax.swing.JPanel();
        jLabel1 = new javax.swing.JLabel();
        width = new javax.swing.JTextField();
        jLabel2 = new javax.swing.JLabel();
        length = new javax.swing.JTextField();
        jLabel3 = new javax.swing.JLabel();
        contactSpacing = new javax.swing.JTextField();
        jLabel4 = new javax.swing.JLabel();
        spacing = new javax.swing.JTextField();
        image = new javax.swing.JLabel();
        jLabel7 = new javax.swing.JLabel();
        jLabel5 = new javax.swing.JLabel();
        jLabel6 = new javax.swing.JLabel();
        jLabel8 = new javax.swing.JLabel();
        lengthRule = new javax.swing.JTextField();
        widthRule = new javax.swing.JTextField();
        contactSpacingRule = new javax.swing.JTextField();
        spacingRule = new javax.swing.JTextField();

        getContentPane().setLayout(new java.awt.GridBagLayout());

        setTitle("Gate");
        setName("");
        addWindowListener(new java.awt.event.WindowAdapter() {
            public void windowClosing(java.awt.event.WindowEvent evt) {
                closeDialog(evt);
            }
        });

        gate.setLayout(new java.awt.GridBagLayout());

        jLabel1.setText("Width (B):");
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 4;
        gridBagConstraints.anchor = java.awt.GridBagConstraints.WEST;
        gridBagConstraints.insets = new java.awt.Insets(1, 4, 1, 0);
        gate.add(jLabel1, gridBagConstraints);

        width.setColumns(8);
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 4;
        gridBagConstraints.insets = new java.awt.Insets(1, 0, 1, 2);
        gate.add(width, gridBagConstraints);

        jLabel2.setText("Length (A):");
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.anchor = java.awt.GridBagConstraints.WEST;
        gridBagConstraints.insets = new java.awt.Insets(1, 4, 1, 0);
        gate.add(jLabel2, gridBagConstraints);

        length.setColumns(8);
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.insets = new java.awt.Insets(1, 0, 1, 2);
        gate.add(length, gridBagConstraints);

        jLabel3.setText("Contact spacing (C):");
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 5;
        gridBagConstraints.anchor = java.awt.GridBagConstraints.WEST;
        gridBagConstraints.insets = new java.awt.Insets(1, 4, 1, 0);
        gate.add(jLabel3, gridBagConstraints);

        contactSpacing.setColumns(8);
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 5;
        gridBagConstraints.insets = new java.awt.Insets(1, 0, 1, 2);
        gate.add(contactSpacing, gridBagConstraints);

        jLabel4.setText("Spacing (D):");
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 6;
        gridBagConstraints.anchor = java.awt.GridBagConstraints.WEST;
        gridBagConstraints.insets = new java.awt.Insets(1, 4, 1, 0);
        gate.add(jLabel4, gridBagConstraints);

        spacing.setColumns(8);
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 6;
        gridBagConstraints.insets = new java.awt.Insets(1, 0, 1, 2);
        gate.add(spacing, gridBagConstraints);

        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.gridwidth = 3;
        gridBagConstraints.insets = new java.awt.Insets(4, 4, 4, 4);
        gate.add(image, gridBagConstraints);

        jLabel7.setText("Distances are in nanometers");
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 7;
        gridBagConstraints.gridwidth = 3;
        gridBagConstraints.insets = new java.awt.Insets(4, 4, 1, 0);
        gate.add(jLabel7, gridBagConstraints);

        jLabel5.setText("Gate Parameters");
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.gridwidth = 3;
        gridBagConstraints.insets = new java.awt.Insets(4, 0, 4, 0);
        gate.add(jLabel5, gridBagConstraints);

        jLabel6.setText("Distance");
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 2;
        gate.add(jLabel6, gridBagConstraints);

        jLabel8.setText("Rule Name");
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 2;
        gate.add(jLabel8, gridBagConstraints);

        lengthRule.setColumns(8);
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.insets = new java.awt.Insets(1, 2, 1, 2);
        gate.add(lengthRule, gridBagConstraints);

        widthRule.setColumns(8);
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 4;
        gridBagConstraints.insets = new java.awt.Insets(1, 2, 1, 2);
        gate.add(widthRule, gridBagConstraints);

        contactSpacingRule.setColumns(8);
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 5;
        gridBagConstraints.insets = new java.awt.Insets(1, 2, 1, 2);
        gate.add(contactSpacingRule, gridBagConstraints);

        spacingRule.setColumns(8);
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 6;
        gridBagConstraints.insets = new java.awt.Insets(1, 2, 1, 2);
        gate.add(spacingRule, gridBagConstraints);

        getContentPane().add(gate, new java.awt.GridBagConstraints());

        pack();
    }// </editor-fold>//GEN-END:initComponents

	/** Closes the dialog */
	private void closeDialog(java.awt.event.WindowEvent evt)//GEN-FIRST:event_closeDialog
	{
		setVisible(false);
		dispose();
	}//GEN-LAST:event_closeDialog

    // Variables declaration - do not modify//GEN-BEGIN:variables
    private javax.swing.JTextField contactSpacing;
    private javax.swing.JTextField contactSpacingRule;
    private javax.swing.JPanel gate;
    private javax.swing.JLabel image;
    private javax.swing.JLabel jLabel1;
    private javax.swing.JLabel jLabel2;
    private javax.swing.JLabel jLabel3;
    private javax.swing.JLabel jLabel4;
    private javax.swing.JLabel jLabel5;
    private javax.swing.JLabel jLabel6;
    private javax.swing.JLabel jLabel7;
    private javax.swing.JLabel jLabel8;
    private javax.swing.JTextField length;
    private javax.swing.JTextField lengthRule;
    private javax.swing.JTextField spacing;
    private javax.swing.JTextField spacingRule;
    private javax.swing.JTextField width;
    private javax.swing.JTextField widthRule;
    // End of variables declaration//GEN-END:variables

}
