/*
 * Decompiled with CFR 0.152.
 */
package org.videolan.vlma.order;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.PrintWriter;
import java.net.Socket;
import org.apache.commons.configuration.Configuration;
import org.apache.log4j.Logger;
import org.videolan.vlma.model.Adapter;
import org.videolan.vlma.model.Order;
import org.videolan.vlma.model.Program;
import org.videolan.vlma.model.Server;
import org.videolan.vlma.model.StreamingStrategy;
import org.videolan.vlma.order.CommandLogger;

public abstract class OrderSender {
    private static final Logger logger = Logger.getLogger(OrderSender.class);
    private static final int TELNET_WAIT_INTERVAL = 100;
    private static final int TELNET_WAIT_MAX = 5000;
    protected CommandLogger commandLogger;
    protected Configuration configuration;
    private Socket telnetSocket;
    private PrintWriter telnetOut;
    private BufferedReader telnetIn;

    protected String getVLMCommandName(Order order) {
        return "flux-" + order.getAdapter().getName();
    }

    protected void telnetConnect(Server server) throws IOException {
        this.telnetSocket = new Socket(server.getIp(), this.configuration.getInt("vlc.telnet.port"));
        this.telnetOut = new PrintWriter(this.telnetSocket.getOutputStream(), true);
        this.telnetIn = new BufferedReader(new InputStreamReader(this.telnetSocket.getInputStream()));
        this.telnetOut.println(this.configuration.getString("vlc.telnet.password"));
        try {
            Thread.sleep(this.configuration.getInt("vlc.telnet.delay"));
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
    }

    protected void telnetClose() throws IOException {
        this.telnetOut.close();
        this.telnetIn.close();
        this.telnetSocket.close();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void telnetCommand(String command, Adapter adapter) throws IOException {
        Server server = adapter.getServer();
        synchronized (server) {
            logger.debug((Object)("Send command " + command + " to " + adapter.getServer().getName()));
            this.telnetOut.println(command);
            try {
                Thread.sleep(this.configuration.getInt("vlc.telnet.delay"));
            }
            catch (InterruptedException e) {
                // empty catch block
            }
            int timeSleeped = 0;
            while (!this.telnetIn.ready() && (timeSleeped += 100) <= 5000) {
                try {
                    Thread.sleep(100L);
                }
                catch (InterruptedException e) {}
            }
            StringBuilder response = new StringBuilder();
            while (this.telnetIn.ready()) {
                response.append((char)this.telnetIn.read());
            }
            this.commandLogger.add(adapter.getServer(), command, response.toString());
            logger.debug((Object)("Command result: " + response));
        }
    }

    protected void init(String commandName, Adapter adapter) throws IOException {
        this.telnetCommand("setup " + commandName + " disabled", adapter);
        this.telnetCommand("control " + commandName + " stop", adapter);
        this.telnetCommand("del " + commandName, adapter);
        this.telnetCommand("new " + commandName + " broadcast", adapter);
        this.telnetCommand("setup " + commandName + " option vvv", adapter);
        this.telnetCommand("setup " + commandName + " option color", adapter);
        this.telnetCommand("setup " + commandName + " option ttl=" + Integer.toString(this.configuration.getInt("vlc.stream.ttl")), adapter);
    }

    public abstract void start(Order var1) throws IOException;

    public String getAccess(Program program) {
        StreamingStrategy streamingStrategy = program.getStreamingStrategy();
        if (streamingStrategy.getProtocol().equals((Object)StreamingStrategy.Protocol.UDP_MULTICAST)) {
            return "udp";
        }
        if (streamingStrategy.getProtocol().equals((Object)StreamingStrategy.Protocol.HTTP)) {
            return "http";
        }
        return null;
    }

    public String getDst(Program program) {
        StreamingStrategy streamingStrategy = program.getStreamingStrategy();
        if (streamingStrategy.getProtocol().equals((Object)StreamingStrategy.Protocol.UDP_MULTICAST)) {
            return program.getIp().getHostAddress();
        }
        if (streamingStrategy.getProtocol().equals((Object)StreamingStrategy.Protocol.HTTP)) {
            Integer port = this.configuration.getInt("vlma.streaming.http.port");
            return program.getPlayer().getHostAddress() + ":" + port + "/" + program.hashCode();
        }
        return null;
    }

    public String getMux(Program program) {
        return program.getStreamingStrategy().getEncapsulation().toString().toLowerCase();
    }

    protected void stopCommand(String commandName, Adapter adapter) throws IOException {
        this.telnetCommand("control " + commandName + " disabled", adapter);
        this.telnetCommand("control " + commandName + " stop", adapter);
        this.telnetCommand("del " + commandName, adapter);
    }

    public void stop(Order o) throws IOException {
        this.telnetConnect(o.getAdapter().getServer());
        this.stopCommand(this.getVLMCommandName(o), o.getAdapter());
        this.telnetClose();
    }

    public void setConfiguration(Configuration configuration) {
        this.configuration = configuration;
    }

    public void setCommandLogger(CommandLogger commandLogger) {
        this.commandLogger = commandLogger;
    }
}

