/*
 * Decompiled with CFR 0.152.
 */
package org.jrobin.graph;

import java.awt.BasicStroke;
import java.awt.Color;
import java.util.HashMap;
import org.jrobin.core.RrdException;
import org.jrobin.core.XmlWriter;
import org.jrobin.graph.ChartGraphics;
import org.jrobin.graph.Source;

abstract class PlotDef {
    protected static final int PLOT_LINE = 0;
    protected static final int PLOT_AREA = 1;
    protected static final int PLOT_STACK = 2;
    protected static final BasicStroke STROKE = new BasicStroke();
    protected boolean visible = true;
    protected boolean stacked = false;
    protected int plotType = 0;
    protected String sourceName = "";
    protected Source source = null;
    protected Color color = Color.BLACK;
    protected double[] values = null;

    PlotDef() {
    }

    PlotDef(String string, Color color) {
        this.sourceName = string;
        this.color = color;
        if (color == null) {
            this.visible = false;
        }
    }

    PlotDef(Source source, double[] dArray, Color color, boolean bl, boolean bl2) {
        this.source = source;
        this.values = dArray;
        this.color = color;
        this.stacked = bl;
        this.visible = bl2;
    }

    void setSource(Source[] sourceArray, HashMap hashMap) throws RrdException {
        if (!hashMap.containsKey(this.sourceName)) {
            throw new RrdException("Invalid DEF or CDEF: " + this.sourceName);
        }
        this.source = sourceArray[(Integer)hashMap.get(this.sourceName)];
    }

    void prepareValues(int n) {
        this.values = new double[n];
    }

    void setValue(int n, long l, long[] lArray) {
        this.values[n] = this.source.get(l, lArray);
    }

    double getValue(int n, long[] lArray) {
        return this.source.get(n);
    }

    abstract void draw(ChartGraphics var1, int[] var2, double[] var3, int var4) throws RrdException;

    Source getSource() {
        return this.source;
    }

    String getSourceName() {
        return this.sourceName;
    }

    int getType() {
        return this.plotType;
    }

    Color getColor() {
        return this.color;
    }

    void exportXmlTemplate(XmlWriter xmlWriter, String string) {
    }
}

