/*
 * Decompiled with CFR 0.152.
 */
import java.awt.Font;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.Menu;
import java.awt.MenuBar;
import java.awt.MenuItem;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.util.Enumeration;
import javax.swing.JButton;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.UIDefaults;
import javax.swing.UIManager;
import javax.swing.border.BevelBorder;
import javax.swing.plaf.FontUIResource;
import snmp.SNMPBadValueException;
import snmp.SNMPGetException;
import snmp.SNMPObject;
import snmp.SNMPObjectIdentifier;
import snmp.SNMPOctetString;
import snmp.SNMPPDU;
import snmp.SNMPRequestListener;
import snmp.SNMPSequence;
import snmp.SNMPSetException;
import snmp.SNMPVariablePair;
import snmp.SNMPv1AgentInterface;

public class SNMPAgentTest
extends JFrame
implements ActionListener,
SNMPRequestListener {
    JButton clearButton;
    JTextArea messagesArea;
    JScrollPane messagesScroll;
    JLabel authorLabel;
    MenuBar theMenubar;
    Menu fileMenu;
    MenuItem aboutItem;
    MenuItem quitItem;
    SNMPv1AgentInterface agentInterface;
    String communityName = "public";
    SNMPOctetString storedSNMPValue;

    public SNMPAgentTest() {
        this.setUpDisplay();
        this.storedSNMPValue = new SNMPOctetString("Original value");
        try {
            int n = 0;
            this.agentInterface = new SNMPv1AgentInterface(n);
            this.agentInterface.addRequestListener(this);
            this.agentInterface.startReceiving();
        }
        catch (Exception exception) {
            this.messagesArea.append("Problem starting Agent Test: " + exception.toString() + "\n");
        }
    }

    private void setUpDisplay() {
        Object object;
        this.setTitle("SNMP Agent Test");
        this.getRootPane().setBorder(new BevelBorder(0));
        UIManager uIManager = new UIManager();
        FontUIResource fontUIResource = new FontUIResource("SansSerif", 0, 10);
        UIDefaults uIDefaults = uIManager.getLookAndFeelDefaults();
        Enumeration enumeration = uIDefaults.keys();
        while (enumeration.hasMoreElements()) {
            object = (String)enumeration.nextElement();
            if (((String)object).indexOf("font") <= -1 && ((String)object).indexOf("Font") <= -1) continue;
            UIManager.put(object, fontUIResource);
        }
        this.addWindowListener(new WindowCloseAdapter());
        this.theMenubar = new MenuBar();
        this.setMenuBar(this.theMenubar);
        this.fileMenu = new Menu("File");
        this.aboutItem = new MenuItem("About...");
        this.aboutItem.setActionCommand("about");
        this.aboutItem.addActionListener(this);
        this.fileMenu.add(this.aboutItem);
        this.fileMenu.addSeparator();
        this.quitItem = new MenuItem("Quit");
        this.quitItem.setActionCommand("quit");
        this.quitItem.addActionListener(this);
        this.fileMenu.add(this.quitItem);
        this.theMenubar.add(this.fileMenu);
        this.clearButton = new JButton("Clear messages");
        this.clearButton.setActionCommand("clear messages");
        this.clearButton.addActionListener(this);
        this.authorLabel = new JLabel(" Version 1.0        J. Sevy, August 2003 ");
        this.authorLabel.setFont(new Font("SansSerif", 2, 8));
        this.messagesArea = new JTextArea(10, 60);
        this.messagesScroll = new JScrollPane(this.messagesArea);
        object = new GridBagLayout();
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.gridheight = 1;
        gridBagConstraints.fill = 0;
        gridBagConstraints.ipadx = 0;
        gridBagConstraints.ipady = 0;
        gridBagConstraints.insets = new Insets(2, 2, 2, 2);
        gridBagConstraints.anchor = 10;
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.weighty = 0.0;
        JPanel jPanel = new JPanel();
        jPanel.setLayout((LayoutManager)object);
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.anchor = 17;
        JLabel jLabel = new JLabel("Received requests:");
        ((GridBagLayout)object).setConstraints(jLabel, gridBagConstraints);
        jPanel.add(jLabel);
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.anchor = 13;
        ((GridBagLayout)object).setConstraints(this.clearButton, gridBagConstraints);
        jPanel.add(this.clearButton);
        gridBagConstraints.fill = 1;
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.weightx = 0.5;
        gridBagConstraints.weighty = 0.5;
        gridBagConstraints.anchor = 10;
        ((GridBagLayout)object).setConstraints(this.messagesScroll, gridBagConstraints);
        jPanel.add(this.messagesScroll);
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.weighty = 0.0;
        this.getContentPane().setLayout((LayoutManager)object);
        gridBagConstraints.fill = 1;
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.weightx = 0.5;
        gridBagConstraints.weighty = 0.5;
        ((GridBagLayout)object).setConstraints(jPanel, gridBagConstraints);
        this.getContentPane().add(jPanel);
        gridBagConstraints.fill = 0;
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.weighty = 0.0;
        ((GridBagLayout)object).setConstraints(this.authorLabel, gridBagConstraints);
        this.getContentPane().add(this.authorLabel);
    }

    public void actionPerformed(ActionEvent actionEvent) {
        String string = actionEvent.getActionCommand();
        if (string == "quit") {
            System.exit(0);
        }
        if (string == "clear messages") {
            this.messagesArea.setText("");
        }
        if (string == "about") {
            // empty if block
        }
    }

    public SNMPSequence processRequest(SNMPPDU sNMPPDU, String string) throws SNMPGetException, SNMPSetException {
        this.messagesArea.append("Got pdu:\n");
        this.messagesArea.append("  community name:     " + string + "\n");
        this.messagesArea.append("  request ID:         " + sNMPPDU.getRequestID() + "\n");
        this.messagesArea.append("  pdu type:           ");
        byte by = sNMPPDU.getPDUType();
        switch (by) {
            case -96: {
                this.messagesArea.append("SNMPGETREQUEST\n");
                break;
            }
            case -95: {
                this.messagesArea.append("SNMPGETNEXTREQUEST\n");
                break;
            }
            case -93: {
                this.messagesArea.append("SNMPSETREQUEST\n");
                break;
            }
            case -94: {
                this.messagesArea.append("SNMPGETRESPONSE\n");
                break;
            }
            case -92: {
                this.messagesArea.append("SNMPTRAP\n");
                break;
            }
            default: {
                this.messagesArea.append("unknown\n");
            }
        }
        SNMPSequence sNMPSequence = sNMPPDU.getVarBindList();
        SNMPSequence sNMPSequence2 = new SNMPSequence();
        for (int i = 0; i < sNMPSequence.size(); ++i) {
            SNMPVariablePair sNMPVariablePair;
            SNMPSequence sNMPSequence3 = (SNMPSequence)sNMPSequence.getSNMPObjectAt(i);
            SNMPObjectIdentifier sNMPObjectIdentifier = (SNMPObjectIdentifier)sNMPSequence3.getSNMPObjectAt(0);
            SNMPObject sNMPObject = sNMPSequence3.getSNMPObjectAt(1);
            this.messagesArea.append("       OID:           " + sNMPObjectIdentifier + "\n");
            this.messagesArea.append("       value:         " + sNMPObject + "\n");
            if (!string.equals(this.communityName)) continue;
            if (sNMPObjectIdentifier.toString().equals("1.3.6.1.2.1.99.0")) {
                if (by == -93) {
                    int n = i + 1;
                    int n2 = 4;
                    throw new SNMPSetException("Trying to set a read-only variable!", n, n2);
                }
                if (by == -96) {
                    try {
                        sNMPVariablePair = new SNMPVariablePair(sNMPObjectIdentifier, new SNMPOctetString("Boo"));
                        sNMPSequence2.addSNMPObject(sNMPVariablePair);
                    }
                    catch (SNMPBadValueException sNMPBadValueException) {
                        // empty catch block
                    }
                }
            }
            if (!sNMPObjectIdentifier.toString().equals("1.3.6.1.2.1.100.0")) continue;
            if (by == -93) {
                if (sNMPObject instanceof SNMPOctetString) {
                    this.storedSNMPValue = (SNMPOctetString)sNMPObject;
                    try {
                        sNMPVariablePair = new SNMPVariablePair(sNMPObjectIdentifier, this.storedSNMPValue);
                        sNMPSequence2.addSNMPObject(sNMPVariablePair);
                    }
                    catch (SNMPBadValueException sNMPBadValueException) {}
                    continue;
                }
                int n = i + 1;
                int n3 = 3;
                throw new SNMPSetException("Supplied value must be SNMPOctetString", n, n3);
            }
            if (by != -96) continue;
            try {
                sNMPVariablePair = new SNMPVariablePair(sNMPObjectIdentifier, this.storedSNMPValue);
                sNMPSequence2.addSNMPObject(sNMPVariablePair);
                continue;
            }
            catch (SNMPBadValueException sNMPBadValueException) {
                // empty catch block
            }
        }
        this.messagesArea.append("\n");
        return sNMPSequence2;
    }

    public SNMPSequence processGetNextRequest(SNMPPDU sNMPPDU, String string) throws SNMPGetException {
        this.messagesArea.append("Got pdu:\n");
        this.messagesArea.append("  community name:     " + string + "\n");
        this.messagesArea.append("  request ID:         " + sNMPPDU.getRequestID() + "\n");
        this.messagesArea.append("  pdu type:           ");
        byte by = sNMPPDU.getPDUType();
        switch (by) {
            case -96: {
                this.messagesArea.append("SNMPGETREQUEST\n");
                break;
            }
            case -95: {
                this.messagesArea.append("SNMPGETNEXTREQUEST\n");
                break;
            }
            case -93: {
                this.messagesArea.append("SNMPSETREQUEST\n");
                break;
            }
            case -94: {
                this.messagesArea.append("SNMPGETRESPONSE\n");
                break;
            }
            case -92: {
                this.messagesArea.append("SNMPTRAP\n");
                break;
            }
            default: {
                this.messagesArea.append("unknown\n");
            }
        }
        SNMPSequence sNMPSequence = sNMPPDU.getVarBindList();
        SNMPSequence sNMPSequence2 = new SNMPSequence();
        for (int i = 0; i < sNMPSequence.size(); ++i) {
            SNMPSequence sNMPSequence3 = (SNMPSequence)sNMPSequence.getSNMPObjectAt(i);
            SNMPObjectIdentifier sNMPObjectIdentifier = (SNMPObjectIdentifier)sNMPSequence3.getSNMPObjectAt(0);
            SNMPObject sNMPObject = sNMPSequence3.getSNMPObjectAt(1);
            this.messagesArea.append("       OID:           " + sNMPObjectIdentifier + "\n");
            this.messagesArea.append("       value:         " + sNMPObject + "\n");
            if (!string.equals(this.communityName) || !sNMPObjectIdentifier.toString().equals("1.3.6.1.2.1.99.0") || by != -95) continue;
            try {
                SNMPObjectIdentifier sNMPObjectIdentifier2 = new SNMPObjectIdentifier("1.3.6.1.2.1.100.0");
                SNMPVariablePair sNMPVariablePair = new SNMPVariablePair(sNMPObjectIdentifier2, this.storedSNMPValue);
                SNMPVariablePair sNMPVariablePair2 = new SNMPVariablePair(sNMPObjectIdentifier, sNMPVariablePair);
                sNMPSequence2.addSNMPObject(sNMPVariablePair2);
                continue;
            }
            catch (SNMPBadValueException sNMPBadValueException) {
                // empty catch block
            }
        }
        this.messagesArea.append("\n");
        return sNMPSequence2;
    }

    public static void main(String[] stringArray) {
        try {
            SNMPAgentTest sNMPAgentTest = new SNMPAgentTest();
            sNMPAgentTest.pack();
            sNMPAgentTest.setSize(600, 500);
            sNMPAgentTest.show();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private class WindowCloseAdapter
    extends WindowAdapter {
        private WindowCloseAdapter() {
        }

        public void windowClosing(WindowEvent windowEvent) {
            System.exit(0);
        }
    }
}

