/*
 * Copyright (C) 2006-2008 the VideoLAN team
 *
 * This file is part of VLMa.
 * 
 * VLMa is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 2 of the License, or
 * (at your option) any later version.
 * 
 * VLMa is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with VLMa. If not, see <http://www.gnu.org/licenses/>.
 *
 */

package org.videolan.vlma.web.servers;

import org.videolan.vlma.common.IVlData;

public class ServersAdapterAdd {

    private int server;

    private String name;

    private IVlData data;

    private String type;

    private String satellite;

    public String getSatellite() {
        return satellite;
    }

    public void setSatellite(String satellite) {
        this.satellite = satellite;
    }

    public IVlData getData() {
        return data;
    }

    public void setData(IVlData data) {
        this.data = data;
    }

    public String getName() {
        return name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public int getServer() {
        return server;
    }

    public void setServer(int server) {
        this.server = server;
    }

    public String getType() {
        if (type.equals("DVB-S")) {
            return "org.videolan.vlma.common.adapters.VlDVBS";
        } else if (type.equals("DVB-T")) {
            return "org.videolan.vlma.common.adapters.VlDVBT";
        } else if (type.equals("Files-Adapter")) {
            return "org.videolan.vlma.common.adapters.VlFilesAdapter";
        }
        return type;
    }

    public void setType(String type) {
        this.type = type;
    }

}
