# This is a shell script that calls functions and scripts from
# tml@iki.fi's personal work environment. It is not expected to be
# usable unmodified by others, and is included only for reference.

MOD=libgnomeui
VER=2.22.1
THIS=$MOD-$VER
HEX=`echo $THIS | md5sum | cut -d' ' -f1`
TARGET=/devel/target/$HEX

MINOR=${VER%.*}
MINOR=${MINOR#*.}

(( $MINOR % 2 == 1 )) && UNSTABLE="-unstable"

DEPS=`/devel/src/tml/latest$UNSTABLE.sh glib atk pixman cairo pango gtk+ libIDL ORBit2 libglade libart_lgpl libgnomecanvas gail libbonobo GConf libgnome libbonoboui gnome-vfs`

sed -e 's/need_relink=yes/need_relink=no # no way --tml/' <ltmain.sh >ltmain.temp && mv ltmain.temp ltmain.sh

# Avoid using "file" in libtool. Otherwise libtool won't create a
# shared library, and give the extremely confusing and annoying
# warning "Trying to link with static lib archive [...] But I can only
# do this if you have shared version of the library, which you do not
# appear to have." Screw libtool. I know what I am doing. Yes, I do
# want to link with a static libintl now. (The proxy-libintl libintl
# wrapper.)

sed -e 's!file /!dont-want-to-use-file!' <configure >configure.temp && mv configure.temp configure

usedev

MY_PKG_CONFIG_PATH=""
for D in $DEPS; do
    PATH=/devel/dist/$D/bin:$PATH
    MY_PKG_CONFIG_PATH=/devel/dist/$D/lib/pkgconfig:$MY_PKG_CONFIG_PATH
done

# Nah, this doesn't work either. Anyway, I don't think this intltool-extract stuff matters that much
# sed -e "s!='\$(top_builddir)/intltool-extract'!='perl \$(top_builddir)/intltool-extract'!" <configure >configure.tmp && mv configure.tmp configure &&

PKG_CONFIG_PATH=$MY_PKG_CONFIG_PATH:$PKG_CONFIG_PATH CC='gcc -mtune=pentium3 -mthreads' CPPFLAGS='-I/opt/win_iconv/include -I/opt/proxy-libintl/include -I/opt/gnuwin32/include -I/devel/dist/popt-1.10.2-tml-20050828/include' LDFLAGS='-L/opt/proxy-libintl/lib -L/opt/gnuwin32/lib -L/devel/dist/popt-1.10.2-tml-20050828/lib' CFLAGS=-O2 ./configure --enable-debug=yes --disable-gtk-doc --disable-static --prefix=c:$TARGET &&
libtoolcacheize &&
unset MY_PKG_CONFIG_PATH &&

PATH=$TARGET/bin:.libs:$PATH make -j3 install &&
PATH=$TARGET/bin:$PATH make check &&

./libgnomeui-zip &&

(cd /devel/src/tml && zip /tmp/$MOD-dev-$VER.zip make/$THIS.sh) &&
manifestify /tmp/$MOD*-$VER.zip
