# This is a shell script that calls functions and scripts from
# tml@iki.fi's personal work environment. It is not expected to be
# usable unmodified by others, and is included only for reference.

MOD=gnome-icon-theme
VER=2.24.0
REV=1
ARCH=win32

THIS=${MOD}_${VER}-${REV}_${ARCH}

RUNZIP=${MOD}_${VER}-${REV}_${ARCH}.zip
DEVZIP=${MOD}-dev_${VER}-${REV}_${ARCH}.zip

HEX=`echo $THIS | md5sum | cut -d' ' -f1`
TARGET=c:/devel/target/$HEX

usedev

(

set -x

DEPS=`latest --arch=${ARCH} hicolor-icon-theme icon-naming-utils intltool`

PKG_CONFIG_PATH=/dummy
for D in $DEPS; do
    PATH="/devel/dist/${ARCH}/$D/bin:$PATH"
    [ -d /devel/dist/${ARCH}/$D/lib/pkgconfig ] && PKG_CONFIG_PATH=/devel/dist/${ARCH}/$D/lib/pkgconfig:$PKG_CONFIG_PATH
    [ -d /devel/dist/${ARCH}/$D/share/pkgconfig ] && PKG_CONFIG_PATH=/devel/dist/${ARCH}/$D/share/pkgconfig:$PKG_CONFIG_PATH
done

CC='gcc -mtune=pentium3 -mthreads' ./configure --disable-gtk-doc --prefix=$TARGET &&

GMSGFMT=msgfmt make install &&

cd /devel/target/$HEX &&
rm -f /tmp/$RUNZIP &&
zip -r -D /tmp/$RUNZIP share/icons/gnome &&
rm -f /tmp/$DEVZIP &&
zip -r -D /tmp/$DEVZIP share/pkgconfig

) 2>&1 | tee /devel/src/tml/make/$THIS.log

(cd /devel && zip /tmp/$DEVZIP src/tml/make/$THIS.{sh,log}) &&
manifestify /tmp/$RUNZIP /tmp/$DEVZIP
