# This is a shell script that calls functions and scripts from
# tml@iki.fi's personal work environment. It is not expected to be
# usable unmodified by others, and is included only for reference.

MOD=gnome-common
VER=2.28.0
REV=1
ARCH=win32

THIS=${MOD}_${VER}-${REV}_${ARCH}

RUNZIP=${MOD}_${VER}-${REV}_${ARCH}.zip
DEVZIP=${MOD}-dev_${VER}-${REV}_${ARCH}.zip

HEX=`echo $THIS | md5sum | cut -d' ' -f1`
TARGET=c:/devel/target/$HEX

usedev

(

set -x

./configure --prefix=c:/devel/target/$THIS &&
make install &&

rm -f /tmp/$RUNZIP /tmp/$DEVZIP &&

cd /devel/target/$THIS &&

# RUNZIP is empty, everything is in DEVZIP
zip /tmp/$RUNZIP nul: &&
zip -d /tmp/$RUNZIP nul:. &&

zip -D -r /tmp/$DEVZIP . &&

:) 2>&1 | tee /devel/src/tml/packaging/$THIS.log

(cd /devel && zip /tmp/$DEVZIP src/tml/packaging/$THIS.{sh,log}) &&
manifestify /tmp/$RUNZIP /tmp/$DEVZIP
