# EFS40 EADI by Bea Wolf (D-ECHO) based on A320 canvas avionics by Joshua Davidson

var EFS40_EADI_main = nil;
var EFS40_EADI_display = nil;

# Instrument Properties
var ias_kts		=	props.globals.getNode("instrumentation/airspeed-indicator/indicated-speed-kt", 1);
var no_wow		=	props.globals.getNode("fdm/jsbsim/fcs/gear-no-wow");
var gs		=	props.globals.getNode("velocities/groundspeed-kt");
var sat		=	props.globals.getNode("environment/temperature-degc");
var pitch		=	props.globals.getNode("orientation/pitch-deg");
var roll		=	props.globals.getNode("orientation/roll-deg");
var turn		=	props.globals.getNode("instrumentation/turn-indicator/indicated-turn-rate");
var radaralt	=	props.globals.getNode("instrumentation/radar-altimeter/radar-altitude-ft");
var heading		=	props.globals.getNode("orientation/heading-deg");
var vs_fpm		=	props.globals.getNode("instrumentation/vertical-speed-indicator/indicated-speed-fpm");
var vs_needle	=	base.getNode("vertical-speed-needle");
var alt		=	props.globals.getNode("instrumentation/altimeter/indicated-altitude-ft");
var qnh		=	props.globals.getNode("instrumentation/altimeter/setting-hpa");
var fd_pitch	=	props.globals.getNode("autopilot/fd/pitch-command-deg");
var fd_roll		=	props.globals.getNode("autopilot/fd/roll-command-deg");
var fd_active	=	props.globals.getNode("autopilot/internal/flight-director-active");

var marker = [
	props.globals.getNode("instrumentation/marker-beacon/outer"),
	props.globals.getNode("instrumentation/marker-beacon/middle"),
	props.globals.getNode("instrumentation/marker-beacon/inner"),
];

var dec_hgt		=	props.globals.initNode("instrumentation/efs40/decision-height", 200, "INT");
var alt_presel	=	props.globals.initNode("autopilot/settings/target-altitude-ft", 0.0, "DOUBLE");

#var ap_on    = props.globals.getNode("autopilot/internal/autopilot-active");
#var yd_on    = props.globals.getNode("autopilot/internal/yaw-damper-active");
#aircraft.light.new( "/instrumentation/efi-890r/ap-fds/ap-flash", [0.2, 0.2] );
#aircraft.light.new( "/instrumentation/efi-890r/ap-fds/yd-flash", [0.2, 0.2] );
#var ap_flash = [
#	props.globals.getNode("/instrumentation/efi-890r/ap-fds/ap-flash/state"),
#	props.globals.getNode("/instrumentation/efi-890r/ap-fds/ap-flash/enabled"),
#];
#var yd_flash = [
#	props.globals.getNode("/instrumentation/efi-890r/ap-fds/yd-flash/state"),
#	props.globals.getNode("/instrumentation/efi-890r/ap-fds/yd-flash/enabled"),
#];

var canvas_EFS40_EADI_base = {
	init: func(canvas_group, file) {
		var font_mapper = func(family, weight) {
			return "LiberationFonts/LiberationSans-Bold.ttf";
		};
		
		canvas.parsesvg(canvas_group, file, {'font-mapper': font_mapper});
		
		var svg_keys = me.getKeys();
		 
		foreach(var key; svg_keys) {
			me[key] = canvas_group.getElementById(key);
		}
		
		if( me["horizon"] != nil and me["fd"] != nil ){
			me.h_trans = me["horizon"].createTransform();
			me.h_rot = me["horizon"].createTransform();
			me.fd_trans = me["fd"].createTransform();
			me.fd_rot = me["fd"].createTransform();
		}
		
		me.page = canvas_group;
		
		return me;
	},
	getKeys: func() {
		return [];
	},
	update: func() {
		if( du_status[0] >= 1 ){
			EFS40_EADI_main.page.show();
		} else {
			EFS40_EADI_main.page.hide();
		}
	},
};

var canvas_EFS40_EADI_main = {
	new: func(canvas_group, file) {
		var m = { parents: [canvas_EFS40_EADI_main , canvas_EFS40_EADI_base] };
		m.init(canvas_group, file);

		return m;
	},
	getKeys: func() {
		return ["horizon", "sky_pointer", "radaralt", "turn.needle", 
		
		"ap.annun", "yd.annun", "fd",
		"dh.text", "dh.annun",
		#	Slow update
		"horizon.hdg_bar",
		"hdg_bug",
		"OM.annun", "MM.annun", "IM.annun",
		];
	},
	fast_update: func() {
		if( du_status[0] != 2 ) return;
		
		# Attitude Indicator
		var pitch_v = pitch.getDoubleValue();
		var roll_v = roll.getDoubleValue();
		me.h_trans.setTranslation( 0, pitch_v * 9.5 );
		me.h_rot.setRotation( -roll_v * D2R , me["horizon"].getCenter() );
		me["sky_pointer"].setRotation( -roll_v * D2R );
		
		# Flight Director
	#	if( fd_active.getBoolValue() ){
	#		me["fd"].show();
	#		me.fd_trans.setTranslation( 0, ( pitch_v + fd_pitch.getDoubleValue() ) * 8.8819 );
	#		me.fd_rot.setRotation( ( roll_v + fd_roll.getDoubleValue() ) * -D2R, me["fd"].getCenter() );
	#	} else {
	#		me["fd"].hide();
	#	}
		
		

		# Radio altimeter
		var ra = radaralt.getDoubleValue() or 0.0;
		if( ra <= 2500 ){
			me["radaralt"].show();
			if( ra >= 500 ){
				me["radaralt"].setText(sprintf("%1d", math.round( ra, 10 )));
			} else {
				me["radaralt"].setText(sprintf("%1d", math.round( ra,  5) ));
			}
		} else {
			me["radaralt"].hide();
		}

		# Decision Height
		var dh = dec_hgt.getDoubleValue();
		me["dh.text"].setText( sprintf("%3d", math.round( dh ) ) );
		
		if( ra < dh ){
			me["dh.annun"].show();
		} else {
			me["dh.annun"].hide();
		}

		
		# Autopilot Annunciations
	#	if( ap_status[0] == 2 or ( ap_status[0] * ap_flash[0].getBoolValue() ) == 1 ){
	#		me["ap.annun"].show();
	#	} else {
	#		me["ap.annun"].hide();
	#	}
	#	if( ap_status[1] == 2 or ( ap_status[1] * yd_flash[0].getBoolValue() ) == 1 ){
	#		me["yd.annun"].show();
	#	} else {
	#		me["yd.annun"].hide();
	#	}
	},
	slow_update: func{
		if( du_status[0] != 2 ) return;

		# HSI
		var heading_v = heading.getDoubleValue();
		me["horizon.hdg_bar"].setTranslation( -heading_v * 4.2, 0 );

		var hdg_bug_v = hdg_bug.getDoubleValue();
		me["hdg_bug"].setTranslation( -hdg_bug_v * 4.2, 0 );
		
		# Marker Beacon
		if( marker[0].getBoolValue() ){
			me["OM.annun"].show();
		} else {
			me["OM.annun"].hide();
		}
		if( marker[1].getBoolValue() ){
			me["MM.annun"].show();
		} else {
			me["MM.annun"].hide();
		}
		if( marker[2].getBoolValue() ){
			me["IM.annun"].show();
		} else {
			me["IM.annun"].hide();
		}
	},
};


var efs40_eadi_update = maketimer(0.02, func {
	canvas_EFS40_EADI_base.update();
});
efs40_eadi_update.simulatedTime = 1;

var main_fast_update = maketimer( 0.02, func{ EFS40_EADI_main.fast_update(); } );
main_fast_update.simulatedTime = 1;

var main_slow_update = maketimer( 0.2, func{ EFS40_EADI_main.slow_update(); } );
main_slow_update.simulatedTime = 1;

var ls_eadi = setlistener("sim/signals/fdm-initialized", func {
	EFS40_EADI_display = canvas.new({
		"name": "EFS40_EADI",
		"size": [600, 600],
		"view": [600, 600],
		"mipmapping": 1
	});
	EFS40_EADI_display.addPlacement({"node": "ed462.screen.eadi"});
	var groupMain = 

	EFS40_EADI_main = canvas_EFS40_EADI_main.new(EFS40_EADI_display.createGroup(), instrument_path~"efs40-eadi.svg");

	efs40_eadi_update.start();
	main_fast_update.start();
	main_slow_update.start();
	
	removelistener(ls_eadi);
});
