##################################################################
#
# Wing Failure: Reset all failure values
#
################################################################## 

var wing_failure_repair = func { 
	setprop("orientation/roll-deg", 0. );  
	setprop("sim/asw20/wing-failure", 0 );
	setprop("sim/asw20/wing-failure-direction", 0 );
	setprop("sim/asw20/wing-failure-left", 0 );
	setprop("sim/asw20/wing-failure-right", 0 );      
	setprop("fdm/jsbsim/metrics/Sw-sqft", 113. );
	setprop("ai/submodels/submodel[0]/count", 1 );
	setprop("ai/submodels/submodel[1]/count", 1 );
	print("plane repaired");
}



##################################################################
#
# Set hook according to hook_in_use
#
##################################################################

var set_hook = func() { 
	var hook_in_use = getprop("sim/asw20/hook/hook-in-use");
	
	if( hook_in_use == 0 ){
		# auto (c.g. hook for winch / nose hook for towing)
		setprop("/sim/hitches/aerotow/force_name_jsbsim", "aerotow_hitch");
		setprop("/sim/hitches/winch/force_name_jsbsim", "cg_hitch");
	} elsif( hook_in_use == 1 ){
		# c.g. hook for both
		setprop("/sim/hitches/aerotow/force_name_jsbsim", "cg_hitch");
		setprop("/sim/hitches/winch/force_name_jsbsim", "cg_hitch");
	} else{
		# aerotow hook for both
		setprop("/sim/hitches/aerotow/force_name_jsbsim", "aerotow_hitch");
		setprop("/sim/hitches/winch/force_name_jsbsim", "aerotow_hitch");
	}	
}



################################################################################################
#
# Set default weight values
#
################################################################################################

var weight_and_balance_defaults = func {
	
	setprop("/fdm/jsbsim/inertia/pointmass-weight-kg[0]", 85.);
	setprop("/fdm/jsbsim/inertia/pointmass-weight-kg[1]", 6.);
	setprop("/fdm/jsbsim/inertia/pointmass-weight-kg[2]", 2.);
	setprop("/fdm/jsbsim/inertia/pointmass-weight-kg[3]", 0.);
	setprop("/fdm/jsbsim/inertia/pointmass-weight-kg[4]", 2.);
	setprop("/fdm/jsbsim/inertia/waterballast_total_slider-kg", 0.);
	setprop("/fdm/jsbsim/inertia/pointmass-weight-lbs[5]", 0.);
	setprop("/fdm/jsbsim/inertia/pointmass-weight-lbs[6]", 0.);
	setprop("/fdm/jsbsim/inertia/pointmass-location-X-inches[0]",-23.425) ;
	
}


################################################################################################
#
# Avoid possible wing failure at startup
#
################################################################################################

if ( getprop("sim/asw20/wing-failure-enable") ) {
	setprop("sim/asw20/wing-failure-enable",0);
	settimer( func { setprop("sim/asw20/wing-failure-enable", 1 ); }, 2 );
}

