var FuelFlowFixTank = func(tankNr) {
  var previousLevelKg = getprop("/consumables/fuel/tank["~tankNr~"]/previous-level-kg");
  var levelKg = getprop("/consumables/fuel/tank["~tankNr~"]/level-kg");

  if (previousLevelKg > levelKg) {
    var fuelFlowCorrection = getprop("/consumables/fuel/fuel-flow-correction");
    var deltaFuel = previousLevelKg - levelKg;
    levelKg = levelKg + deltaFuel * fuelFlowCorrection;
    setprop("/consumables/fuel/tank["~tankNr~"]/level-kg", levelKg);
  }

  previousLevelKg = levelKg;
  setprop("/consumables/fuel/tank["~tankNr~"]/previous-level-kg", previousLevelKg);
}

var FuelFlowFix = func() {
  FuelFlowFixTank(0);
  FuelFlowFixTank(1);
  settimer( FuelFlowFix, 0.2);
}

setlistener("/sim/signals/fdm-initialized", FuelFlowFix);
