var transfer = {
	switch:	props.globals.getNode("/controls/fuel/transfer", 1), #-1=transfer left 0=off 1=transfer right
	fuel_level: [
		props.globals.getNode("/consumables/fuel/tank[0]/level-lbs", 1 ),
		props.globals.getNode("/consumables/fuel/tank[1]/level-lbs", 1 ),
	],
};

var update_transfer = func{
	var x = transfer.switch.getIntValue();
	
	if( x != 0 ){
		transfer.fuel_level[0].setDoubleValue( transfer.fuel_level[0].getDoubleValue() - x * 5 );
		transfer.fuel_level[1].setDoubleValue( transfer.fuel_level[1].getDoubleValue() + x * 5 );
	}
}

var transfer_loop = maketimer( 1.0, update_transfer );
transfer_loop.simulatedTime = 1;

var cutoff_controls = {
	cmd:	[
		props.globals.getNode("/controls/engines/engine[0]/cutoff-cmd", 1),
		props.globals.getNode("/controls/engines/engine[1]/cutoff-cmd", 1),
	],
	n2:	[
		props.globals.getNode("/engines/engine[0]/n2", 1),
		props.globals.getNode("/engines/engine[1]/n2", 1),
	],
	running:	[
		props.globals.getNode("/engines/engine[0]/running", 1),
		props.globals.getNode("/engines/engine[1]/running", 1),
	],
	starter:	[
		props.globals.getNode("/controls/engines/engine[0]/starter", 1),
		props.globals.getNode("/controls/engines/engine[1]/starter", 1),
	],
	ignition:	[
		props.globals.getNode("/fdm/jsbsim/propulsion/engine[0]/ignition-auto", 1),
		props.globals.getNode("/fdm/jsbsim/propulsion/engine[1]/ignition-auto", 1),
	],
	internal:	[
		props.globals.getNode("/controls/engines/engine[0]/cutoff", 1),
		props.globals.getNode("/controls/engines/engine[1]/cutoff", 1),
	],
};


var update_cutoff = func{
	
	if(!cutoff_controls.cmd[0].getBoolValue() and ( cutoff_controls.running[0].getBoolValue() or ( cutoff_controls.starter[0].getBoolValue() and cutoff_controls.n2[0].getDoubleValue() >=15 and cutoff_controls.ignition[0].getBoolValue() ) ) ) {
		cutoff_controls.internal[0].setBoolValue( 0 );
	} else {
		cutoff_controls.internal[0].setBoolValue( 1 );
	}
	
	if(!cutoff_controls.cmd[1].getBoolValue() and ( cutoff_controls.running[1].getBoolValue() or ( cutoff_controls.starter[1].getBoolValue() and cutoff_controls.n2[1].getDoubleValue() >=15 and cutoff_controls.ignition[1].getBoolValue() ) ) ) {
		cutoff_controls.internal[1].setBoolValue( 0 );
	} else {
		cutoff_controls.internal[1].setBoolValue( 1 );
	}
}

var cutoff_loop = maketimer( 0.1, update_cutoff );
cutoff_loop.simulatedTime = 1;


var fuel_lis = setlistener("/sim/signals/fdm-initialized", func{
	transfer_loop.start();
	cutoff_loop.start();
	removelistener( fuel_lis );
	print("Fuel System initialized.");	
});
