# Simulation of Alpha Electro Variometer (VSI) by Benedikt Wolf (D-ECHO) based on

# A3XX Lower ECAM Canvas
# Joshua Davidson (it0uchpods)

# References:
#	https://www.kanardia.eu/wp-content/uploads/2020/02/Vario-Manual.pdf
#	POH (see -jsb.xml)

var VSI_main = nil;
var VSI_display = nil;

var VSI = props.globals.getNode("instrumentation/vertical-speed-indicator/indicated-speed-fpm", 1);

var volts = props.globals.getNode( "/systems/electrical/outputs/instruments", 1 );

var instrument_dir = "Aircraft/Phoenix/Models/Instruments/VSI/";


var canvas_VSI_base = {
	init: func(canvas_group, file) {
		var font_mapper = func(family, weight) {
			return "LiberationFonts/LiberationSans-Bold.ttf";
		};

		
		canvas.parsesvg(canvas_group, file, {'font-mapper': font_mapper});

		var svg_keys = me.getKeys();
		foreach (var key; svg_keys) {
			me[key] = canvas_group.getElementById(key);
		}
		
		me.page = canvas_group;

		return me;
	},
	getKeys: func() {
		return [];
	},
	update: func() {
		if ( volts.getDoubleValue() > 10) {
			VSI_main.page.show();
			VSI_main.update();
		} else {
			VSI_main.page.hide();
		}
	},
};
	
	
var canvas_VSI_main = {
	new: func(canvas_group, file) {
		var m = { parents: [canvas_VSI_main , canvas_VSI_base] };
		m.init(canvas_group, file);

		return m;
	},
	getKeys: func() {
		return ["vario"];
	},
	update: func() {
		me["vario"].setText(sprintf("%5d", math.round( VSI.getDoubleValue() ,50)));
	}
	
};

var base_updater = maketimer( 0.02, canvas_VSI_base.update );
base_updater.simulatedTime = 1;


setlistener("sim/signals/fdm-initialized", func {
	VSI_display = canvas.new({
		"name": "VSI",
		"size": [320, 240],
		"view": [320, 240],
		"mipmapping": 1
	});
	VSI_display.addPlacement({"node": "VSI.display"});
	var groupMain = VSI_display.createGroup();


	VSI_main = canvas_VSI_main.new(groupMain, instrument_dir~"VSI_main.svg");

	base_updater.start();
});
