##########################################
##	MC-15 CRI-CRI			    ##
##########################################

##	Liveries	##
aircraft.livery.init("Aircraft/MC-15/Models/Liveries");

##	Instruments	##
# Load vario instrument for the mechanical vario-5stv5
# (the following code is based on the ILEC SC7 e-vario)
io.include("Aircraft/Generic/soaring-instrumentation-sdk.nas");

var probe = TotalEnergyProbe.new();

var vario_needle = Dampener.new(
	input: probe,
	dampening: 2.7,
	on_update: update_prop("/instrumentation/variometer/te-reading-mps"));

# Wrap everything together into an instrument
var fast_instruments = UpdateLoop.new(
	update_period: 0,
	components: [probe, vario_needle],
	enable: 1);

# Vibrating yaw string
var yawstring = YawString.new(
	on_update: update_prop("instrumentation/yawstring"));

var string_instrument = Instrument.new(
	components: [yawstring],
	enable: 1);
