#Initialise
var engine3 = engines.Turboprop.new(2, 0.4);
var engine4 = engines.Turboprop.new(3, 0.4);

engine3.init();
engine4.init();

props.globals.initNode("/sim/autostart/started", 0, "BOOL");

var eng3fuelon = func { setprop("/controls/engines/engine[2]/cutoff", 0); }
var eng4fuelon = func { setprop("/controls/engines/engine[3]/cutoff", 0); }

var eng3fueloff = func { setprop("/controls/engines/engine[2]/cutoff", 1); }
var eng4fueloff = func { setprop("/controls/engines/engine[3]/cutoff", 1); }

var eng3starter = func { setprop("/controls/engines/engine[2]/starter", 1); }
var eng4starter = func { setprop("/controls/engines/engine[3]/starter", 1); }

var eng3stop    = func { setprop("/controls/engines/engine[2]/starter", 0); }
var eng4stop    = func { setprop("/controls/engines/engine[3]/starter", 0); }

var eng3start = func {
  gui.popupTip("*** Jet start left  ***");
  eng3fuelon();
  eng3starter();
  setprop("/controls/engines/engine[2]/condition", 1);
  settimer(eng3fuelon, 2);
}

var eng4start = func {
  gui.popupTip("*** Jet start right  ***");
  eng4fuelon();
  eng4starter();
  setprop("/controls/engines/engine[3]/condition", 1);
  settimer(eng4fuelon, 2);
}

var engstart = func {
  settimer(eng3start, 2);
  settimer(eng4start, 8);
}

var engstop = func {
  eng3fueloff();
  eng3stop();
  setprop("/controls/engines/engine[2]/throttle", 0);
  setprop("/controls/engines/engine[2]/condition", 0);
  eng4fueloff();
  eng4stop();
  setprop("/controls/engines/engine[3]/throttle", 0);
  setprop("/controls/engines/engine[3]/condition", 0);
}

var autostart = func {
  var startstatus = getprop("/sim/autostart/started");
  if ( startstatus == 0 ) {
    gui.popupTip("Autostarting...");
    setprop("/sim/model/autostart", 1);
    setprop("/sim/autostart/started", 1);
    setprop("/controls/electric/battery-switch", 1);
    settimer(engstart, 0.4);
    gui.popupTip("Starting Engines");
  }
  if ( startstatus == 1 ) {
    gui.popupTip("Shutting Down...");
    setprop("/sim/model/autostart", 0);
    setprop("/sim/autostart/started", 0);
    setprop("/controls/electric/battery-switch", 0);
    engstop();
  }
}
