##################################################################
####      autogear.nas - ePilot                               ####
####                                                          ####
####    Gear config based on loading location and             ####
####    on ground gear protection                             ####
##################################################################

var autogear = func {

  var surface=getprop("fdm/jsbsim/ground/solid");
  if(surface) {
    setprop("controls/gear/gear-down", 1);
    setprop("controls/gear/brake-parking", 1);

  } else {
    setprop("controls/gear/gear-down", 0);
    setprop("controls/gear/brake-parking", 0);
  }

}

setlistener("/sim/signals/fdm-initialized", autogear);

#########################   Gear protect  #############################

var gearprotect = func {

  var onground=getprop("/gear/gear/wow");

  if(onground) {
    setprop("controls/gear/gear-down", 1);
    if(getprop("sim/time/elapsed-sec") > 4) {
      setprop("/sim/messages/copilot", "Please don't raise the gear while on the ground Captain");
    }

  }

}

setlistener("/controls/gear/gear-down", gearprotect, 0, 0);
