# Script for recording the minimum / maximum G forces seen by the

var current = props.globals.getNode("/accelerations/pilot-g");
var minimum = props.globals.initNode("/accelerations/pilot-gmin", 1.0, "DOUBLE");
var maximum = props.globals.initNode("/accelerations/pilot-gmax", 1.0, "DOUBLE");

var gmeterUpdate = func {

    var GCurrent = current.getDoubleValue();
    var GMin = minimum.getDoubleValue();
    var GMax = maximum.getDoubleValue();

    if (GCurrent < GMin) {
        minimum.setDoubleValue( math.max( GCurrent, -6 ) );
    } elsif (GCurrent > GMax) {
        maximum.setDoubleValue( math.min( GCurrent, 10 ) );
    }
}

var gmeterTimer = maketimer( 0.0, gmeterUpdate );
gmeterTimer.simulatedTime = 1;
gmeterTimer.start();
