## Lightmaps
var logo = props.getNode("sim/model/lights/logo-lightmap",1);
var wing = props.getNode("sim/model/lights/wing-lightmap",1);
var panel0 = props.getNode("sim/model/lights/panel0-lightmap",1);
var panel1 = props.getNode("sim/model/lights/panel1-lightmap",1);
var panel2 = props.getNode("sim/model/lights/panel2-lightmap",1);
var cabin = props.getNode("sim/model/lights/cabin-lightmap",1);
var taxi = props.getNode("sim/model/lights/taxi-lightmap",1);
var lm_landing_left = props.getNode("sim/model/lights/landing-left-lightmap",1);
var lm_landing_nose = props.getNode("sim/model/lights/landing-nose-lightmap",1);
var lm_landing_right = props.getNode("sim/model/lights/landing-right-lightmap",1);



var update_lightmaps = func
{
    var logo_lights = getprop("systems/AC/outputs/logo-lights");
    if (logo_lights == nil) {
        # This happens in remote instances of flightgear loading the CRJ-700.
        # Because the logo_lights property is not transmitted over the multiplayer
        # protocol, it is absent.
        return;
    }
    logo.setValue(logo_lights > 108);
    wing.setValue(getprop("systems/DC/outputs/wing-lights") > 15);
    lm_landing_left.setValue(getprop("systems/DC/outputs/landing-lights[0]") > 20);
    #lm_landing_nose.setValue(getprop("systems/DC/outputs/landing-lights[1]") > 20);
    lm_landing_right.setValue(getprop("systems/DC/outputs/landing-lights[2]") > 20);

    if (getprop("systems/DC/outputs/instrument-flood-lights") > 15) {
        panel0.setDoubleValue(getprop("controls/lighting/panel-flood-norm"));
        panel1.setDoubleValue(getprop("controls/lighting[1]/panel-flood-norm"));
        panel2.setDoubleValue(getprop("controls/lighting[2]/panel-flood-norm"));
    }
    else {
        panel0.setDoubleValue(0);
        panel1.setDoubleValue(0);
        panel2.setDoubleValue(0);
    }
    if (getprop("systems/AC/outputs/cabin-lights") > 100)
        cabin.setDoubleValue(getprop("controls/lighting/cabin-norm"));
    else cabin.setDoubleValue(0);
};
