#	Switch Sound Logic

var left_btn_sw = [
	props.globals.getNode("controls/electric/horis-switch-pressed", 1),
	props.globals.getNode("controls/electric/vario-switch-pressed", 1),
	props.globals.getNode("controls/electric/flt_inst-switch-pressed", 1),
	props.globals.getNode("controls/electric/eng_inst-switch-pressed", 1),
];
var right_btn_sw = [
	props.globals.getNode("controls/electric/comm-switch-pressed", 1),
	props.globals.getNode("controls/electric/xpdr-switch-pressed", 1),
	props.globals.getNode("controls/electric/strobe_lt-switch-pressed", 1),
	props.globals.getNode("controls/electric/nav_lt-switch-pressed", 1),
];

var reset_sw_in = func {
	setprop("controls/switches/button-in[0]", 0);
	setprop("controls/switches/button-in[1]", 0);
}
var reset_sw_out = func {
	setprop("controls/switches/button-out[0]", 0);
	setprop("controls/switches/button-out[1]", 0);
}


var reset_in_timer = maketimer( 0.1, reset_sw_in );
reset_in_timer.simulatedTime = 1;
reset_in_timer.singleShot = 1;

var reset_out_timer = maketimer( 0.1, reset_sw_out );
reset_out_timer.simulatedTime = 1;
reset_out_timer.singleShot = 1;


foreach( var el; left_btn_sw ){
	setlistener( el, func( i ){
		if( i.getBoolValue() == 1 ){
			setprop("controls/switches/button-in[0]", 1);
			reset_in_timer.start();
		} else {
			setprop("controls/switches/button-out[0]", 1);
			reset_out_timer.start();
		}
	});
}
foreach( var el; right_btn_sw ){
	setlistener( el, func( i ){
		if( i.getBoolValue() == 1 ){
			setprop("controls/switches/button-in[1]", 1);
			reset_in_timer.start();
		} else {
			setprop("controls/switches/button-out[1]", 1);
			reset_out_timer.start();
		}
	});
}
