#	Kannad 406 ELT by Bea Wolf (D-ECHO) based on Basic ELT by Pavel Cueto, with A LOT of collaboration from Thorsten and AndersG
#	03/2022

#	Reference: 	Initial Installation Manual 		https://www.dallasavionics.com/kannad/s1840501-02_install.pdf
#			Installation and User Manual RC200	https://www.seasofsolutions.com/wp-content/uploads/2015/12/DMA00514E-RC200-User-Manual-Rev-04.pdf

#	Used Properties
var prop_base = props.globals.initNode("/instrumentation/elt");
var elt_light = prop_base.initNode("light-sw", 0, "BOOL");
var elt_active = prop_base.initNode("active", 0, "BOOL");
var elt_test = prop_base.initNode("test", 0, "BOOL");
var elt_sw_pos = prop_base.initNode("switch-pos", 0, "INT");
var position = [
	props.globals.getNode("/position/latitude-string"),
	props.globals.getNode("/position/longitude-string"),
];
var height = props.globals.getNode("/position/altitude-agl-ft");
var time = props.globals.getNode("/sim/time/elapsed-sec");

var x_accel = props.globals.getNode("/fdm/jsbsim/accelerations/a-pilot-x-ft_sec2", 1);

#Aircraft ID definition
var ac_name = getprop("sim/description");
var callsign = getprop("sim/multiplay/callsign");
var aircraft_id = ac_name ~ ", " ~ callsign;

#	Crash Sensor (G-Switch)
#	Note: Exact values for the Kannad 406 cant be found, so we use data for the Artex 345 for now.
#	ref. manual p.21: deceleration 4.5 +- 0.5 ft/sec (2.3g)
#			assume: ft/sec2 (ft/sec is velocity, not acceleration)
#			4.5 ft/sec2 equals about 0.14 g, so we use 2.3g
#			2.3 g = 74 ft/sec2
var g_sensor = func{
	if( x_accel.getDoubleValue() < -74 and !elt_test.getBoolValue() ){
		elt_active.setBoolValue( 1 );
	}
}

var g_sensor_loop = maketimer( 0.0, g_sensor );
g_sensor_loop.simulatedTime = 1;

var fdm_listener = setlistener( "/sim/signals/fdm-initialized", func{
	g_sensor_loop.start();
	removelistener( fdm_listener );
});

setlistener( elt_sw_pos, func {
	var val = elt_sw_pos.getIntValue();
	if( val == -1 ){
		test_btn( 1 );
	} elsif( val == 0 ){
		test_btn( 0 );
	} elsif( val == 1 ){
		test_btn( 0 );
		elt_active.setBoolValue( 1 );
	}
});

#Print an emergency message when pilot turns on the "armed" button
setlistener( elt_active, func {
	if ( elt_active.getBoolValue() ) {
		var help_string = "ELT Message: " ~ aircraft_id ~ ", DECLARING EMERGENCY AT " ~position[0].getValue()~" LAT, "~position[1].getValue()~" LON";
		setprop("/sim/multiplay/chat", help_string);
		print(help_string);
		elt_light.setBoolValue( 1 );
	} elsif( !elt_test.getBoolValue() ) {
		elt_light.setBoolValue( 0 );
	}
});

var press_time = nil;
var test_last_state = 0;
var test_btn = func( on ){
	if( on ){
		press_time = time.getDoubleValue();
		settimer( func{ test_btn(0); }, 1.01 );
		test_last_state = 1;
	} elsif( test_last_state != 0 ){
		if( press_time != nil and time.getDoubleValue() - press_time >= 1.0 ){
			if( elt_active.getBoolValue() ){
				elt_active.setBoolValue( 0 );
			} else {
				elt_test.setBoolValue( 1 );
			}
		}
		press_time = nil;
		test_last_state = 0;
	}
}

#Print a message when pressing the TEST button
setlistener( elt_test, func {
	if ( elt_test.getBoolValue() ) {
		var help_string = "ELT Message: " ~ aircraft_id ~ ", Emergency Locator Transmitter active";
		setprop("/sim/multiplay/chat", help_string);
		print(help_string);
		elt_light.setBoolValue( 1 );
		settimer( func{ elt_test.setBoolValue(0) }, 1 );
	} elsif( !elt_active.getBoolValue() ){
		elt_light.setBoolValue( 0 );
	}
});

var blinking_led = aircraft.light.new("/instrumentation/elt/light", [0.2, 0.2], elt_light);
