##	Taurus Electro G2.5	ESYS-MAN	Engine Instrument and Control Unit
##		by Benedikt Wolf (D-ECHO) 05/2020
##		Reference:	[1]	p.6-72		ESYS-MAN
##		thanks to: Joshua Davidson (Octal450): basic canvas structure (from A320 Family)


# Initialize global variables
var esys_main		= nil;
var esys_start		= nil;
var esys_display 	= nil;
var HP2KW		= 0.7457;

var esys	=	props.globals.initNode("/instrumentation/esys-man");
var esys_master	=	esys.initNode("master", 1, "BOOL");
var start_prop	=	esys.initNode("start", 0.0, "DOUBLE");

var leds	=	esys.initNode("leds");
var system_led	=	leds.initNode("system", 0, "BOOL");
var extend_led	=	leds.initNode("extended", 0, "BOOL");
var retract_led	=	leds.initNode("retracted", 0, "BOOL");

var prop_pos	=	props.globals.initNode("/fdm/jsbsim/propulsion/engine[0]/propeller-tower-pos-norm", 0.0, "DOUBLE");
var volt_prop	=	props.globals.initNode("/systems/electrical/outputs/esys", 0.0, "DOUBLE");

var eng_rpm = props.globals.getNode("engines/engine[0]/rpm", 1);
var eng_pwr = props.globals.getNode("fdm/jsbsim/propulsion/engine[0]/power-hp", 1);

var batt_volts = props.globals.getNode("/systems/FES/volts", 1);
var batt_amps = props.globals.getNode("/systems/FES/amps", 1);

var throttle	=	esys.initNode("throttle", 0.0, "DOUBLE");

var temp_motor = props.globals.getNode("/systems/FES/temperatures/motor-degc", 1);
var temp_controller = props.globals.getNode("/systems/FES/temperatures/controller-degc", 1);
var temp_battery1 = props.globals.getNode("/systems/FES/temperatures/battery1-degc", 1);
var temp_battery2 = props.globals.getNode("/systems/FES/temperatures/battery2-degc", 1);

var master_switch	=	props.globals.getNode("/systems/FES/fes-master-switch", 1);

var charge_avg		=	props.globals.getNode("/systems/electrical/average-charge", 1);

var instrument_dir	=	"Aircraft/Taurus/Models/Instruments/esys-man/";


var canvas_esys_base = {
	init: func(canvas_group, file) {
		var font_mapper = func(family, weight) {
			return "Helvetica.txf";
		};

		
		canvas.parsesvg(canvas_group, file, {'font-mapper': font_mapper});

		var svg_keys = me.getKeys();
		 
		foreach(var key; svg_keys) {
			me[key] = canvas_group.getElementById(key);
			var clip_el = canvas_group.getElementById(key ~ "_clip");
			if (clip_el != nil) {
				clip_el.setVisible(0);
				var tran_rect = clip_el.getTransformedBounds();
				var clip_rect = sprintf("rect(%d,%d, %d,%d)", 
				tran_rect[1], # 0 ys
				tran_rect[2], # 1 xe
				tran_rect[3], # 2 ye
				tran_rect[0]); #3 xs
				#   coordinates are top,right,bottom,left (ys, xe, ye, xs) ref: l621 of simgear/canvas/CanvasElement.cxx
				me[key].set("clip", clip_rect);
				me[key].set("clip-frame", canvas.Element.PARENT);
			}
		}

		me.page = canvas_group;

		return me;
	},
	getKeys: func() {
		return [];
	},
	update: func() {
		var volt = volt_prop.getDoubleValue();
		var start = start_prop.getDoubleValue();
		if ( start == 1 and volt >= 9 ) {
			esys_start.page.hide();
			esys_main.page.show();
			esys_main.update();
			
			var pos = prop_pos.getDoubleValue();
			if( pos == 1 ){
				extend_led.setBoolValue( 1 );
				retract_led.setBoolValue( 0 );
			} else if ( pos == 0 ){
				extend_led.setBoolValue( 0 );
				retract_led.setBoolValue( 1 );
			} else {
				extend_led.setBoolValue( 0 );
				retract_led.setBoolValue( 0 );
			}
		} else if ( start > 0 and start < 1 and volt >= 9){
			esys_main.page.hide();
			esys_start.page.show();
		} else {
			esys_main.page.hide();
			esys_start.page.hide();
		}
	},
};
	
	
var canvas_esys_main = {
	new: func(canvas_group, file) {
		var m = { parents: [canvas_esys_main , canvas_esys_base] };
		m.init(canvas_group, file);

		return m;
	},
	getKeys: func() {
		return ["rpm.100","pwr","battery.volts","battery.amps","throttle.bar.orange","battery.1","battery.2","battery.3","battery.4","battery.5","battery.6","battery.7","battery.8","temp.motor","temp.controller","temp.battery1","temp.battery2","controller.flag"];
	},
	update: func() {
		me["rpm.100"].setText(sprintf("%02d", math.round(math.floor(eng_rpm.getValue()/100))));
		
		var power = eng_pwr.getValue() * HP2KW;
		if(power > 1){
			me["pwr"].setText(sprintf("%2d", math.round(power)));
		}else{
			me["pwr"].setText("--");
		}
		
	#	var bv = batt_volts.getValue();
	#	if(bv != nil){
	#		me["battery.volts"].setText(sprintf("%3d", math.round(bv))~"V");
	#	}else{
	#		me["battery.volts"].setText("---V");
	#	}
	#	var ba = batt_amps.getValue();
	#	if(ba != nil and ba > 0){
	#		me["battery.amps"].setText(sprintf("%3d", math.round(ba))~"A");
	#	}else{
	#		me["battery.amps"].setText("---A");
	#	}
		
		me["throttle.bar.orange"].setTranslation(-(1-throttle.getValue())*228,0);
		
		var charge = charge_avg.getValue();
		
		if(charge > 0.875){
			me["battery.8"].show();
		}else{
			me["battery.8"].hide();
		}
		if(charge > 0.75){
			me["battery.7"].show();
		}else{
			me["battery.7"].hide();
		}
		if(charge > 0.625){
			me["battery.6"].show();
		}else{
			me["battery.6"].hide();
		}
		if(charge > 0.5){
			me["battery.5"].show();
		}else{
			me["battery.5"].hide();
		}
		if(charge > 0.375){
			me["battery.4"].show();
		}else{
			me["battery.4"].hide();
		}
		if(charge > 0.25){
			me["battery.3"].show();
		}else{
			me["battery.3"].hide();
		}
		if(charge > 0.125){
			me["battery.2"].show();
		}else{
			me["battery.2"].hide();
		}
		if(charge > 0.0){
			me["battery.1"].show();
		}else{
			me["battery.1"].hide();
		}
		
		
	#	me["temp.motor"].setText(sprintf("%2d", math.round(temp_motor.getValue()))~"°C");
	#	me["temp.controller"].setText(sprintf("%2d", math.round(temp_controller.getValue()))~"°C");
	#	me["temp.battery1"].setText(sprintf("%2d", math.round(temp_battery1.getValue()))~"°C");
	#	me["temp.battery2"].setText(sprintf("%2d", math.round(temp_battery2.getValue()))~"°C");
		
	
	#	if(master_switch.getValue()){
	#		me["controller.flag"].setText("CONTROLLER READY");
	#		me["controller.flag"].setColor(0,1,0);
	#	}else{
	#		me["controller.flag"].setText("NO DATA FROM CONTROLLER");
	#		me["controller.flag"].setColor(1,1,1);
	#	}
	}
	
};



var canvas_esys_start = {
	new: func(canvas_group, file) {
		var m = { parents: [canvas_esys_start , canvas_esys_base] };
		m.init(canvas_group, file);

		return m;
	},
	getKeys: func() {
		return [];
	},
	update: func() {
	}
	
};


var ls = setlistener("sim/signals/fdm-initialized", func {
	esys_display = canvas.new({
		"name": "ESYS-MAN",
		"size": [250, 200],
		"view": [250, 200],
		"mipmapping": 1
	});
	esys_display.addPlacement({"node": "esys.display"});
	var groupMain = esys_display.createGroup();
	var groupStart = esys_display.createGroup();


	esys_main = canvas_esys_main.new(groupMain, instrument_dir~"esys-man.svg");
	esys_start = canvas_esys_start.new(groupStart, instrument_dir~"esys-man.start.svg");

	var base_update = maketimer(	0.1, 
					func {
						canvas_esys_base.update();
					});
	base_update.start();
	removelistener(ls);
});

setlistener( start_prop, func {
	if( start_prop.getDoubleValue() == 1 ){
		system_led.setBoolValue( 1 );
	} else {
		system_led.setBoolValue( 0 );
	}
});

setlistener(volt_prop, func{
	if( volt_prop.getDoubleValue() >= 9 and start_prop.getDoubleValue() == 0){
		interpolate(start_prop, 1, 2 );
	}else if( ( volt_prop.getDoubleValue() < 9 ) and start_prop.getDoubleValue() != 0){
		start_prop.setDoubleValue( 0 );
	}
});
