props.globals.initNode("/sim/is-MP-Aircraft", 0, "BOOL");

#initialize triggers
props.globals.initNode("/controls/armament/fire-s8-rockets", 0, "BOOL");

props.globals.initNode("/controls/armament/trigger-s8", 0, "BOOL");
props.globals.initNode("/controls/armament/trigger-s8-r", 0, "BOOL");
props.globals.initNode("/controls/armament/weapon-type", 2, "DOUBLE");
props.globals.initNode("/controls/armament/salvo-ripple", 0, "INT");

#ammo counter
props.globals.initNode("/controls/armament/rocketsLeft1", 20, "INT");
props.globals.initNode("/controls/armament/rocketsCount1", 20, "DOUBLE");

var reload = func {
  if ( getprop("/gear/gear[0]/wow") and getprop("/gear/gear[1]/wow") and getprop("/gear/gear[2]/wow") and (getprop("/velocities/groundspeed-kt") < 2) ) {

    setprop("/controls/armament/rocketsLeft1", 20);
    setprop("/controls/armament/rocketsCount1", 20);

    setprop("/controls/armament/rocketsLeft2", 20);
    setprop("/controls/armament/rocketsCount2", 20);

    screen.log.write("S-8 rockets reloaded (20 rockets per pod)", 1, 0.6, 0.1);
  } else {
    screen.log.write("You must be still on the ground to reaload! ", 1, 0.6, 0.1);
  }
}

# A resource friendly way of ammo counting: Instead of counting every bullet, I set an interpolate on float variant of ammo counter. But I need a timer to cut off fire when out of ammo.

var outOfAmmo1 = maketimer(1.0, func {
  #print("Out of rockets! ");
  screen.log.write("B8V20 pods out of rockets! ", 1, 0.6, 0.1);
  setprop("/controls/armament/trigger-s8", 0);
  setprop("/controls/armament/rocketsCount1", 0);
  setprop("/controls/armament/rocketsLeft1", 0);
});
outOfAmmo1.singleShot = 1;

var Rockets_Stop = maketimer(0.1, func {
  #print("Rockets Stopped! ");
  setprop("controls/armament/fire-s8-rockets", 0);
  setprop("/controls/armament/trigger-s8", 0);
  setprop("/controls/armament/trigger-s8-r", 0);
  if ( getprop("/controls/armament/report-ammo") ) {
    screen.log.write("S-8 rockets left: " ~ getprop("/controls/armament/rocketsLeft1"), 1, 0.6, 0.1);
    #screen.log.write("S-8 rockets Inner left: " ~ getprop("/controls/armament/rocketsLeft2"), 1, 0.6, 0.1);
  }
});
Rockets_Stop.singleShot = 1;

var Rockets_Ripple_1_OUT = maketimer(0.1, func {
  #print("2x more rockets! ");
  setprop("/controls/armament/trigger-s8", 1);
  Rockets_Stop.start(0.1);
  Rockets_Ripple_1_OUT.stop();
});
Rockets_Ripple_1_OUT.singleShot = 1;

#trigger control with ammo counting
var triggerControl = func {
  triggerState = getprop("controls/armament/fire-s8-rockets");
  MasterArm    = getprop("controls/armament/master-arm");
  RocketsON    = (getprop("controls/armament/weapon-type") == 2);
  RippleType   = getprop("controls/armament/salvo-ripple");

  if (triggerState and MasterArm and RocketsON) {

    var fireTime1    = 1.0; #continuous fire for 0.15s intervals
    var rocketsLeft1 = getprop("/controls/armament/rocketsLeft1");
    outOfAmmo1.restart(fireTime1*(rocketsLeft1/20));

    if (getprop("/controls/armament/rocketsLeft1") > 0 and RippleType ==0) {
      setprop("/controls/armament/trigger-s8", 1);
      var rocketsLeft1 = getprop("/controls/armament/rocketsLeft1");
      setprop("/controls/armament/rocketsCount1", rocketsLeft1);
      interpolate("/controls/armament/rocketsCount1", 0,
      fireTime1*(rocketsLeft1/20));
      outOfAmmo1.restart(fireTime1*(rocketsLeft1/20));
    }

    if (getprop("/controls/armament/rocketsLeft1") > 0 and RippleType ==1) {
      var rocketsLeft1 = (getprop("/controls/armament/rocketsLeft1") -2);
      setprop("/controls/armament/rocketsCount1", rocketsLeft1);
      setprop("/controls/armament/trigger-s8", 1);
      Rockets_Stop.start(0.1);
    }

    if (getprop("/controls/armament/rocketsLeft1") > 0 and RippleType ==2) {
      var rocketsLeft1 = (getprop("/controls/armament/rocketsLeft1") -4);
      setprop("/controls/armament/rocketsCount1", rocketsLeft1);
      setprop("/controls/armament/trigger-s8", 1);
      Rockets_Ripple_1_OUT.start();
    }

  } else {
    setprop("/controls/armament/trigger-s8", 0);
    setprop("/controls/armament/trigger-s8-r", 0);

    setprop("/controls/armament/rocketsLeft1",
    getprop("/controls/armament/rocketsCount1"));#gets truncated
    interpolate("/controls/armament/rocketsCount1",
    getprop("/controls/armament/rocketsLeft1"), 0);

    outOfAmmo1.stop();

    Rockets_Ripple_1_OUT.stop();

    #ammo count report on trigger release
    if (getprop("/controls/armament/report-ammo")) {
      screen.log.write("S8 rockets left: " ~ getprop("/controls/armament/rocketsLeft1"), 1, 0.6, 0.1);
      # screen.log.write("S-5 rockets Inner left: " ~ getprop("/controls/armament/rocketsLeft2"), 1, 0.6, 0.1);
    }
  }
}

setlistener("controls/armament/fire-s8-rockets", triggerControl);
