NAME
    RISCOS::Clone -- copy nested structures.

SYNOPSIS
        use RISCOS::Clone qw(clone);
        @copy = clone (@original);

        $copy = $original->Clone();


DESCRIPTION
    This module provides functions to copy structures.

    Clone <hash_ref>
        copies a hash reference, `bless'ing the returned hash with
        the class (if any) of the original. `Clone' uses <clone> to
        copy each hash value.

    clone <object> ...
        recursively copies the objects passed in. In list contest
        returns the copied objects, in scalar context returns the
        first object. `clone' copies `undef', scalars, code
        referencess and globs unchanged, scalar references are
        copied as a reference to scalar containing the identical
        value. Array references are passed recursively to `clone',
        hash references to `Clone'. Blessed references that posses a
        `Clone' method have this method called, else `Clone' is
        called to make a copy.

        `clone' is simpleminded and will go wrong as follows.

        	clone will loop on structures that refer to themselves
        	clone will copy things that may not want duplication
        	  (eg RISCOS::Font objects have a dummy Clone method to stop this)
        	clone will not work correctly if hashes are supposed to be keyed with a
        	  stringified reference.
        	Clone will C<die> if blessed references are not hash references.


        For objects these problems can be overcome by writing a
        custom `Clone' method.


BUGS
    Caveats as noted above. Not tested enough yet.

AUTHOR
    Nicholas Clark <nick@unfortu.net>

