/*
 * Decompiled with CFR 0.152.
 */
package org.apache.batik.test.svg;

import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.image.BufferedImage;
import java.awt.image.ColorModel;
import java.awt.image.RenderedImage;
import java.awt.image.WritableRaster;
import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.LinkedList;
import java.util.List;
import java.util.Locale;
import java.util.ResourceBundle;
import org.apache.batik.ext.awt.image.GraphicsUtil;
import org.apache.batik.ext.awt.image.renderable.Filter;
import org.apache.batik.ext.awt.image.spi.ImageTagRegistry;
import org.apache.batik.ext.awt.image.spi.ImageWriter;
import org.apache.batik.ext.awt.image.spi.ImageWriterRegistry;
import org.apache.batik.test.AbstractTest;
import org.apache.batik.test.DefaultTestReport;
import org.apache.batik.test.Test;
import org.apache.batik.test.TestReport;
import org.apache.batik.test.svg.Messages;
import org.apache.batik.util.ParsedURL;

public abstract class AbstractRenderingAccuracyTest
extends AbstractTest {
    public static final String ERROR_CANNOT_CREATE_TEMP_FILE = "SVGRenderingAccuracyTest.error.cannot.create.temp.file";
    public static final String ERROR_CANNOT_CREATE_TEMP_FILE_STREAM = "SVGRenderingAccuracyTest.error.cannot.create.temp.file.stream";
    public static final String ERROR_CANNOT_OPEN_REFERENCE_IMAGE = "SVGRenderingAccuracyTest.error.cannot.open.reference.image";
    public static final String ERROR_CANNOT_OPEN_GENERATED_IMAGE = "SVGRenderingAccuracyTest.error.cannot.open.genereted.image";
    public static final String ERROR_ERROR_WHILE_COMPARING_FILES = "SVGRenderingAccuracyTest.error.while.comparing.files";
    public static final String ERROR_SVG_RENDERING_NOT_ACCURATE = "SVGRenderingAccuracyTest.error.svg.rendering.not.accurate";
    public static final String ENTRY_KEY_ERROR_DESCRIPTION = "SVGRenderingAccuracyTest.entry.key.error.description";
    public static final String ENTRY_KEY_REFERENCE_GENERATED_IMAGE_URI = "SVGRenderingAccuracyTest.entry.key.reference.generated.image.file";
    public static final String ENTRY_KEY_DIFFERENCE_IMAGE = "SVGRenderingAccuracyTest.entry.key.difference.image";
    public static final String ENTRY_KEY_INTERNAL_ERROR = "SVGRenderingAccuracyTest.entry.key.internal.error";
    public static final String COULD_NOT_GENERATE_COMPARISON_IMAGES = "SVGRenderingAccuracyTest.message.error.could.not.generate.comparison.images";
    public static final String COULD_NOT_LOAD_IMAGE = "SVGRenderingAccuracyTest.message.error.could.not.load.image";
    public static final String COULD_NOT_OPEN_VARIATION_URL = "SVGRenderingAccuracyTest.message.warning.could.not.open.variation.url";
    public static final String CONFIGURATION_RESOURCES = "org.apache.batik.test.svg.resources.Configuration";
    public static final String IMAGE_TYPE_COMPARISON = "_cmp";
    public static final String IMAGE_TYPE_DIFF = "_diff";
    public static final String IMAGE_FILE_EXTENSION = ".png";
    protected static ResourceBundle configuration = ResourceBundle.getBundle("org.apache.batik.test.svg.resources.Configuration", Locale.getDefault());
    public static final String TEMP_FILE_PREFIX = configuration.getString("temp.file.prefix");
    public static final String TEMP_FILE_SUFFIX = configuration.getString("temp.file.suffix");
    protected URL svgURL;
    protected URL refImgURL;
    protected List variationURLs;
    protected File saveVariation;
    protected File candidateReference;
    protected static File tempDirectory;

    public static File getTempDirectory() {
        if (tempDirectory == null) {
            String tmpDir = System.getProperty("java.io.tmpdir");
            if (tmpDir == null) {
                throw new RuntimeException();
            }
            tempDirectory = new File(tmpDir);
            if (!tempDirectory.exists()) {
                throw new RuntimeException();
            }
        }
        return tempDirectory;
    }

    public AbstractRenderingAccuracyTest(String svgURL, String refImgURL) {
        this.setConfig(svgURL, refImgURL);
    }

    protected AbstractRenderingAccuracyTest() {
    }

    public void setConfig(String svgURL, String refImgURL) {
        if (svgURL == null) {
            throw new IllegalArgumentException();
        }
        if (refImgURL == null) {
            throw new IllegalArgumentException();
        }
        this.svgURL = this.resolveURL(svgURL);
        this.refImgURL = this.resolveURL(refImgURL);
    }

    protected URL resolveURL(String url) {
        File f = new File(url).getAbsoluteFile();
        if (f.getParentFile().exists()) {
            try {
                return f.toURI().toURL();
            }
            catch (MalformedURLException e) {
                throw new IllegalArgumentException();
            }
        }
        try {
            return new URL(url);
        }
        catch (MalformedURLException e) {
            throw new IllegalArgumentException(url);
        }
    }

    public void setSaveVariation(File saveVariation) {
        this.saveVariation = saveVariation;
    }

    public File getSaveVariation() {
        return this.saveVariation;
    }

    public String[] getVariationURLs() {
        if (this.variationURLs != null) {
            return this.variationURLs.toArray(new String[0]);
        }
        return null;
    }

    public void addVariationURL(String variationURL) {
        if (this.variationURLs == null) {
            this.variationURLs = new LinkedList();
        }
        try {
            this.variationURLs.add(this.resolveURL(variationURL));
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
    }

    public void setCandidateReference(File candidateReference) {
        this.candidateReference = candidateReference;
    }

    public File getCandidateReference() {
        return this.candidateReference;
    }

    public String getName() {
        if (this.name == null) {
            return this.svgURL.toString();
        }
        return this.name;
    }

    public TestReport run() {
        DefaultTestReport report = new DefaultTestReport((Test)this);
        if (this.candidateReference != null && this.candidateReference.exists()) {
            this.candidateReference.delete();
        }
        File tmpFile = null;
        try {
            tmpFile = this.candidateReference != null ? this.candidateReference : File.createTempFile(TEMP_FILE_PREFIX, TEMP_FILE_SUFFIX, null);
        }
        catch (IOException e) {
            report.setErrorCode(ERROR_CANNOT_CREATE_TEMP_FILE);
            report.setDescription(new TestReport.Entry[]{new TestReport.Entry(Messages.formatMessage(ENTRY_KEY_ERROR_DESCRIPTION, null), (Object)Messages.formatMessage(ERROR_CANNOT_CREATE_TEMP_FILE, new Object[]{e.getMessage()}))});
            report.setPassed(false);
            return report;
        }
        FileOutputStream tmpFileOS = null;
        try {
            tmpFile.getParentFile().mkdirs();
            tmpFileOS = new FileOutputStream(tmpFile);
        }
        catch (IOException e) {
            report.setErrorCode(ERROR_CANNOT_CREATE_TEMP_FILE_STREAM);
            report.setDescription(new TestReport.Entry[]{new TestReport.Entry(Messages.formatMessage(ENTRY_KEY_ERROR_DESCRIPTION, null), (Object)Messages.formatMessage(ERROR_CANNOT_CREATE_TEMP_FILE_STREAM, new String[]{tmpFile.getAbsolutePath(), e.getMessage()}))});
            report.setPassed(false);
            tmpFile.deleteOnExit();
            return report;
        }
        TestReport encodeTR = this.encode(this.svgURL, tmpFileOS);
        if (encodeTR != null && !encodeTR.hasPassed()) {
            tmpFile.deleteOnExit();
            return encodeTR;
        }
        BufferedInputStream refStream = null;
        BufferedInputStream newStream = null;
        try {
            refStream = new BufferedInputStream(this.refImgURL.openStream());
        }
        catch (IOException e) {
            report.setErrorCode(ERROR_CANNOT_OPEN_REFERENCE_IMAGE);
            report.setDescription(new TestReport.Entry[]{new TestReport.Entry(Messages.formatMessage(ENTRY_KEY_ERROR_DESCRIPTION, null), (Object)Messages.formatMessage(ERROR_CANNOT_OPEN_REFERENCE_IMAGE, new Object[]{this.refImgURL.toString(), e.getMessage()}))});
            report.setPassed(false);
            if (this.candidateReference == null) {
                tmpFile.delete();
            }
            return report;
        }
        try {
            newStream = new BufferedInputStream(new FileInputStream(tmpFile));
        }
        catch (IOException e) {
            report.setErrorCode(ERROR_CANNOT_OPEN_GENERATED_IMAGE);
            report.setDescription(new TestReport.Entry[]{new TestReport.Entry(Messages.formatMessage(ENTRY_KEY_ERROR_DESCRIPTION, null), (Object)Messages.formatMessage(ERROR_CANNOT_OPEN_GENERATED_IMAGE, new Object[]{tmpFile.getAbsolutePath(), e.getMessage()}))});
            report.setPassed(false);
            tmpFile.delete();
            return report;
        }
        boolean accurate = false;
        try {
            accurate = this.compare(refStream, newStream);
        }
        catch (IOException e) {
            report.setErrorCode(ERROR_ERROR_WHILE_COMPARING_FILES);
            report.setDescription(new TestReport.Entry[]{new TestReport.Entry(Messages.formatMessage(ENTRY_KEY_ERROR_DESCRIPTION, null), (Object)Messages.formatMessage(ERROR_ERROR_WHILE_COMPARING_FILES, new Object[]{this.refImgURL.toString(), tmpFile.getAbsolutePath(), e.getMessage()}))});
            report.setPassed(false);
            if (this.candidateReference == null) {
                tmpFile.delete();
            }
            return report;
        }
        if (accurate) {
            report.setPassed(true);
            tmpFile.delete();
            return report;
        }
        try {
            BufferedImage ref = this.getImage(this.refImgURL);
            BufferedImage gen = this.getImage(tmpFile);
            BufferedImage diff = AbstractRenderingAccuracyTest.buildDiffImage(ref, gen);
            if (this.variationURLs != null) {
                for (Object variationURL1 : this.variationURLs) {
                    BufferedInputStream tmpDiffStream;
                    BufferedInputStream refDiffStream;
                    URL variationURL = (URL)variationURL1;
                    File tmpDiff = this.imageToFile(diff, IMAGE_TYPE_DIFF);
                    InputStream variationURLStream = null;
                    try {
                        variationURLStream = variationURL.openStream();
                    }
                    catch (IOException e) {
                        System.err.println(Messages.formatMessage(COULD_NOT_OPEN_VARIATION_URL, new Object[]{variationURL.toString()}));
                    }
                    if (variationURLStream == null || !this.compare(refDiffStream = new BufferedInputStream(variationURLStream), tmpDiffStream = new BufferedInputStream(new FileInputStream(tmpDiff)))) continue;
                    accurate = true;
                }
            }
            if (accurate) {
                report.setPassed(true);
                tmpFile.delete();
                return report;
            }
            System.err.println(">>>>>>>>>>>>>>>>>>>>>> Rendering is not accurate");
            if (this.saveVariation != null) {
                this.saveImage(diff, this.saveVariation);
            }
            BufferedImage cmp = this.makeCompareImage(ref, gen);
            File cmpFile = this.imageToFile(cmp, IMAGE_TYPE_COMPARISON);
            File diffFile = this.imageToFile(diff, IMAGE_TYPE_DIFF);
            report.setErrorCode(ERROR_SVG_RENDERING_NOT_ACCURATE);
            report.setDescription(new TestReport.Entry[]{new TestReport.Entry(Messages.formatMessage(ENTRY_KEY_ERROR_DESCRIPTION, null), (Object)Messages.formatMessage(ERROR_SVG_RENDERING_NOT_ACCURATE, null)), new TestReport.Entry(Messages.formatMessage(ENTRY_KEY_REFERENCE_GENERATED_IMAGE_URI, null), (Object)cmpFile), new TestReport.Entry(Messages.formatMessage(ENTRY_KEY_DIFFERENCE_IMAGE, null), (Object)diffFile)});
        }
        catch (Exception e) {
            report.setErrorCode(ERROR_SVG_RENDERING_NOT_ACCURATE);
            StringWriter trace = new StringWriter();
            e.printStackTrace(new PrintWriter(trace));
            report.setDescription(new TestReport.Entry[]{new TestReport.Entry(Messages.formatMessage(ENTRY_KEY_ERROR_DESCRIPTION, null), (Object)Messages.formatMessage(ERROR_SVG_RENDERING_NOT_ACCURATE, null)), new TestReport.Entry(Messages.formatMessage(ENTRY_KEY_INTERNAL_ERROR, null), (Object)Messages.formatMessage(COULD_NOT_GENERATE_COMPARISON_IMAGES, new Object[]{e.getClass().getName(), e.getMessage(), trace.toString()}))});
        }
        if (this.candidateReference == null) {
            tmpFile.delete();
        }
        report.setPassed(false);
        return report;
    }

    public abstract TestReport encode(URL var1, FileOutputStream var2);

    protected boolean compare(InputStream refStream, InputStream newStream) throws IOException {
        int nb;
        int b;
        do {
            b = refStream.read();
            nb = newStream.read();
        } while (b != -1 && nb != -1 && b == nb);
        refStream.close();
        newStream.close();
        return b == nb;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void saveImage(BufferedImage img, File imgFile) throws IOException {
        if (!imgFile.exists()) {
            imgFile.getParentFile().mkdirs();
            imgFile.createNewFile();
        }
        try (FileOutputStream out = new FileOutputStream(imgFile);){
            this.saveImage(img, out);
        }
    }

    protected void saveImage(BufferedImage img, OutputStream os) throws IOException {
        ImageWriter writer = ImageWriterRegistry.getInstance().getWriterFor("image/png");
        writer.writeImage((RenderedImage)img, os);
    }

    public static BufferedImage buildDiffImage(BufferedImage ref, BufferedImage gen) {
        ColorModel cm;
        boolean genPre;
        BufferedImage diff = new BufferedImage(ref.getWidth(), ref.getHeight(), 2);
        WritableRaster refWR = ref.getRaster();
        WritableRaster genWR = gen.getRaster();
        WritableRaster dstWR = diff.getRaster();
        boolean refPre = ref.isAlphaPremultiplied();
        if (!refPre) {
            ColorModel cm2 = ref.getColorModel();
            cm2 = GraphicsUtil.coerceData((WritableRaster)refWR, (ColorModel)cm2, (boolean)true);
            ref = new BufferedImage(cm2, refWR, true, null);
        }
        if (!(genPre = gen.isAlphaPremultiplied())) {
            ColorModel cm3 = gen.getColorModel();
            cm3 = GraphicsUtil.coerceData((WritableRaster)genWR, (ColorModel)cm3, (boolean)true);
            gen = new BufferedImage(cm3, genWR, true, null);
        }
        int w = ref.getWidth();
        int h = ref.getHeight();
        int[] refPix = null;
        int[] genPix = null;
        for (int y = 0; y < h; ++y) {
            refPix = refWR.getPixels(0, y, w, 1, refPix);
            genPix = genWR.getPixels(0, y, w, 1, genPix);
            for (int i = 0; i < refPix.length; ++i) {
                int val = (genPix[i] - refPix[i]) * 10 + 128;
                if ((val & 0xFFFFFF00) != 0) {
                    val = (val & Integer.MIN_VALUE) != 0 ? 0 : 255;
                }
                genPix[i] = val;
            }
            dstWR.setPixels(0, y, w, 1, genPix);
        }
        if (!genPre) {
            cm = gen.getColorModel();
            cm = GraphicsUtil.coerceData((WritableRaster)genWR, (ColorModel)cm, (boolean)false);
        }
        if (!refPre) {
            cm = ref.getColorModel();
            cm = GraphicsUtil.coerceData((WritableRaster)refWR, (ColorModel)cm, (boolean)false);
        }
        return diff;
    }

    protected BufferedImage getImage(File file) throws Exception {
        return this.getImage(file.toURI().toURL());
    }

    protected BufferedImage getImage(URL url) throws IOException {
        ImageTagRegistry reg = ImageTagRegistry.getRegistry();
        Filter filt = reg.readURL(new ParsedURL(url));
        if (filt == null) {
            throw new IOException(Messages.formatMessage(COULD_NOT_LOAD_IMAGE, new Object[]{url.toString()}));
        }
        RenderedImage red = filt.createDefaultRendering();
        if (red == null) {
            throw new IOException(Messages.formatMessage(COULD_NOT_LOAD_IMAGE, new Object[]{url.toString()}));
        }
        BufferedImage img = new BufferedImage(red.getWidth(), red.getHeight(), 2);
        red.copyData(img.getRaster());
        return img;
    }

    protected BufferedImage makeCompareImage(BufferedImage ref, BufferedImage gen) {
        BufferedImage cmp = new BufferedImage(ref.getWidth() * 2, ref.getHeight(), 2);
        Graphics2D g = cmp.createGraphics();
        g.setPaint(Color.white);
        g.fillRect(0, 0, cmp.getWidth(), cmp.getHeight());
        g.drawImage((Image)ref, 0, 0, null);
        g.translate(ref.getWidth(), 0);
        g.drawImage((Image)gen, 0, 0, null);
        g.dispose();
        return cmp;
    }

    protected File imageToFile(BufferedImage img, String imageType) throws IOException {
        String file = this.getURLFile(this.svgURL);
        File imageFile = null;
        imageFile = !"".equals(file) ? this.makeTempFileName(file, imageType) : this.makeRandomFileName(imageType);
        imageFile.deleteOnExit();
        this.saveImage(img, imageFile);
        return imageFile;
    }

    protected String getURLFile(URL url) {
        String path = url.getPath();
        int n = path.lastIndexOf(47);
        if (n == -1) {
            return path;
        }
        if (n < path.length()) {
            return path.substring(n + 1, path.length());
        }
        return "";
    }

    protected File makeTempFileName(String svgFileName, String imageType) {
        int dotIndex = svgFileName.lastIndexOf(46);
        if (dotIndex == -1) {
            return this.getNextTempFileName(svgFileName + imageType);
        }
        return this.getNextTempFileName(svgFileName.substring(0, dotIndex) + imageType + IMAGE_FILE_EXTENSION);
    }

    protected File getNextTempFileName(String fileName) {
        File f = new File(AbstractRenderingAccuracyTest.getTempDirectory(), fileName);
        if (!f.exists()) {
            return f;
        }
        return this.getNextTempFileName(fileName, 1);
    }

    protected File getNextTempFileName(String fileName, int instance) {
        File r;
        int n = fileName.lastIndexOf(46);
        String iFileName = fileName + instance;
        if (n != -1) {
            iFileName = fileName.substring(0, n) + instance + fileName.substring(n, fileName.length());
        }
        if (!(r = new File(AbstractRenderingAccuracyTest.getTempDirectory(), iFileName)).exists()) {
            return r;
        }
        return this.getNextTempFileName(fileName, instance + 1);
    }

    protected File makeRandomFileName(String imageType) throws IOException {
        return File.createTempFile(TEMP_FILE_PREFIX, TEMP_FILE_SUFFIX + imageType, null);
    }
}

