/*
 * Setuid and setgid for unix from java
 */

#include "sunlabs_brazil_sunlabs_RunAsHandler.h"
#include <sys/types.h>
#include <unistd.h>
#include <stdio.h>
#include <grp.h>
#include <pwd.h>

/*
 * Set the effective user id
 */

JNIEXPORT jboolean JNICALL Java_sunlabs_brazil_sunlabs_RunAsHandler_setUser
	  (JNIEnv *env, jclass class, jstring jstr) {
    const char *name;
    struct passwd *passwd;
    jboolean result;

    name = (*env)->GetStringUTFChars(env, jstr, 0);
    passwd = getpwnam(name);
    result = (passwd != NULL && setuid(passwd->pw_uid) == 0);
    (*env)->ReleaseStringUTFChars(env, jstr, name);
    return result;
}

/*
 * set the effective group id
 */

JNIEXPORT jboolean JNICALL Java_sunlabs_brazil_sunlabs_RunAsHandler_setGroup
	(JNIEnv *env, jclass class, jstring jstr) {
    const char *name;
    struct group *group;
    jboolean result;

    name = (*env)->GetStringUTFChars(env, jstr, 0);
    group  = getgrnam(name);
    result = (group != NULL && setgid(group->gr_gid) == 0);
    (*env)->ReleaseStringUTFChars(env, jstr, name);
    return result;
}
