package org.apache.dvsl;

/*
 * Licensed to the Apache Software Foundation (ASF) under one
 * or more contributor license agreements.  See the NOTICE file
 * distributed with this work for additional information
 * regarding copyright ownership.  The ASF licenses this file
 * to you under the Apache License, Version 2.0 (the
 * "License"); you may not use this file except in compliance
 * with the License.  You may obtain a copy of the License at
 *
 *   http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied.  See the License for the
 * specific language governing permissions and limitations
 * under the License.
 */

import java.util.List;
import java.util.ArrayList;
import java.util.Map;
import java.util.HashMap;
import java.util.Stack;

import org.apache.velocity.context.Context;
import org.apache.velocity.VelocityContext;

/**
 *  Context implementation that handles wrapping several
 *  contexts simultaneously.  The style context gets
 *  special treatment, getting checked first.
 *
 *  @author <a href="mailto:geirm@apache.org">Geir Magnusson Jr.</a>
 */
class DVSLContext extends VelocityContext
{
    protected Context styleContext = null;
    protected List contextList = new ArrayList();

    /**
     *  Used to hold the nodes as we get invoked from
     *  within the document for applyTemplates() duties
     */
    private Stack nodeStack = new Stack();

    protected Map ctx = new HashMap();

    public DVSLNode pushNode( DVSLNode n )
    {
        nodeStack.push( n );
        return n;
    }

    public DVSLNode peekNode()
    {
        return (DVSLNode) nodeStack.peek();
    }

    public DVSLNode popNode()
    {
        return (DVSLNode) nodeStack.pop();
    }

    public void clearNode()
    {
        nodeStack.clear();
        return;
    }

    public void clearContexts()
    {
        styleContext = null;
        contextList.clear();
    }

    public void addContext( Context c )
    {
        if (c != null)
            contextList.add( c );
    }

    public void setStyleContext( Context c )
    {
        styleContext = c;
    }

   /**
     *  retrieves value for key from internal
     *  storage
     *
     *  @param key name of value to get
     *  @return value as object
     */
    public Object internalGet( String key )
    {
        Object o = null;

        /*
         *  special tokens
         */

        if ( key.equals("node"))
        {
            return peekNode();
        }

        /*
         *  start with local storage
         */

        o = ctx.get( key );

        if ( o != null)
            return o;

        /*
         *  if that doesn't work, try style first
         *  then others
         */

        if ( styleContext != null)
        {
            o = styleContext.get( key );

            if ( o != null )
                return o;
        }

        for( int i = 0; i < contextList.size(); i++)
        {

            Context c = (Context) contextList.get( i );

            o = c.get( key );

            if ( o != null )
                return o;
        }

        return null;
    }

    /**
     *  stores the value for key to internal
     *  storage
     *
     *  @param key name of value to store
     *  @param value value to store
     *  @return previous value of key as Object
     */
    public Object internalPut( String key, Object value )
    {
        if ( key.equals("node"))
            return null;

        return ctx.put( key, value );
    }

    /**
     *  determines if there is a value for the
     *  given key
     *
     *  @param key name of value to check
     *  @return true if non-null value in store
     */
    public  boolean internalContainsKey(Object key)
    {
        /*
         *  start with local storage
         */

        if ( ctx.containsKey( key ))
            return true;

        /*
         *  if that doesn't work, try style first
         *  then others
         */

        if ( styleContext != null && styleContext.containsKey( key ) )
            return true;

        for( int i = 0; i < contextList.size(); i++)
        {
            Context c = (Context) contextList.get( i );

            if ( c.containsKey( key ))
                return true;
        }

        return false;
    }

    /**
     *  returns array of keys
     *
     *  $$$ GMJ todo
     *
     *  @return keys as []
     */
    public  Object[] internalGetKeys()
    {
        return null;
    }

    /**
     *  remove a key/value pair from the
     *  internal storage
     *
     *  @param key name of value to remove
     *  @return value removed
     */
    public  Object internalRemove(Object key)
    {
        return ctx.remove( key );
    }


}
