/*
 * Decompiled with CFR 0.152.
 */
package com.strobel.assembler.metadata;

import com.strobel.assembler.metadata.GenericParameter;
import com.strobel.assembler.metadata.IGenericContext;
import com.strobel.assembler.metadata.IGenericParameterProvider;
import com.strobel.assembler.metadata.IMethodSignature;
import com.strobel.assembler.metadata.MemberReference;
import com.strobel.assembler.metadata.MetadataResolver;
import com.strobel.assembler.metadata.MethodDefinition;
import com.strobel.assembler.metadata.ParameterDefinition;
import com.strobel.assembler.metadata.TypeReference;
import com.strobel.core.StringUtilities;
import com.strobel.util.ContractUtils;
import java.util.Collections;
import java.util.List;

public abstract class MethodReference
extends MemberReference
implements IMethodSignature,
IGenericParameterProvider,
IGenericContext {
    protected static final String CONSTRUCTOR_NAME = "<init>";
    protected static final String STATIC_INITIALIZER_NAME = "<clinit>";

    @Override
    public abstract TypeReference getReturnType();

    @Override
    public boolean hasParameters() {
        return !this.getParameters().isEmpty();
    }

    @Override
    public abstract List<ParameterDefinition> getParameters();

    @Override
    public List<TypeReference> getThrownTypes() {
        return Collections.emptyList();
    }

    @Override
    public void invalidateSignature() {
    }

    @Override
    public boolean isSpecialName() {
        return CONSTRUCTOR_NAME.equals(this.getName()) || STATIC_INITIALIZER_NAME.equals(this.getName());
    }

    @Override
    public boolean containsGenericParameters() {
        if (super.containsGenericParameters() || this.hasGenericParameters()) {
            return true;
        }
        if (this.getReturnType().containsGenericParameters()) {
            return true;
        }
        if (this.hasParameters()) {
            List<ParameterDefinition> parameters = this.getParameters();
            int n = parameters.size();
            for (int i = 0; i < n; ++i) {
                if (!parameters.get(i).getParameterType().containsGenericParameters()) continue;
                return true;
            }
        }
        return false;
    }

    @Override
    public boolean isEquivalentTo(MemberReference member) {
        if (super.isEquivalentTo(member)) {
            return true;
        }
        if (member instanceof MethodReference) {
            MethodReference method = (MethodReference)member;
            return StringUtilities.equals((String)method.getName(), (String)this.getName()) && StringUtilities.equals((String)method.getErasedSignature(), (String)this.getErasedSignature()) && MetadataResolver.areEquivalent(method.getDeclaringType(), this.getDeclaringType());
        }
        return false;
    }

    @Override
    protected StringBuilder appendName(StringBuilder sb, boolean fullName, boolean dottedName) {
        TypeReference declaringType;
        if (fullName && (declaringType = this.getDeclaringType()) != null) {
            return declaringType.appendName(sb, true, false).append('.').append(this.getName());
        }
        return sb.append(this.getName());
    }

    public boolean isConstructor() {
        return CONSTRUCTOR_NAME.equals(this.getName());
    }

    public boolean isTypeInitializer() {
        return STATIC_INITIALIZER_NAME.equals(this.getName());
    }

    public boolean isGenericMethod() {
        return this.hasGenericParameters();
    }

    @Override
    public boolean hasGenericParameters() {
        return !this.getGenericParameters().isEmpty();
    }

    @Override
    public boolean isGenericDefinition() {
        return this.hasGenericParameters() && this.isDefinition();
    }

    @Override
    public List<GenericParameter> getGenericParameters() {
        return Collections.emptyList();
    }

    @Override
    public GenericParameter findTypeVariable(String name) {
        for (GenericParameter genericParameter : this.getGenericParameters()) {
            if (!StringUtilities.equals((String)genericParameter.getName(), (String)name)) continue;
            return genericParameter;
        }
        TypeReference declaringType = this.getDeclaringType();
        if (declaringType != null) {
            return declaringType.findTypeVariable(name);
        }
        return null;
    }

    public MethodDefinition resolve() {
        TypeReference declaringType = this.getDeclaringType();
        if (declaringType == null) {
            throw ContractUtils.unsupported();
        }
        return declaringType.resolve(this);
    }

    @Override
    public StringBuilder appendSignature(StringBuilder sb) {
        return MethodReference.appendSignature(this, sb);
    }

    @Override
    public StringBuilder appendErasedSignature(StringBuilder sb) {
        return MethodReference.appendErasedSignature(this, sb);
    }

    static StringBuilder appendSignature(IMethodSignature method, StringBuilder sb) {
        List<ParameterDefinition> parameters = method.getParameters();
        StringBuilder s = sb;
        s.append('(');
        int n = parameters.size();
        for (int i = 0; i < n; ++i) {
            ParameterDefinition p = parameters.get(i);
            s = p.getParameterType().appendSignature(s);
        }
        s.append(')');
        s = method.getReturnType().appendSignature(s);
        return s;
    }

    static StringBuilder appendErasedSignature(IMethodSignature method, StringBuilder sb) {
        StringBuilder s = sb;
        s.append('(');
        List<ParameterDefinition> parameterTypes = method.getParameters();
        int n = parameterTypes.size();
        for (int i = 0; i < n; ++i) {
            s = parameterTypes.get(i).getParameterType().appendErasedSignature(s);
        }
        s.append(')');
        s = method.getReturnType().appendErasedSignature(s);
        return s;
    }
}

