/*
 * Decompiled with CFR 0.152.
 */
package org.apache.uima.cas.impl;

import java.util.Vector;
import org.apache.uima.cas.Feature;
import org.apache.uima.cas.Type;
import org.apache.uima.cas.TypeSystem;
import org.apache.uima.cas.admin.FSIndexComparator;
import org.apache.uima.cas.admin.LinearTypeOrder;
import org.apache.uima.cas.impl.CASImpl;
import org.apache.uima.cas.impl.FeatureImpl;
import org.apache.uima.cas.impl.TypeImpl;
import org.apache.uima.internal.util.IntVector;

public class FSIndexComparatorImpl
implements FSIndexComparator {
    private Type type;
    private Vector<Object> keyVector;
    private IntVector compVector;
    private IntVector keyTypeVector;
    private TypeSystem ts;
    private CASImpl cas;

    private FSIndexComparatorImpl() {
    }

    public FSIndexComparatorImpl(CASImpl cas) {
        this.keyVector = new Vector();
        this.compVector = new IntVector();
        this.keyTypeVector = new IntVector();
        this.type = null;
        this.ts = cas.getTypeSystem();
        this.cas = cas;
    }

    private boolean checkType(Type t) {
        return t.isPrimitive();
    }

    @Override
    public void setType(Type type) {
        this.type = type;
    }

    @Override
    public Type getType() {
        return this.type;
    }

    int getTypeCode() {
        return ((TypeImpl)this.type).getCode();
    }

    @Override
    public int addKey(Feature feat, int compareKey) {
        if (!this.checkType(feat.getRange())) {
            return -1;
        }
        int rc = this.keyVector.size();
        this.keyVector.add(feat);
        this.compVector.add(compareKey);
        this.keyTypeVector.add(0);
        return rc;
    }

    @Override
    public int addKey(LinearTypeOrder typeOrder, int compareKey) {
        int rc = this.keyVector.size();
        this.compVector.add(compareKey);
        this.keyVector.add(typeOrder);
        this.keyTypeVector.add(1);
        return rc;
    }

    @Override
    public int getKeyType(int key) {
        return this.keyTypeVector.get(key);
    }

    @Override
    public int getNumberOfKeys() {
        return this.keyVector.size();
    }

    @Override
    public Feature getKeyFeature(int key) {
        if (this.keyTypeVector.get(key) == 0) {
            return (Feature)this.keyVector.get(key);
        }
        return null;
    }

    public LinearTypeOrder getKeyTypeOrder(int key) {
        if (this.keyTypeVector.get(key) == 1) {
            return (LinearTypeOrder)this.keyVector.get(key);
        }
        return null;
    }

    @Override
    public int getKeyComparator(int key) {
        return this.compVector.get(key);
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof FSIndexComparator)) {
            return false;
        }
        FSIndexComparator comp = (FSIndexComparator)o;
        int max = this.getNumberOfKeys();
        if (max != comp.getNumberOfKeys()) {
            return false;
        }
        for (int i = 0; i < max; ++i) {
            if (this.getKeyFeature(i) == comp.getKeyFeature(i) && this.getKeyComparator(i) == comp.getKeyComparator(i)) continue;
            return false;
        }
        return true;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        int max = this.getNumberOfKeys();
        for (int i = 0; i < max; ++i) {
            Feature f = this.getKeyFeature(i);
            result = 31 * result + (f == null ? 31 : f.hashCode());
            result = 31 * result + this.getKeyComparator(i);
        }
        return result;
    }

    CASImpl getLowLevelCAS() {
        return this.cas;
    }

    @Override
    public boolean isValid() {
        if (this.type == null) {
            return false;
        }
        int max = this.getNumberOfKeys();
        for (int i = 0; i < max; ++i) {
            Feature feat;
            if (this.keyTypeVector.get(i) != 0 || this.ts.subsumes((feat = (Feature)this.keyVector.get(i)).getDomain(), this.type)) continue;
            return false;
        }
        return true;
    }

    synchronized FSIndexComparatorImpl copy() {
        FSIndexComparatorImpl copy = new FSIndexComparatorImpl(this.cas);
        copy.type = this.type;
        int max = this.getNumberOfKeys();
        copy.compVector.add(this.compVector.getArray(), 0, this.compVector.size());
        copy.keyTypeVector.add(this.keyTypeVector.getArray(), 0, this.keyTypeVector.size());
        for (int i = 0; i < max; ++i) {
            copy.keyVector.add(this.keyVector.get(i));
        }
        return copy;
    }

    @Override
    public int compareTo(FSIndexComparator o) {
        FSIndexComparator comp = o;
        int thisSize = this.getNumberOfKeys();
        int compSize = comp.getNumberOfKeys();
        int i = 0;
        while (i < thisSize && i < compSize) {
            int feat2;
            int feat1 = ((FeatureImpl)this.getKeyFeature(i)).getCode();
            if (feat1 < (feat2 = ((FeatureImpl)comp.getKeyFeature(i)).getCode())) {
                return -1;
            }
            if (feat1 > feat2) {
                return 1;
            }
            if (this.getKeyComparator(i) < comp.getKeyComparator(i)) {
                return -1;
            }
            if (this.getKeyComparator(i) <= comp.getKeyComparator(i)) continue;
            return 1;
        }
        if (i < thisSize) {
            return 1;
        }
        if (i < compSize) {
            return -1;
        }
        return 0;
    }
}

