/*
 * Decompiled with CFR 0.152.
 */
package org.assertj.core.api.recursive.comparison;

import java.lang.reflect.Array;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.assertj.core.api.recursive.comparison.ComparisonDifference;
import org.assertj.core.api.recursive.comparison.DualValue;
import org.assertj.core.api.recursive.comparison.DualValueDeque;
import org.assertj.core.api.recursive.comparison.RecursiveComparisonConfiguration;
import org.assertj.core.internal.Objects;
import org.assertj.core.util.IterableUtil;
import org.assertj.core.util.Lists;
import org.assertj.core.util.Sets;
import org.assertj.core.util.introspection.PropertyOrFieldSupport;

public class RecursiveComparisonDifferenceCalculator {
    private static final String DIFFERENT_ACTUAL_AND_EXPECTED_FIELD_TYPES = "expected field is %s but actual field is not (%s)";
    private static final String ACTUAL_NOT_ORDERED_COLLECTION = "expected field is an ordered collection but actual field is not (%s), ordered collections are: " + RecursiveComparisonDifferenceCalculator.describeOrderedCollectionTypes();
    private static final String VALUE_FIELD_NAME = "value";
    private static final String STRICT_TYPE_ERROR = "the fields are considered different since the comparison enforces strict type check and %s is not a subtype of %s";
    private static final String DIFFERENT_SIZE_ERROR = "actual and expected values are %s of different size, actual size=%s when expected size=%s";
    private static final String MISSING_FIELDS = "%s can't be compared to %s as %s does not declare all %s fields, it lacks these: %s";
    private static final Map<Class<?>, Boolean> customEquals = new ConcurrentHashMap();
    private static final Map<Class<?>, Boolean> customHash = new ConcurrentHashMap();

    public List<ComparisonDifference> determineDifferences(Object actual, Object expected, RecursiveComparisonConfiguration recursiveComparisonConfiguration) {
        if (recursiveComparisonConfiguration.isInStrictTypeCheckingMode() && RecursiveComparisonDifferenceCalculator.expectedTypeIsNotSubtypeOfActualType(actual, expected)) {
            return Lists.list(RecursiveComparisonDifferenceCalculator.expectedAndActualTypeDifference(actual, expected));
        }
        List<String> rootPath = Lists.list(new String[0]);
        HashSet<DualValue> visited = new HashSet<DualValue>();
        return RecursiveComparisonDifferenceCalculator.determineDifferences(actual, expected, rootPath, true, visited, recursiveComparisonConfiguration);
    }

    private static List<ComparisonDifference> determineDifferences(Object actual, Object expected, List<String> parentPath, boolean isRootObject, Set<DualValue> visited, RecursiveComparisonConfiguration recursiveComparisonConfiguration) {
        ComparisonState comparisonState = new ComparisonState(visited, recursiveComparisonConfiguration);
        comparisonState.initDualValuesToCompare(actual, expected, parentPath, isRootObject);
        while (comparisonState.hasDualValuesToCompare()) {
            DualValue dualValue = comparisonState.pickDualValueToCompare();
            List<String> currentPath = dualValue.getPath();
            Object actualFieldValue = dualValue.actual;
            Object expectedFieldValue = dualValue.expected;
            if (actualFieldValue == expectedFieldValue) continue;
            if (recursiveComparisonConfiguration.hasCustomComparator(dualValue)) {
                if (RecursiveComparisonDifferenceCalculator.propertyOrFieldValuesAreEqual(dualValue, recursiveComparisonConfiguration)) continue;
                comparisonState.addDifference(dualValue);
                continue;
            }
            if (actualFieldValue == null || expectedFieldValue == null) {
                comparisonState.addDifference(dualValue);
                continue;
            }
            if (dualValue.isEnum()) {
                RecursiveComparisonDifferenceCalculator.compareAsEnums(dualValue, comparisonState, recursiveComparisonConfiguration);
                continue;
            }
            if (dualValue.isExpectedFieldAnArray()) {
                RecursiveComparisonDifferenceCalculator.compareArrays(dualValue, comparisonState);
                continue;
            }
            if (dualValue.isExpectedFieldAnOrderedCollection() && !recursiveComparisonConfiguration.shouldIgnoreCollectionOrder(dualValue)) {
                RecursiveComparisonDifferenceCalculator.compareOrderedCollections(dualValue, comparisonState);
                continue;
            }
            if (dualValue.isExpectedFieldAnIterable()) {
                RecursiveComparisonDifferenceCalculator.compareUnorderedIterables(dualValue, comparisonState);
                continue;
            }
            if (dualValue.isExpectedFieldAnOptional()) {
                RecursiveComparisonDifferenceCalculator.compareOptional(dualValue, comparisonState);
                continue;
            }
            if (dualValue.isExpectedFieldASortedMap()) {
                RecursiveComparisonDifferenceCalculator.compareSortedMap(dualValue, comparisonState);
                continue;
            }
            if (dualValue.isExpectedFieldAMap()) {
                RecursiveComparisonDifferenceCalculator.compareUnorderedMap(dualValue, comparisonState);
                continue;
            }
            Class<?> actualFieldValueClass = actualFieldValue.getClass();
            if (!recursiveComparisonConfiguration.shouldIgnoreOverriddenEqualsOf(dualValue) && RecursiveComparisonDifferenceCalculator.hasOverriddenEquals(actualFieldValueClass)) {
                if (actualFieldValue.equals(expectedFieldValue)) continue;
                comparisonState.addDifference(dualValue);
                continue;
            }
            Class<?> expectedFieldClass = expectedFieldValue.getClass();
            if (recursiveComparisonConfiguration.isInStrictTypeCheckingMode() && RecursiveComparisonDifferenceCalculator.expectedTypeIsNotSubtypeOfActualType(dualValue)) {
                comparisonState.addDifference(dualValue, STRICT_TYPE_ERROR, expectedFieldClass.getName(), actualFieldValueClass.getName());
                continue;
            }
            Set<String> actualNonIgnoredFieldsNames = recursiveComparisonConfiguration.getNonIgnoredActualFieldNames(dualValue);
            Set<String> expectedFieldsNames = Objects.getFieldsNames(expectedFieldClass);
            if (!expectedFieldsNames.containsAll(actualNonIgnoredFieldsNames)) {
                HashSet<String> actualFieldsNamesNotInExpected = Sets.newHashSet(actualNonIgnoredFieldsNames);
                actualFieldsNamesNotInExpected.removeAll(expectedFieldsNames);
                String missingFields = ((Object)actualFieldsNamesNotInExpected).toString();
                String expectedClassName = expectedFieldClass.getName();
                String actualClassName = actualFieldValueClass.getName();
                String missingFieldsDescription = String.format(MISSING_FIELDS, actualClassName, expectedClassName, expectedFieldClass.getSimpleName(), actualFieldValueClass.getSimpleName(), missingFields);
                comparisonState.addDifference(dualValue, missingFieldsDescription, new Object[0]);
                continue;
            }
            for (String actualFieldName : actualNonIgnoredFieldsNames) {
                if (!expectedFieldsNames.contains(actualFieldName)) continue;
                DualValue newDualValue = new DualValue(currentPath, actualFieldName, PropertyOrFieldSupport.COMPARISON.getSimpleValue(actualFieldName, actualFieldValue), PropertyOrFieldSupport.COMPARISON.getSimpleValue(actualFieldName, expectedFieldValue));
                comparisonState.registerForComparison(newDualValue);
            }
        }
        return comparisonState.getDifferences();
    }

    private static void compareAsEnums(DualValue dualValue, ComparisonState comparisonState, RecursiveComparisonConfiguration recursiveComparisonConfiguration) {
        if (recursiveComparisonConfiguration.isInStrictTypeCheckingMode()) {
            if (dualValue.actual != dualValue.expected) {
                comparisonState.addDifference(dualValue);
            }
            return;
        }
        if (!dualValue.isActualFieldAnEnum()) {
            comparisonState.addDifference(dualValue, RecursiveComparisonDifferenceCalculator.differentTypeErrorMessage(dualValue, "an enum"), new Object[0]);
            return;
        }
        Enum actualEnum = (Enum)dualValue.actual;
        Enum expectedEnum = (Enum)dualValue.expected;
        if (!actualEnum.name().equals(expectedEnum.name())) {
            comparisonState.addDifference(dualValue);
        }
    }

    private static boolean shouldHonorOverriddenEquals(DualValue dualValue, RecursiveComparisonConfiguration recursiveComparisonConfiguration) {
        boolean shouldNotIgnoreOverriddenEqualsIfAny = !recursiveComparisonConfiguration.shouldIgnoreOverriddenEqualsOf(dualValue);
        return shouldNotIgnoreOverriddenEqualsIfAny && dualValue.actual != null && RecursiveComparisonDifferenceCalculator.hasOverriddenEquals(dualValue.actual.getClass());
    }

    private static void compareArrays(DualValue dualValue, ComparisonState comparisonState) {
        int expectedArrayLength;
        if (!dualValue.isActualFieldAnArray()) {
            comparisonState.addDifference(dualValue, RecursiveComparisonDifferenceCalculator.differentTypeErrorMessage(dualValue, "an array"), new Object[0]);
            return;
        }
        int actualArrayLength = Array.getLength(dualValue.actual);
        if (actualArrayLength != (expectedArrayLength = Array.getLength(dualValue.expected))) {
            comparisonState.addDifference(dualValue, DIFFERENT_SIZE_ERROR, "arrays", actualArrayLength, expectedArrayLength);
            return;
        }
        List<String> arrayFieldPath = dualValue.getPath();
        for (int i = 0; i < actualArrayLength; ++i) {
            Object actualElement = Array.get(dualValue.actual, i);
            Object expectedElement = Array.get(dualValue.expected, i);
            comparisonState.registerForComparison(new DualValue(arrayFieldPath, actualElement, expectedElement));
        }
    }

    private static void compareOrderedCollections(DualValue dualValue, ComparisonState comparisonState) {
        if (!dualValue.isActualFieldAnOrderedCollection()) {
            comparisonState.addDifference(dualValue, ACTUAL_NOT_ORDERED_COLLECTION, dualValue.actual.getClass().getCanonicalName());
            return;
        }
        Collection actualCollection = (Collection)dualValue.actual;
        Collection expectedCollection = (Collection)dualValue.expected;
        if (actualCollection.size() != expectedCollection.size()) {
            comparisonState.addDifference(dualValue, DIFFERENT_SIZE_ERROR, "collections", actualCollection.size(), expectedCollection.size());
            return;
        }
        Iterator expectedIterator = expectedCollection.iterator();
        List<String> path = dualValue.getPath();
        actualCollection.stream().map(element -> new DualValue(path, element, expectedIterator.next())).forEach(x$0 -> comparisonState.registerForComparison(x$0));
    }

    private static String differentTypeErrorMessage(DualValue dualValue, String actualTypeDescription) {
        return String.format(DIFFERENT_ACTUAL_AND_EXPECTED_FIELD_TYPES, actualTypeDescription, dualValue.actual.getClass().getCanonicalName());
    }

    private static void compareUnorderedIterables(DualValue dualValue, ComparisonState comparisonState) {
        int expectedSize;
        if (!dualValue.isActualFieldAnIterable()) {
            comparisonState.addDifference(dualValue, RecursiveComparisonDifferenceCalculator.differentTypeErrorMessage(dualValue, "an iterable"), new Object[0]);
            return;
        }
        Iterable actual = (Iterable)dualValue.actual;
        Iterable expected = (Iterable)dualValue.expected;
        int actualSize = IterableUtil.sizeOf(actual);
        if (actualSize != (expectedSize = IterableUtil.sizeOf(expected))) {
            comparisonState.addDifference(dualValue, DIFFERENT_SIZE_ERROR, "collections", actualSize, expectedSize);
            return;
        }
        List<String> path = dualValue.getPath();
        LinkedList expectedCopy = new LinkedList(IterableUtil.toCollection(expected));
        block0: for (Object actualElement : actual) {
            Iterator expectedIterator = expectedCopy.iterator();
            while (expectedIterator.hasNext()) {
                Object expectedElement = expectedIterator.next();
                List<ComparisonDifference> differences = RecursiveComparisonDifferenceCalculator.determineDifferences(actualElement, expectedElement, path, false, comparisonState.visitedDualValues, comparisonState.recursiveComparisonConfiguration);
                if (!differences.isEmpty()) continue;
                expectedIterator.remove();
                continue block0;
            }
        }
        if (!expectedCopy.isEmpty()) {
            comparisonState.addDifference(dualValue);
        }
    }

    private static <K, V> void compareSortedMap(DualValue dualValue, ComparisonState comparisonState) {
        if (!dualValue.isActualFieldASortedMap()) {
            comparisonState.addDifference(dualValue, RecursiveComparisonDifferenceCalculator.differentTypeErrorMessage(dualValue, "a sorted map"), new Object[0]);
            return;
        }
        Map actualMap = (Map)dualValue.actual;
        Map expectedMap = (Map)dualValue.expected;
        if (actualMap.size() != expectedMap.size()) {
            comparisonState.addDifference(dualValue, DIFFERENT_SIZE_ERROR, "sorted maps", actualMap.size(), expectedMap.size());
            return;
        }
        List<String> path = dualValue.getPath();
        Iterator expectedMapEntries = expectedMap.entrySet().iterator();
        for (Map.Entry actualEntry : actualMap.entrySet()) {
            Map.Entry expectedEntry = expectedMapEntries.next();
            comparisonState.registerForComparison(new DualValue(path, actualEntry.getKey(), expectedEntry.getKey()));
            comparisonState.registerForComparison(new DualValue(path, actualEntry.getValue(), expectedEntry.getValue()));
        }
    }

    private static void compareUnorderedMap(DualValue dualValue, ComparisonState comparisonState) {
        if (!dualValue.isActualFieldAMap()) {
            comparisonState.addDifference(dualValue, RecursiveComparisonDifferenceCalculator.differentTypeErrorMessage(dualValue, "a map"), new Object[0]);
            return;
        }
        Map actualMap = (Map)dualValue.actual;
        Map expectedMap = (Map)dualValue.expected;
        if (actualMap.size() != expectedMap.size()) {
            comparisonState.addDifference(dualValue, DIFFERENT_SIZE_ERROR, "maps", actualMap.size(), expectedMap.size());
            return;
        }
        Map<Integer, Map.Entry> fastLookup = expectedMap.entrySet().stream().collect(Collectors.toMap(entry -> RecursiveComparisonDifferenceCalculator.deepHashCode(entry.getKey()), entry -> entry));
        List<String> path = dualValue.getPath();
        for (Map.Entry actualEntry : actualMap.entrySet()) {
            int deepHashCode = RecursiveComparisonDifferenceCalculator.deepHashCode(actualEntry.getKey());
            if (!fastLookup.containsKey(deepHashCode)) {
                comparisonState.addDifference(dualValue);
                return;
            }
            Map.Entry expectedEntry = fastLookup.get(deepHashCode);
            comparisonState.registerForComparison(new DualValue(path, actualEntry.getKey(), expectedEntry.getKey()));
            comparisonState.registerForComparison(new DualValue(path, actualEntry.getValue(), expectedEntry.getValue()));
        }
    }

    private static void compareOptional(DualValue dualValue, ComparisonState comparisonState) {
        if (!dualValue.isActualFieldAnOptional()) {
            comparisonState.addDifference(dualValue, RecursiveComparisonDifferenceCalculator.differentTypeErrorMessage(dualValue, "an Optional"), new Object[0]);
            return;
        }
        Optional actual = (Optional)dualValue.actual;
        Optional expected = (Optional)dualValue.expected;
        if (actual.isPresent() != expected.isPresent()) {
            comparisonState.addDifference(dualValue);
            return;
        }
        if (!actual.isPresent()) {
            return;
        }
        Object value1 = actual.get();
        Object value2 = expected.get();
        comparisonState.registerForComparison(new DualValue(dualValue.getPath(), VALUE_FIELD_NAME, value1, value2));
    }

    static boolean hasOverriddenEquals(Class<?> c) {
        if (customEquals.containsKey(c)) {
            return customEquals.get(c);
        }
        Class<?> origClass = c;
        while (!Object.class.equals(c)) {
            try {
                c.getDeclaredMethod("equals", Object.class);
                customEquals.put(origClass, true);
                return true;
            }
            catch (Exception exception) {
                c = c.getSuperclass();
            }
        }
        customEquals.put(origClass, false);
        return false;
    }

    static int deepHashCode(Object obj) {
        HashSet<Object> visited = new HashSet<Object>();
        LinkedList<Object> stack = new LinkedList<Object>();
        stack.addFirst(obj);
        int hash = 0;
        while (!stack.isEmpty()) {
            obj = stack.removeFirst();
            if (obj == null || visited.contains(obj)) continue;
            visited.add(obj);
            if (obj.getClass().isArray()) {
                int len = Array.getLength(obj);
                for (int i = 0; i < len; ++i) {
                    stack.addFirst(Array.get(obj, i));
                }
                continue;
            }
            if (obj instanceof Collection) {
                stack.addAll(0, (Collection)obj);
                continue;
            }
            if (obj instanceof Map) {
                stack.addAll(0, ((Map)obj).keySet());
                stack.addAll(0, ((Map)obj).values());
                continue;
            }
            if (obj instanceof Double || obj instanceof Float) {
                stack.add(Math.round(((Number)obj).doubleValue()));
                continue;
            }
            if (RecursiveComparisonDifferenceCalculator.hasCustomHashCode(obj.getClass())) {
                hash += obj.hashCode();
                continue;
            }
            Set<Field> fields = Objects.getDeclaredFieldsIncludingInherited(obj.getClass());
            for (Field field : fields) {
                stack.addFirst(PropertyOrFieldSupport.COMPARISON.getSimpleValue(field.getName(), obj));
            }
        }
        return hash;
    }

    static boolean hasCustomHashCode(Class<?> c) {
        Class<?> origClass = c;
        if (customHash.containsKey(c)) {
            return customHash.get(c);
        }
        while (!Object.class.equals(c)) {
            try {
                c.getDeclaredMethod("hashCode", new Class[0]);
                customHash.put(origClass, true);
                return true;
            }
            catch (Exception exception) {
                c = c.getSuperclass();
            }
        }
        customHash.put(origClass, false);
        return false;
    }

    private static boolean propertyOrFieldValuesAreEqual(DualValue dualValue, RecursiveComparisonConfiguration recursiveComparisonConfiguration) {
        String fieldName = dualValue.getConcatenatedPath();
        Object actualFieldValue = dualValue.actual;
        Object expectedFieldValue = dualValue.expected;
        if (actualFieldValue == expectedFieldValue) {
            return true;
        }
        Comparator<?> fieldComparator = recursiveComparisonConfiguration.getComparatorForField(fieldName);
        if (fieldComparator != null) {
            return fieldComparator.compare(actualFieldValue, expectedFieldValue) == 0;
        }
        Class<?> fieldType = actualFieldValue != null ? actualFieldValue.getClass() : expectedFieldValue.getClass();
        Comparator<?> typeComparator = recursiveComparisonConfiguration.getComparatorForType(fieldType);
        if (typeComparator != null) {
            return typeComparator.compare(actualFieldValue, expectedFieldValue) == 0;
        }
        return org.assertj.core.util.Objects.areEqual(actualFieldValue, expectedFieldValue);
    }

    private static ComparisonDifference expectedAndActualTypeDifference(Object actual, Object expected) {
        String additionalInformation = String.format("actual and expected are considered different since the comparison enforces strict type check and expected type %s is not a subtype of actual type %s", expected.getClass().getName(), actual.getClass().getName());
        return ComparisonDifference.rootComparisonDifference(actual, expected, additionalInformation);
    }

    private static boolean expectedTypeIsNotSubtypeOfActualType(DualValue dualField) {
        return RecursiveComparisonDifferenceCalculator.expectedTypeIsNotSubtypeOfActualType(dualField.actual, dualField.expected);
    }

    private static boolean expectedTypeIsNotSubtypeOfActualType(Object actual, Object expected) {
        return !actual.getClass().isAssignableFrom(expected.getClass());
    }

    private static String describeOrderedCollectionTypes() {
        return Stream.of(DualValue.DEFAULT_ORDERED_COLLECTION_TYPES).map(Class::getName).collect(Collectors.joining(", ", "[", "]"));
    }

    private static class ComparisonState {
        Set<DualValue> visitedDualValues;
        List<ComparisonDifference> differences = new ArrayList<ComparisonDifference>();
        DualValueDeque dualValuesToCompare;
        RecursiveComparisonConfiguration recursiveComparisonConfiguration;

        public ComparisonState(Set<DualValue> visited, RecursiveComparisonConfiguration recursiveComparisonConfiguration) {
            this.visitedDualValues = visited;
            this.dualValuesToCompare = new DualValueDeque(recursiveComparisonConfiguration);
            this.recursiveComparisonConfiguration = recursiveComparisonConfiguration;
        }

        void addDifference(DualValue dualValue) {
            this.differences.add(new ComparisonDifference(dualValue.getPath(), dualValue.actual, dualValue.expected));
        }

        void addDifference(DualValue dualValue, String description, Object ... args) {
            this.differences.add(new ComparisonDifference(dualValue.getPath(), dualValue.actual, dualValue.expected, String.format(description, args)));
        }

        public List<ComparisonDifference> getDifferences() {
            Collections.sort(this.differences);
            return this.differences;
        }

        public boolean hasDualValuesToCompare() {
            return !this.dualValuesToCompare.isEmpty();
        }

        public DualValue pickDualValueToCompare() {
            DualValue dualValue = (DualValue)this.dualValuesToCompare.removeFirst();
            this.visitedDualValues.add(dualValue);
            return dualValue;
        }

        private void registerForComparison(DualValue dualValue) {
            if (!this.visitedDualValues.contains(dualValue)) {
                this.dualValuesToCompare.addFirst(dualValue);
            }
        }

        private void initDualValuesToCompare(Object actual, Object expected, List<String> parentPath, boolean isRootObject) {
            DualValue dualValue = new DualValue(parentPath, actual, expected);
            boolean mustCompareFieldsRecursively = this.mustCompareFieldsRecursively(isRootObject, dualValue);
            if (dualValue.hasNoNullValues() && dualValue.hasNoContainerValues() && mustCompareFieldsRecursively) {
                Set<String> nonIgnoredActualFieldsNames = this.recursiveComparisonConfiguration.getNonIgnoredActualFieldNames(dualValue);
                if (!nonIgnoredActualFieldsNames.isEmpty()) {
                    Set<String> expectedFieldsNames = Objects.getFieldsNames(expected.getClass());
                    if (expectedFieldsNames.containsAll(nonIgnoredActualFieldsNames)) {
                        for (String nonIgnoredActualFieldName : nonIgnoredActualFieldsNames) {
                            DualValue fieldDualValue = new DualValue(parentPath, nonIgnoredActualFieldName, PropertyOrFieldSupport.COMPARISON.getSimpleValue(nonIgnoredActualFieldName, actual), PropertyOrFieldSupport.COMPARISON.getSimpleValue(nonIgnoredActualFieldName, expected));
                            this.dualValuesToCompare.addFirst(fieldDualValue);
                        }
                    } else {
                        this.dualValuesToCompare.addFirst(dualValue);
                    }
                } else {
                    this.dualValuesToCompare.addFirst(dualValue);
                }
            } else {
                this.dualValuesToCompare.addFirst(dualValue);
            }
            this.dualValuesToCompare.removeAll(this.visitedDualValues);
        }

        private boolean mustCompareFieldsRecursively(boolean isRootObject, DualValue dualValue) {
            boolean noCustomComparisonForDualValue = !this.recursiveComparisonConfiguration.hasCustomComparator(dualValue) && !RecursiveComparisonDifferenceCalculator.shouldHonorOverriddenEquals(dualValue, this.recursiveComparisonConfiguration);
            return isRootObject || noCustomComparisonForDualValue;
        }
    }
}

